/*
 * Decompiled with CFR 0.152.
 */
package com.talkilla.service.impl;

import com.talkilla.mysql.domain.TCustTimezone;
import com.talkilla.mysql.domain.TSysdict;
import com.talkilla.mysql.domain.TZonecode;
import com.talkilla.mysql.mapper.TCustTimezoneDao;
import com.talkilla.mysql.mapper.TMenuDao;
import com.talkilla.mysql.mapper.TNationDao;
import com.talkilla.mysql.mapper.TSysdictDao;
import com.talkilla.mysql.mapper.TTimezoneDao;
import com.talkilla.mysql.mapper.TZonecodeDao;
import com.talkilla.otherbean.CustomerTimerDto;
import com.talkilla.otherbean.NationDto;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.nestframework.commons.utils.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="initDictionUtil")
public class InitDictionUtil {
    private static final Logger logger = LoggerFactory.getLogger(InitDictionUtil.class);
    private Map<String, CustomerTimerDto> timers = new HashMap<String, CustomerTimerDto>();
    private List<TSysdict> sysDictes;
    private Map<String, String> keyDictes = new HashMap<String, String>();
    @Autowired
    private TSysdictDao tSysdictDao;
    @Autowired
    private TMenuDao tMenuDao;
    @Autowired
    private TNationDao tNationDao;
    @Autowired
    private TTimezoneDao tTimezoneDao;
    @Autowired
    private TZonecodeDao tZonecodeDao;
    @Autowired
    private TCustTimezoneDao tCustTimezoneDao;
    private List<NationDto> list = new ArrayList<NationDto>();
    private Map<String, String> keyNationsZn = new HashMap<String, String>();
    private Map<String, String> keyNationsEn = new HashMap<String, String>();
    private List<Map<String, String>> x = new ArrayList<Map<String, String>>();
    private List<Map<String, String>> xen = new ArrayList<Map<String, String>>();

    @PostConstruct
    public void findAllSysDict() {
        HashMap<String, String> mp;
        List allBZone;
        if (this.sysDictes == null || this.sysDictes.size() == 0) {
            this.sysDictes = this.tSysdictDao.findAll();
            for (TSysdict bn : this.sysDictes) {
                this.keyDictes.put(bn.getDictid().toString(), bn.getDictname());
            }
        }
        if (this.list == null || this.list.size() == 0) {
            this.list = this.tNationDao.findAllNationDto();
            for (NationDto d : this.list) {
                this.keyNationsZn.put(d.getNationid(), d.getName());
                this.keyNationsEn.put(d.getNationid(), d.getEname());
            }
        }
        if (this.x == null || this.x.size() == 0) {
            allBZone = this.tZonecodeDao.findAllBZone();
            this.x = new ArrayList<Map<String, String>>();
            for (TZonecode zonecode : allBZone) {
                mp = new HashMap<String, String>();
                mp.put("id", zonecode.getZonecode());
                mp.put("text", zonecode.getZonename());
                this.x.add(mp);
            }
        }
        if (this.xen == null || this.xen.size() == 0) {
            allBZone = this.tZonecodeDao.findAllBZone();
            this.xen = new ArrayList<Map<String, String>>();
            for (TZonecode zonecode : allBZone) {
                mp = new HashMap();
                mp.put("id", zonecode.getZonecode());
                mp.put("text", zonecode.getRomecode());
                this.xen.add(mp);
            }
        }
        if (this.timers == null) {
            this.timers = new HashMap<String, CustomerTimerDto>();
            List all = this.tCustTimezoneDao.findAll();
            for (TCustTimezone zone : all) {
                NationDto d;
                d = new CustomerTimerDto();
                d.setId(zone.getCustid());
                d.setInClude(zone.getIsinclude().intValue());
                if (d.getInClude() == 1) {
                    d.setNewTimeZone(zone.getTimezone());
                } else {
                    d.setTimezone(zone.getTimezone());
                }
                d.setDelay(zone.getDelay().intValue());
                d.setDisIncludeDelay(zone.getUnincludedelay().intValue());
                d.setFstMonth(zone.getFstmonth().intValue());
                d.setFstWeek(zone.getFstweek().intValue());
                d.setFstWeekDay(zone.getFstweekday().intValue());
                d.setSecMonth(zone.getSecmonth().intValue());
                d.setSecWeek(zone.getSecweek().intValue());
                d.setSecWeekDay(zone.getSecweekday().intValue());
                if (StringUtil.isEmpty((String)d.getTimezone())) {
                    this.timers.put(d.getNewTimeZone(), (CustomerTimerDto)d);
                    continue;
                }
                this.timers.put(d.getTimezone(), (CustomerTimerDto)d);
            }
        }
    }

    public String getCityNameById(String id) {
        int len = this.x.size();
        for (int i = 0; i < len; ++i) {
            if (!id.equals(this.x.get(i).get("id"))) continue;
            return this.x.get(i).get("text");
        }
        return "";
    }

    public String getCityNameEnById(String id) {
        int len = this.xen.size();
        for (int i = 0; i < len; ++i) {
            if (!id.equals(this.xen.get(i).get("id"))) continue;
            return this.xen.get(i).get("text");
        }
        return "";
    }

    public String getNationNameById(String nationid, String type) {
        if (StringUtil.isEmpty((String)type) || "zn".equals(type)) {
            return this.keyNationsZn.get(nationid);
        }
        return this.keyNationsEn.get(nationid);
    }

    public List<TSysdict> getAllSysDict() {
        return this.sysDictes;
    }

    public List<TSysdict> getDictByDictType(Integer dictType) {
        ArrayList<TSysdict> ret = new ArrayList<TSysdict>();
        try {
            if (this.sysDictes != null && this.sysDictes.size() > 0) {
                for (TSysdict diction : this.sysDictes) {
                    if (new Integer(diction.getDicttype().toString()).compareTo(dictType) != 0) continue;
                    ret.add(diction);
                }
            }
        }
        catch (Exception ex) {
            logger.error(ex.getMessage() + ex.fillInStackTrace());
        }
        return ret;
    }

    public String getDictNameByDictId(String dictId) {
        String ret = "";
        if (StringUtil.isEmpty((String)dictId)) {
            return "";
        }
        try {
            if (this.keyDictes != null && null != this.keyDictes.get(dictId)) {
                ret = this.keyDictes.get(dictId);
            }
        }
        catch (Exception ex) {
            logger.error(ex.getMessage() + ex.fillInStackTrace());
        }
        return ret;
    }

    public TSysdictDao gettSysdictDao() {
        return this.tSysdictDao;
    }

    public void settSysdictDao(TSysdictDao tSysdictDao) {
        this.tSysdictDao = tSysdictDao;
    }

    public TMenuDao gettMenuDao() {
        return this.tMenuDao;
    }

    public void settMenuDao(TMenuDao tMenuDao) {
        this.tMenuDao = tMenuDao;
    }

    public TNationDao gettNationDao() {
        return this.tNationDao;
    }

    public void settNationDao(TNationDao tNationDao) {
        this.tNationDao = tNationDao;
    }

    public TTimezoneDao gettTimezoneDao() {
        return this.tTimezoneDao;
    }

    public void settTimezoneDao(TTimezoneDao tTimezoneDao) {
        this.tTimezoneDao = tTimezoneDao;
    }

    public TZonecodeDao gettZonecodeDao() {
        return this.tZonecodeDao;
    }

    public void settZonecodeDao(TZonecodeDao tZonecodeDao) {
        this.tZonecodeDao = tZonecodeDao;
    }

    public TCustTimezoneDao gettCustTimezoneDao() {
        return this.tCustTimezoneDao;
    }

    public void settCustTimezoneDao(TCustTimezoneDao tCustTimezoneDao) {
        this.tCustTimezoneDao = tCustTimezoneDao;
    }
}

