/*
 * Decompiled with CFR 0.152.
 */
package com.talkilla.local;

import com.talkilla.constant.enums.CalculatePriceTypeEnums;
import com.talkilla.mysql.domain.TCoursesession;
import com.talkilla.mysql.mapper.TCoursesessionDao;
import com.talkilla.utils.MathUtils;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Service
public class CourseCommonService {
    @Autowired
    private TCoursesessionDao tCoursesessionDao;

    public BigDecimal calculateCoursesessionPrice(CalculatePriceTypeEnums type, Integer cid, Integer courcesessionCount, BigDecimal changePrice) {
        Assert.notNull((Object)type, (String)"\u8bf7\u6307\u5b9aCalculatePriceTypeEnums\u53c2\u6570");
        BigDecimal price = null;
        if (type.equals((Object)CalculatePriceTypeEnums.AWARD)) {
            price = BigDecimal.ZERO;
        } else {
            Assert.notNull((Object)cid);
            List tCoursesessionList = this.tCoursesessionDao.findNoCompleteAndIsPayByCid(cid);
            if (type.equals((Object)CalculatePriceTypeEnums.ADDTIME_SAMEPRICE)) {
                Assert.notNull((Object)courcesessionCount);
                if (!CollectionUtils.isEmpty((Collection)tCoursesessionList)) {
                    BigDecimal leftTotalFee = BigDecimal.ZERO;
                    for (TCoursesession tCoursesession : tCoursesessionList) {
                        if (Objects.isNull(tCoursesession.getPrice())) continue;
                        leftTotalFee = leftTotalFee.add(tCoursesession.getPrice());
                    }
                    price = MathUtils.div((BigDecimal)leftTotalFee, (BigDecimal)BigDecimal.valueOf(tCoursesessionList.size() + courcesessionCount), (int)2);
                } else {
                    price = BigDecimal.ZERO;
                }
            } else if (type.equals((Object)CalculatePriceTypeEnums.SAMETIME_CHANGEPRICE)) {
                Assert.notNull((Object)changePrice);
                if (!CollectionUtils.isEmpty((Collection)tCoursesessionList)) {
                    BigDecimal leftTotalFee = BigDecimal.ZERO;
                    for (TCoursesession tCoursesession : tCoursesessionList) {
                        if (Objects.isNull(tCoursesession.getPrice())) continue;
                        leftTotalFee = leftTotalFee.add(tCoursesession.getPrice());
                    }
                    price = MathUtils.div((BigDecimal)leftTotalFee.add(changePrice), (BigDecimal)BigDecimal.valueOf(tCoursesessionList.size()), (int)2);
                } else {
                    price = BigDecimal.ZERO;
                }
            }
        }
        return price;
    }
}

