/*
 * Decompiled with CFR 0.152.
 */
package com.talkilla.wechat.utils;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Map;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

public class HttpsMrzjUtils {
    public static int readTimeout = 30000;
    public static int connectionTimeout = 300000;
    public static String defaultEncoding = "UTF-8";
    public static Integer POST_TYPE_FORM = 1;
    public static Integer POST_TYPE_JSON = 2;
    public static Integer POST_TYPE_XML = 3;

    public static String httpsGet(String urlStr, Map<String, Object> param, String paramEncoding) {
        if (paramEncoding == null || "".equals(paramEncoding.trim())) {
            paramEncoding = defaultEncoding;
        }
        try {
            StringBuffer paramStr = new StringBuffer();
            if (param != null && param.size() > 0) {
                for (String key : param.keySet()) {
                    Object value = param.get(key);
                    if (value == null) {
                        value = "";
                    }
                    if (value instanceof String) {
                        value = URLEncoder.encode(value.toString(), paramEncoding);
                    }
                    paramStr.append("&").append(key).append("=").append(value);
                }
            }
            return HttpsMrzjUtils.httpsGet(urlStr, paramStr.length() > 1 ? paramStr.substring(1) : null, paramEncoding, null, null);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String httpsGet(String urlStr, String param, String paramEncoding, String resultEncoding, Integer conTimeout) {
        if (paramEncoding == null || "".equals(paramEncoding.trim())) {
            paramEncoding = defaultEncoding;
        }
        if (resultEncoding == null || "".equals(resultEncoding.trim())) {
            resultEncoding = defaultEncoding;
        }
        try {
            String line;
            if (param != null && !"".equals(param.trim())) {
                urlStr = urlStr + "?" + param;
            }
            URL url = new URL(urlStr);
            HttpsURLConnection con = (HttpsURLConnection)url.openConnection();
            if (conTimeout == null) {
                con.setConnectTimeout(connectionTimeout);
            } else {
                con.setConnectTimeout(conTimeout * 1000);
            }
            con.setSSLSocketFactory(MyX509TrustManager.getSslSocketFactory());
            con.setReadTimeout(readTimeout);
            con.setRequestMethod("GET");
            con.connect();
            BufferedReader reader = new BufferedReader(new InputStreamReader(con.getInputStream(), resultEncoding));
            StringBuffer result = new StringBuffer();
            while ((line = reader.readLine()) != null) {
                result.append(line + "\n");
            }
            reader.close();
            con.disconnect();
            return result.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String httpsPost(String urlStr, Map<String, Object> param, String paramEncoding) {
        if (paramEncoding == null || "".equals(paramEncoding.trim())) {
            paramEncoding = defaultEncoding;
        }
        try {
            StringBuffer paramStr = new StringBuffer();
            if (param != null && param.size() > 0) {
                for (String key : param.keySet()) {
                    Object value = param.get(key);
                    if (value == null) {
                        value = "";
                    }
                    if (value instanceof String) {
                        value = URLEncoder.encode(value.toString(), paramEncoding);
                    }
                    paramStr.append("&").append(key).append("=").append(value);
                }
            }
            return HttpsMrzjUtils.httpsPost(urlStr, paramStr.length() > 1 ? paramStr.substring(1) : null, paramEncoding, null, null);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String httpPost(String urlStr, Map<String, Object> param, String paramEncoding) {
        if (paramEncoding == null || "".equals(paramEncoding.trim())) {
            paramEncoding = defaultEncoding;
        }
        try {
            StringBuffer paramStr = new StringBuffer();
            if (param != null && param.size() > 0) {
                for (String key : param.keySet()) {
                    Object value = param.get(key);
                    if (value == null) {
                        value = "";
                    }
                    paramStr.append("&").append(key).append("=").append(value);
                }
            }
            return HttpsMrzjUtils.httpPost(urlStr, paramStr.length() > 1 ? paramStr.substring(1) : null, POST_TYPE_FORM, paramEncoding, null, null);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String httpPost(String urlStr, String params, Integer type, String paramEncoding, String resultEncoding, Integer conTimeout) {
        HttpURLConnection urlConn = null;
        BufferedReader in = null;
        try {
            String line;
            if (paramEncoding == null || paramEncoding.trim().equals("")) {
                paramEncoding = defaultEncoding;
            }
            if (resultEncoding == null || resultEncoding.trim().equals("")) {
                resultEncoding = defaultEncoding;
            }
            StringBuffer result = new StringBuffer();
            URL destURL = new URL(urlStr);
            urlConn = (HttpURLConnection)destURL.openConnection();
            if (POST_TYPE_FORM.equals(type)) {
                urlConn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded; charset=" + paramEncoding.toLowerCase());
            } else if (POST_TYPE_JSON.equals(type)) {
                urlConn.setRequestProperty("Content-Type", "application/json; charset=" + paramEncoding.toLowerCase());
            }
            urlConn.setDoOutput(true);
            urlConn.setDoInput(true);
            urlConn.setAllowUserInteraction(false);
            urlConn.setUseCaches(false);
            urlConn.setRequestMethod("POST");
            if (conTimeout == null) {
                urlConn.setConnectTimeout(connectionTimeout);
            } else {
                urlConn.setConnectTimeout(conTimeout * 1000);
            }
            urlConn.setReadTimeout(readTimeout);
            OutputStream os = urlConn.getOutputStream();
            if (params != null) {
                os.write(params.getBytes(paramEncoding));
            }
            in = new BufferedReader(new InputStreamReader(urlConn.getInputStream(), resultEncoding));
            while ((line = in.readLine()) != null) {
                result.append(line + "\n");
            }
            String string = result.toString();
            return string;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                in.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            try {
                urlConn.disconnect();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String httpsPost(String urlStr, String params, Integer type, String paramEncoding, String resultEncoding, Integer conTimeout, Map<String, String> headers) {
        BufferedReader in = null;
        HttpURLConnection urlConn = null;
        try {
            String line;
            if (paramEncoding == null || paramEncoding.trim().equals("")) {
                paramEncoding = defaultEncoding;
            }
            if (resultEncoding == null || resultEncoding.trim().equals("")) {
                resultEncoding = defaultEncoding;
            }
            StringBuffer result = new StringBuffer();
            URL destURL = new URL(urlStr);
            urlConn = (HttpsURLConnection)destURL.openConnection();
            if (POST_TYPE_FORM.equals(type)) {
                urlConn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded; charset=" + paramEncoding.toLowerCase());
            } else if (POST_TYPE_JSON.equals(type)) {
                urlConn.setRequestProperty("Content-Type", "application/json; charset=" + paramEncoding.toLowerCase());
            } else if (POST_TYPE_XML.equals(type)) {
                urlConn.setRequestProperty("Content-Type", "text/xml; charset=" + paramEncoding.toLowerCase());
            }
            if (headers != null) {
                for (String key : headers.keySet()) {
                    urlConn.setRequestProperty(key, headers.get(key));
                }
            }
            urlConn.setDoOutput(true);
            urlConn.setDoInput(true);
            urlConn.setAllowUserInteraction(false);
            urlConn.setUseCaches(false);
            urlConn.setRequestMethod("POST");
            ((HttpsURLConnection)urlConn).setSSLSocketFactory(MyX509TrustManager.getSslSocketFactory());
            if (conTimeout == null) {
                urlConn.setConnectTimeout(connectionTimeout);
            } else {
                urlConn.setConnectTimeout(conTimeout * 1000);
            }
            urlConn.setReadTimeout(readTimeout);
            OutputStream os = urlConn.getOutputStream();
            if (params != null) {
                os.write(params.getBytes(paramEncoding));
            }
            in = new BufferedReader(new InputStreamReader(urlConn.getInputStream(), resultEncoding));
            while ((line = in.readLine()) != null) {
                result.append(line + "\n");
            }
            in.close();
            String string = result.toString();
            return string;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                in.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                urlConn.disconnect();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public static String httpsPost(String urlStr, String params, String paramEncoding, String resultEncoding, Integer conTimeout) {
        try {
            String line;
            BufferedReader in = null;
            if (paramEncoding == null || paramEncoding.trim().equals("")) {
                paramEncoding = defaultEncoding;
            }
            if (resultEncoding == null || resultEncoding.trim().equals("")) {
                resultEncoding = defaultEncoding;
            }
            StringBuffer result = new StringBuffer();
            URL destURL = new URL(urlStr);
            HttpsURLConnection urlConn = (HttpsURLConnection)destURL.openConnection();
            urlConn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded; charset=" + paramEncoding.toLowerCase());
            urlConn.setDoOutput(true);
            urlConn.setDoInput(true);
            urlConn.setAllowUserInteraction(false);
            urlConn.setUseCaches(false);
            urlConn.setRequestMethod("POST");
            urlConn.setSSLSocketFactory(MyX509TrustManager.getSslSocketFactory());
            if (conTimeout == null) {
                urlConn.setConnectTimeout(connectionTimeout);
            } else {
                urlConn.setConnectTimeout(conTimeout * 1000);
            }
            urlConn.setReadTimeout(readTimeout);
            OutputStream os = urlConn.getOutputStream();
            if (params != null) {
                os.write(params.getBytes(paramEncoding));
            }
            in = new BufferedReader(new InputStreamReader(urlConn.getInputStream(), resultEncoding));
            while ((line = in.readLine()) != null) {
                result.append(line + "\n");
            }
            in.close();
            return result.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static class MyX509TrustManager
    implements X509TrustManager {
        public static SSLSocketFactory getSslSocketFactory() throws Exception {
            SSLContext sslContext = SSLContext.getInstance("SSL", "SunJSSE");
            sslContext.init(null, new TrustManager[]{new MyX509TrustManager()}, new SecureRandom());
            return sslContext.getSocketFactory();
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }
    }
}

