/*
 * Decompiled with CFR 0.152.
 */
package com.talkilla.wechat.service;

import com.talkilla.constant.SystemConfig;
import com.talkilla.constant.TalkillaConfig;
import com.talkilla.wechat.bean.Button;
import com.talkilla.wechat.bean.ComplexButton;
import com.talkilla.wechat.bean.Menu;
import com.talkilla.wechat.bean.UrlButton;
import com.talkilla.wechat.form.WechatConfigForm;
import com.talkilla.wechat.form.WechatHttpsForm;
import com.talkilla.wechat.form.WechatLoginForm;
import com.talkilla.wechat.form.WechatUserInfoForm;
import com.talkilla.wechat.result.WeChatConfigResult;
import com.talkilla.wechat.result.WechatHttpsResult;
import com.talkilla.wechat.result.WechatUserInfoResult;
import com.talkilla.wechat.result.WechatUserLoginResult;
import com.talkilla.wechat.result.WechatUserResult;
import com.talkilla.wechat.utils.BeanUtils;
import com.talkilla.wechat.utils.EncryptUtil;
import com.talkilla.wechat.utils.HttpsMrzjUtils;
import com.talkilla.wechat.utils.JsonUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="wechatService")
public class WechatService {
    private static final Logger logger = LoggerFactory.getLogger(WechatService.class);
    private static Long ACCESS_TOKEN_SAVE_TIME = 5300000L;
    private static Long TICKET_SAVE_TIME = 5300000L;
    public static final String PLATFORM_NAME = "wechat";

    public String getAccessTokenByAppId(String appId) {
        String accessToken = TalkillaConfig.accessToken;
        Long time = TalkillaConfig.tokenTime;
        Long tempTime = null;
        if (time != null && time != 0L) {
            tempTime = System.currentTimeMillis() - time;
        }
        if (StringUtils.isBlank((String)accessToken) || tempTime != null && tempTime > ACCESS_TOKEN_SAVE_TIME) {
            accessToken = this.getNewAccessToken(appId);
        }
        return accessToken;
    }

    private String getNewAccessToken(String appId) {
        WechatHttpsForm request = new WechatHttpsForm();
        request.setAppid(SystemConfig.Wechat.WECHAT_APP_ID);
        request.setGrant_type("client_credential");
        request.setSecret(SystemConfig.Wechat.WECHAT_APP_SECRET);
        String responseStr = HttpsMrzjUtils.httpsGet("https://api.weixin.qq.com/cgi-bin/token", BeanUtils.getPropertiesMap(request), "UTF-8");
        WechatHttpsResult response = JsonUtil.strToObj(responseStr, WechatHttpsResult.class);
        logger.info("\u83b7\u53d6\u5fae\u4fe1,accessToken\u63a5\u53e3\u54cd\u5e94\u7ed3\u679c\u4e3a: {}", (Object)response);
        TalkillaConfig.accessToken = response.getAccess_token();
        long nowTime = System.currentTimeMillis();
        TalkillaConfig.tokenTime = nowTime;
        return response.getAccess_token();
    }

    public String getTicket(String appId) {
        String ticket = TalkillaConfig.ticket;
        Long time = TalkillaConfig.ticketTime;
        Long tempTime = null;
        if (time != null && time != 0L) {
            tempTime = System.currentTimeMillis() - time;
        }
        if (StringUtils.isBlank((String)ticket) || tempTime != null && tempTime > TICKET_SAVE_TIME) {
            ticket = this.getNewTicket(appId);
        }
        return ticket;
    }

    private String getNewTicket(String appId) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("access_token", this.getAccessTokenByAppId(appId));
        param.put("type", "jsapi");
        String responseStr = HttpsMrzjUtils.httpsGet("https://api.weixin.qq.com/cgi-bin/ticket/getticket", param, "UTF-8");
        WechatHttpsResult response = JsonUtil.strToObj(responseStr, WechatHttpsResult.class);
        TalkillaConfig.ticket = response.getTicket();
        long nowTime = System.currentTimeMillis();
        TalkillaConfig.ticketTime = nowTime;
        return response.getTicket();
    }

    public WechatHttpsResult getAccessTokenByCode(String code) {
        WechatHttpsForm request = new WechatHttpsForm();
        request.setAppid(SystemConfig.Wechat.WECHAT_APP_ID);
        request.setCode(code);
        request.setGrant_type("authorization_code");
        request.setSecret(SystemConfig.Wechat.WECHAT_APP_SECRET);
        logger.info("wechat request:{}", (Object)request);
        String responseStr = HttpsMrzjUtils.httpsGet("https://api.weixin.qq.com/sns/oauth2/access_token", BeanUtils.getPropertiesMap(request), "UTF-8");
        logger.info("wechat responseStr:{}", (Object)responseStr);
        WechatHttpsResult response = JsonUtil.strToObj(responseStr, WechatHttpsResult.class);
        return response;
    }

    public WechatUserLoginResult getOpenIdOrUnionId(String code) {
        WechatHttpsResult tempResult = this.getAccessTokenByCode(code);
        WechatUserLoginResult result = new WechatUserLoginResult();
        if (tempResult == null) {
            return null;
        }
        result.setOpenid(tempResult.getOpenid());
        result.setUnionid(tempResult.getUnionid());
        return result;
    }

    public WechatUserInfoResult getUserInfo(WechatUserInfoForm wechatUserInfoForm) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("openid", wechatUserInfoForm.getOpenId());
        WechatUserResult httpResult = this.wechatHttpsGetWithAccessToken("https://api.weixin.qq.com/cgi-bin/user/info", param, WechatUserResult.class, wechatUserInfoForm.getAppId());
        WechatUserInfoResult result = new WechatUserInfoResult();
        result.setAvatar(httpResult.getHeadimgurl());
        result.setCity(httpResult.getCity());
        result.setCountry(httpResult.getCountry());
        result.setNickname(httpResult.getNickname());
        result.setOpenid(httpResult.getOpenid());
        result.setPrivince(httpResult.getProvince());
        if (StringUtils.isBlank((String)httpResult.getSex())) {
            result.setSex("\u672a\u77e5");
        } else if (httpResult.getSex().equals("1")) {
            result.setSex("\u7537");
        } else if (httpResult.getSex().equals("2")) {
            result.setSex("\u5973");
        } else {
            result.setSex("\u672a\u77e5");
        }
        if (StringUtils.isNotBlank((String)httpResult.getSubscribe())) {
            result.setSubscribe(httpResult.getSubscribe().equals("1"));
        }
        result.setUnionid(httpResult.getUnionid());
        return result;
    }

    public <T extends WechatHttpsResult> T wechatHttpsGetWithAccessToken(String url, Map<String, Object> request, Class<T> resultClass, String appId) {
        request.put("access_token", this.getAccessTokenByAppId(appId));
        String responseStr = HttpsMrzjUtils.httpsGet(url, request, "UTF-8");
        WechatHttpsResult response = (WechatHttpsResult)JsonUtil.strToObj(responseStr, resultClass);
        if ("0".equals(response.getErrcode()) || null == response.getErrcode()) {
            return (T)response;
        }
        if ("40001".equals(response.getErrcode())) {
            request.put("access_token", this.getNewAccessToken(appId));
            responseStr = HttpsMrzjUtils.httpsGet(url, request, "UTF-8");
            response = (WechatHttpsResult)JsonUtil.strToObj(responseStr, resultClass);
            if ("0".equals(response.getErrcode()) || null == response.getErrcode()) {
                return (T)response;
            }
            return null;
        }
        return null;
    }

    public <T extends WechatHttpsResult> T wechatHttpsPostJsonWithAccessToken(String url, String param, Class<T> resultClass, String appId) {
        return this.wechatHttpsPostWithAccessToken(url, param, resultClass, appId, HttpsMrzjUtils.POST_TYPE_JSON);
    }

    public <T extends WechatHttpsResult> T wechatHttpsPostWithAccessToken(String url, String param, Class<T> resultClass, String appId) {
        return this.wechatHttpsPostWithAccessToken(url, param, resultClass, appId, HttpsMrzjUtils.POST_TYPE_FORM);
    }

    public <T extends WechatHttpsResult> T wechatHttpsPostWithAccessToken(String url, String param, Class<T> resultClass, String appId, Integer type) {
        String responseStr;
        WechatHttpsResult response;
        if (!url.contains("access_token=")) {
            url = url.contains("?") ? url + "&access_token=" + this.getAccessTokenByAppId(appId) : url + "?access_token=" + this.getAccessTokenByAppId(appId);
        }
        if ((response = (WechatHttpsResult)JsonUtil.strToObj(responseStr = HttpsMrzjUtils.httpsPost(url, param, type, "UTF-8", null, null, null), resultClass)) == null) {
            return null;
        }
        if (null == response.getErrcode() || "0".equals(response.getErrcode())) {
            return (T)response;
        }
        if ("40001".equals(response.getErrcode())) {
            url.replaceAll("access_token=[^&]*", "access_token=" + this.getNewAccessToken(appId));
            responseStr = HttpsMrzjUtils.httpsPost(url, param, type, "UTF-8", null, null, null);
            response = (WechatHttpsResult)JsonUtil.strToObj(responseStr, resultClass);
            if ("0".equals(response.getErrcode()) || null == response.getErrcode()) {
                return (T)response;
            }
            return null;
        }
        return null;
    }

    public String getSignStringByMD5(Map<String, Object> map, String appId) {
        String key2;
        int index = SystemConfig.Wechat.WECHAT_APP_ID.indexOf(appId);
        StringBuffer signString = new StringBuffer();
        TreeMap<String, Object> param = new TreeMap<String, Object>(map);
        for (String key2 : param.keySet()) {
            if (key2.toLowerCase().contains("sign")) continue;
            Object value = param.get(key2);
            signString.append(key2).append("=").append(value).append("&");
        }
        key2 = TalkillaConfig.WECHAT_PAYSIGNKEY;
        signString.append("key=").append(key2);
        String sign = EncryptUtil.encryptMD5(signString.toString());
        return sign.toUpperCase();
    }

    public boolean isSignRightByMD5(String sign, Map<String, Object> map, String appId) {
        if (StringUtils.isBlank((String)sign)) {
            return false;
        }
        return this.getSignStringByMD5(map, appId).equals(sign);
    }

    public String getSignStringBySHA1(Map<String, String> map) {
        StringBuffer signString = new StringBuffer();
        TreeMap<String, String> param = new TreeMap<String, String>(map);
        for (String key : param.keySet()) {
            if (key.toLowerCase().contains("sign")) continue;
            Object value = param.get(key);
            key = key.toLowerCase();
            signString.append("&").append(key).append("=").append(value);
        }
        String sign = EncryptUtil.encryptSHA1(signString.toString().substring(1), "UTF-8");
        return sign.toLowerCase();
    }

    public WeChatConfigResult getJsConfig(WechatConfigForm wechatConfigForm) {
        WeChatConfigResult result = new WeChatConfigResult();
        try {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("url", wechatConfigForm.getUrl());
            map.put("noncestr", wechatConfigForm.getNoncestr());
            map.put("timestamp", wechatConfigForm.getTimestamp());
            String ticket = this.getTicket(wechatConfigForm.getAppId());
            map.put("jsapi_ticket", ticket);
            String sign = this.getSignStringBySHA1(map);
            result.setJsapi_ticket(ticket);
            result.setNoncestr(wechatConfigForm.getNoncestr());
            result.setSign(sign);
            result.setTimestamp(wechatConfigForm.getTimestamp());
            result.setUrl(wechatConfigForm.getUrl());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public WechatUserLoginResult login(WechatLoginForm wechatLoginForm) {
        WechatHttpsResult tempResult = this.getAccessToken(wechatLoginForm.getCode(), wechatLoginForm.getAppId());
        WechatUserLoginResult result = new WechatUserLoginResult();
        if (tempResult == null) {
            return null;
        }
        result.setOpenid(tempResult.getOpenid());
        result.setUnionid(tempResult.getUnionid());
        return result;
    }

    public WechatHttpsResult getAccessToken(String code, String appId) {
        WechatHttpsForm request = new WechatHttpsForm();
        request.setAppid(SystemConfig.Wechat.WECHAT_APP_ID);
        request.setCode(code);
        request.setGrant_type("authorization_code");
        request.setSecret(SystemConfig.Wechat.WECHAT_APP_SECRET);
        String responseStr = HttpsMrzjUtils.httpsGet("https://api.weixin.qq.com/sns/oauth2/access_token", BeanUtils.getPropertiesMap(request), "UTF-8");
        WechatHttpsResult response = JsonUtil.strToObj(responseStr, WechatHttpsResult.class);
        return response;
    }

    public void createMenu(String token) {
        Menu menu = new Menu();
        Button[] menuButtons = new Button[3];
        UrlButton urlButton = new UrlButton();
        urlButton.setType("view");
        urlButton.setName("\u8bfe\u7a0b\u4e2d\u5fc3");
        urlButton.setUrl("https://open.weixin.qq.com/connect/oauth2/authorize?appid=wxa1e7eb4c847b83fc&redirect_uri=http%3a%2f%2fwechat.talkilla.org%2fwechat%2fcourse%2fcourseCenter&response_type=code&scope=snsapi_base&state=10#wechat_redirec");
        menuButtons[0] = urlButton;
        Button[] menuSubButtons = new Button[3];
        ComplexButton complexButton = new ComplexButton();
        urlButton = new UrlButton();
        urlButton.setType("view");
        urlButton.setName("\u4e13\u5c5e\u4e8c\u7ef4\u7801");
        urlButton.setUrl("https://open.weixin.qq.com/connect/oauth2/authorize?appid=wxa1e7eb4c847b83fc&redirect_uri=http%3a%2f%2fwechat.talkilla.org%2fwechat%2frecommend%2findex&response_type=code&scope=snsapi_base&state=10#wechat_redirect");
        menuSubButtons[0] = urlButton;
        urlButton = new UrlButton();
        urlButton.setType("view");
        urlButton.setName("\u5982\u4f55\u8fd0\u4f5c");
        urlButton.setUrl("http://mp.weixin.qq.com/s?__biz=MzIwODE3NTAyMA==&mid=100000033&idx=1&sn=798d86a48b18627e1f119e1d5250ebc4&chksm=17066be22071e2f490ae04934f8e9bb394d9db60ae63fc1cb6e1e439b1b5fd33838a90cbcc8a#rd");
        menuSubButtons[1] = urlButton;
        urlButton = new UrlButton();
        urlButton.setType("view");
        urlButton.setName("\u5956\u52b1\u6838\u9500");
        urlButton.setUrl("https://open.weixin.qq.com/connect/oauth2/authorize?appid=wxa1e7eb4c847b83fc&redirect_uri=http%3a%2f%2fwechat.talkilla.org%2fwechat%2ftimeAward%2ftimeAward%2fget&response_type=code&scope=snsapi_base&state=10#wechat_redirect");
        menuSubButtons[2] = urlButton;
        complexButton.setName("\u63a8\u8350\u8d62\u5b66\u65f6");
        complexButton.setSub_button(menuSubButtons);
        menuButtons[1] = complexButton;
        urlButton = new UrlButton();
        urlButton.setType("view");
        urlButton.setName("\u5e2e\u52a9\u4e2d\u5fc3");
        urlButton.setUrl("https://mp.weixin.qq.com/s?__biz=MzIwODE3NTAyMA==&mid=100000061&idx=1&sn=f41465653304dd34fbf1353cab1fe64f&chksm=17066bfe2071e2e8982b884e2b2cdd9d8584bdb99cd96aa22bb591081ccc74b329fdb7785782");
        menuButtons[2] = urlButton;
        menu.setButton(menuButtons);
        String jsonMenu = JSONObject.fromObject((Object)menu).toString();
        System.out.println(jsonMenu);
        WechatHttpsResult wechatHttpsResult = this.wechatHttpsPostWithMyAccessToken(" https://api.weixin.qq.com/cgi-bin/menu/create", jsonMenu, HttpsMrzjUtils.POST_TYPE_JSON, token, WechatHttpsResult.class);
        System.out.println(wechatHttpsResult);
    }

    public void getMenu(String token) {
        HashMap<String, Object> request = new HashMap<String, Object>();
        WechatHttpsResult wechatHttpsResult = this.wechatHttpsGetWithMyAccessToken("https://api.weixin.qq.com/cgi-bin/menu/get", request, WechatHttpsResult.class, token);
        System.out.println(wechatHttpsResult);
        System.out.println("-------");
    }

    public <T extends WechatHttpsResult> T wechatHttpsPostWithMyAccessToken(String url, String param, Integer type, String token, Class<T> resultClass) {
        if (!url.contains("access_token=")) {
            url = url.contains("?") ? url + "&access_token=" + token : url + "?access_token=" + token;
        }
        String responseStr = HttpsMrzjUtils.httpsPost(url, param, type, "UTF-8", null, null, null);
        WechatHttpsResult response = (WechatHttpsResult)JsonUtil.strToObj(responseStr, resultClass);
        System.out.println("---------");
        System.out.println(responseStr);
        System.out.println("----------");
        if (response == null) {
            return null;
        }
        if (null == response.getErrcode() || "0".equals(response.getErrcode())) {
            return (T)response;
        }
        return null;
    }

    public <T extends WechatHttpsResult> T wechatHttpsGetWithMyAccessToken(String url, Map<String, Object> request, Class<T> resultClass, String token) {
        request.put("access_token", token);
        String responseStr = HttpsMrzjUtils.httpsGet(url, request, "UTF-8");
        System.out.println(responseStr);
        WechatHttpsResult response = (WechatHttpsResult)JsonUtil.strToObj(responseStr, resultClass);
        if ("0".equals(response.getErrcode()) || null == response.getErrcode()) {
            return (T)response;
        }
        return null;
    }
}

