/*
 * Decompiled with CFR 0.152.
 */
package com.talkilla.service.impl.wechat;

import com.talkilla.form.UserLoginForm;
import com.talkilla.form.student.FindPwdSaveForm;
import com.talkilla.form.student.UserInfoModifySaveForm;
import com.talkilla.form.student.UserLoginByCodeForm;
import com.talkilla.mysql.domain.TLogin;
import com.talkilla.mysql.domain.TStudent;
import com.talkilla.mysql.mapper.TLoginDao;
import com.talkilla.mysql.mapper.TStudentDao;
import com.talkilla.service.CommonService;
import com.talkilla.service.wechat.UserService;
import com.talkilla.utils.CheckFormatUtils;
import com.talkilla.utils.PasswordUtil;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="userService")
public class UserServiceImpl
implements UserService {
    @Autowired
    private TLoginDao tLoginDao;
    @Autowired
    private TStudentDao tStudentDao;
    @Autowired
    private CommonService commonService;

    @Override
    public TLogin userLogin(UserLoginForm form) {
        TLogin login = null;
        login = CheckFormatUtils.isMobile((String)form.getUsername()) ? this.tLoginDao.userLoginByMobile(form.getUsername(), form.getPassword()) : this.tLoginDao.userLogin(form.getUsername(), form.getPassword());
        if (login != null) {
            login.setLoginCount(Integer.valueOf(login.getLoginCount() + 1));
            login.setUpdateTime(new Date());
            this.tLoginDao.updateByIdSelective(login);
        }
        return login;
    }

    @Override
    public TLogin userLoginByCode(UserLoginByCodeForm form) {
        Boolean result = this.commonService.checkCode(form.getMobile(), form.getCode());
        if (result.booleanValue()) {
            return this.tLoginDao.findByMobile(form.getMobile());
        }
        return null;
    }

    @Override
    public Map<String, String> savePwdByMobile(FindPwdSaveForm form) {
        HashMap<String, String> result = new HashMap<String, String>();
        TLogin login = this.tLoginDao.findByMobile(form.getMobile());
        if (!this.commonService.checkCode(form.getMobile(), form.getCode()).booleanValue()) {
            result.put("flag", "1");
            result.put("message", "\u624b\u673a\u9a8c\u8bc1\u7801\u9519\u8bef");
            return result;
        }
        if (login == null) {
            result.put("flag", "1");
            result.put("message", "\u7528\u6237\u4e0d\u5b58\u5728");
            return result;
        }
        if (!form.getPassword().equals(form.getConfirmPassword())) {
            result.put("flag", "1");
            result.put("message", "\u8f93\u5165\u7684\u5bc6\u7801\u4e0d\u4e00\u81f4");
            return result;
        }
        login.setLoginPwd(PasswordUtil.encrypt2((String)form.getPassword()));
        this.tLoginDao.updateByIdSelective(login);
        result.put("flag", "0");
        result.put("message", "\u4fee\u6539\u6210\u529f");
        return result;
    }

    @Override
    public Map<String, String> saveStuUserInfo(UserInfoModifySaveForm form) {
        TStudent student = this.tStudentDao.findOne(form.getStuId());
        student.setBirthday(form.getBirthday());
        student.setRealName(form.getStuName());
        student.setParentName(form.getParentName());
        student.setWeixinhao(form.getWeixin());
        student.setEnglishName(form.getEnglishName());
        student.setAvatar(form.getAvatar());
        student.setProvinceId(form.getProvinceId());
        student.setCityId(form.getCityId());
        student.setDistrictId(form.getDistrictId());
        student.setGender(form.getGender());
        this.tStudentDao.updateByIdSelective(student);
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("flag", "0");
        result.put("message", "\u4fee\u6539\u6210\u529f");
        return result;
    }

    @Override
    public TStudent findStudentById(Integer stuId) {
        TStudent student = this.tStudentDao.findOne(stuId);
        return student;
    }
}

