/*
 * Decompiled with CFR 0.152.
 */
package com.talkilla.service.impl.wechat;

import com.talkilla.constant.TalkillaConstant;
import com.talkilla.mysql.domain.TAwardCourse;
import com.talkilla.mysql.domain.TCourse;
import com.talkilla.mysql.domain.TCourseRule;
import com.talkilla.mysql.domain.TCourseSessionStudent;
import com.talkilla.mysql.domain.TCoursesession;
import com.talkilla.mysql.domain.TStudent;
import com.talkilla.mysql.domain.TStudentConsultant;
import com.talkilla.mysql.domain.TTeacher;
import com.talkilla.mysql.domain.TWechat;
import com.talkilla.mysql.mapper.TAwardCourseDao;
import com.talkilla.mysql.mapper.TAwardCourseRecordDao;
import com.talkilla.mysql.mapper.TConsultantDao;
import com.talkilla.mysql.mapper.TCourseDao;
import com.talkilla.mysql.mapper.TCourseRuleDao;
import com.talkilla.mysql.mapper.TCourseSessionStudentDao;
import com.talkilla.mysql.mapper.TCourseStudentDao;
import com.talkilla.mysql.mapper.TCoursesessionDao;
import com.talkilla.mysql.mapper.TCustTimezoneDao;
import com.talkilla.mysql.mapper.TLoginDao;
import com.talkilla.mysql.mapper.TStudentConsultantDao;
import com.talkilla.mysql.mapper.TStudentDao;
import com.talkilla.mysql.mapper.TTeacherDao;
import com.talkilla.mysql.mapper.TWechatDao;
import com.talkilla.result.LeaveCourseResult;
import com.talkilla.service.TAwardCourseService;
import com.talkilla.service.TCourseService;
import com.talkilla.service.TCoursesessionService;
import com.talkilla.service.wechat.LessonTimeAwardService;
import com.talkilla.utils.DateUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service(value="lessonTimeAwardService")
public class LessonTimeAwardServiceImpl
implements LessonTimeAwardService {
    @Autowired
    private TCourseDao tCourseDao;
    @Autowired
    private TAwardCourseDao tAwardCourseDao;
    @Autowired
    private TCourseRuleDao tCourseRuleDao;
    @Autowired
    private TAwardCourseRecordDao tAwardCourseRecordDao;
    @Autowired
    private TCoursesessionDao tCoursesessionDao;
    @Autowired
    private TTeacherDao tTeacherDao;
    @Autowired
    private TCustTimezoneDao tCustTimezoneDao;
    @Autowired
    private TLoginDao tLoginDao;
    @Autowired
    private TStudentConsultantDao tStudentConsultantDao;
    @Autowired
    private TConsultantDao tConsultantDao;
    @Autowired
    private TWechatDao tWechatDao;
    @Autowired
    private TStudentDao tStudentDao;
    @Autowired
    private TCourseService tCourseService;
    @Autowired
    private TCoursesessionService tCoursesessionService;
    @Autowired
    private TAwardCourseService tAwardCourseService;
    @Autowired
    private TCourseStudentDao tCourseStudentDao;
    @Autowired
    private TCourseSessionStudentDao tCourseSessionStudentDao;

    @Override
    public TAwardCourse findOneByStuId(Integer id) {
        return this.tAwardCourseDao.findOneByStuId(id);
    }

    @Override
    public TCourse findOne(Integer cid) {
        return this.tCourseDao.findOne(cid);
    }

    @Override
    public TStudentConsultant findByStudentId(Integer stuId) {
        return this.tStudentConsultantDao.findByStudentId(stuId);
    }

    @Override
    public TWechat getTWechatInfoByLoginId(Integer loginId) {
        return this.tWechatDao.getTWechatInfoByLoginId(loginId);
    }

    @Override
    public List<TCourseRule> findOneByCid(Integer cid) {
        return this.tCourseRuleDao.findOneByCid(cid);
    }

    @Override
    @Transactional(rollbackFor={Throwable.class}, propagation=Propagation.REQUIRED)
    public Map<String, String> timeAwardCompleteWriteOff(TStudent _student, Integer cid, Integer courseTime, Double frequency) throws Exception {
        List<LeaveCourseResult> leaveCourseResults;
        HashMap<String, String> _map = new HashMap<String, String>();
        TStudentConsultant studentConsultant = this.tStudentConsultantDao.findByStudentId(_student.getStuId());
        TWechat tWechat = this.tWechatDao.getTWechatInfoByLoginId(_student.getLoginId());
        TCourse tCourse = this.tCourseDao.findOne(Integer.valueOf(cid));
        TAwardCourse tAwardCourse = this.tAwardCourseDao.findOneByStuId(Integer.valueOf(_student.getStuId()));
        if (tAwardCourse.getCourseNum() == 0.0) {
            _map.put("code", "0");
            _map.put("msg", "\u5956\u52b1\u6c60\u7684\u5c0f\u65f6\u6570\u4e3a0");
            return _map;
        }
        if (tCourse.getType().equals(100002)) {
            _map.put("code", "0");
            _map.put("msg", "\u5c0f\u7ec4\u8bfe\u4e0d\u80fd\u591f\u6838\u9500");
            return _map;
        }
        Integer teacherId = null;
        if (teacherId == null) {
            TCoursesession lastOneByCid = this.tCoursesessionDao.findLastOneByCid(tCourse.getCid());
            teacherId = lastOneByCid.getTeacherId();
        }
        TTeacher tTeacher = this.tTeacherDao.findOne(teacherId);
        this.tCourseService.processCourseCount(cid, (double)tCourse.getDuration().intValue() * frequency / 60.0, TalkillaConstant.CourseCountType.STUDENT_HEXIAO);
        if (frequency.intValue() >= 1 && (leaveCourseResults = this.tCoursesessionService.leaveCoursePlan(cid, frequency.intValue())) != null && leaveCourseResults.size() > 0) {
            List addBeforeStudentIdList = this.tCourseStudentDao.findStudentIdListByCid(tCourse.getCid());
            for (LeaveCourseResult leaveCourseResult : leaveCourseResults) {
                TCoursesession newCoursesession = new TCoursesession();
                newCoursesession.setTeacherId(teacherId);
                newCoursesession.setCreateTime(new Date());
                newCoursesession.setDuration(Integer.valueOf(leaveCourseResult.getTimeLength()));
                newCoursesession.setSessionid(null);
                newCoursesession.setStatus(null);
                newCoursesession.setStarttime(DateUtils.parseDateToSecond((String)leaveCourseResult.getStartTime()));
                newCoursesession.setIsSystem(Integer.valueOf(1));
                newCoursesession.setCid(cid);
                newCoursesession.setRate(tCourse.getRate());
                newCoursesession.setIspay(Integer.valueOf(0));
                newCoursesession.setPrice(BigDecimal.ZERO);
                newCoursesession.setStuId(_student.getStuId());
                newCoursesession.setStuEnName(_student.getEnglishName());
                newCoursesession.setStuName(_student.getRealName());
                newCoursesession.setCourseType(tCourse.getType());
                if (tCourse.getType() == 100001) {
                    newCoursesession.setRate(new BigDecimal(tTeacher.getOneOnOne()));
                } else {
                    newCoursesession.setRate(new BigDecimal(tTeacher.getOneOnMultiple()));
                }
                this.tCoursesessionDao.insertSelective(newCoursesession);
                ArrayList<TCourseSessionStudent> tCourseSessionStudentList = new ArrayList<TCourseSessionStudent>();
                for (Integer stuId : addBeforeStudentIdList) {
                    TCourseSessionStudent tCourseSessionStudent = new TCourseSessionStudent();
                    tCourseSessionStudent.setCourseSessionId(newCoursesession.getSessionid());
                    tCourseSessionStudent.setStudentId(stuId);
                    tCourseSessionStudent.setCreater(String.valueOf(_student.getLoginId()));
                    tCourseSessionStudentList.add(tCourseSessionStudent);
                }
                this.tCourseSessionStudentDao.batchInsert(tCourseSessionStudentList);
            }
        }
        this.tAwardCourseService.process(_student.getStuId(), (double)tCourse.getDuration().intValue() * frequency / 60.0, TalkillaConstant.CourseAward.MINUS_FOR_USER, "\u5b66\u5458\u5fae\u4fe1\u7aef\u6838\u9500\u64cd\u4f5c", cid);
        return _map;
    }
}

