/*
 * Decompiled with CFR 0.152.
 */
package com.talkilla.service.impl.teacher;

import com.talkilla.constant.SystemConfig;
import com.talkilla.constant.TalkillaConstant;
import com.talkilla.form.UserLoginForm;
import com.talkilla.form.student.FindpwdForm;
import com.talkilla.form.student.RegisterForm;
import com.talkilla.form.teacher.PersonalInfoUpdateForm;
import com.talkilla.form.teacher.ToChangePasswordPageForm;
import com.talkilla.mysql.domain.TLogin;
import com.talkilla.mysql.domain.TSendEmailRecord;
import com.talkilla.mysql.domain.TTeacher;
import com.talkilla.mysql.mapper.TCountryDao;
import com.talkilla.mysql.mapper.TDTimezoneDao;
import com.talkilla.mysql.mapper.TLoginDao;
import com.talkilla.mysql.mapper.TNationDao;
import com.talkilla.mysql.mapper.TRoleMenuDao;
import com.talkilla.mysql.mapper.TSendEmailRecordDao;
import com.talkilla.mysql.mapper.TTeacherDao;
import com.talkilla.otherbean.NationDto;
import com.talkilla.result.ReturnMessageResult;
import com.talkilla.result.teacher.PersonalInfoResult;
import com.talkilla.result.teacher.ZTreeNode;
import com.talkilla.service.UploadPhotoService;
import com.talkilla.service.teacher.TeaUserService;
import com.talkilla.serviceUtils.TalkillaEmailMessageUtils;
import com.talkilla.utils.NUllChangeUtils;
import com.talkilla.utils.PasswordUtil;
import com.talkilla.utils.UploadPhotoUtils;
import java.lang.reflect.InvocationTargetException;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.RandomUtils;
import org.omg.CORBA.portable.ApplicationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;

@Service(value="teaUserService")
public class TeaUserServiceImpl
implements TeaUserService {
    Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private TLoginDao tLoginDao;
    @Autowired
    private TCountryDao tCountryDao;
    @Autowired
    private TNationDao tNationDao;
    @Autowired
    private TDTimezoneDao tdTimezoneDao;
    @Autowired
    private TTeacherDao tTeacherDao;
    @Autowired
    private TRoleMenuDao tRoleMenuDao;
    @Autowired
    UploadPhotoService uploadPhotoService;
    @Autowired
    private TSendEmailRecordDao tSendEmailRecordDao;

    @Override
    public TLogin userLogin(UserLoginForm form) {
        return this.tLoginDao.userLogin(form.getUsername(), form.getPassword());
    }

    @Override
    @Transactional(rollbackFor={Throwable.class}, propagation=Propagation.REQUIRED)
    public String passwordUpdate(ToChangePasswordPageForm form, Integer loginId) {
        String flag = "";
        String oldPwd = form.getOldPwd();
        String newPwd = form.getNewPwd();
        String rNewPwd = form.getrNewPwd();
        if (StringUtils.isEmpty((String)oldPwd)) {
            flag = "old password is empty";
            return flag;
        }
        if (StringUtils.isEmpty((String)newPwd)) {
            flag = "new password is empty";
            return flag;
        }
        if (StringUtils.isEmpty((String)rNewPwd)) {
            flag = "repeat new password is empty";
            return flag;
        }
        if (!newPwd.equals(rNewPwd)) {
            flag = "new password is not same";
            return flag;
        }
        TLogin tLogin = this.tLoginDao.findOne(loginId);
        if (tLogin.getLoginPwd().equals(PasswordUtil.encrypt2((String)oldPwd).toLowerCase())) {
            tLogin.setLoginPwd(PasswordUtil.encrypt2((String)newPwd).toLowerCase());
            this.tLoginDao.updateByIdSelective(tLogin);
            flag = "success";
            return flag;
        }
        flag = "old password is not correct";
        return flag;
    }

    @Override
    public PersonalInfoResult personalInfo(TTeacher teacher) {
        PersonalInfoResult infoResult = new PersonalInfoResult();
        List nations = this.tNationDao.findAllNationDto();
        List timezoneList = this.tdTimezoneDao.findListString();
        teacher = this.tTeacherDao.findOne(teacher.getTeacherId());
        infoResult.setCountryList(nations);
        infoResult.setTimezoneList(timezoneList);
        infoResult.settTeacher(teacher);
        return infoResult;
    }

    @Override
    @Transactional(rollbackFor={Throwable.class}, propagation=Propagation.REQUIRED)
    public ReturnMessageResult personalInfoUpdate(TTeacher teacher, MultipartFile fileItem, PersonalInfoUpdateForm form) throws IllegalAccessException, InvocationTargetException, ApplicationException {
        ReturnMessageResult messageResult = new ReturnMessageResult();
        TTeacher tTeacher = this.tTeacherDao.findOne(teacher.getTeacherId());
        BeanUtils.copyProperties((Object)form, (Object)tTeacher);
        if (StringUtils.isNotBlank((String)fileItem.getOriginalFilename())) {
            String filePath = UploadPhotoUtils.savePhoto((MultipartFile)fileItem, (String)form.getAvatar(), (String)"teacher");
            tTeacher.setAvatar(filePath);
            NUllChangeUtils.nullConverNullString((Object)tTeacher);
            tTeacher.setUpdateTime(new Date());
            this.tTeacherDao.updateByIdSelective(tTeacher);
            messageResult.setFlag(Integer.valueOf(0));
            messageResult.setMessage("Saved successfully.");
        } else if (StringUtils.isBlank((String)tTeacher.getAvatar())) {
            messageResult.setFlag(Integer.valueOf(1));
            messageResult.setMessage("The picture can't be empty!");
        } else {
            tTeacher.setUpdateTime(new Date());
            this.tTeacherDao.updateByIdSelective(tTeacher);
            messageResult.setFlag(Integer.valueOf(0));
            messageResult.setMessage("Saved successfully.");
        }
        return messageResult;
    }

    @Override
    public List<ZTreeNode> findTeacherMenuList() {
        return this.tRoleMenuDao.findTeacherMenuList();
    }

    @Override
    public TTeacher findTeacherByLoginId(Integer loginId) {
        return this.tTeacherDao.findTeacherByLoginId(loginId);
    }

    @Override
    public TLogin findTLoginByLoginId(Integer loginId) {
        return this.tLoginDao.findOne(loginId);
    }

    @Override
    public HashMap<String, String> findpwd(FindpwdForm form) {
        HashMap<String, String> result = new HashMap<String, String>();
        boolean flag = false;
        TLogin tLogin = this.tLoginDao.findByLoginName(form.getLoginname());
        if (tLogin == null) {
            result.put("flag", "1");
            result.put("message", form.getLoginname() + " loginname not exists");
            return result;
        }
        int newPwd = RandomUtils.nextInt((int)1000000);
        tLogin.setLoginPwd(PasswordUtil.encrypt2((String)(newPwd + "")).toLowerCase());
        this.tLoginDao.updateByIdSelective(tLogin);
        String title = "Language Spring Online - find password";
        String content = "new password :" + newPwd;
        TalkillaEmailMessageUtils.sendMessageToPeople(tLogin.getLoginName(), content, title);
        TSendEmailRecord tSendEmailRecord = new TSendEmailRecord();
        tSendEmailRecord.setUserType(TalkillaConstant.SendEmailUserType.TEACHER);
        tSendEmailRecord.setEmail(tLogin.getLoginName());
        tSendEmailRecord.setEmailType(TalkillaConstant.SendEmailType.SEND_TEACHER_FOR_FIND_PWD);
        tSendEmailRecord.setRecordType(TalkillaConstant.SendEmailType.SEND_TEACHER_FOR_FIND_PWD);
        tSendEmailRecord.setCid(Integer.valueOf(0));
        tSendEmailRecord.setStuId(Integer.valueOf(0));
        tSendEmailRecord.setTeacherId(Integer.valueOf(0));
        this.tSendEmailRecordDao.insertSelective(tSendEmailRecord);
        result.put("flag", "0");
        result.put("message", "new password has already sended to your email");
        return result;
    }

    @Override
    @Transactional(rollbackFor={Throwable.class}, propagation=Propagation.REQUIRED)
    public HashMap<String, String> register(HttpSession session, RegisterForm form, MultipartFile fileItem) {
        HashMap<String, String> result = new HashMap<String, String>();
        String msg = null;
        if (Objects.nonNull(fileItem) && fileItem.getSize() > 0L) {
            msg = this.uploadPhotoService.checkPhotoEn(fileItem, "5", "500", ".jpg.JPG.Jpg.gif.GIF");
        }
        if (StringUtils.isNotBlank(msg)) {
            result.put("flag", "1");
            result.put("message", msg);
            return result;
        }
        TLogin tLogin = this.tLoginDao.findByLoginName(form.getUsername());
        if (tLogin != null) {
            result.put("flag", "1");
            result.put("message", form.getUsername() + " has already been used\uff01\uff01");
            return result;
        }
        if (!form.getPassword().equals(form.getConfirmPassword())) {
            result.put("flag", "1");
            result.put("message", "Your Repeat password is not equals with password\uff0cplease try again \uff01\uff01");
            return result;
        }
        String path = this.uploadPhotoService.savePhoto(fileItem, "", "", "teacher");
        TLogin newTLogin = new TLogin();
        newTLogin.setCreater(form.getUsername());
        newTLogin.setLoginCount(Integer.valueOf(0));
        newTLogin.setLoginName(form.getUsername());
        newTLogin.setLoginPwd(PasswordUtil.encrypt2((String)form.getPassword()).toLowerCase());
        newTLogin.setRoleId(TalkillaConstant.KEY_LOGIN_TYPE_TEACHER);
        int flag = this.tLoginDao.insertSelective(newTLogin);
        if (flag < 1) {
            this.logger.info("tLoginDao.insertSelective(newTLogin) \u6267\u884c\u5931\u8d25");
        }
        TTeacher tTeacher = new TTeacher();
        if (StringUtils.isNotBlank((String)form.getZoomId())) {
            String zoomid = form.getZoomId().replace("-", "");
            tTeacher.setJoinurl("https://zoom.us/j/" + zoomid);
        }
        tTeacher.setAvatar(path);
        tTeacher.setLoginId(newTLogin.getLoginId());
        tTeacher.setCountry(form.getCountry());
        tTeacher.setLastName(form.getLastName());
        tTeacher.setFirstName(form.getFirstName());
        tTeacher.setGender(form.getGender());
        tTeacher.setSkypeid(form.getSkypeId());
        tTeacher.setZoomId(form.getZoomId());
        tTeacher.setTimezone(form.getTimezone());
        tTeacher.setPaypalAccount(form.getPaypalAccount());
        tTeacher.setCountry(form.getCountry());
        tTeacher.setAboutMyself(form.getAboutmyself());
        tTeacher.setTeachingSinceYear(form.getTeachingsinceyear());
        tTeacher.setCertificates(form.getCertificates());
        tTeacher.setWorkExperience(form.getWorkexperience());
        tTeacher.setCity(form.getCity());
        flag = this.tTeacherDao.insertSelective(tTeacher);
        if (flag < 1) {
            this.logger.info("tTeacherDao.insertSelective(tStudent) \u6267\u884c\u5931\u8d25");
        }
        List list = this.tNationDao.findAllNationDto();
        String nation = "";
        try {
            if (list != null) {
                for (NationDto nd : list) {
                    if (!nd.getNationid().equals(tTeacher.getCountry().toString())) continue;
                    nation = nd.getEname();
                }
            }
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        TalkillaEmailMessageUtils.sendNewTeacherRegisterSuccess(SystemConfig.Admin.ADMIN_EMAIL, newTLogin, tTeacher, nation);
        TSendEmailRecord tSendEmailRecord = new TSendEmailRecord();
        tSendEmailRecord.setUserType(TalkillaConstant.SendEmailUserType.ADMIN);
        tSendEmailRecord.setEmail(SystemConfig.Admin.ADMIN_EMAIL);
        tSendEmailRecord.setEmailType(TalkillaConstant.SendEmailType.SEND_NEW_TEACHER_REGISTER_SUCCESS);
        tSendEmailRecord.setRecordType(TalkillaConstant.SendEmailType.SEND_NEW_TEACHER_REGISTER_SUCCESS);
        tSendEmailRecord.setCid(Integer.valueOf(0));
        tSendEmailRecord.setStuId(Integer.valueOf(0));
        tSendEmailRecord.setTeacherId(tTeacher.getTeacherId());
        this.tSendEmailRecordDao.insertSelective(tSendEmailRecord);
        String message = "Dear " + tTeacher.getFirstName() + " " + tTeacher.getLastName() + ", Thanks for your registeration at Talkilla.Org for being an online English Tutor. We will get back to you very soon.";
        result.put("flag", "0");
        result.put("message", message);
        return result;
    }
}

