/*
 * Decompiled with CFR 0.152.
 */
package com.talkilla.service.impl.teacher;

import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.talkilla.form.teacher.StudentClassDetailForm;
import com.talkilla.form.teacher.StudentListForm;
import com.talkilla.form.teacher.StudentSummaryAddForm;
import com.talkilla.form.teacher.StudentSummaryListForm;
import com.talkilla.mysql.domain.TCourse;
import com.talkilla.mysql.domain.TStudent;
import com.talkilla.mysql.domain.TStudentSummary;
import com.talkilla.mysql.domain.TTeacher;
import com.talkilla.mysql.domain.TZonecode;
import com.talkilla.mysql.mapper.TCourseDao;
import com.talkilla.mysql.mapper.TStudentDao;
import com.talkilla.mysql.mapper.TStudentSummaryDao;
import com.talkilla.mysql.mapper.TZonecodeDao;
import com.talkilla.result.ReturnMessageResult;
import com.talkilla.result.admin.base.PageObj;
import com.talkilla.result.teacher.StudentDetailResult;
import com.talkilla.result.teacher.StudentInfoDetailResult;
import com.talkilla.service.teacher.TeaStudentService;
import java.util.List;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service(value="teaStudentService")
public class TeaStudentServiceImpl
implements TeaStudentService {
    @Autowired
    private TStudentDao tStudentDao;
    @Autowired
    private TCourseDao tCourseDao;
    @Autowired
    private TZonecodeDao tZonecodeDao;
    @Autowired
    private TStudentSummaryDao tStudentSummaryDao;

    @Override
    public PageObj studentList(StudentListForm form, TTeacher teacher) {
        Integer pageNo = form.getPageNo();
        Integer pageSize = form.getPageSize();
        if (pageNo == null || pageNo <= 0) {
            pageNo = 1;
            form.setPageNo(pageNo);
        }
        if (pageSize == null || pageSize <= 0) {
            pageSize = 10;
            form.setPageSize(pageSize);
        }
        form.setTeacherId(teacher.getTeacherId());
        Page page = PageHelper.startPage((int)pageNo, (int)pageSize);
        this.tStudentDao.studentList(form);
        PageObj pageObj = new PageObj();
        pageObj.setCurrPageNumber(pageNo);
        pageObj.setFirstPageNumber(Integer.valueOf(1));
        pageObj.setLastPageNumber(pageObj.processTotalPage(page.getTotal(), Integer.valueOf(page.getPageSize())));
        pageObj.setPreviousPageNumber(pageObj.processPreviousPage(pageNo));
        pageObj.setNextPageNumber(pageObj.processNextPage());
        pageObj.setPageElements(page.getResult());
        pageObj.setPageSize(pageSize);
        pageObj.setTotalCount(Long.valueOf(page.getTotal()));
        return pageObj;
    }

    @Override
    public List<StudentDetailResult> studentDetailList(TTeacher teacher, Integer stuId) {
        return this.tStudentDao.studentDetailList(teacher.getTeacherId(), stuId);
    }

    @Override
    public TCourse studentClassDetail(StudentClassDetailForm form) {
        return this.tCourseDao.fingStudentClassDetail(form.getStuId(), form.getClassid());
    }

    @Override
    public StudentInfoDetailResult studentInfoDetail(Integer stuId) {
        StudentInfoDetailResult result = new StudentInfoDetailResult();
        TStudent tStudent = this.tStudentDao.findOne(stuId);
        BeanUtils.copyProperties((Object)tStudent, (Object)result);
        TZonecode tZonecode = this.tZonecodeDao.findOne(tStudent.getCity());
        result.setCityName(tZonecode.getName());
        return result;
    }

    @Override
    public PageObj studentSummaryList(TTeacher teacher, StudentSummaryListForm form) {
        Integer pageNo = form.getPageNo();
        Integer pageSize = form.getPageSize();
        if (pageNo == null || pageNo <= 0) {
            pageNo = 1;
            form.setPageNo(pageNo);
        }
        if (pageSize == null || pageSize <= 0) {
            pageSize = 10;
            form.setPageSize(pageSize);
        }
        form.setTeacherId(teacher.getTeacherId());
        Page page = PageHelper.startPage((int)pageNo, (int)pageSize);
        this.tStudentSummaryDao.findtStudentSummaryList(form.getStuId(), form.getTeacherId());
        PageObj pageObj = new PageObj();
        pageObj.setCurrPageNumber(pageNo);
        pageObj.setFirstPageNumber(Integer.valueOf(1));
        pageObj.setLastPageNumber(pageObj.processTotalPage(page.getTotal(), Integer.valueOf(page.getPageSize())));
        pageObj.setPreviousPageNumber(pageObj.processPreviousPage(pageNo));
        pageObj.setNextPageNumber(pageObj.processNextPage());
        pageObj.setPageElements(page.getResult());
        pageObj.setPageSize(pageSize);
        pageObj.setTotalCount(Long.valueOf(page.getTotal()));
        return pageObj;
    }

    @Override
    @Transactional(rollbackFor={Throwable.class}, propagation=Propagation.REQUIRED)
    public ReturnMessageResult studentSummaryAdd(TTeacher teacher, StudentSummaryAddForm form) {
        ReturnMessageResult messageResult = new ReturnMessageResult();
        TStudentSummary tStudentSummary = new TStudentSummary();
        tStudentSummary.setTeacherId(teacher.getTeacherId());
        tStudentSummary.setStudentId(form.getStuId());
        tStudentSummary.setSummary(form.getSummary());
        this.tStudentSummaryDao.insertSelective(tStudentSummary);
        messageResult.setFlag(Integer.valueOf(0));
        messageResult.setMessage("\u4fdd\u5b58\u6210\u529f");
        return messageResult;
    }
}

