/*
 * Decompiled with CFR 0.152.
 */
package com.talkilla.service.impl.teacher;

import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.talkilla.constant.SystemConfig;
import com.talkilla.constant.TalkillaConstant;
import com.talkilla.form.teacher.CourseTeachingListForm;
import com.talkilla.form.teacher.FindIncomeForm;
import com.talkilla.form.teacher.SaveModifyStatusForm;
import com.talkilla.mysql.domain.TConsultant;
import com.talkilla.mysql.domain.TCourse;
import com.talkilla.mysql.domain.TCourseSessionStudent;
import com.talkilla.mysql.domain.TCoursesession;
import com.talkilla.mysql.domain.TCustTimezone;
import com.talkilla.mysql.domain.TLogin;
import com.talkilla.mysql.domain.TSendEmailRecord;
import com.talkilla.mysql.domain.TStuFeeback;
import com.talkilla.mysql.domain.TStudent;
import com.talkilla.mysql.domain.TStudentConsultant;
import com.talkilla.mysql.domain.TTeacher;
import com.talkilla.mysql.domain.TTeacherComments;
import com.talkilla.mysql.domain.TTeacherNotice;
import com.talkilla.mysql.domain.TWechat;
import com.talkilla.mysql.mapper.TConsultantDao;
import com.talkilla.mysql.mapper.TCourseDao;
import com.talkilla.mysql.mapper.TCourseSessionStudentDao;
import com.talkilla.mysql.mapper.TCoursesessionDao;
import com.talkilla.mysql.mapper.TCustTimezoneDao;
import com.talkilla.mysql.mapper.TLoginDao;
import com.talkilla.mysql.mapper.TSendEmailRecordDao;
import com.talkilla.mysql.mapper.TStuFeebackDao;
import com.talkilla.mysql.mapper.TStudentConsultantDao;
import com.talkilla.mysql.mapper.TStudentDao;
import com.talkilla.mysql.mapper.TTeacherCommentsDao;
import com.talkilla.mysql.mapper.TTeacherDao;
import com.talkilla.mysql.mapper.TTeacherNoticeDAO;
import com.talkilla.mysql.mapper.TWechatDao;
import com.talkilla.mysql.mapper.TZonecodeDao;
import com.talkilla.result.CoursesessionInfoResult;
import com.talkilla.result.LeaveCourseResult;
import com.talkilla.result.ReturnMessageResult;
import com.talkilla.result.teacher.CourseTeachingListResult;
import com.talkilla.result.teacher.CourseTeachingResult;
import com.talkilla.result.teacher.ReportMessageResult;
import com.talkilla.result.teacher.TeacherIndexResult;
import com.talkilla.result.teacher.TeacherSchedualResult;
import com.talkilla.result.teacher.ToModifystustatusResult;
import com.talkilla.service.TCourseService;
import com.talkilla.service.TCoursesessionService;
import com.talkilla.service.teacher.TeaCourseService;
import com.talkilla.serviceUtils.TalkillaEmailMessageUtils;
import com.talkilla.serviceUtils.TimeZoneUtil;
import com.talkilla.utils.DateUtils;
import com.talkilla.wechat.form.WechatCourseStatusChangeForm;
import com.talkilla.wechat.service.WechatMessageService;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service(value="teaCourseService")
public class TeaCourseServiceImpl
implements TeaCourseService {
    private static final Logger log = LoggerFactory.getLogger(TeaCourseServiceImpl.class);
    @Autowired
    private TCoursesessionDao tCoursesessionDao;
    @Autowired
    private TCustTimezoneDao tCustTimezoneDao;
    @Autowired
    private TCourseDao tCourseDao;
    @Autowired
    private TTeacherCommentsDao tTeacherCommentsDao;
    @Autowired
    private TTeacherDao tTeacherDao;
    @Autowired
    private TCoursesessionService tCoursesessionService;
    @Autowired
    private TStudentDao tStudentDao;
    @Autowired
    private TLoginDao tLoginDao;
    @Autowired
    private TStudentConsultantDao tStudentConsultantDao;
    @Autowired
    private WechatMessageService wechatMessageService;
    @Autowired
    private TWechatDao tWechatDao;
    @Autowired
    private TStuFeebackDao tStuFeebackDao;
    @Autowired
    private TZonecodeDao tZonecodeDao;
    @Autowired
    private TConsultantDao tConsultantDao;
    @Autowired
    private TCourseService tCourseService;
    @Autowired
    private TCourseSessionStudentDao tCourseSessionStudentDao;
    @Autowired
    private TSendEmailRecordDao tSendEmailRecordDao;
    @Autowired
    private TTeacherNoticeDAO tTeacherNoticeDAO;

    @Override
    public TeacherIndexResult teacherIndex(TTeacher teacher) throws ParseException {
        TeacherIndexResult result = new TeacherIndexResult();
        ArrayList<TeacherIndexResult.Course> courseList = new ArrayList<TeacherIndexResult.Course>();
        FindIncomeForm form = new FindIncomeForm();
        form.setTeacherId(teacher.getTeacherId());
        String min = DateUtils.getThisYearFirstDay();
        String max = DateUtils.getThisYearLastDay();
        form.setStartTime(min);
        form.setEndTime(max);
        BigDecimal income1 = this.tCoursesessionDao.findIncome1ByTeacherId(form);
        BigDecimal income2 = this.tCoursesessionDao.findIncome2ByTeacherId(form);
        result.setYearToDayTotalFee(income1.subtract(income2).setScale(2, RoundingMode.HALF_UP));
        min = DateUtils.getLastMonthFirstDay();
        max = DateUtils.getLastMonthLastDay();
        form.setStartTime(min);
        form.setEndTime(max);
        income1 = this.tCoursesessionDao.findIncome1ByTeacherId(form);
        income2 = this.tCoursesessionDao.findIncome2ByTeacherId(form);
        result.setLastMonthFee(income1.subtract(income2).setScale(2, RoundingMode.HALF_UP));
        min = DateUtils.getThisMonthFirstDay();
        max = DateUtils.getThisMonthLastDay();
        form.setStartTime(min);
        form.setEndTime(max);
        income1 = this.tCoursesessionDao.findIncome1ByTeacherId(form);
        income2 = this.tCoursesessionDao.findIncome2ByTeacherId(form);
        result.setThisMonthFee(income1.subtract(income2).setScale(2, RoundingMode.HALF_UP));
        String timezone = teacher.getTimezone();
        TCustTimezone tCustTimezone = this.tCustTimezoneDao.findByTimezone(timezone);
        List coursesessionList = this.tCoursesessionDao.findListByTeacherId(teacher.getTeacherId());
        if (coursesessionList != null && coursesessionList.size() > 0) {
            ArrayList courseSessionIds = Lists.newArrayList();
            for (CoursesessionInfoResult coursesessionInfo : coursesessionList) {
                courseSessionIds.add(coursesessionInfo.getSessionid());
                TeacherIndexResult.Course course = new TeacherIndexResult.Course(result);
                String title = coursesessionInfo.getClassname();
                Integer status = coursesessionInfo.getStatus();
                String statusStr = (String)TalkillaConstant.statusMap.get(status);
                String englishName = coursesessionInfo.getEnglishName();
                if (statusStr != null) {
                    title = (String)statusStr + "(" + title + ")";
                }
                String color = TalkillaConstant.COURSE_STATUS_COMPLETED.equals(status) ? "gray" : (TalkillaConstant.COURSE_STATUS_LEAVE_TEACHER.equals(status) || TalkillaConstant.COURSE_STATUS_LEAVE_STUDENT.equals(status) || TalkillaConstant.COURSE_STATUS_SPECIAL_CASES.equals(status) ? "blue" : (TalkillaConstant.COURSE_STATUS_ABSENT_TEACHER.equals(status) || TalkillaConstant.COURSE_STATUS_ABSENT_STUDENT.equals(status) ? "red" : (TalkillaConstant.COURSE_STATUS_UMCONFIRMED.equals(status) ? "purple" : "green")));
                Date starttime = tCustTimezone != null ? TimeZoneUtil.findTimeByCustomerDate(coursesessionInfo.getStarttime(), tCustTimezone) : TimeZoneUtil.Date2TimezoneDefault(coursesessionInfo.getStarttime(), timezone);
                course.setClassname(coursesessionInfo.getClassname());
                course.setType(coursesessionInfo.getType());
                course.setStarTimeStr(DateUtils.formatDateToMinute((Date)starttime));
                course.setEndTimeStr(DateUtils.formatDateToMinute((Date)DateUtils.addTimeByType((Date)starttime, (int)12, (int)coursesessionInfo.getDuration())));
                course.setSessionid(coursesessionInfo.getSessionid());
                course.setTitle(title);
                course.setEnglishName(englishName);
                course.setColor(color);
                courseList.add(course);
            }
            List relations = this.tCourseSessionStudentDao.findBySessionIds((List)courseSessionIds);
            if (!CollectionUtils.isEmpty((Collection)relations)) {
                ArrayList stuIds = Lists.newArrayList();
                HashMap relationMap = Maps.newHashMap();
                HashMap relationvMap = Maps.newHashMap();
                for (TCourseSessionStudent relation : relations) {
                    stuIds.add(relation.getStudentId());
                    Object relationStuIds = (List)relationMap.get(relation.getCourseSessionId());
                    if (CollectionUtils.isEmpty((Collection)relationStuIds)) {
                        relationStuIds = Lists.newArrayList();
                        relationMap.put(relation.getCourseSessionId(), relationStuIds);
                    }
                    relationStuIds.add(relation.getStudentId());
                    relationvMap.put(relation.getStudentId(), relation.getCourseSessionId());
                }
                List students = this.tStudentDao.findByStuIdList((List)stuIds);
                HashMap studentNames = Maps.newHashMap();
                for (TStudent student : students) {
                    studentNames.put(student.getStuId(), student.getEnglishName());
                }
                HashMap relationNames = Maps.newHashMap();
                for (Map.Entry entry : relationMap.entrySet()) {
                    List sStuIds = (List)entry.getValue();
                    if (CollectionUtils.isEmpty((Collection)sStuIds)) continue;
                    ArrayList sStuNames = Lists.newArrayList();
                    for (Integer stuId : sStuIds) {
                        String enname = (String)studentNames.get(stuId);
                        sStuNames.add(enname);
                    }
                    if (CollectionUtils.isEmpty((Collection)sStuNames)) continue;
                    relationNames.put(entry.getKey(), sStuNames);
                }
                for (TeacherIndexResult.Course rCourse : courseList) {
                    List enNames = (List)relationNames.get(rCourse.getSessionid());
                    if (CollectionUtils.isEmpty((Collection)enNames)) continue;
                    rCourse.setGroupNames(StringUtils.join((Collection)enNames, (String)","));
                }
            }
        }
        result.setCourseCount(Integer.valueOf(0));
        result.setNowDate(DateUtils.formatDateToSecond((Date)new Date()));
        result.setCalenderList(courseList);
        return result;
    }

    @Override
    public ToModifystustatusResult toModifystustatus(Integer sessionid, TTeacher teacher) {
        ToModifystustatusResult result = new ToModifystustatusResult();
        TCoursesession tCoursesession = this.tCoursesessionDao.findOne(sessionid);
        TCourse tCourse = this.tCourseDao.findOne(tCoursesession.getCid());
        TTeacherComments comments = this.tTeacherCommentsDao.findBySessionid(sessionid);
        TTeacher tTeacher = this.tTeacherDao.findOne(tCoursesession.getTeacherId());
        List studentList = this.tCoursesessionDao.findStudentNameAndIdListBySessionid(sessionid);
        BeanUtils.copyProperties((Object)tCoursesession, (Object)result);
        String timezone = teacher.getTimezone();
        TCustTimezone tCustTimezone = this.tCustTimezoneDao.findByTimezone(timezone);
        Date starttime = tCustTimezone != null ? TimeZoneUtil.findTimeByCustomerDate(tCoursesession.getStarttime(), tCustTimezone) : TimeZoneUtil.Date2TimezoneDefault(tCoursesession.getStarttime(), timezone);
        if (comments != null) {
            result.setComments(comments.getComments());
        }
        result.setClassid(tCourse.getClassid());
        result.setClassName(tCourse.getClassname());
        result.setStartTimeStr(DateUtils.formatDateToSecond((Date)starttime));
        result.setType(tCourse.getType());
        result.setClassType((String)TalkillaConstant.classTypeMap.get(tCourse.getType()));
        result.setFirstName(tTeacher.getFirstName());
        result.setLastName(tTeacher.getLastName());
        result.setStudentList(studentList);
        return result;
    }

    @Override
    @Transactional(rollbackFor={Throwable.class}, propagation=Propagation.REQUIRED)
    public ReturnMessageResult saveModifyStatus(TTeacher teacher, SaveModifyStatusForm form) throws ParseException {
        Object newCoursesession;
        ReturnMessageResult messageResult = new ReturnMessageResult();
        Integer sessionid = form.getSessionid();
        Integer status = form.getStatus();
        TCoursesession tCoursesession = this.tCoursesessionDao.findOne(sessionid);
        TCourse tCourse = this.tCourseDao.findOne(tCoursesession.getCid());
        TTeacher tTeacher = this.tTeacherDao.findOne(tCoursesession.getTeacherId());
        TLogin teacherLogin = this.tLoginDao.findOne(tTeacher.getLoginId());
        TWechat tWechat = null;
        TLogin studentLogin = null;
        TStudentConsultant studentConsultant = null;
        TStudent student = null;
        Boolean checkValue = this.tCoursesessionService.checkCoursesessionStatus(sessionid, null);
        if (!checkValue.booleanValue()) {
            messageResult.setFlag(Integer.valueOf(1));
            messageResult.setMessage("The status of the session has been made and can't be changed any more.");
            return messageResult;
        }
        if (form.getStatus().equals(TalkillaConstant.COURSE_STATUS_UMCONFIRMED) && tCoursesession.getStarttime().getTime() > System.currentTimeMillis()) {
            messageResult.setFlag(Integer.valueOf(1));
            messageResult.setMessage("The status of the future session   can't be changed to unconfirmed.");
            return messageResult;
        }
        tCoursesession.setStatus(status);
        tCoursesession.setUpdateTime(new Date());
        this.tCoursesessionDao.updateByIdSelective(tCoursesession);
        if (StringUtils.isNotEmpty((String)form.getComments())) {
            TTeacherComments tTeacherComments = this.tTeacherCommentsDao.findBySessionid(sessionid);
            if (tTeacherComments != null) {
                tTeacherComments.setComments(form.getComments());
                this.tTeacherCommentsDao.updateByIdSelective(tTeacherComments);
            } else {
                TTeacherComments teacherComments = new TTeacherComments();
                teacherComments.setComments(form.getComments());
                teacherComments.setSessionid(tCoursesession.getSessionid());
                teacherComments.setStuId(tCourse.getStuId());
                teacherComments.setTeacherId(tCoursesession.getTeacherId());
                this.tTeacherCommentsDao.insertSelective(teacherComments);
            }
        }
        List courseSessionStudents = this.tCourseSessionStudentDao.findListBySessionId(tCoursesession.getSessionid());
        ArrayList<TStudent> students = new ArrayList<TStudent>();
        if (courseSessionStudents != null && courseSessionStudents.size() > 0) {
            for (TCourseSessionStudent courseSessionStudent : courseSessionStudents) {
                student = this.tStudentDao.findOne(courseSessionStudent.getStudentId());
                students.add(student);
            }
        } else {
            log.error("\u6ca1\u6709\u67e5\u8be2\u5230\u5b66\u751f\uff0csessionId\u662f" + tCoursesession.getSessionid());
        }
        String message = "You've set the session status to " + (String)TalkillaConstant.statusMap.get(status) + " successfully.";
        if (TalkillaConstant.COURSE_STATUS_LEAVE_TEACHER.equals(status)) {
            TSendEmailRecord tSendEmailRecord;
            message = "Your leave request is accepted successfully; the original class scheduled at " + DateUtils.formatDateToMinute((Date)tCoursesession.getStarttime()) + " will be postponed accordingly. If you want make changes of the schedule,  please talk to your Talkilla contact directly.";
            newCoursesession = new TCoursesession();
            List<LeaveCourseResult> leaveCourseResults = this.tCoursesessionService.leaveCoursePlan(tCoursesession.getCid(), 1);
            if (leaveCourseResults != null && leaveCourseResults.size() > 0) {
                LeaveCourseResult leaveCourseResult = leaveCourseResults.get(0);
                BeanUtils.copyProperties((Object)tCoursesession, (Object)newCoursesession, (String[])new String[]{"updateTime"});
                newCoursesession.setTeacherId(tCoursesession.getTeacherId());
                newCoursesession.setCreateTime(null);
                newCoursesession.setDuration(Integer.valueOf(leaveCourseResult.getTimeLength()));
                newCoursesession.setSessionid(null);
                newCoursesession.setStatus(null);
                newCoursesession.setStarttime(DateUtils.parseDateToSecond((String)leaveCourseResult.getStartTime()));
                newCoursesession.setIsSystem(Integer.valueOf(1));
                if (tCourse.getType() == 100001) {
                    newCoursesession.setRate(new BigDecimal(tTeacher.getOneOnOne()));
                } else {
                    newCoursesession.setRate(new BigDecimal(tTeacher.getOneOnMultiple()));
                }
                this.tCoursesessionDao.insertSelective((TCoursesession)newCoursesession);
                for (TStudent tStudent : students) {
                    TCourseSessionStudent tCourseSessionStudent = new TCourseSessionStudent();
                    tCourseSessionStudent.setCourseSessionId(newCoursesession.getSessionid());
                    tCourseSessionStudent.setStudentId(tStudent.getStuId());
                    this.tCourseSessionStudentDao.insertSelective(tCourseSessionStudent);
                }
            }
            String englishNames = "";
            for (TStudent tStudent : students) {
                englishNames = englishNames + " " + tStudent.getEnglishName();
                studentLogin = this.tLoginDao.findOne(tStudent.getLoginId());
                studentConsultant = this.tStudentConsultantDao.findByStudentId(tStudent.getStuId());
                tWechat = this.tWechatDao.getTWechatInfoByLoginId(tStudent.getLoginId());
                ArrayList<String> addressList = new ArrayList<String>();
                addressList.add(SystemConfig.Admin.ADMIN_EMAIL);
                if (studentConsultant != null && !"admin".equals(studentConsultant.getConsultantEmail())) {
                    addressList.add(studentConsultant.getConsultantEmail());
                }
                TalkillaEmailMessageUtils.sendStudentByTeacherLeaveClass(studentLogin.getLoginName(), addressList, tStudent, tTeacher, studentConsultant, DateUtils.formatDateToDay((Date)tCoursesession.getStarttime()), DateUtils.getHHmmString((Date)tCoursesession.getStarttime(), (Integer)tCoursesession.getDuration()), DateUtils.getChineseWeekNumberOfDate((Date)tCoursesession.getStarttime()));
                tSendEmailRecord = new TSendEmailRecord();
                tSendEmailRecord.setUserType(TalkillaConstant.SendEmailUserType.STUDENT);
                tSendEmailRecord.setEmail(studentLogin.getLoginName());
                tSendEmailRecord.setEmailType(TalkillaConstant.SendEmailType.SEND_STUDENT_BY_TEACHER_LEAVE_CLASS);
                tSendEmailRecord.setRecordType(TalkillaConstant.SendEmailType.SEND_STUDENT_BY_TEACHER_LEAVE_CLASS);
                tSendEmailRecord.setCid(tCourse.getCid());
                tSendEmailRecord.setStuId(tStudent.getStuId());
                tSendEmailRecord.setTeacherId(tCourse.getTeacherId());
                this.tSendEmailRecordDao.insertSelective(tSendEmailRecord);
                this.wechatMessageService.sendStudentByTeacherLeaveClass(tStudent, tWechat, teacher, studentConsultant, DateUtils.formatDate((Date)tCoursesession.getStarttime(), (String)"yyyy-MM-dd HH:mm"), DateUtils.getChineseWeekNumberOfDate((Date)tCoursesession.getStarttime()), tCoursesession.getSessionid(), null);
            }
            String timezone = teacher.getTimezone();
            TCustTimezone tCustTimezone = this.tCustTimezoneDao.findByTimezone(timezone);
            Date starttime = tCustTimezone != null ? TimeZoneUtil.findTimeByCustomerDate(tCoursesession.getStarttime(), tCustTimezone) : TimeZoneUtil.Date2TimezoneDefault(tCoursesession.getStarttime(), timezone);
            TalkillaEmailMessageUtils.sendTeacherByLeaveClassEmail(teacherLogin.getLoginName(), teacher, englishNames, DateUtils.formatDateToDay((Date)starttime), DateUtils.getHHmmString((Date)starttime, (Integer)tCoursesession.getDuration()), DateUtils.getEnglishWeekNumberOfDate((Date)starttime));
            tSendEmailRecord = new TSendEmailRecord();
            tSendEmailRecord.setUserType(TalkillaConstant.SendEmailUserType.TEACHER);
            tSendEmailRecord.setEmail(teacherLogin.getLoginName());
            tSendEmailRecord.setEmailType(TalkillaConstant.SendEmailType.SEND_TEACHER_BY_LEAVE_CLASS_EMAIL);
            tSendEmailRecord.setRecordType(TalkillaConstant.SendEmailType.SEND_TEACHER_BY_LEAVE_CLASS_EMAIL);
            tSendEmailRecord.setCid(tCourse.getCid());
            tSendEmailRecord.setStuId(tCourse.getStuId());
            tSendEmailRecord.setTeacherId(tCourse.getTeacherId());
            this.tSendEmailRecordDao.insertSelective(tSendEmailRecord);
        } else if (TalkillaConstant.COURSE_STATUS_ABSENT_STUDENT.equals(status)) {
            this.tCourseService.processCourseCount(tCourse.getCid(), (double)tCoursesession.getDuration().intValue() / 60.0, TalkillaConstant.CourseCountType.STUDENT_ABSENT);
            for (TStudent stu : students) {
                studentConsultant = this.tStudentConsultantDao.findByStudentId(stu.getStuId());
                tWechat = this.tWechatDao.getTWechatInfoByLoginId(stu.getLoginId());
                WechatCourseStatusChangeForm wechatCourseStatusChangeForm = new WechatCourseStatusChangeForm();
                wechatCourseStatusChangeForm.setSessionid(tCoursesession.getSessionid());
                wechatCourseStatusChangeForm.setStudentRealName(stu.getRealName());
                wechatCourseStatusChangeForm.setTeacherFirstName(teacher.getFirstName());
                if (Objects.nonNull(studentConsultant)) {
                    wechatCourseStatusChangeForm.setConsultantName(studentConsultant.getConsultantName());
                    TConsultant consultant = this.tConsultantDao.findOne(studentConsultant.getConsultantId());
                    wechatCourseStatusChangeForm.setOnsultantPhone(consultant.getMobile());
                }
                wechatCourseStatusChangeForm.setCourseStatusDesc(TalkillaConstant.transferCourseStatus((Integer)status));
                if (Objects.nonNull(tWechat)) {
                    wechatCourseStatusChangeForm.setOpenId(tWechat.getOpenid());
                }
                wechatCourseStatusChangeForm.setStartTime(DateUtils.formatDate((Date)tCoursesession.getStarttime(), (String)"yyyy-MM-dd HH:mm"));
                wechatCourseStatusChangeForm.setWeek(DateUtils.getChineseWeekNumberOfDate((Date)tCoursesession.getStarttime()));
                wechatCourseStatusChangeForm.setComments(form.getComments());
                wechatCourseStatusChangeForm.setClassName(tCourse.getClassname());
                this.wechatMessageService.sendTaskTemplateMessageForCourseStatusChange(wechatCourseStatusChangeForm);
                Integer pendingCount = 0;
                List tCoursesessionList = this.tCoursesessionDao.findNoCompleteListByCid(tCourse.getCid());
                if (tCoursesessionList == null) continue;
                pendingCount = tCoursesessionList.size();
                Integer type = tCourse.getType();
                if (pendingCount > 2 || type != 100001) continue;
                studentLogin = this.tLoginDao.findOne(stu.getLoginId());
                ArrayList<String> addressList = new ArrayList<String>();
                addressList.add(SystemConfig.Admin.ADMIN_EMAIL);
                if (Objects.nonNull(studentConsultant) && !"admin".equals(studentConsultant.getConsultantEmail())) {
                    addressList.add(studentConsultant.getConsultantEmail());
                }
                TalkillaEmailMessageUtils.sendStudentByGoOnClass(studentLogin.getLoginName(), addressList, student, pendingCount);
                this.wechatMessageService.sendStudentByGoOnClass(stu, tWechat, teacher, tCourse.getClassname(), pendingCount);
                TSendEmailRecord tSendEmailRecord = new TSendEmailRecord();
                tSendEmailRecord.setUserType(TalkillaConstant.SendEmailUserType.STUDENT);
                tSendEmailRecord.setEmail(studentLogin.getLoginName());
                if (pendingCount == 2) {
                    tSendEmailRecord.setEmailType(TalkillaConstant.SendEmailType.RENEW_COURSE_BYTWO_EMAIL);
                    tSendEmailRecord.setRecordType(TalkillaConstant.SendEmailType.RENEW_COURSE_BYTWO_EMAIL);
                } else {
                    tSendEmailRecord.setEmailType(TalkillaConstant.SendEmailType.RENEW_COURSE_BYONE_EMAIL);
                    tSendEmailRecord.setRecordType(TalkillaConstant.SendEmailType.RENEW_COURSE_BYONE_EMAIL);
                }
                tSendEmailRecord.setCid(tCourse.getCid());
                tSendEmailRecord.setStuId(student.getStuId());
                tSendEmailRecord.setTeacherId(tCourse.getTeacherId());
                this.tSendEmailRecordDao.insertSelective(tSendEmailRecord);
            }
        } else if (TalkillaConstant.COURSE_STATUS_ABSENT_TEACHER.equals(status)) {
            newCoursesession = new TCoursesession();
            String msg = "";
            Double pendHours = 0.0;
            List<LeaveCourseResult> leaveCourseResults = this.tCoursesessionService.leaveCoursePlan(tCoursesession.getCid(), 2);
            if (leaveCourseResults != null && leaveCourseResults.size() > 0) {
                int i = 0;
                for (LeaveCourseResult leaveCourseResult : leaveCourseResults) {
                    ++i;
                    BeanUtils.copyProperties((Object)tCoursesession, (Object)newCoursesession, (String[])new String[]{"updateTime"});
                    newCoursesession.setCreateTime(null);
                    newCoursesession.setDuration(Integer.valueOf(leaveCourseResult.getTimeLength()));
                    newCoursesession.setSessionid(null);
                    newCoursesession.setStatus(null);
                    newCoursesession.setStarttime(DateUtils.parseDateToSecond((String)leaveCourseResult.getStartTime()));
                    newCoursesession.setIsSystem(Integer.valueOf(1));
                    newCoursesession.setTeacherId(tCoursesession.getTeacherId());
                    if (i == 2) {
                        newCoursesession.setIspay(Integer.valueOf(0));
                        newCoursesession.setPrice(BigDecimal.ZERO);
                    }
                    if (tCourse.getType() == 100001) {
                        newCoursesession.setRate(new BigDecimal(tTeacher.getOneOnOne()));
                    } else {
                        newCoursesession.setRate(new BigDecimal(tTeacher.getOneOnMultiple()));
                    }
                    this.tCoursesessionDao.insertSelective((TCoursesession)newCoursesession);
                    msg = msg + "," + leaveCourseResult.getStartTime();
                    pendHours = pendHours + new Double(leaveCourseResult.getTimeLength());
                    for (TStudent tStudent : students) {
                        TCourseSessionStudent tCourseSessionStudent = new TCourseSessionStudent();
                        tCourseSessionStudent.setCourseSessionId(newCoursesession.getSessionid());
                        tCourseSessionStudent.setStudentId(tStudent.getStuId());
                        this.tCourseSessionStudentDao.insertSelective(tCourseSessionStudent);
                    }
                }
            }
            this.tCourseService.processCourseCount(tCourse.getCid(), (double)tCoursesession.getDuration().intValue() / 60.0, TalkillaConstant.CourseCountType.TEACHER_ABSENT);
            message = "You have set the status of the class at " + DateUtils.formatDate((Date)tCoursesession.getStarttime(), (String)"yyyy-MM-dd HH:mm:ss") + " to Absence-Teacher successfully.";
            for (TStudent stu : students) {
                studentConsultant = this.tStudentConsultantDao.findByStudentId(stu.getStuId());
                tWechat = this.tWechatDao.getTWechatInfoByLoginId(stu.getLoginId());
                WechatCourseStatusChangeForm wechatCourseStatusChangeForm = new WechatCourseStatusChangeForm();
                wechatCourseStatusChangeForm.setSessionid(tCoursesession.getSessionid());
                wechatCourseStatusChangeForm.setStudentRealName(stu.getRealName());
                wechatCourseStatusChangeForm.setTeacherFirstName(teacher.getFirstName());
                if (Objects.nonNull(studentConsultant)) {
                    wechatCourseStatusChangeForm.setConsultantName(studentConsultant.getConsultantName());
                    TConsultant consultant = this.tConsultantDao.findOne(studentConsultant.getConsultantId());
                    wechatCourseStatusChangeForm.setOnsultantPhone(consultant.getMobile());
                }
                wechatCourseStatusChangeForm.setCourseStatusDesc(TalkillaConstant.transferCourseStatus((Integer)status));
                if (Objects.nonNull(tWechat)) {
                    wechatCourseStatusChangeForm.setOpenId(tWechat.getOpenid());
                }
                wechatCourseStatusChangeForm.setStartTime(DateUtils.formatDate((Date)tCoursesession.getStarttime(), (String)"yyyy-MM-dd HH:mm"));
                wechatCourseStatusChangeForm.setWeek(DateUtils.getChineseWeekNumberOfDate((Date)tCoursesession.getStarttime()));
                wechatCourseStatusChangeForm.setComments(form.getComments());
                wechatCourseStatusChangeForm.setClassName(tCourse.getClassname());
                this.wechatMessageService.sendTaskTemplateMessageForCourseStatusChange(wechatCourseStatusChangeForm);
            }
        } else if (TalkillaConstant.COURSE_STATUS_COMPLETED.equals(status)) {
            TStudent tStudent = this.tStudentDao.findOne(tCourse.getStuId());
            message = "You have set the session status to Completed successfully.";
            this.tCourseService.processCourseCount(tCourse.getCid(), (double)tCoursesession.getDuration().intValue() / 60.0, TalkillaConstant.CourseCountType.NORMAL_COMPLETE);
            for (TStudent stu : students) {
                studentConsultant = this.tStudentConsultantDao.findByStudentId(stu.getStuId());
                tWechat = this.tWechatDao.getTWechatInfoByLoginId(stu.getLoginId());
                WechatCourseStatusChangeForm wechatCourseStatusChangeForm = new WechatCourseStatusChangeForm();
                wechatCourseStatusChangeForm.setSessionid(tCoursesession.getSessionid());
                wechatCourseStatusChangeForm.setStudentRealName(stu.getRealName());
                wechatCourseStatusChangeForm.setTeacherFirstName(teacher.getFirstName());
                if (Objects.nonNull(studentConsultant)) {
                    wechatCourseStatusChangeForm.setConsultantName(studentConsultant.getConsultantName());
                    TConsultant consultant = this.tConsultantDao.findOne(studentConsultant.getConsultantId());
                    wechatCourseStatusChangeForm.setOnsultantPhone(consultant.getMobile());
                }
                wechatCourseStatusChangeForm.setCourseStatusDesc(TalkillaConstant.transferCourseStatus((Integer)status));
                if (Objects.nonNull(tWechat)) {
                    wechatCourseStatusChangeForm.setOpenId(tWechat.getOpenid());
                }
                wechatCourseStatusChangeForm.setStartTime(DateUtils.formatDate((Date)tCoursesession.getStarttime(), (String)"yyyy-MM-dd HH:mm"));
                wechatCourseStatusChangeForm.setWeek(DateUtils.getChineseWeekNumberOfDate((Date)tCoursesession.getStarttime()));
                wechatCourseStatusChangeForm.setComments(form.getComments());
                wechatCourseStatusChangeForm.setClassName(tCourse.getClassname());
                this.wechatMessageService.sendTaskTemplateMessageForCourseStatusChange(wechatCourseStatusChangeForm);
            }
        } else if (TalkillaConstant.COURSE_STATUS_SPECIAL_CASES.equals(status)) {
            TSendEmailRecord tSendEmailRecord;
            message = "You have set the session at " + DateUtils.formatDateToMinute((Date)tCoursesession.getStarttime()) + " to Special Case successfully: the original class will be postponed accordingly. If you want to make changes to the schedule, please talk to your Talkilla contact directly.";
            newCoursesession = new TCoursesession();
            List<LeaveCourseResult> leaveCourseResults = this.tCoursesessionService.leaveCoursePlan(tCoursesession.getCid(), 1);
            if (leaveCourseResults != null && leaveCourseResults.size() > 0) {
                LeaveCourseResult leaveCourseResult = leaveCourseResults.get(0);
                BeanUtils.copyProperties((Object)tCoursesession, (Object)newCoursesession, (String[])new String[]{"updateTime"});
                newCoursesession.setCreateTime(null);
                newCoursesession.setDuration(Integer.valueOf(leaveCourseResult.getTimeLength()));
                newCoursesession.setSessionid(null);
                newCoursesession.setStatus(null);
                newCoursesession.setStarttime(DateUtils.parseDateToSecond((String)leaveCourseResult.getStartTime()));
                newCoursesession.setIsSystem(Integer.valueOf(1));
                newCoursesession.setTeacherId(tCoursesession.getTeacherId());
                if (tCourse.getType() == 100001) {
                    newCoursesession.setRate(new BigDecimal(tTeacher.getOneOnOne()));
                } else {
                    newCoursesession.setRate(new BigDecimal(tTeacher.getOneOnMultiple()));
                }
                this.tCoursesessionDao.insertSelective((TCoursesession)newCoursesession);
                for (TStudent stu : students) {
                    TCourseSessionStudent tCourseSessionStudent = new TCourseSessionStudent();
                    tCourseSessionStudent.setCourseSessionId(newCoursesession.getSessionid());
                    tCourseSessionStudent.setStudentId(stu.getStuId());
                    this.tCourseSessionStudentDao.insertSelective(tCourseSessionStudent);
                }
            }
            String englishNames = "";
            for (TStudent tStudent : students) {
                englishNames = englishNames + " " + tStudent.getEnglishName();
                studentLogin = this.tLoginDao.findOne(tStudent.getLoginId());
                studentConsultant = this.tStudentConsultantDao.findByStudentId(tStudent.getStuId());
                tWechat = this.tWechatDao.getTWechatInfoByLoginId(tStudent.getLoginId());
                ArrayList<String> addressList = new ArrayList<String>();
                addressList.add(SystemConfig.Admin.ADMIN_EMAIL);
                if (studentConsultant != null && !"admin".equals(studentConsultant.getConsultantEmail())) {
                    addressList.add(studentConsultant.getConsultantEmail());
                }
                TalkillaEmailMessageUtils.sendStudentByTeacherLeaveClass(studentLogin.getLoginName(), addressList, tStudent, tTeacher, studentConsultant, DateUtils.formatDateToDay((Date)tCoursesession.getStarttime()), DateUtils.getHHmmString((Date)tCoursesession.getStarttime(), (Integer)tCoursesession.getDuration()), DateUtils.getChineseWeekNumberOfDate((Date)tCoursesession.getStarttime()));
                tSendEmailRecord = new TSendEmailRecord();
                tSendEmailRecord.setUserType(TalkillaConstant.SendEmailUserType.STUDENT);
                tSendEmailRecord.setEmail(studentLogin.getLoginName());
                tSendEmailRecord.setEmailType(TalkillaConstant.SendEmailType.SEND_STUDENT_BY_TEACHER_LEAVE_CLASS);
                tSendEmailRecord.setRecordType(TalkillaConstant.SendEmailType.SEND_STUDENT_BY_TEACHER_LEAVE_CLASS);
                tSendEmailRecord.setCid(tCourse.getCid());
                tSendEmailRecord.setStuId(tStudent.getStuId());
                tSendEmailRecord.setTeacherId(tCourse.getTeacherId());
                this.tSendEmailRecordDao.insertSelective(tSendEmailRecord);
                WechatCourseStatusChangeForm wechatCourseStatusChangeForm = new WechatCourseStatusChangeForm();
                wechatCourseStatusChangeForm.setSessionid(tCoursesession.getSessionid());
                wechatCourseStatusChangeForm.setStudentRealName(tStudent.getRealName());
                wechatCourseStatusChangeForm.setTeacherFirstName(teacher.getFirstName());
                if (Objects.nonNull(studentConsultant)) {
                    wechatCourseStatusChangeForm.setConsultantName(studentConsultant.getConsultantName());
                    TConsultant consultant = this.tConsultantDao.findOne(studentConsultant.getConsultantId());
                    wechatCourseStatusChangeForm.setOnsultantPhone(consultant.getMobile());
                }
                wechatCourseStatusChangeForm.setCourseStatusDesc(TalkillaConstant.transferCourseStatus((Integer)status));
                if (Objects.nonNull(tWechat)) {
                    wechatCourseStatusChangeForm.setOpenId(tWechat.getOpenid());
                }
                wechatCourseStatusChangeForm.setStartTime(DateUtils.formatDate((Date)tCoursesession.getStarttime(), (String)"yyyy-MM-dd HH:mm"));
                wechatCourseStatusChangeForm.setWeek(DateUtils.getChineseWeekNumberOfDate((Date)tCoursesession.getStarttime()));
                wechatCourseStatusChangeForm.setComments(form.getComments());
                wechatCourseStatusChangeForm.setClassName(tCourse.getClassname());
                wechatCourseStatusChangeForm.setAddComment("\u4e0d\u8ba1\u8bfe\u65f6\uff0c\u8bfe\u7a0b\u5c06\u987a\u5ef6\u3002");
                this.wechatMessageService.sendTaskTemplateMessageForCourseStatusChange(wechatCourseStatusChangeForm);
            }
            String timezone = teacher.getTimezone();
            TCustTimezone tCustTimezone = this.tCustTimezoneDao.findByTimezone(timezone);
            Date starttime = tCustTimezone != null ? TimeZoneUtil.findTimeByCustomerDate(tCoursesession.getStarttime(), tCustTimezone) : TimeZoneUtil.Date2TimezoneDefault(tCoursesession.getStarttime(), timezone);
            TalkillaEmailMessageUtils.sendTeacherBySpecialClassEmail(teacherLogin.getLoginName(), teacher, (TStudent)students.get(0), DateUtils.formatDateToDay((Date)starttime), DateUtils.getHHmmString((Date)starttime, (Integer)tCoursesession.getDuration()), DateUtils.getEnglishWeekNumberOfDate((Date)starttime));
            tSendEmailRecord = new TSendEmailRecord();
            tSendEmailRecord.setUserType(TalkillaConstant.SendEmailUserType.TEACHER);
            tSendEmailRecord.setEmail(teacherLogin.getLoginName());
            tSendEmailRecord.setEmailType(TalkillaConstant.SendEmailType.SEND_TEACHER_BY_SPECIAL_CLASS_EMAIL);
            tSendEmailRecord.setRecordType(TalkillaConstant.SendEmailType.SEND_TEACHER_BY_SPECIAL_CLASS_EMAIL);
            tSendEmailRecord.setCid(tCourse.getCid());
            tSendEmailRecord.setStuId(tCourse.getStuId());
            tSendEmailRecord.setTeacherId(tCourse.getTeacherId());
            this.tSendEmailRecordDao.insertSelective(tSendEmailRecord);
        }
        messageResult.setMessage(message);
        messageResult.setFlag(Integer.valueOf(0));
        return messageResult;
    }

    @Override
    public CourseTeachingListResult courseTeachingList(CourseTeachingListForm form, TTeacher teacher) throws ParseException {
        CourseTeachingListResult result = new CourseTeachingListResult();
        BigDecimal totalMoney = new BigDecimal(0);
        Integer pageNo = form.getPageNo();
        Integer pageSize = form.getPageSize();
        if (pageNo == null || pageNo <= 0) {
            pageNo = 1;
            form.setPageNo(pageNo);
        }
        if (pageSize == null || pageSize <= 0) {
            pageSize = 10;
            form.setPageSize(pageSize);
        }
        form.setTeacherId(teacher.getTeacherId());
        if (StringUtils.isNotEmpty((String)form.getDate())) {
            form.setStartDate(DateUtils.getMonthFirstDay((String)form.getDate()));
            form.setEndDate(DateUtils.getMonthEndDay((String)form.getDate()));
        }
        Page pages = PageHelper.startPage((int)pageNo, (int)pageSize);
        List teachingResultList = this.tCoursesessionDao.courseTeachingList(form);
        if (teachingResultList != null && teachingResultList.size() > 0) {
            String timezone = teacher.getTimezone();
            TCustTimezone tCustTimezone = this.tCustTimezoneDao.findByTimezone(timezone);
            for (CourseTeachingResult teachingResult : teachingResultList) {
                teachingResult.setStatusStr((String)TalkillaConstant.statusMap.get(teachingResult.getStatus()));
                teachingResult.setTypeStr((String)TalkillaConstant.classTypeMap.get(teachingResult.getType()));
                Date starttime = tCustTimezone != null ? TimeZoneUtil.findTimeByCustomerDate(teachingResult.getStarttime(), tCustTimezone) : TimeZoneUtil.Date2TimezoneDefault(teachingResult.getStarttime(), timezone);
                teachingResult.setStarttimeStr(DateUtils.formatDateToSecond((Date)starttime));
                totalMoney = totalMoney.add(teachingResult.getMoney());
            }
        }
        result.setTotalMoney(totalMoney);
        result.setPageSize(pageSize);
        result.setPageNo(pageNo);
        result.setResultList(pages.getResult());
        result.setTotalCount(Long.valueOf(pages.getTotal()));
        return result;
    }

    @Override
    public TTeacherComments stuCommentList(TTeacher teacher, Integer sessionid) {
        return this.tTeacherCommentsDao.findBySessionid(sessionid);
    }

    @Override
    public List<TStuFeeback> stuFeedbackList(TTeacher teacher, Integer sessionid) {
        return this.tStuFeebackDao.findBySessionid(sessionid);
    }

    @Override
    public TeacherSchedualResult teacherSchedual(TTeacher teacher) throws ParseException {
        TeacherSchedualResult result = new TeacherSchedualResult();
        FindIncomeForm form = new FindIncomeForm();
        form.setTeacherId(teacher.getTeacherId());
        String min = DateUtils.getThisYearFirstDay();
        String max = DateUtils.getThisYearLastDay();
        form.setStartTime(min);
        form.setEndTime(max);
        result.setTeacherId(teacher.getTeacherId());
        result.setTeacherName(teacher.getLastName() + " " + teacher.getFirstName());
        result.setCourseCount(Integer.valueOf(0));
        result.setNowDate(DateUtils.formatDateToSecond((Date)new Date()));
        this.setTeacherScheduals(teacher, result);
        return result;
    }

    private void setTeacherScheduals(TTeacher teacher, TeacherSchedualResult result) {
        ArrayList<TeacherSchedualResult.Course> courseList = new ArrayList<TeacherSchedualResult.Course>();
        List coursesessions = this.tCoursesessionDao.findListByTeacherId(teacher.getTeacherId());
        if (CollectionUtils.isEmpty((Collection)coursesessions)) {
            result.setCalenderList(new ArrayList());
            return;
        }
        String timeZoneStr = teacher.getTimezone();
        TCustTimezone tCustTimezone = this.tCustTimezoneDao.findByTimezone(timeZoneStr);
        for (CoursesessionInfoResult coursesessionInfo : coursesessions) {
            TeacherSchedualResult.Course course = new TeacherSchedualResult.Course(result);
            String title = coursesessionInfo.getClassname();
            Integer status = coursesessionInfo.getStatus();
            String statusStr = (String)TalkillaConstant.statusMap.get(status);
            if (statusStr != null) {
                title = title + "(" + statusStr + ")";
            }
            Date starttime = tCustTimezone != null ? TimeZoneUtil.findTimeByCustomerDate(coursesessionInfo.getStarttime(), tCustTimezone) : TimeZoneUtil.Date2TimezoneDefault(coursesessionInfo.getStarttime(), timeZoneStr);
            result.setTeacherId(teacher.getTeacherId());
            result.setTeacherName(teacher.getLastName() + " " + teacher.getFirstName());
            result.setCourseCount(Integer.valueOf(0));
            result.setNowDate(DateUtils.formatDateToSecond((Date)new Date()));
            course.setStarTimeStr(DateUtils.formatDateToMinuteByTimeZone((Date)starttime));
            course.setEndTimeStr(DateUtils.formatDateToMinuteByTimeZone((Date)DateUtils.addTimeByType((Date)starttime, (int)12, (int)coursesessionInfo.getDuration())));
            course.setSessionid(coursesessionInfo.getSessionid());
            course.setColor("gray");
            course.setTitle(title);
            courseList.add(course);
        }
        result.setCalenderList(courseList);
    }

    @Override
    public boolean canSendTeacherReportTwoTypeEmail(Integer cid) {
        TCourse course = this.tCourseDao.findOne(cid);
        if (course == null) {
            return false;
        }
        if (course.getTotalhour() == null || course.getTotalhour() < 20.0) {
            return false;
        }
        TCoursesession lastSession = this.tCoursesessionDao.findLastOneByCid(cid);
        long daysNearbyToday = DateUtils.getDaysNearbyToday((Date)lastSession.getStarttime());
        if (daysNearbyToday < 7L || daysNearbyToday > 8L) {
            return false;
        }
        long count = this.tSendEmailRecordDao.countRecordByTeacherId(course.getTeacherId(), TalkillaConstant.SendEmailType.SEND_TO_TEACHER_REPORT_TWO_TYPE, cid);
        return count <= 0L;
    }

    @Override
    public boolean canSendTeacherReportOneTypeEmail(Integer cid) {
        TCourse course = this.tCourseDao.findOne(cid);
        if (course == null) {
            return false;
        }
        Long count = this.tCoursesessionDao.countCourseByTeacherIdAndStuId(course.getStuId(), course.getTeacherId());
        if (count != 1L) {
            return false;
        }
        count = this.tCoursesessionDao.countCompleteSessions(cid);
        if (count < 5L) {
            return false;
        }
        count = this.tSendEmailRecordDao.countRecordByTeacherId(course.getTeacherId(), TalkillaConstant.SendEmailType.SEND_TO_TEACHER_REPORT_ONE_TYPE, cid);
        return count <= 0L;
    }

    @Override
    public List<ReportMessageResult> findReportMessageByTeacherId(Integer teacherId) {
        ArrayList<ReportMessageResult> results = new ArrayList<ReportMessageResult>();
        List cids = this.tCoursesessionDao.selectNowClassIdByTeacherId(teacherId);
        for (Integer cid : cids) {
            ReportMessageResult result;
            TStudent student;
            TCourse course;
            if (this.canSendTeacherReportOneTypeEmail(cid) || this.hasNoNoticeReportOneType(cid)) {
                course = this.tCourseDao.findOne(cid);
                student = this.tStudentDao.findOne(course.getStuId());
                result = new ReportMessageResult();
                result.setClassName(course.getClassname());
                result.setStuName(student.getEnglishName());
                result.setReportType("Early Feedback for finishing first 5 lessons ");
                results.add(result);
            }
            if (!this.canSendTeacherReportTwoTypeEmail(cid) && !this.hasNoNoticeReportTwoType(cid)) continue;
            course = this.tCourseDao.findOne(cid);
            student = this.tStudentDao.findOne(course.getStuId());
            result = new ReportMessageResult();
            result.setClassName(course.getClassname());
            result.setStuName(student.getEnglishName());
            result.setReportType("Progress Report for finishing the Package");
            results.add(result);
        }
        return results;
    }

    @Override
    public void noticeTeacherReportMessageComform(Integer teacherId) {
        List cids = this.tCoursesessionDao.selectNowClassIdByTeacherId(teacherId);
        for (Integer cid : cids) {
            TTeacherNotice tTeacherNotice;
            if (this.hasNoNoticeReportOneType(cid)) {
                tTeacherNotice = new TTeacherNotice();
                tTeacherNotice.setCid(cid);
                tTeacherNotice.setNoticeType(TalkillaConstant.TeacherNoticeType.SEND_TO_TEACHER_REPORT_ONE_TYPE);
                tTeacherNotice.setTeacherId(teacherId);
                this.tTeacherNoticeDAO.insertSelective(tTeacherNotice);
            }
            if (!this.hasNoNoticeReportTwoType(cid)) continue;
            tTeacherNotice = new TTeacherNotice();
            tTeacherNotice.setCid(cid);
            tTeacherNotice.setNoticeType(TalkillaConstant.TeacherNoticeType.SEND_TO_TEACHER_REPORT_TWO_TYPE);
            tTeacherNotice.setTeacherId(teacherId);
            this.tTeacherNoticeDAO.insertSelective(tTeacherNotice);
        }
    }

    private boolean hasNoNoticeReportTwoType(Integer cid) {
        TTeacherNotice tTeacherNotice = this.tTeacherNoticeDAO.selectByTeacherIdAndCidAndType(cid, TalkillaConstant.TeacherNoticeType.SEND_TO_TEACHER_REPORT_TWO_TYPE);
        return tTeacherNotice == null;
    }

    private boolean hasNoNoticeReportOneType(Integer cid) {
        TTeacherNotice tTeacherNotice = this.tTeacherNoticeDAO.selectByTeacherIdAndCidAndType(cid, TalkillaConstant.TeacherNoticeType.SEND_TO_TEACHER_REPORT_ONE_TYPE);
        return tTeacherNotice == null;
    }
}

