/*
 * Decompiled with CFR 0.152.
 */
package com.talkilla.service.impl.student;

import com.talkilla.constant.SystemConfig;
import com.talkilla.constant.TalkillaConstant;
import com.talkilla.form.UserLoginForm;
import com.talkilla.form.student.FindpwdForm;
import com.talkilla.form.student.MobileRegisterForm;
import com.talkilla.form.student.MobileRegisterSavePWDForm;
import com.talkilla.form.student.PasswordUpdateForm;
import com.talkilla.form.student.RegisterForm;
import com.talkilla.form.student.UpdateStudentInfoForm;
import com.talkilla.mysql.domain.TLogin;
import com.talkilla.mysql.domain.TMenu;
import com.talkilla.mysql.domain.TSendEmailRecord;
import com.talkilla.mysql.domain.TStudent;
import com.talkilla.mysql.domain.TStudentConsultant;
import com.talkilla.mysql.mapper.TCourseDao;
import com.talkilla.mysql.mapper.TLoginDao;
import com.talkilla.mysql.mapper.TMenuDao;
import com.talkilla.mysql.mapper.TMobileCodeDao;
import com.talkilla.mysql.mapper.TSendEmailRecordDao;
import com.talkilla.mysql.mapper.TStudentConsultantDao;
import com.talkilla.mysql.mapper.TStudentDao;
import com.talkilla.mysql.mapper.TZonecodeDao;
import com.talkilla.otherbean.CalendarDto;
import com.talkilla.otherbean.UserDto;
import com.talkilla.otherbean.ZTreeNode;
import com.talkilla.result.ReturnMessageResult;
import com.talkilla.result.student.QueryAreaByNameResult;
import com.talkilla.result.student.StudentInfoPageResult;
import com.talkilla.service.CommonService;
import com.talkilla.service.impl.InitDictionUtil;
import com.talkilla.service.student.StuUserService;
import com.talkilla.serviceUtils.TalkillaEmailMessageUtils;
import com.talkilla.utils.CheckFormatUtils;
import com.talkilla.utils.DateUtils;
import com.talkilla.utils.PasswordUtil;
import com.talkilla.utils.UploadPhotoUtils;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.RandomUtils;
import org.nestframework.commons.utils.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;

@Service(value="stuUserService")
public class StuUserServiceImpl
implements StuUserService {
    @Autowired
    private TLoginDao tLoginDao;
    @Autowired
    private TStudentDao tStudentDao;
    @Autowired
    private TStudentConsultantDao tStudentConsultantDao;
    @Autowired
    private TZonecodeDao tZonecodeDao;
    @Autowired
    private TMenuDao tMenuDao;
    @Autowired
    private TCourseDao tCourseDao;
    @Autowired
    private TMobileCodeDao tMobileCodeDao;
    @Autowired
    private InitDictionUtil initDictionUtil;
    @Autowired
    private CommonService commonService;
    @Autowired
    private TSendEmailRecordDao tSendEmailRecordDao;
    private static final Logger logger = LoggerFactory.getLogger(StuUserServiceImpl.class);

    @Override
    public TLogin userLogin(UserLoginForm form) {
        TLogin login = null;
        login = CheckFormatUtils.isMobile((String)form.getUsername()) ? this.tLoginDao.userLoginByMobile(form.getUsername(), form.getPassword()) : this.tLoginDao.userLogin(form.getUsername(), form.getPassword());
        if (login != null) {
            login.setLoginCount(Integer.valueOf(login.getLoginCount() + 1));
            login.setUpdateTime(new Date());
            this.tLoginDao.updateByIdSelective(login);
        }
        return login;
    }

    @Override
    @Transactional(rollbackFor={Throwable.class}, propagation=Propagation.REQUIRED)
    public HashMap<String, String> register(HttpSession session, RegisterForm form) throws ParseException {
        HashMap<String, String> result = new HashMap<String, String>();
        String rand = (String)session.getAttribute("rand");
        if (!rand.equals(form.getRand())) {
            result.put("flag", "1");
            result.put("message", "\u9a8c\u8bc1\u7801\u9519\u8bef\uff01\uff01");
            return result;
        }
        TLogin tLogin = this.tLoginDao.findByLoginName(form.getUsername());
        if (tLogin != null) {
            result.put("flag", "1");
            result.put("message", form.getUsername() + "\u5df2\u7ecf\u88ab\u4f7f\u7528\u4e86\uff01\uff01");
            return result;
        }
        TLogin newTLogin = new TLogin();
        newTLogin.setCreater(form.getUsername());
        newTLogin.setLoginCount(Integer.valueOf(0));
        newTLogin.setLoginName(form.getUsername());
        newTLogin.setLoginPwd(PasswordUtil.encrypt2((String)form.getPassword()).toLowerCase());
        newTLogin.setRoleId(Integer.valueOf(1));
        int flag = this.tLoginDao.insertSelective(newTLogin);
        if (flag < 1) {
            logger.info("tLoginDao.insertSelective(newTLogin) \u6267\u884c\u5931\u8d25");
        }
        TStudent tStudent = new TStudent();
        tStudent.setLoginId(newTLogin.getLoginId());
        tStudent.setPhone(form.getPhone());
        tStudent.setRealName(form.getRealName());
        tStudent.setEnglishName(form.getEnglishname());
        tStudent.setRecommendId(form.getTid());
        tStudent.setRecommendType(form.getTlevel());
        if (StringUtils.isNotBlank((String)form.getRealName())) {
            tStudent.setRealName(form.getRealName());
        } else {
            tStudent.setRealName(form.getEnglishname());
        }
        tStudent.setBirthday(form.getBirthday());
        flag = this.tStudentDao.insertSelective(tStudent);
        if (flag < 1) {
            logger.info("tStudentDao.insertSelective(tStudent) \u6267\u884c\u5931\u8d25");
        }
        TStudentConsultant tStudentConsultant = new TStudentConsultant();
        tStudentConsultant.setStuId(tStudent.getStuId());
        tStudentConsultant.setConsultantName("admin");
        tStudentConsultant.setConsultantId(Integer.valueOf(1));
        tStudentConsultant.setConsultantEmail("yanfengxue@talkilla.org");
        tStudentConsultant.setMobile("18910070280");
        flag = this.tStudentConsultantDao.insertSelective(tStudentConsultant);
        if (flag < 1) {
            logger.info("tStudentConsultantDao.insertSelective(tStudentConsultant) \u6267\u884c\u5931\u8d25");
        }
        TalkillaEmailMessageUtils.sendNewStudentRegisterSuccess(SystemConfig.Admin.ADMIN_EMAIL, tStudent);
        TSendEmailRecord tSendEmailRecord = new TSendEmailRecord();
        tSendEmailRecord.setUserType(TalkillaConstant.SendEmailUserType.ADMIN);
        tSendEmailRecord.setEmail(SystemConfig.Admin.ADMIN_EMAIL);
        tSendEmailRecord.setEmailType(TalkillaConstant.SendEmailType.SEND_NEW_STUDENT_REGISTER_SUCCESS);
        tSendEmailRecord.setRecordType(TalkillaConstant.SendEmailType.SEND_NEW_STUDENT_REGISTER_SUCCESS);
        tSendEmailRecord.setCid(Integer.valueOf(0));
        tSendEmailRecord.setStuId(tStudent.getStuId());
        tSendEmailRecord.setTeacherId(Integer.valueOf(0));
        this.tSendEmailRecordDao.insertSelective(tSendEmailRecord);
        result.put("flag", "0");
        result.put("message", "\u606d\u559c\u60a8\u6ce8\u518c\u6210\u529f\u5e76\u83b7\u5f97\u4e0e\u82f1\u7f8e\u5916\u6559\u7684\u514d\u8d39\u4f53\u9a8c\u8bfe\uff01\u6211\u4eec\u7684\u5ba2\u670d\u4eba\u5458\u4f1a\u9a6c\u4e0a\u4e0e\u60a8\u8054\u7cfb\u3002");
        return result;
    }

    @Override
    @Transactional(rollbackFor={Throwable.class}, propagation=Propagation.REQUIRED)
    public HashMap<String, String> findpwd(FindpwdForm form) {
        HashMap<String, String> result = new HashMap<String, String>();
        boolean flag = false;
        TLogin tLogin = this.tLoginDao.findByLoginName(form.getLoginname());
        if (tLogin == null) {
            result.put("flag", "1");
            result.put("message", form.getLoginname() + " \u67e5\u65e0\u6b64\u4eba");
            return result;
        }
        int newPwd = RandomUtils.nextInt((int)1000000);
        tLogin.setLoginPwd(PasswordUtil.encrypt2((String)(newPwd + "")).toLowerCase());
        this.tLoginDao.updateByIdSelective(tLogin);
        String title = "\u8bed\u6cc9\u82f1\u8bed-\u627e\u56de\u5bc6\u7801";
        String content = "\u60a8\u7684\u65b0\u5bc6\u7801\u662f:" + newPwd;
        TalkillaEmailMessageUtils.sendMessageToPeople(tLogin.getLoginName(), content, title);
        TSendEmailRecord tSendEmailRecord = new TSendEmailRecord();
        tSendEmailRecord.setUserType(TalkillaConstant.SendEmailUserType.STUDENT);
        tSendEmailRecord.setEmail(tLogin.getLoginName());
        tSendEmailRecord.setEmailType(TalkillaConstant.SendEmailType.SEND_STUDENT_FOR_FIND_PWD);
        tSendEmailRecord.setRecordType(TalkillaConstant.SendEmailType.SEND_STUDENT_FOR_FIND_PWD);
        tSendEmailRecord.setCid(Integer.valueOf(0));
        tSendEmailRecord.setStuId(Integer.valueOf(0));
        tSendEmailRecord.setTeacherId(Integer.valueOf(0));
        this.tSendEmailRecordDao.insertSelective(tSendEmailRecord);
        result.put("flag", "0");
        result.put("message", "\u65b0\u5bc6\u7801\u5df2\u7ecf\u53d1\u9001\u5230\u60a8\u7684\u90ae\u7bb1");
        return result;
    }

    @Override
    @Transactional(rollbackFor={Throwable.class}, propagation=Propagation.REQUIRED)
    public ReturnMessageResult passwordUpdate(UserDto student, PasswordUpdateForm form) {
        ReturnMessageResult result = new ReturnMessageResult();
        String newPwd = form.getNewPwd();
        String oldPwd = form.getOldPwd();
        String rNewPwd = form.getrNewPwd();
        if (StringUtils.isEmpty((String)oldPwd)) {
            result.setFlag(Integer.valueOf(1));
            result.setMessage("\u8bf7\u8f93\u5165\u539f\u59cb\u5bc6\u7801");
            return result;
        }
        if (StringUtils.isEmpty((String)newPwd)) {
            result.setFlag(Integer.valueOf(1));
            result.setMessage("\u8bf7\u8f93\u5165\u65b0\u5bc6\u7801");
            return result;
        }
        if (StringUtils.isEmpty((String)rNewPwd)) {
            result.setFlag(Integer.valueOf(1));
            result.setMessage("\u8bf7\u518d\u6b21\u8f93\u5165\u5bc6\u7801");
            return result;
        }
        if (!newPwd.equals(rNewPwd)) {
            result.setFlag(Integer.valueOf(1));
            result.setMessage("\u4f60\u8f93\u5165\u7684\u786e\u8ba4\u65b0\u5bc6\u7801\u4e0e\u65b0\u5bc6\u7801\u4e0d\u4e00\u81f4\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165");
            return result;
        }
        TLogin tLogin = this.tLoginDao.findOne(student.getLoginId());
        if (!tLogin.getLoginPwd().equals(PasswordUtil.encrypt2((String)oldPwd))) {
            result.setFlag(Integer.valueOf(1));
            result.setMessage("\u5bf9\u4e0d\u8d77\uff0c\u65e7\u767b\u5f55\u5bc6\u7801\u9a8c\u8bc1\u9519\u8bef\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165");
            return result;
        }
        tLogin.setLoginPwd(PasswordUtil.encrypt2((String)newPwd));
        this.tLoginDao.updateByIdSelective(tLogin);
        result.setFlag(Integer.valueOf(0));
        result.setMessage("\u5bc6\u7801\u66f4\u65b0\u6210\u529f");
        return result;
    }

    @Override
    public StudentInfoPageResult studentInfoPage(UserDto student) {
        StudentInfoPageResult result = new StudentInfoPageResult();
        TStudent tStudent = this.tStudentDao.findOne(student.getStuId());
        BeanUtils.copyProperties((Object)tStudent, (Object)result);
        result.setAvatar(SystemConfig.PICTURE_PATH + result.getPhone());
        if (result.getBirthday() != null) {
            result.setBirthdayStr(DateUtils.formatDateToDay((Date)result.getBirthday()));
        }
        return result;
    }

    @Override
    public List<QueryAreaByNameResult> queryAreaByName(String queryName) {
        return this.tZonecodeDao.queryAreaByName(queryName);
    }

    @Override
    @Transactional(rollbackFor={Throwable.class}, propagation=Propagation.REQUIRED)
    public ReturnMessageResult updateStudentInfo(TStudent student, MultipartFile fileItem, UpdateStudentInfoForm form) {
        ReturnMessageResult messageResult = new ReturnMessageResult();
        TStudent tStudent = this.tStudentDao.findOne(student.getStuId());
        if (fileItem != null) {
            String filePath = UploadPhotoUtils.savePhoto((MultipartFile)fileItem, (String)tStudent.getAvatar(), (String)"student");
            tStudent.setAvatar(filePath);
        }
        BeanUtils.copyProperties((Object)form, (Object)tStudent);
        this.tStudentDao.updateByIdSelective(tStudent);
        messageResult.setFlag(Integer.valueOf(0));
        messageResult.setMessage("\u4fdd\u5b58\u6210\u529f");
        return messageResult;
    }

    @Override
    public List<ZTreeNode> findStudentMenuList(Integer loginId) {
        ArrayList<ZTreeNode> list = new ArrayList<ZTreeNode>();
        List menus = this.tMenuDao.findListByRoleId(Integer.valueOf(3));
        ZTreeNode znode = null;
        for (TMenu menu : menus) {
            znode = new ZTreeNode();
            znode.setId("" + menu.getMenuId());
            znode.setpId("" + menu.getParentId());
            znode.setName(menu.getMenuName());
            znode.setUrl(menu.getMenuUrl());
            list.add(znode);
        }
        return list;
    }

    @Override
    public String[] processStudentInfosByLoginId(Integer id) {
        String[] res = new String[10];
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Calendar c = Calendar.getInstance();
        res[0] = String.valueOf(this.tCourseDao.getStudentNowClassname(id));
        res[1] = String.valueOf(this.tCourseDao.countStudentComments(id));
        res[2] = String.valueOf(this.tCourseDao.countNotCompleteCoursessions(id));
        res[3] = String.valueOf(this.tCourseDao.countStudentComments(id));
        return res;
    }

    @Override
    public List<CalendarDto> findAllCalendarsByLoginId(Integer loginId) {
        List calendarDtos = this.tCourseDao.findStudentAllCalendarsByLoginId(loginId);
        ArrayList<CalendarDto> result = new ArrayList<CalendarDto>();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Iterator iterator = calendarDtos.iterator();
        while (iterator.hasNext()) {
            CalendarDto rs;
            CalendarDto d = rs = (CalendarDto)iterator.next();
            String classname = rs.getClassname();
            int duration = rs.getDuration();
            d.setStartTime(rs.getStartTime());
            Date date = rs.getStartTime();
            Integer status = rs.getStatus();
            Calendar c = Calendar.getInstance();
            c.setTime(date);
            c.add(12, duration);
            Date date2 = c.getTime();
            String st = this.initDictionUtil.getDictNameByDictId("" + status);
            if (StringUtil.isNotEmpty((String)st)) {
                st = "(" + st + ")";
            }
            d.setTitle(classname + " " + st);
            d.setStarTimeStr(sdf.format(date));
            d.setEndTimeStr(sdf.format(date2));
            c.setTime(date);
            c.add(11, -12);
            String firstName = rs.getFirstName();
            d.setTitle(d.getTitle() + "(" + firstName + ")");
            d.setType("1");
            if (status == null) {
                d.setColor("green");
            } else if (status == 101001) {
                d.setColor("gray");
            } else if (status == 101002 || status == 101003 || status == 101006) {
                d.setColor("blue");
            } else if (status == 101004 || status == 101005) {
                d.setColor("red");
            } else if (status == 101007) {
                d.setColor("purple");
            } else {
                d.setColor("green");
            }
            d.setSessionid(rs.getSessionid());
            d.setCid(rs.getCid());
            result.add(d);
        }
        return result;
    }

    @Override
    public HashMap<String, String> registerByMobile(MobileRegisterForm form) throws ParseException {
        HashMap<String, String> result = new HashMap<String, String>();
        if (StringUtils.isEmpty((String)form.getMobile()) || StringUtils.isEmpty((String)form.getCode())) {
            result.put("flag", "1");
            result.put("message", "\u9a8c\u8bc1\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            return result;
        }
        if (!this.commonService.checkCode(form.getMobile(), form.getCode()).booleanValue()) {
            result.put("flag", "1");
            result.put("message", "\u9a8c\u8bc1\u7801\u9519\u8bef\uff01\uff01");
            return result;
        }
        TLogin tLogin = this.tLoginDao.findByMobile(form.getMobile());
        if (tLogin != null) {
            result.put("flag", "1");
            result.put("message", form.getMobile() + "\u5df2\u7ecf\u88ab\u4f7f\u7528\u4e86\uff01\uff01");
            return result;
        }
        TLogin newTLogin = new TLogin();
        newTLogin.setCreater(form.getMobile());
        newTLogin.setLoginCount(Integer.valueOf(0));
        newTLogin.setMobile(form.getMobile());
        newTLogin.setRoleId(Integer.valueOf(1));
        int flag = this.tLoginDao.insertSelective(newTLogin);
        if (flag < 1) {
            logger.info("tLoginDao.insertSelective(newTLogin) \u6267\u884c\u5931\u8d25");
        }
        TStudent tStudent = new TStudent();
        tStudent.setLoginId(newTLogin.getLoginId());
        tStudent.setPhone(form.getMobile());
        tStudent.setEnglishName(form.getEnglishName());
        tStudent.setRealName(form.getEnglishName());
        tStudent.setBirthday(DateUtils.getBirthdayFromAge((Double)form.getAge()));
        flag = this.tStudentDao.insertSelective(tStudent);
        if (flag < 1) {
            logger.info("tStudentDao.insertSelective(tStudent) \u6267\u884c\u5931\u8d25");
        }
        TStudentConsultant tStudentConsultant = new TStudentConsultant();
        tStudentConsultant.setStuId(tStudent.getStuId());
        tStudentConsultant.setConsultantName("admin");
        tStudentConsultant.setConsultantId(Integer.valueOf(1));
        tStudentConsultant.setConsultantEmail("yanfengxue@talkilla.org");
        tStudentConsultant.setMobile("18910070280");
        flag = this.tStudentConsultantDao.insertSelective(tStudentConsultant);
        if (flag < 1) {
            logger.info("tStudentConsultantDao.insertSelective(tStudentConsultant) \u6267\u884c\u5931\u8d25");
        }
        result.put("stuId", tStudent.getStuId() + "");
        result.put("flag", "0");
        result.put("message", "\u606d\u559c\u60a8\u6ce8\u518c\u6210\u529f\u5e76\u83b7\u5f97\u4e0e\u82f1\u7f8e\u5916\u6559\u7684\u514d\u8d39\u4f53\u9a8c\u8bfe\uff01\u6211\u4eec\u7684\u5ba2\u670d\u4eba\u5458\u4f1a\u9a6c\u4e0a\u4e0e\u60a8\u8054\u7cfb\u3002");
        return result;
    }

    @Override
    public HashMap<String, String> savePassword(MobileRegisterSavePWDForm form) {
        HashMap<String, String> result = new HashMap<String, String>();
        if (StringUtils.isBlank((String)form.getPassword()) || StringUtils.isBlank((String)form.getConfirmPassword())) {
            result.put("flag", "1");
            result.put("message", "\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            return result;
        }
        if (!form.getPassword().equals(form.getConfirmPassword())) {
            result.put("flag", "1");
            result.put("message", "\u5bc6\u7801\u4e0e\u786e\u8ba4\u5bc6\u7801\u4e0d\u4e00\u81f4");
            return result;
        }
        TStudent student = this.tStudentDao.findOne(form.getStuId());
        TLogin tLogin = this.tLoginDao.findOne(student.getLoginId());
        tLogin.setLoginPwd(PasswordUtil.encrypt2((String)form.getPassword()));
        this.tLoginDao.updateByIdSelective(tLogin);
        result.put("flag", "0");
        result.put("message", "\u5bc6\u7801\u8bbe\u7f6e\u6210\u529f");
        return result;
    }
}

