/*
 * Decompiled with CFR 0.152.
 */
package com.talkilla.service.impl.admin;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.talkilla.constant.SystemConfig;
import com.talkilla.form.admin.message.MessageAddForm;
import com.talkilla.mysql.domain.TConsultant;
import com.talkilla.mysql.domain.TLogin;
import com.talkilla.mysql.domain.TMessage;
import com.talkilla.mysql.domain.TTeacher;
import com.talkilla.mysql.mapper.TConsultantDao;
import com.talkilla.mysql.mapper.TLoginDao;
import com.talkilla.mysql.mapper.TMessageDao;
import com.talkilla.mysql.mapper.TTeacherDao;
import com.talkilla.mysql.mapper.TTeacherMessageDao;
import com.talkilla.result.admin.base.PageObj;
import com.talkilla.service.admin.MessageService;
import com.talkilla.service.form.QueryMessageForm;
import com.talkilla.utils.DateUtils;
import com.talkilla.utils.HttpUtils;
import java.util.HashMap;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;
import org.nestframework.commons.utils.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="messageService")
public class MessageServiceImpl
implements MessageService {
    private static final Logger log = LoggerFactory.getLogger(MessageServiceImpl.class);
    Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private TMessageDao tMessageDao;
    @Autowired
    private TTeacherMessageDao tTeacherMessageDao;
    @Autowired
    private TLoginDao tLoginDao;
    @Autowired
    private TTeacherDao tTeacherDao;
    @Autowired
    private TConsultantDao tConsultantDao;

    @Override
    public PageObj findPageMessage(QueryMessageForm form) {
        Page page;
        HashMap<String, String> querymap = new HashMap<String, String>();
        if (StringUtil.isNotEmpty((String)form.getDate1()) && StringUtil.isNotEmpty((String)form.getDate2())) {
            querymap.put("startDate", form.getDate1());
            querymap.put("endDate", form.getDate2());
        }
        if (StringUtils.isNotBlank((String)form.getTitle())) {
            querymap.put("title", form.getTitle());
        }
        if (Objects.nonNull(form.getStatus())) {
            querymap.put("status", String.valueOf(form.getStatus()));
        }
        if (form.getPageNo() != null && form.getPageNo() != 0) {
            querymap.put("pageNo", form.getPageNo() + "");
        } else {
            querymap.put("pageNo", "1");
        }
        if (form.getPageSize() != null && form.getPageSize() != 0) {
            querymap.put("pageSize", form.getPageSize() + "");
        } else {
            querymap.put("pageSize", "20");
        }
        Integer pageNo = Integer.valueOf((String)querymap.get("pageNo"));
        Integer pageSize = Integer.valueOf((String)querymap.get("pageSize"));
        if (pageNo != null && pageNo != 0 && pageSize != null && pageSize != 0) {
            page = PageHelper.startPage((int)pageNo, (int)pageSize);
        } else {
            pageNo = 1;
            pageSize = 20;
            page = PageHelper.startPage((int)pageNo, (int)pageSize);
        }
        this.tMessageDao.findMessages((String)querymap.get("title"), (String)querymap.get("status"), (String)querymap.get("startDate"), (String)querymap.get("endDate"));
        PageObj pageObj = new PageObj();
        pageObj.setCurrPageNumber(pageNo);
        pageObj.setFirstPageNumber(Integer.valueOf(1));
        pageObj.setLastPageNumber(pageObj.processTotalPage(page.getTotal(), Integer.valueOf(page.getPageSize())));
        pageObj.setPreviousPageNumber(pageObj.processPreviousPage(pageNo));
        pageObj.setNextPageNumber(pageObj.processNextPage());
        pageObj.setPageElements(page.getResult());
        pageObj.setPageSize(pageSize);
        pageObj.setTotalCount(Long.valueOf(page.getTotal()));
        return pageObj;
    }

    @Override
    public void saveOrUpdate(MessageAddForm form) {
        boolean isValid = this.isValidParamForMessageAddForm(form);
        if (!isValid) {
            return;
        }
        TMessage tMessage = this.saveOrUpdateTMessage(form);
        this.sendTopicToCommunity(form, tMessage);
    }

    private void sendTopicToCommunity(MessageAddForm form, TMessage tMessage) {
        if (tMessage == null || form.getSyncToCommunityFlag() == null || form.getSyncToCommunityFlag() != 1) {
            return;
        }
        try {
            Integer status = form.getStatus();
            if (status == 1) {
                TConsultant tConsultant;
                TTeacher tTeacher;
                TLogin tLogin = this.tLoginDao.findOne(form.getLoginId());
                HashMap<String, String> body = new HashMap<String, String>();
                body.put("title", form.getTitle());
                body.put("content", form.getMessage());
                String email = tLogin.getLoginName();
                body.put("email", email);
                Integer roleId = tLogin.getRoleId();
                body.put("roleId", roleId.toString());
                String displayName = email;
                Integer loginId = tLogin.getLoginId();
                if (roleId == 2 && (tTeacher = this.tTeacherDao.findTeacherByLoginId(loginId)) != null) {
                    displayName = tTeacher.getFirstName() + " " + tTeacher.getLastName();
                }
                if (roleId == 4 && (tConsultant = this.tConsultantDao.findByLoginId(loginId)) != null) {
                    displayName = tConsultant.geteName();
                }
                body.put("displayName", displayName);
                String result = HttpUtils.httpPost((String)(SystemConfig.TALKILLACOMMUNITY_URL + "api/topic/create-by-talkillaAdmin"), (String)JSON.toJSONString(body));
                if (StringUtils.isNotBlank((String)result)) {
                    JSONObject jsonObject = JSON.parseObject((String)result);
                    Integer topicId = jsonObject.getJSONObject("detail").getInteger("id");
                    String topicViewUrl = "topic/" + topicId;
                    tMessage.setTopicViewUrl(topicViewUrl);
                    this.tMessageDao.updateByIdSelective(tMessage);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public TMessage getByMessageId(Integer messageId) {
        TMessage tMessage = this.tMessageDao.findOne(messageId);
        return tMessage;
    }

    @Override
    @Transactional
    public void deleteByMessageId(Integer messageId, Integer loginId) {
        Integer nowSeconds = DateUtils.getNowSeconds();
        TMessage tMessage = this.tMessageDao.findOne(messageId);
        tMessage.setUpdater("" + loginId);
        tMessage.setIsDelete(nowSeconds);
        this.tMessageDao.updateByIdSelective(tMessage);
        this.tTeacherMessageDao.deleteByMessageId(tMessage.getId(), "" + loginId, nowSeconds);
    }

    private TMessage saveOrUpdateTMessage(MessageAddForm form) {
        Integer messageId = form.getId();
        TMessage tMessage = null;
        if (Objects.isNull(messageId)) {
            tMessage = new TMessage();
            tMessage.setTitle(form.getTitle());
            tMessage.setMessage(form.getMessage());
            tMessage.setStatus(form.getStatus());
            tMessage.setCreater("" + form.getLoginId());
            this.tMessageDao.insertSelective(tMessage);
        } else {
            tMessage = this.tMessageDao.findOne(messageId);
            if (Objects.isNull(tMessage)) {
                log.error("messageId\u4e3a:{}\u7684\u6d88\u606f\u4e0d\u5b58\u5728", (Object)messageId);
                return null;
            }
            tMessage.setTitle(form.getTitle());
            tMessage.setMessage(form.getMessage());
            tMessage.setStatus(form.getStatus());
            tMessage.setUpdater("" + form.getLoginId());
            this.tMessageDao.updateByIdSelective(tMessage);
        }
        return tMessage;
    }

    private boolean isValidParamForMessageAddForm(MessageAddForm form) {
        String title = form.getTitle();
        if (StringUtils.isEmpty((String)title)) {
            log.error("\u65b0\u589e\u5e7f\u64ad\u6d88\u606f\uff0c\u6807\u9898title\u4e3a\u7a7a");
            return false;
        }
        String message = form.getMessage();
        if (StringUtils.isEmpty((String)message)) {
            log.error("\u65b0\u589e\u5e7f\u64ad\u6d88\u606f\uff0c\u6d88\u606f\u5185\u5bb9message\u4e3a\u7a7a");
            return false;
        }
        Integer status = form.getStatus();
        if (Objects.isNull(status)) {
            log.error("\u65b0\u589e\u5e7f\u64ad\u6d88\u606f\uff0c\u6d88\u606f\u53d1\u9001\u72b6\u6001status\u4e3a\u7a7a");
            return false;
        }
        if (!status.equals(0) && !status.equals(1)) {
            log.error("\u65b0\u589e\u5e7f\u64ad\u6d88\u606f\uff0c\u6d88\u606f\u53d1\u9001\u72b6\u6001status\u503c\u672a\u5b9a\u4e49");
            return false;
        }
        return true;
    }
}

