/*
 * Decompiled with CFR 0.152.
 */
package com.talkilla.service.impl.admin;

import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.talkilla.constant.SystemConfig;
import com.talkilla.constant.TalkillaConstant;
import com.talkilla.form.admin.AdminTeacherMonthIncomeRecordAddOrUpdateForm;
import com.talkilla.form.admin.AdminTeacherWagesForm;
import com.talkilla.form.admin.AdminTeacherWagesFormOld;
import com.talkilla.form.admin.AdminTeachingRecordEditRecoverForm;
import com.talkilla.form.admin.AdminTeachingRecordEditSaveForm;
import com.talkilla.form.admin.AdminTeachingRecordsForm;
import com.talkilla.mysql.domain.TConsultant;
import com.talkilla.mysql.domain.TCourse;
import com.talkilla.mysql.domain.TCourseSessionStudent;
import com.talkilla.mysql.domain.TCoursesession;
import com.talkilla.mysql.domain.TCustTimezone;
import com.talkilla.mysql.domain.TLogin;
import com.talkilla.mysql.domain.TNation;
import com.talkilla.mysql.domain.TSendEmailRecord;
import com.talkilla.mysql.domain.TStuFeeback;
import com.talkilla.mysql.domain.TStudent;
import com.talkilla.mysql.domain.TStudentConsultant;
import com.talkilla.mysql.domain.TTeacher;
import com.talkilla.mysql.domain.TTeacherComments;
import com.talkilla.mysql.domain.TTeacherMonthIncomeRecord;
import com.talkilla.mysql.domain.TWechat;
import com.talkilla.mysql.mapper.TConsultantDao;
import com.talkilla.mysql.mapper.TCourseDao;
import com.talkilla.mysql.mapper.TCourseSessionStudentDao;
import com.talkilla.mysql.mapper.TCourseStudentDao;
import com.talkilla.mysql.mapper.TCoursesessionDao;
import com.talkilla.mysql.mapper.TCustTimezoneDao;
import com.talkilla.mysql.mapper.TLoginDao;
import com.talkilla.mysql.mapper.TNationDao;
import com.talkilla.mysql.mapper.TSendEmailRecordDao;
import com.talkilla.mysql.mapper.TStuFeebackDao;
import com.talkilla.mysql.mapper.TStudentConsultantDao;
import com.talkilla.mysql.mapper.TStudentDao;
import com.talkilla.mysql.mapper.TTeacherCommentsDao;
import com.talkilla.mysql.mapper.TTeacherDao;
import com.talkilla.mysql.mapper.TTeacherMonthIncomeRecordDao;
import com.talkilla.mysql.mapper.TWechatDao;
import com.talkilla.otherbean.BankBillDto;
import com.talkilla.otherbean.TeacherManagementActionQueryDto;
import com.talkilla.otherbean.UserDto;
import com.talkilla.result.LeaveCourseResult;
import com.talkilla.result.ReturnMessageResult;
import com.talkilla.result.admin.AdminTeacherWagesDetailListResult;
import com.talkilla.result.admin.AdminTeacherWagesDetailListResult2;
import com.talkilla.result.admin.AdminTeachingRecordEditResult;
import com.talkilla.result.admin.AdminTeachingRecordListResult;
import com.talkilla.result.admin.base.PageObj;
import com.talkilla.service.TCourseService;
import com.talkilla.service.TCoursesessionService;
import com.talkilla.service.UploadPhotoService;
import com.talkilla.service.admin.AdminTeacherManageService;
import com.talkilla.service.form.AdminTeacherFenleiSaveForm;
import com.talkilla.service.form.AdminTeacherListForm;
import com.talkilla.service.form.AdminTeacherManageEditSaveForm;
import com.talkilla.serviceUtils.TalkillaEmailMessageUtils;
import com.talkilla.serviceUtils.TimeZoneUtil;
import com.talkilla.utils.DateUtils;
import com.talkilla.utils.MathUtils;
import com.talkilla.utils.NoServiceUtil;
import com.talkilla.wechat.form.WechatCourseStatusChangeForm;
import com.talkilla.wechat.service.WechatMessageService;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;
import org.nestframework.commons.utils.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.web.multipart.MultipartFile;

@Service(value="adminTeacherManageService")
public class AdminTeacherManageServiceImpl
implements AdminTeacherManageService {
    Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    UploadPhotoService uploadPhotoService;
    @Autowired
    TCourseDao tCourseDao;
    @Autowired
    TCoursesessionDao tCoursesessionDao;
    @Autowired
    TTeacherDao tTeacherDao;
    @Autowired
    TNationDao tNationDao;
    @Autowired
    TLoginDao tLoginDao;
    @Autowired
    TStudentDao tStudentDao;
    @Autowired
    TCoursesessionService tCoursesessionService;
    @Autowired
    TCourseService tCourseService;
    @Autowired
    TWechatDao tWechatDao;
    @Autowired
    TStudentConsultantDao tStudentConsultantDao;
    @Autowired
    TConsultantDao tConsultantDao;
    @Autowired
    TCustTimezoneDao tCustTimezoneDao;
    @Autowired
    TStuFeebackDao tStuFeebackDao;
    @Autowired
    TTeacherCommentsDao tTeacherCommentsDao;
    @Autowired
    WechatMessageService wechatMessageService;
    @Autowired
    private TCourseStudentDao tCourseStudentDao;
    @Autowired
    private TCourseSessionStudentDao tCourseSessionStudentDao;
    @Autowired
    private TSendEmailRecordDao tSendEmailRecordDao;
    @Autowired
    private TTeacherMonthIncomeRecordDao tTeacherMonthIncomeRecordDao;

    @Override
    public List<BankBillDto> findBillsByTime(Date start, Date end) {
        ArrayList<BankBillDto> results = new ArrayList<BankBillDto>();
        List cids = this.tCoursesessionDao.findCourseIdByStartTimeAndEndTimeCid(start, end);
        for (Integer cid : cids) {
            BankBillDto dto = new BankBillDto();
            TCourse one = this.tCourseDao.findOne(cid);
            dto.setClassName(one.getClassname());
            dto.setDanjia(MathUtils.mul((BigDecimal)one.getRate(), (BigDecimal)new BigDecimal((double)one.getDuration().intValue() / 60.0)).doubleValue());
            dto.setCreateDate(one.getCreatedate());
            dto.setHourpurchase(one.getHourpurchase().doubleValue());
            dto.setHourawarded(one.getHourawarded().doubleValue());
            dto.setZongjia(MathUtils.mul((BigDecimal)one.getRate(), (BigDecimal)new BigDecimal(one.getHourpurchase() * (double)one.getDuration().intValue() / 60.0)).doubleValue());
            TTeacher teacher = this.tTeacherDao.findOne(one.getTeacherId());
            dto.setTName(teacher.getFirstName() + "-" + teacher.getLastName());
            TStudent student = this.tStudentDao.findOne(one.getStuId());
            dto.setStuName(student.getRealName());
            dto.setFatherName(student.getParentName());
            Integer complete = this.tCoursesessionDao.countCoursesessionByStatusAndTimeCid(TalkillaConstant.COURSE_STATUS_COMPLETED, start, end, cid);
            Integer tleave = this.tCoursesessionDao.countCoursesessionByStatusAndTimeCid(TalkillaConstant.COURSE_STATUS_LEAVE_TEACHER, start, end, cid) + this.tCoursesessionDao.countCoursesessionByStatusAndTimeCid(TalkillaConstant.COURSE_STATUS_SPECIAL_CASES, start, end, cid);
            Integer sleave = this.tCoursesessionDao.countCoursesessionByStatusAndTimeCid(TalkillaConstant.COURSE_STATUS_LEAVE_STUDENT, start, end, cid);
            Integer tabsent = this.tCoursesessionDao.countCoursesessionByStatusAndTimeCid(TalkillaConstant.COURSE_STATUS_ABSENT_TEACHER, start, end, cid);
            Integer sabsent = this.tCoursesessionDao.countCoursesessionByStatusAndTimeCid(TalkillaConstant.COURSE_STATUS_ABSENT_STUDENT, start, end, cid);
            Integer uncomplete = this.tCoursesessionDao.countUnCompleteCoursesessionByTimeCid(start, end, cid);
            dto.setApplymoney(MathUtils.mul((BigDecimal)one.getRate(), (BigDecimal)new BigDecimal((double)(complete * one.getDuration()) / 60.0)).doubleValue());
            dto.setTleave((double)(tleave * one.getDuration()) / 60.0);
            dto.setSleave((double)(sleave * one.getDuration()) / 60.0);
            dto.setTabsent((double)(tabsent * one.getDuration()) / 60.0);
            dto.setSabsent((double)(sabsent * one.getDuration()) / 60.0);
            dto.setUncomplete((double)(uncomplete * one.getDuration()) / 60.0);
            results.add(dto);
        }
        return results;
    }

    @Override
    public PageObj findTotalInfosByParam(Map<String, Object> querymap, Integer pageNo, Integer pageSize) {
        return new PageObj();
    }

    @Override
    public List<AdminTeacherWagesDetailListResult> findWageDetailsByTeacherIdOld(AdminTeacherWagesFormOld form) {
        return this.tTeacherDao.findWageDetailsByTeacherId(form);
    }

    @Override
    public List<AdminTeacherWagesDetailListResult2> findWageDetailsByTeacherId(AdminTeacherWagesForm form) throws ParseException {
        if (null != form.getDate1()) {
            form.setDate2(DateUtils.getMonthEndDay((Date)form.getDate1()));
        }
        return this.tTeacherDao.findWageDetailsByTeacherId2(form);
    }

    @Override
    public PageObj getTeacherList(AdminTeacherListForm form) {
        Integer pageNo = form.getPageNo();
        Integer pageSize = form.getPageSize();
        if (pageNo == null || pageNo == 0) {
            pageNo = 1;
        }
        if (pageSize == null || pageSize == 0) {
            pageSize = 10;
        }
        Page page = PageHelper.startPage((int)pageNo, (int)pageSize);
        this.tTeacherDao.findTeacherList(form.getFname(), form.getLname(), form.getCountry(), form.getFenlei());
        List result = page.getResult();
        ArrayList<TeacherManagementActionQueryDto> results = new ArrayList<TeacherManagementActionQueryDto>();
        for (TTeacher teacher : result) {
            TNation nation;
            TLogin login;
            TeacherManagementActionQueryDto dto = new TeacherManagementActionQueryDto();
            BeanUtils.copyProperties((Object)teacher, (Object)dto);
            dto.setFenlei(teacher.getTeacherType() + "");
            dto.setPhotopath(teacher.getAvatar());
            dto.setPaypalaccount(teacher.getPaypalAccount());
            dto.setTeachingsinceyear(teacher.getTeachingSinceYear());
            dto.setWorkexperience(teacher.getWorkExperience());
            if (teacher.getOneOnMultiple() != null) {
                dto.setOnetomany(teacher.getOneOnMultiple().doubleValue());
            }
            if (teacher.getOneOnOne() != null) {
                dto.setOnetoone(teacher.getOneOnOne().doubleValue());
            }
            if ((login = this.tLoginDao.findOne(teacher.getLoginId())) != null) {
                dto.setLoginname(login.getLoginName());
            }
            if ((nation = this.tNationDao.findOne(teacher.getCountry())) != null) {
                dto.setCountrystr(nation.getName());
            }
            if (teacher.getCreateTime() != null) {
                dto.setCreateTime(DateUtils.formatDateToDay((Date)teacher.getCreateTime()));
            }
            results.add(dto);
        }
        PageObj pageObj = new PageObj();
        pageObj.setCurrPageNumber(pageNo);
        pageObj.setFirstPageNumber(Integer.valueOf(1));
        pageObj.setLastPageNumber(pageObj.processTotalPage(page.getTotal(), Integer.valueOf(page.getPageSize())));
        pageObj.setPreviousPageNumber(pageObj.processPreviousPage(pageNo));
        pageObj.setNextPageNumber(pageObj.processNextPage());
        pageObj.setPageElements(results);
        pageObj.setPageSize(pageSize);
        pageObj.setTotalCount(Long.valueOf(page.getTotal()));
        return pageObj;
    }

    @Override
    @Transactional(rollbackFor={Throwable.class}, propagation=Propagation.REQUIRED)
    public void dingjiSave(AdminTeacherFenleiSaveForm form) {
        List coursesessions;
        TTeacher newinstance = this.tTeacherDao.findOne(form.getTeacherId());
        newinstance.setTeacherType(form.getFenleisave());
        if (form.getOneonone() != null && form.getOneonone() != 0.0 && (newinstance.getOneOnOne() == null || newinstance.getOneOnOne().compareTo(form.getOneonone()) != 0)) {
            newinstance.setOneOnOne(form.getOneonone());
            coursesessions = this.tCoursesessionDao.getNowSessionByTeacherIdAndCourseType(form.getTeacherId(), Integer.valueOf(100001));
            if (coursesessions != null && coursesessions.size() > 0) {
                for (TCoursesession coursesession : coursesessions) {
                    coursesession.setRate(new BigDecimal(form.getOneonone()));
                    coursesession.setUpdateTime(new Date());
                    this.tCoursesessionDao.updateByIdSelective(coursesession);
                }
            }
        }
        if (form.getOneonmultiple() != null && form.getOneonmultiple() != 0.0 && (newinstance.getOneOnMultiple() == null || newinstance.getOneOnMultiple().compareTo(form.getOneonmultiple()) != 0)) {
            newinstance.setOneOnMultiple(form.getOneonmultiple());
            coursesessions = this.tCoursesessionDao.getNowSessionByTeacherIdAndCourseType(form.getTeacherId(), Integer.valueOf(100002));
            if (coursesessions != null && coursesessions.size() > 0) {
                for (TCoursesession coursesession : coursesessions) {
                    coursesession.setRate(new BigDecimal(form.getOneonmultiple()));
                    coursesession.setUpdateTime(new Date());
                    this.tCoursesessionDao.updateByIdSelective(coursesession);
                }
            }
        }
        newinstance.setForeignServiceId(form.getForeignServiceId());
        newinstance.setManagementCost(form.getManagementCost());
        newinstance.setDesUrl(form.getDesUrl());
        if (StringUtils.isNotBlank((String)form.getCutoffDate())) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            try {
                newinstance.setCutoffDate(sdf.parse(form.getCutoffDate()));
            }
            catch (ParseException e) {
                this.logger.error("\u65e5\u671f\u89e3\u6790\u9519\u8bef", (Throwable)e);
            }
        }
        newinstance.setUpdateTime(new Date());
        this.tTeacherDao.updateByIdSelective(newinstance);
    }

    @Override
    public Map dingjiDelete(Integer teacherId) {
        TTeacher teacher = this.tTeacherDao.findOne(teacherId);
        if (teacher != null) {
            teacher.setIsDelete(DateUtils.getNowSeconds());
            teacher.setUpdateTime(new Date());
            this.tTeacherDao.updateByIdSelective(teacher);
            TLogin one = this.tLoginDao.findOne(teacher.getLoginId());
            one.setIsDelete(DateUtils.getNowSeconds());
            this.tLoginDao.updateByIdSelective(one);
        }
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("message", "\u5220\u9664\u6210\u529f");
        return result;
    }

    @Override
    public ReturnMessageResult teacherMonthIncomeRecordAddOrUpdate(UserDto user, AdminTeacherMonthIncomeRecordAddOrUpdateForm form) {
        ReturnMessageResult messageResult = new ReturnMessageResult();
        Integer teacherId = form.getTeacherId();
        if (teacherId == null) {
            messageResult.setFlag(Integer.valueOf(1));
            messageResult.setMessage("teacherId is null");
            return messageResult;
        }
        String yearMonth = form.getYearMonth();
        if (StringUtils.isEmpty((String)yearMonth)) {
            yearMonth = "9999-99";
            form.setYearMonth(yearMonth);
        }
        Integer loginId = user.getLoginId();
        Date date = new Date();
        TTeacherMonthIncomeRecord record = this.tTeacherMonthIncomeRecordDao.findByTeacherIdAndMonth(form.getTeacherId(), form.getYearMonth());
        if (null != record) {
            record.setUpdateTime(date);
            record.setUpdater(loginId.toString());
            record.setRemarks(form.getRemarks());
            record.setActualPayMoney(form.getActualPayMoney());
            this.tTeacherMonthIncomeRecordDao.updateByIdSelective(record);
        } else {
            record = new TTeacherMonthIncomeRecord();
            record.setTeacherId(form.getTeacherId());
            record.setYearMonth(form.getYearMonth());
            record.setActualPayMoney(form.getActualPayMoney());
            record.setCreateTime(date);
            record.setCreater(loginId.toString());
            record.setRemarks(form.getRemarks());
            this.tTeacherMonthIncomeRecordDao.insertSelective(record);
        }
        messageResult.setFlag(Integer.valueOf(0));
        messageResult.setMessage("ok");
        return messageResult;
    }

    @Override
    @Transactional(rollbackFor={Throwable.class})
    public ReturnMessageResult teachingRecordEditRecover(AdminTeachingRecordEditRecoverForm form) {
        Integer lastTCoursesessionStatus;
        TCoursesession lastTCoursesession;
        Integer sessionid = form.getSessionid();
        TCoursesession tCoursesession = this.tCoursesessionDao.findOne(sessionid);
        Integer status = tCoursesession.getStatus();
        if (TalkillaConstant.COURSE_STATUS_UMCONFIRMED.equals(status) || status == null) {
            ReturnMessageResult returnMessageResult = new ReturnMessageResult();
            returnMessageResult.setFlag(Integer.valueOf(1));
            returnMessageResult.setMessage("\u5f53\u524d\u8bfe\u7a0b\u5904\u4e8e\u5c1a\u672a\u786e\u8ba4\u7684\u72b6\u6001");
            return returnMessageResult;
        }
        Integer cid = tCoursesession.getCid();
        TCourse tCourse = this.tCourseDao.findOne(cid);
        if (TalkillaConstant.COURSE_STATUS_COMPLETED.equals(status) || TalkillaConstant.COURSE_STATUS_ABSENT_STUDENT.equals(status)) {
            this.tCoursesessionDao.updateStatusBySessionId(sessionid, null);
            tCourse.setHourpending(MathUtils.add((Double)tCourse.getHourpending(), (Double)((double)tCoursesession.getDuration().intValue() / 60.0)));
            if (tCourse.getHourpending() == 0.0) {
                tCourse.setTeachStatus(Integer.valueOf(2));
            }
            tCourse.setHourcomplete(MathUtils.sub((Double)tCourse.getHourcomplete(), (Double)((double)tCoursesession.getDuration().intValue() / 60.0)));
            tCourse.setUpdateTime(new Date());
            this.tCourseDao.updateByIdSelective(tCourse);
            this.tTeacherCommentsDao.deleteBySessionid(sessionid, DateUtils.getNowSeconds());
        }
        if (TalkillaConstant.COURSE_STATUS_ABSENT_TEACHER.equals(status)) {
            this.tCoursesessionDao.updateStatusBySessionId(sessionid, null);
            tCourse.setHourpending(MathUtils.sub((Double)tCourse.getHourpending(), (Double)((double)tCoursesession.getDuration().intValue() / 60.0)));
            if (tCourse.getHourpending() == 0.0) {
                tCourse.setTeachStatus(Integer.valueOf(2));
            }
            tCourse.setHourawarded(MathUtils.sub((Double)tCourse.getHourawarded(), (Double)((double)tCoursesession.getDuration().intValue() / 60.0)));
            tCourse.setTotalhour(MathUtils.sub((Double)tCourse.getTotalhour(), (Double)((double)tCoursesession.getDuration().intValue() / 60.0)));
            tCourse.setUpdateTime(new Date());
            lastTCoursesession = this.tCoursesessionDao.findLastOneByCid(cid);
            lastTCoursesessionStatus = lastTCoursesession.getStatus();
            if (TalkillaConstant.COURSE_STATUS_COMPLETED.equals(lastTCoursesessionStatus) || TalkillaConstant.COURSE_STATUS_ABSENT_STUDENT.equals(lastTCoursesessionStatus)) {
                tCourse.setHourcomplete(MathUtils.sub((Double)tCourse.getHourcomplete(), (Double)((double)tCoursesession.getDuration().intValue() / 60.0)));
                tCourse.setTotalhour(MathUtils.sub((Double)tCourse.getTotalhour(), (Double)((double)tCoursesession.getDuration().intValue() / 60.0)));
            }
            this.tCoursesessionDao.deleteBysessionid(lastTCoursesession.getSessionid(), DateUtils.getNowSeconds());
            this.tCourseDao.updateByIdSelective(tCourse);
            this.tTeacherCommentsDao.deleteBySessionid(sessionid, DateUtils.getNowSeconds());
        }
        if (TalkillaConstant.COURSE_STATUS_SPECIAL_CASES.equals(status) || TalkillaConstant.COURSE_STATUS_LEAVE_TEACHER.equals(status) || TalkillaConstant.COURSE_STATUS_LEAVE_STUDENT.equals(status)) {
            this.tCoursesessionDao.updateStatusBySessionId(sessionid, null);
            this.tCoursesessionDao.updateNoteBySessionId(sessionid, "");
            this.tTeacherCommentsDao.deleteBySessionid(sessionid, DateUtils.getNowSeconds());
            lastTCoursesession = this.tCoursesessionDao.findLastOneByCid(cid);
            lastTCoursesessionStatus = lastTCoursesession.getStatus();
            if (TalkillaConstant.COURSE_STATUS_COMPLETED.equals(lastTCoursesessionStatus) || TalkillaConstant.COURSE_STATUS_ABSENT_STUDENT.equals(lastTCoursesessionStatus)) {
                tCourse.setHourcomplete(MathUtils.sub((Double)tCourse.getHourcomplete(), (Double)((double)tCoursesession.getDuration().intValue() / 60.0)));
                tCourse.setTotalhour(MathUtils.sub((Double)tCourse.getTotalhour(), (Double)((double)tCoursesession.getDuration().intValue() / 60.0)));
                this.tCourseDao.updateByIdSelective(tCourse);
            }
            this.tCoursesessionDao.deleteBysessionid(lastTCoursesession.getSessionid(), DateUtils.getNowSeconds());
        }
        return ReturnMessageResult.success((String)"\u6210\u529f");
    }

    @Override
    @Transactional(rollbackFor={Throwable.class}, propagation=Propagation.REQUIRED)
    public void editSave(AdminTeacherManageEditSaveForm form, MultipartFile fileItem) {
        TTeacher teacher = this.tTeacherDao.findOne(form.getTeacherId());
        BeanUtils.copyProperties((Object)form, (Object)teacher);
        if (fileItem != null && StringUtil.isNotEmpty((String)fileItem.getOriginalFilename())) {
            String path = this.uploadPhotoService.savePhoto(fileItem, form.getAvatar(), "", "teacher");
            teacher.setAvatar(path);
        }
        if (StringUtils.isNotBlank((String)form.getZhumuId())) {
            teacher.setZhumuId(form.getZhumuId());
            teacher.setZoomId(form.getZhumuId());
        }
        teacher.setCutoffDate(form.getCutoffDate());
        teacher.setUpdateTime(new Date());
        this.tTeacherDao.updateByIdSelective(teacher);
    }

    @Override
    public TTeacher teacherEditInfo(Integer teacherId) {
        return this.tTeacherDao.findOne(teacherId);
    }

    @Override
    public PageObj wagesOld(AdminTeacherWagesFormOld form) throws ParseException {
        Integer pageNo = form.getPageNo();
        Integer pageSize = form.getPageSize();
        String date1 = form.getDate1();
        if (StringUtil.isNotEmpty((String)date1)) {
            date1 = date1 + "-01";
            String date2 = DateUtils.getMonthEndDay((String)date1);
            form.setDate1(date1);
            form.setDate2(date2);
        }
        if (pageNo == null || pageNo < 1) {
            pageNo = 1;
        }
        if (pageSize == null || pageSize < 0) {
            pageSize = 20;
        }
        Page page = PageHelper.startPage((int)pageNo, (int)pageSize);
        this.tTeacherDao.teacherWageList(form);
        PageObj pageObj = new PageObj();
        pageObj.setCurrPageNumber(pageNo);
        pageObj.setFirstPageNumber(Integer.valueOf(1));
        pageObj.setLastPageNumber(pageObj.processTotalPage(page.getTotal(), Integer.valueOf(page.getPageSize())));
        pageObj.setPreviousPageNumber(pageObj.processPreviousPage(pageNo));
        pageObj.setNextPageNumber(pageObj.processNextPage());
        pageObj.setPageElements(page.getResult());
        pageObj.setPageSize(pageSize);
        pageObj.setTotalCount(Long.valueOf(page.getTotal()));
        return pageObj;
    }

    @Override
    public PageObj wages(AdminTeacherWagesForm form) throws ParseException {
        Integer pageNo = form.getPageNo();
        Integer pageSize = form.getPageSize();
        if (null != form.getDate1()) {
            form.setDate2(DateUtils.getMonthEndDay((Date)form.getDate1()));
        }
        if (pageNo == null || pageNo < 1) {
            pageNo = 1;
            form.setPageNo(pageNo);
        }
        if (pageSize == null || pageSize < 0) {
            pageSize = 20;
            form.setPageSize(pageSize);
        }
        Page page = PageHelper.startPage((int)pageNo, (int)pageSize);
        this.tTeacherDao.teacherWageList2(form);
        PageObj pageObj = new PageObj();
        pageObj.setCurrPageNumber(pageNo);
        pageObj.setFirstPageNumber(Integer.valueOf(1));
        pageObj.setLastPageNumber(pageObj.processTotalPage(page.getTotal(), Integer.valueOf(page.getPageSize())));
        pageObj.setPreviousPageNumber(pageObj.processPreviousPage(pageNo));
        pageObj.setNextPageNumber(pageObj.processNextPage());
        pageObj.setPageElements(page.getResult());
        pageObj.setPageSize(pageSize);
        pageObj.setTotalCount(Long.valueOf(page.getTotal()));
        return pageObj;
    }

    @Override
    public PageObj teachingRecordList(AdminTeachingRecordsForm form) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        Integer pageNo = form.getPageNo();
        Integer pageSize = form.getPageSize();
        if (StringUtils.isNotBlank((String)form.getDoExport())) {
            pageSize = Integer.MAX_VALUE;
        }
        if (form.getEndDate() != null) {
            form.setEndDate(new Date(form.getEndDate().getTime() + 82800000L + 3540000L + 59000L));
        }
        if (form.getStartDate() == null) {
            String date = DateUtils.formatDateToyyyyMM((Date)new Date());
            form.setDate(date);
            try {
                Calendar c = Calendar.getInstance();
                c.set(2, Integer.valueOf(date.split("-")[1]) - 1);
                c.set(1, Integer.valueOf(date.split("-")[0]));
                String maxDay = c.getActualMaximum(5) + "";
                Date start = sdf.parse(date + "-01");
                Date end = sdf.parse(date + "-" + maxDay);
                end = NoServiceUtil.correctDate((Date)end);
                form.setStartDate(start);
                form.setEndDate(end);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (pageNo == null || pageNo < 1) {
            pageNo = 1;
        }
        if (pageSize == null || pageSize < 0) {
            pageSize = 20;
        }
        Page page = PageHelper.startPage((int)pageNo, (int)pageSize);
        List result = this.tCourseDao.teachingRecordList(form);
        ArrayList<AdminTeachingRecordListResult> newResult = new ArrayList<AdminTeachingRecordListResult>();
        StringBuffer sb = new StringBuffer();
        List feedbacks = null;
        List comments = null;
        if (result != null && result.size() > 0) {
            sb.append("(");
            for (AdminTeachingRecordListResult res : result) {
                sb.append(res.getSessionid()).append(",");
            }
            sb.append("0)");
            feedbacks = this.tStuFeebackDao.findBySessionids(sb.toString());
            comments = this.tTeacherCommentsDao.findBySessionids(sb.toString());
        }
        HashMap<Integer, ArrayList<TStuFeeback>> feedbacksMap = new HashMap<Integer, ArrayList<TStuFeeback>>();
        HashMap<Integer, TTeacherComments> commentsMap = new HashMap<Integer, TTeacherComments>();
        if (!CollectionUtils.isEmpty(feedbacks)) {
            for (TStuFeeback stuFeeback : feedbacks) {
                ArrayList<TStuFeeback> tStuFeebacks = (ArrayList<TStuFeeback>)feedbacksMap.get(stuFeeback.getSessionid());
                if (tStuFeebacks == null) {
                    tStuFeebacks = new ArrayList<TStuFeeback>();
                    tStuFeebacks.add(stuFeeback);
                } else {
                    tStuFeebacks.add(stuFeeback);
                }
                feedbacksMap.put(stuFeeback.getSessionid(), tStuFeebacks);
            }
        }
        if (!CollectionUtils.isEmpty(comments)) {
            for (TTeacherComments tTeacherComment : comments) {
                TTeacherComments tTeacherComments = (TTeacherComments)commentsMap.get(tTeacherComment.getSessionid());
                if (tTeacherComments != null) continue;
                commentsMap.put(tTeacherComment.getSessionid(), tTeacherComment);
            }
        }
        if (!CollectionUtils.isEmpty((Collection)result)) {
            for (AdminTeachingRecordListResult res : result) {
                List tStuFeebacks;
                TTeacherComments commentss = (TTeacherComments)commentsMap.get(res.getSessionid());
                if (commentss != null) {
                    res.setComments(commentss.getComments());
                }
                if (!CollectionUtils.isEmpty((Collection)(tStuFeebacks = (List)feedbacksMap.get(res.getSessionid())))) {
                    StringBuilder feedbackinfo = new StringBuilder();
                    for (TStuFeeback feedback : tStuFeebacks) {
                        feedbackinfo.append("(" + feedback.getStar() + ")" + feedback.getFeeback()).append("\n");
                    }
                    res.setFeedbacks(feedbackinfo.toString());
                }
                newResult.add(res);
            }
        }
        PageObj pageObj = new PageObj();
        pageObj.setCurrPageNumber(pageNo);
        pageObj.setFirstPageNumber(Integer.valueOf(1));
        pageObj.setLastPageNumber(pageObj.processTotalPage(page.getTotal(), Integer.valueOf(page.getPageSize())));
        pageObj.setPreviousPageNumber(pageObj.processPreviousPage(pageNo));
        pageObj.setNextPageNumber(pageObj.processNextPage());
        pageObj.setPageElements(newResult);
        pageObj.setPageSize(pageSize);
        pageObj.setTotalCount(Long.valueOf(page.getTotal()));
        return pageObj;
    }

    @Override
    public AdminTeachingRecordEditResult teachingRecordEdit(Integer sessionid) {
        return this.tCoursesessionDao.teachingRecordEdit(sessionid);
    }

    @Override
    @Transactional(rollbackFor={Throwable.class}, propagation=Propagation.REQUIRED)
    public ReturnMessageResult teachingRecordEditSave(AdminTeachingRecordEditSaveForm form) throws ParseException {
        ReturnMessageResult messageResult = new ReturnMessageResult();
        Integer sessionid = form.getSessionid();
        Integer status = form.getStatus();
        Boolean checkValue = this.tCoursesessionService.checkCoursesessionStatus(sessionid, null);
        if (!checkValue.booleanValue()) {
            messageResult.setFlag(Integer.valueOf(1));
            messageResult.setMessage("\u8bfe\u7a0b\u72b6\u6001\u4fee\u6539\u8fc7\u4e86");
            return messageResult;
        }
        TCoursesession tCoursesession = this.tCoursesessionDao.findOne(sessionid);
        TCourse tCourse = this.tCourseDao.findOne(tCoursesession.getCid());
        if (form.getStatus().equals(TalkillaConstant.COURSE_STATUS_UMCONFIRMED) && tCoursesession.getStarttime().getTime() > System.currentTimeMillis()) {
            messageResult.setFlag(Integer.valueOf(1));
            messageResult.setMessage("\u4e0d\u53ef\u4ee5\u8bbe\u7f6e\u672a\u6765\u7684\u8bfe\u7a0b\u4e3a\u5c1a\u672a\u786e\u8ba4");
            return messageResult;
        }
        tCoursesession.setStatus(form.getStatus());
        tCoursesession.setNote(form.getNote());
        tCoursesession.setUpdateTime(new Date());
        this.tCoursesessionDao.updateByIdSelective(tCoursesession);
        TStudent tStudent = this.tStudentDao.findOne(tCourse.getStuId());
        TLogin studentLogin = this.tLoginDao.findOne(tStudent.getLoginId());
        TTeacher tTeacher = this.tTeacherDao.findOne(tCoursesession.getTeacherId());
        TLogin teacherLogin = this.tLoginDao.findOne(tTeacher.getLoginId());
        TStudentConsultant studentConsultant = this.tStudentConsultantDao.findByStudentId(tCourse.getStuId());
        TWechat tWechat = this.tWechatDao.getTWechatInfoByLoginId(tStudent.getLoginId());
        String message = "";
        if (TalkillaConstant.COURSE_STATUS_LEAVE_TEACHER.equals(status)) {
            TSendEmailRecord tSendEmailRecord;
            message = "\u8001\u5e08\u8bf7\u5047\uff0c\u4fdd\u5b58\u6210\u529f,\u8bfe\u7a0b\u987a\u5ef6";
            TCoursesession newCoursesession = new TCoursesession();
            List<LeaveCourseResult> leaveCourseResults = this.tCoursesessionService.leaveCoursePlan(tCoursesession.getCid(), 1);
            List addBeforeStudentIdList = this.tCourseStudentDao.findStudentIdListByCid(tCourse.getCid());
            if (CollectionUtils.isEmpty((Collection)addBeforeStudentIdList)) {
                messageResult.setFlag(Integer.valueOf(1));
                messageResult.setMessage("\u8bfe\u7a0b\u6ca1\u6709\u5173\u8054\u7684\u5b66\u751f");
                return messageResult;
            }
            if (leaveCourseResults != null && leaveCourseResults.size() > 0) {
                LeaveCourseResult leaveCourseResult = leaveCourseResults.get(0);
                BeanUtils.copyProperties((Object)tCoursesession, (Object)newCoursesession, (String[])new String[]{"updateTime"});
                newCoursesession.setTeacherId(tCoursesession.getTeacherId());
                newCoursesession.setCreateTime(null);
                newCoursesession.setDuration(Integer.valueOf(leaveCourseResult.getTimeLength()));
                newCoursesession.setSessionid(null);
                newCoursesession.setStatus(null);
                newCoursesession.setStarttime(DateUtils.parseDateToSecond((String)leaveCourseResult.getStartTime()));
                newCoursesession.setIsSystem(Integer.valueOf(1));
                newCoursesession.setStuId(tCoursesession.getStuId());
                if (tCourse.getType() == 100001) {
                    newCoursesession.setRate(new BigDecimal(tTeacher.getOneOnOne()));
                } else {
                    newCoursesession.setRate(new BigDecimal(tTeacher.getOneOnMultiple()));
                }
                this.tCoursesessionDao.insertSelective(newCoursesession);
                ArrayList<TCourseSessionStudent> tCourseSessionStudentList = new ArrayList<TCourseSessionStudent>();
                for (Integer stuId : addBeforeStudentIdList) {
                    TCourseSessionStudent tCourseSessionStudent = new TCourseSessionStudent();
                    tCourseSessionStudent.setCourseSessionId(newCoursesession.getSessionid());
                    tCourseSessionStudent.setStudentId(stuId);
                    tCourseSessionStudent.setCreater(String.valueOf(form.getLoginId()));
                    tCourseSessionStudentList.add(tCourseSessionStudent);
                }
                this.tCourseSessionStudentDao.batchInsert(tCourseSessionStudentList);
            }
            for (Integer stuId : addBeforeStudentIdList) {
                tStudent = this.tStudentDao.findOne(stuId);
                studentLogin = this.tLoginDao.findOne(tStudent.getLoginId());
                studentConsultant = this.tStudentConsultantDao.findByStudentId(stuId);
                tWechat = this.tWechatDao.getTWechatInfoByLoginId(tStudent.getLoginId());
                ArrayList<String> addressList = new ArrayList<String>();
                addressList.add(SystemConfig.Admin.ADMIN_EMAIL);
                if (studentConsultant != null && !"admin".equals(studentConsultant.getConsultantEmail())) {
                    addressList.add(studentConsultant.getConsultantEmail());
                }
                TalkillaEmailMessageUtils.sendStudentByTeacherLeaveClass(studentLogin.getLoginName(), addressList, tStudent, tTeacher, studentConsultant, DateUtils.formatDateToDay((Date)tCoursesession.getStarttime()), DateUtils.getHHmmString((Date)tCoursesession.getStarttime(), (Integer)tCoursesession.getDuration()), DateUtils.getChineseWeekNumberOfDate((Date)tCoursesession.getStarttime()));
                tSendEmailRecord = new TSendEmailRecord();
                tSendEmailRecord.setUserType(TalkillaConstant.SendEmailUserType.STUDENT);
                tSendEmailRecord.setEmail(studentLogin.getLoginName());
                tSendEmailRecord.setEmailType(TalkillaConstant.SendEmailType.SEND_STUDENT_BY_TEACHER_LEAVE_CLASS);
                tSendEmailRecord.setRecordType(TalkillaConstant.SendEmailType.SEND_STUDENT_BY_TEACHER_LEAVE_CLASS);
                tSendEmailRecord.setCid(tCourse.getCid());
                tSendEmailRecord.setStuId(tStudent.getStuId());
                tSendEmailRecord.setTeacherId(tCourse.getTeacherId());
                this.tSendEmailRecordDao.insertSelective(tSendEmailRecord);
                this.wechatMessageService.sendStudentByTeacherLeaveClass(tStudent, tWechat, tTeacher, studentConsultant, DateUtils.formatDate((Date)tCoursesession.getStarttime(), (String)"yyyy\u5e74MM\u6708dd\u65e5"), DateUtils.getChineseWeekNumberOfDate((Date)tCoursesession.getStarttime()), tCoursesession.getSessionid(), null);
            }
            String timezone = tTeacher.getTimezone();
            TCustTimezone tCustTimezone = this.tCustTimezoneDao.findByTimezone(timezone);
            Date starttime = tCustTimezone != null ? TimeZoneUtil.findTimeByCustomerDate(tCoursesession.getStarttime(), tCustTimezone) : TimeZoneUtil.Date2TimezoneDefault(tCoursesession.getStarttime(), timezone);
            TalkillaEmailMessageUtils.sendTeacherByLeaveClassEmail(teacherLogin.getLoginName(), tTeacher, tCourse.getStuEnName(), DateUtils.formatDateToDay((Date)starttime), DateUtils.getHHmmString((Date)starttime, (Integer)tCoursesession.getDuration()), DateUtils.getEnglishWeekNumberOfDate((Date)starttime));
            tSendEmailRecord = new TSendEmailRecord();
            tSendEmailRecord.setUserType(TalkillaConstant.SendEmailUserType.TEACHER);
            tSendEmailRecord.setEmail(teacherLogin.getLoginName());
            tSendEmailRecord.setEmailType(TalkillaConstant.SendEmailType.SEND_TEACHER_BY_LEAVE_CLASS_EMAIL);
            tSendEmailRecord.setRecordType(TalkillaConstant.SendEmailType.SEND_TEACHER_BY_LEAVE_CLASS_EMAIL);
            tSendEmailRecord.setCid(tCourse.getCid());
            tSendEmailRecord.setStuId(tCourse.getStuId());
            tSendEmailRecord.setTeacherId(tCourse.getTeacherId());
            this.tSendEmailRecordDao.insertSelective(tSendEmailRecord);
        } else if (TalkillaConstant.COURSE_STATUS_LEAVE_STUDENT.equals(status)) {
            TSendEmailRecord tSendEmailRecord;
            message = "\u5b66\u751f\u8bf7\u5047\uff0c\u8bfe\u7a0b\u987a\u5ef6";
            TCoursesession newCoursesession = new TCoursesession();
            List addBeforeStudentIdList = this.tCourseStudentDao.findStudentIdListByCid(tCourse.getCid());
            if (CollectionUtils.isEmpty((Collection)addBeforeStudentIdList)) {
                messageResult.setFlag(Integer.valueOf(1));
                messageResult.setMessage("\u8bfe\u7a0b\u6ca1\u6709\u5173\u8054\u7684\u5b66\u751f");
                return messageResult;
            }
            List<LeaveCourseResult> leaveCourseResults = this.tCoursesessionService.leaveCoursePlan(tCoursesession.getCid(), 1);
            if (leaveCourseResults != null && leaveCourseResults.size() > 0) {
                LeaveCourseResult leaveCourseResult = leaveCourseResults.get(0);
                BeanUtils.copyProperties((Object)tCoursesession, (Object)newCoursesession, (String[])new String[]{"updateTime"});
                newCoursesession.setTeacherId(tCoursesession.getTeacherId());
                newCoursesession.setCreateTime(null);
                newCoursesession.setDuration(Integer.valueOf(leaveCourseResult.getTimeLength()));
                newCoursesession.setSessionid(null);
                newCoursesession.setStatus(null);
                newCoursesession.setStarttime(DateUtils.parseDateToSecond((String)leaveCourseResult.getStartTime()));
                newCoursesession.setIsSystem(Integer.valueOf(1));
                newCoursesession.setStuId(tCoursesession.getStuId());
                if (tCourse.getType() == 100001) {
                    newCoursesession.setRate(new BigDecimal(tTeacher.getOneOnOne()));
                } else {
                    newCoursesession.setRate(new BigDecimal(tTeacher.getOneOnMultiple()));
                }
                this.tCoursesessionDao.insertSelective(newCoursesession);
                ArrayList<TCourseSessionStudent> tCourseSessionStudentList = new ArrayList<TCourseSessionStudent>();
                for (Integer stuId : addBeforeStudentIdList) {
                    TCourseSessionStudent tCourseSessionStudent = new TCourseSessionStudent();
                    tCourseSessionStudent.setCourseSessionId(newCoursesession.getSessionid());
                    tCourseSessionStudent.setStudentId(stuId);
                    tCourseSessionStudent.setCreater(String.valueOf(form.getLoginId()));
                    tCourseSessionStudentList.add(tCourseSessionStudent);
                }
                this.tCourseSessionStudentDao.batchInsert(tCourseSessionStudentList);
            }
            Calendar ca = Calendar.getInstance();
            ca.setTime(tCoursesession.getStarttime());
            String[] weeks = new String[]{"", "\u661f\u671f\u65e5", "\u661f\u671f\u4e00", "\u661f\u671f\u4e8c", "\u661f\u671f\u4e09", "\u661f\u671f\u56db", "\u661f\u671f\u4e94", "\u661f\u671f\u516d"};
            for (Integer stuId : addBeforeStudentIdList) {
                tStudent = this.tStudentDao.findOne(stuId);
                studentLogin = this.tLoginDao.findOne(tStudent.getLoginId());
                studentConsultant = this.tStudentConsultantDao.findByStudentId(stuId);
                tWechat = this.tWechatDao.getTWechatInfoByLoginId(tStudent.getLoginId());
                ArrayList<String> addressList = new ArrayList<String>();
                addressList.add(SystemConfig.Admin.ADMIN_EMAIL);
                if (studentConsultant != null && !"admin".equals(studentConsultant.getConsultantEmail())) {
                    addressList.add(studentConsultant.getConsultantEmail());
                }
                TalkillaEmailMessageUtils.sendStudentByStudentLeaveClass(studentLogin.getLoginName(), null, tStudent, tTeacher, studentConsultant, DateUtils.formatDateToDay((Date)tCoursesession.getStarttime()), DateUtils.getHHmmString((Date)tCoursesession.getStarttime(), (Integer)tCoursesession.getDuration()), DateUtils.getChineseWeekNumberOfDate((Date)tCoursesession.getStarttime()));
                tSendEmailRecord = new TSendEmailRecord();
                tSendEmailRecord.setUserType(TalkillaConstant.SendEmailUserType.STUDENT);
                tSendEmailRecord.setEmail(studentLogin.getLoginName());
                tSendEmailRecord.setEmailType(TalkillaConstant.SendEmailType.SEND_STUDENT_BY_STUDENT_LEAVE_CLASS);
                tSendEmailRecord.setRecordType(TalkillaConstant.SendEmailType.SEND_STUDENT_BY_STUDENT_LEAVE_CLASS);
                tSendEmailRecord.setCid(tCourse.getCid());
                tSendEmailRecord.setStuId(stuId);
                tSendEmailRecord.setTeacherId(tCourse.getTeacherId());
                this.tSendEmailRecordDao.insertSelective(tSendEmailRecord);
                WechatCourseStatusChangeForm wechatCourseStatusChangeForm = new WechatCourseStatusChangeForm();
                wechatCourseStatusChangeForm.setSessionid(tCoursesession.getSessionid());
                wechatCourseStatusChangeForm.setStudentRealName(tStudent.getRealName());
                wechatCourseStatusChangeForm.setTeacherFirstName(tTeacher.getFirstName());
                if (Objects.nonNull(studentConsultant)) {
                    wechatCourseStatusChangeForm.setConsultantName(studentConsultant.getConsultantName());
                    TConsultant consultant = this.tConsultantDao.findOne(studentConsultant.getConsultantId());
                    if (consultant != null) {
                        wechatCourseStatusChangeForm.setOnsultantPhone(consultant.getMobile());
                    }
                }
                wechatCourseStatusChangeForm.setCourseStatusDesc(TalkillaConstant.transferCourseStatus((Integer)status));
                if (Objects.nonNull(tWechat)) {
                    wechatCourseStatusChangeForm.setOpenId(tWechat.getOpenid());
                }
                wechatCourseStatusChangeForm.setStartTime(DateUtils.formatDate((Date)tCoursesession.getStarttime(), (String)"yyyy\u5e74MM\u6708dd\u65e5"));
                wechatCourseStatusChangeForm.setWeek(DateUtils.getChineseWeekNumberOfDate((Date)tCoursesession.getStarttime()));
                wechatCourseStatusChangeForm.setComments(form.getNote());
                wechatCourseStatusChangeForm.setClassName(tCourse.getClassname());
                this.wechatMessageService.sendTaskTemplateMessageForCourseStatusChange(wechatCourseStatusChangeForm);
            }
            String timezone = tTeacher.getTimezone();
            TCustTimezone tCustTimezone = this.tCustTimezoneDao.findByTimezone(timezone);
            Date starttime = tCustTimezone != null ? TimeZoneUtil.findTimeByCustomerDate(tCoursesession.getStarttime(), tCustTimezone) : TimeZoneUtil.Date2TimezoneDefault(tCoursesession.getStarttime(), timezone);
            tStudent.setEnglishName(tCourse.getStuEnName());
            TalkillaEmailMessageUtils.sendTeacherByStudentLeaveClassEmail(teacherLogin.getLoginName(), tTeacher, tStudent, DateUtils.formatDateToDay((Date)starttime), DateUtils.getHHmmString((Date)starttime, (Integer)tCoursesession.getDuration()), DateUtils.getEnglishWeekNumberOfDate((Date)starttime));
            tSendEmailRecord = new TSendEmailRecord();
            tSendEmailRecord.setUserType(TalkillaConstant.SendEmailUserType.TEACHER);
            tSendEmailRecord.setEmail(teacherLogin.getLoginName());
            tSendEmailRecord.setEmailType(TalkillaConstant.SendEmailType.SEND_TEACHER_BY_STUDENT_LEAVE_CLASS_EMAIL);
            tSendEmailRecord.setRecordType(TalkillaConstant.SendEmailType.SEND_TEACHER_BY_STUDENT_LEAVE_CLASS_EMAIL);
            tSendEmailRecord.setCid(tCourse.getCid());
            tSendEmailRecord.setStuId(tCourse.getStuId());
            tSendEmailRecord.setTeacherId(tCourse.getTeacherId());
            this.tSendEmailRecordDao.insertSelective(tSendEmailRecord);
        } else if (TalkillaConstant.COURSE_STATUS_ABSENT_STUDENT.equals(status)) {
            message = "\u4fdd\u5b58\u6210\u529f\uff0c\u5b66\u751f\u65f7\u8bfe";
            this.tCourseService.processCourseCount(tCourse.getCid(), (double)tCoursesession.getDuration().intValue() / 60.0, TalkillaConstant.CourseCountType.STUDENT_ABSENT);
            List addBeforeStudentIdList = this.tCourseStudentDao.findStudentIdListByCid(tCourse.getCid());
            if (CollectionUtils.isEmpty((Collection)addBeforeStudentIdList)) {
                messageResult.setFlag(Integer.valueOf(1));
                messageResult.setMessage("\u8bfe\u7a0b\u6ca1\u6709\u5173\u8054\u7684\u5b66\u751f");
                return messageResult;
            }
            for (Integer stuId : addBeforeStudentIdList) {
                tStudent = this.tStudentDao.findOne(stuId);
                studentLogin = this.tLoginDao.findOne(tStudent.getLoginId());
                studentConsultant = this.tStudentConsultantDao.findByStudentId(stuId);
                tWechat = this.tWechatDao.getTWechatInfoByLoginId(tStudent.getLoginId());
                WechatCourseStatusChangeForm wechatCourseStatusChangeForm = new WechatCourseStatusChangeForm();
                wechatCourseStatusChangeForm.setSessionid(tCoursesession.getSessionid());
                wechatCourseStatusChangeForm.setStudentRealName(tStudent.getRealName());
                wechatCourseStatusChangeForm.setTeacherFirstName(tTeacher.getFirstName());
                if (Objects.nonNull(studentConsultant)) {
                    wechatCourseStatusChangeForm.setConsultantName(studentConsultant.getConsultantName());
                    TConsultant consultant = this.tConsultantDao.findOne(studentConsultant.getConsultantId());
                    wechatCourseStatusChangeForm.setOnsultantPhone(consultant.getMobile());
                }
                wechatCourseStatusChangeForm.setCourseStatusDesc(TalkillaConstant.transferCourseStatus((Integer)status));
                if (Objects.nonNull(tWechat)) {
                    wechatCourseStatusChangeForm.setOpenId(tWechat.getOpenid());
                }
                wechatCourseStatusChangeForm.setStartTime(DateUtils.formatDate((Date)tCoursesession.getStarttime(), (String)"yyyy\u5e74MM\u6708dd\u65e5"));
                wechatCourseStatusChangeForm.setWeek(DateUtils.getChineseWeekNumberOfDate((Date)tCoursesession.getStarttime()));
                wechatCourseStatusChangeForm.setComments(form.getNote());
                wechatCourseStatusChangeForm.setClassName(tCourse.getClassname());
                this.wechatMessageService.sendTaskTemplateMessageForCourseStatusChange(wechatCourseStatusChangeForm);
            }
        } else if (TalkillaConstant.COURSE_STATUS_ABSENT_TEACHER.equals(status)) {
            message = "\u4fdd\u5b58\u6210\u529f\uff0c\u8001\u5e08\u7f3a\u5e2d\uff0c\u8bfe\u7a0b\u987a\u5ef6";
            TCoursesession newCoursesession = new TCoursesession();
            List addBeforeStudentIdList = this.tCourseStudentDao.findStudentIdListByCid(tCourse.getCid());
            if (CollectionUtils.isEmpty((Collection)addBeforeStudentIdList)) {
                messageResult.setFlag(Integer.valueOf(1));
                messageResult.setMessage("\u8bfe\u7a0b\u6ca1\u6709\u5173\u8054\u7684\u5b66\u751f");
                return messageResult;
            }
            String msg = "";
            Double pendHours = 0.0;
            List<LeaveCourseResult> leaveCourseResults = this.tCoursesessionService.leaveCoursePlan(tCoursesession.getCid(), 2);
            if (leaveCourseResults != null && leaveCourseResults.size() > 0) {
                int i = 0;
                for (LeaveCourseResult leaveCourseResult : leaveCourseResults) {
                    ++i;
                    BeanUtils.copyProperties((Object)tCoursesession, (Object)newCoursesession, (String[])new String[]{"updateTime"});
                    newCoursesession.setTeacherId(tCoursesession.getTeacherId());
                    newCoursesession.setCreateTime(null);
                    newCoursesession.setDuration(Integer.valueOf(leaveCourseResult.getTimeLength()));
                    newCoursesession.setSessionid(null);
                    newCoursesession.setStatus(null);
                    newCoursesession.setStarttime(DateUtils.parseDateToSecond((String)leaveCourseResult.getStartTime()));
                    newCoursesession.setIsSystem(Integer.valueOf(1));
                    newCoursesession.setStuId(tCoursesession.getStuId());
                    if (tCourse.getType() == 100001) {
                        newCoursesession.setRate(new BigDecimal(tTeacher.getOneOnOne()));
                    } else {
                        newCoursesession.setRate(new BigDecimal(tTeacher.getOneOnMultiple()));
                    }
                    if (i == 2) {
                        newCoursesession.setIspay(Integer.valueOf(0));
                        newCoursesession.setPrice(BigDecimal.ZERO);
                    }
                    this.tCoursesessionDao.insertSelective(newCoursesession);
                    msg = msg + "," + leaveCourseResult.getStartTime();
                    pendHours = pendHours + new Double(leaveCourseResult.getTimeLength());
                    ArrayList<TCourseSessionStudent> tCourseSessionStudentList = new ArrayList<TCourseSessionStudent>();
                    for (Integer stuId : addBeforeStudentIdList) {
                        TCourseSessionStudent tCourseSessionStudent = new TCourseSessionStudent();
                        tCourseSessionStudent.setCourseSessionId(newCoursesession.getSessionid());
                        tCourseSessionStudent.setStudentId(stuId);
                        tCourseSessionStudent.setCreater(String.valueOf(form.getLoginId()));
                        tCourseSessionStudentList.add(tCourseSessionStudent);
                    }
                    this.tCourseSessionStudentDao.batchInsert(tCourseSessionStudentList);
                }
            }
            this.tCourseService.processCourseCount(tCourse.getCid(), (double)tCoursesession.getDuration().intValue() / 60.0, TalkillaConstant.CourseCountType.TEACHER_ABSENT);
            for (Integer stuId : addBeforeStudentIdList) {
                tStudent = this.tStudentDao.findOne(stuId);
                studentLogin = this.tLoginDao.findOne(tStudent.getLoginId());
                studentConsultant = this.tStudentConsultantDao.findByStudentId(stuId);
                tWechat = this.tWechatDao.getTWechatInfoByLoginId(tStudent.getLoginId());
                WechatCourseStatusChangeForm wechatCourseStatusChangeForm = new WechatCourseStatusChangeForm();
                wechatCourseStatusChangeForm.setSessionid(tCoursesession.getSessionid());
                wechatCourseStatusChangeForm.setStudentRealName(tStudent.getRealName());
                wechatCourseStatusChangeForm.setTeacherFirstName(tTeacher.getFirstName());
                if (Objects.nonNull(studentConsultant)) {
                    wechatCourseStatusChangeForm.setConsultantName(studentConsultant.getConsultantName());
                    TConsultant consultant = this.tConsultantDao.findOne(studentConsultant.getConsultantId());
                    wechatCourseStatusChangeForm.setOnsultantPhone(consultant.getMobile());
                }
                wechatCourseStatusChangeForm.setCourseStatusDesc(TalkillaConstant.transferCourseStatus((Integer)status));
                if (Objects.nonNull(tWechat)) {
                    wechatCourseStatusChangeForm.setOpenId(tWechat.getOpenid());
                }
                wechatCourseStatusChangeForm.setStartTime(DateUtils.formatDate((Date)tCoursesession.getStarttime(), (String)"yyyy\u5e74MM\u6708dd\u65e5"));
                wechatCourseStatusChangeForm.setWeek(DateUtils.getChineseWeekNumberOfDate((Date)tCoursesession.getStarttime()));
                wechatCourseStatusChangeForm.setComments(form.getNote());
                wechatCourseStatusChangeForm.setClassName(tCourse.getClassname());
                this.wechatMessageService.sendTaskTemplateMessageForCourseStatusChange(wechatCourseStatusChangeForm);
            }
        } else if (TalkillaConstant.COURSE_STATUS_COMPLETED.equals(status)) {
            message = "\u4fdd\u5b58\u6210\u529f\uff0c\u8bfe\u7a0b\u6b63\u5e38\u7ed3\u675f";
            this.tCourseService.processCourseCount(tCourse.getCid(), (double)tCoursesession.getDuration().intValue() / 60.0, TalkillaConstant.CourseCountType.NORMAL_COMPLETE);
            List addBeforeStudentIdList = this.tCourseStudentDao.findStudentIdListByCid(tCourse.getCid());
            if (CollectionUtils.isEmpty((Collection)addBeforeStudentIdList)) {
                messageResult.setFlag(Integer.valueOf(1));
                messageResult.setMessage("\u8bfe\u7a0b\u6ca1\u6709\u5173\u8054\u7684\u5b66\u751f");
                return messageResult;
            }
            for (Integer stuId : addBeforeStudentIdList) {
                tStudent = this.tStudentDao.findOne(stuId);
                studentLogin = this.tLoginDao.findOne(tStudent.getLoginId());
                studentConsultant = this.tStudentConsultantDao.findByStudentId(stuId);
                tWechat = this.tWechatDao.getTWechatInfoByLoginId(tStudent.getLoginId());
                WechatCourseStatusChangeForm wechatCourseStatusChangeForm = new WechatCourseStatusChangeForm();
                wechatCourseStatusChangeForm.setSessionid(tCoursesession.getSessionid());
                wechatCourseStatusChangeForm.setStudentRealName(tStudent.getRealName());
                wechatCourseStatusChangeForm.setTeacherFirstName(tTeacher.getFirstName());
                if (Objects.nonNull(studentConsultant)) {
                    wechatCourseStatusChangeForm.setConsultantName(studentConsultant.getConsultantName());
                    TConsultant consultant = this.tConsultantDao.findOne(studentConsultant.getConsultantId());
                    wechatCourseStatusChangeForm.setOnsultantPhone(consultant.getMobile());
                }
                wechatCourseStatusChangeForm.setCourseStatusDesc(TalkillaConstant.transferCourseStatus((Integer)status));
                if (Objects.nonNull(tWechat)) {
                    wechatCourseStatusChangeForm.setOpenId(tWechat.getOpenid());
                }
                wechatCourseStatusChangeForm.setStartTime(DateUtils.formatDate((Date)tCoursesession.getStarttime(), (String)"yyyy\u5e74MM\u6708dd\u65e5"));
                wechatCourseStatusChangeForm.setWeek(DateUtils.getChineseWeekNumberOfDate((Date)tCoursesession.getStarttime()));
                wechatCourseStatusChangeForm.setComments(form.getNote());
                wechatCourseStatusChangeForm.setClassName(tCourse.getClassname());
                this.wechatMessageService.sendTaskTemplateMessageForCourseStatusChange(wechatCourseStatusChangeForm);
            }
        } else if (TalkillaConstant.COURSE_STATUS_SPECIAL_CASES.equals(status)) {
            TSendEmailRecord tSendEmailRecord;
            message = "\u7279\u6b8a\u60c5\u51b5\uff0c\u8bfe\u7a0b\u987a\u5ef6\uff0c\u4fdd\u5b58\u6210\u529f";
            TCoursesession newCoursesession = new TCoursesession();
            List addBeforeStudentIdList = this.tCourseStudentDao.findStudentIdListByCid(tCourse.getCid());
            if (CollectionUtils.isEmpty((Collection)addBeforeStudentIdList)) {
                messageResult.setFlag(Integer.valueOf(1));
                messageResult.setMessage("\u8bfe\u7a0b\u6ca1\u6709\u5173\u8054\u7684\u5b66\u751f");
                return messageResult;
            }
            List<LeaveCourseResult> leaveCourseResults = this.tCoursesessionService.leaveCoursePlan(tCoursesession.getCid(), 1);
            if (leaveCourseResults != null && leaveCourseResults.size() > 0) {
                LeaveCourseResult leaveCourseResult = leaveCourseResults.get(0);
                BeanUtils.copyProperties((Object)tCoursesession, (Object)newCoursesession, (String[])new String[]{"updateTime"});
                newCoursesession.setTeacherId(tCoursesession.getTeacherId());
                newCoursesession.setCreateTime(null);
                newCoursesession.setDuration(Integer.valueOf(leaveCourseResult.getTimeLength()));
                newCoursesession.setSessionid(null);
                newCoursesession.setStatus(null);
                newCoursesession.setStarttime(DateUtils.parseDateToSecond((String)leaveCourseResult.getStartTime()));
                newCoursesession.setIsSystem(Integer.valueOf(1));
                newCoursesession.setStuId(tCoursesession.getStuId());
                if (tCourse.getType() == 100001) {
                    newCoursesession.setRate(new BigDecimal(tTeacher.getOneOnOne()));
                } else {
                    newCoursesession.setRate(new BigDecimal(tTeacher.getOneOnMultiple()));
                }
                this.tCoursesessionDao.insertSelective(newCoursesession);
                ArrayList<TCourseSessionStudent> tCourseSessionStudentList = new ArrayList<TCourseSessionStudent>();
                for (Integer stuId : addBeforeStudentIdList) {
                    TCourseSessionStudent tCourseSessionStudent = new TCourseSessionStudent();
                    tCourseSessionStudent.setCourseSessionId(newCoursesession.getSessionid());
                    tCourseSessionStudent.setStudentId(stuId);
                    tCourseSessionStudent.setCreater(String.valueOf(form.getLoginId()));
                    tCourseSessionStudentList.add(tCourseSessionStudent);
                }
                this.tCourseSessionStudentDao.batchInsert(tCourseSessionStudentList);
            }
            for (Integer stuId : addBeforeStudentIdList) {
                tStudent = this.tStudentDao.findOne(stuId);
                studentLogin = this.tLoginDao.findOne(tStudent.getLoginId());
                studentConsultant = this.tStudentConsultantDao.findByStudentId(stuId);
                tWechat = this.tWechatDao.getTWechatInfoByLoginId(tStudent.getLoginId());
                ArrayList<String> addressList = new ArrayList<String>();
                addressList.add(SystemConfig.Admin.ADMIN_EMAIL);
                if (studentConsultant != null && !"admin".equals(studentConsultant.getConsultantEmail())) {
                    addressList.add(studentConsultant.getConsultantEmail());
                }
                TalkillaEmailMessageUtils.sendStudentByTeacherLeaveClass(studentLogin.getLoginName(), addressList, tStudent, tTeacher, studentConsultant, DateUtils.formatDateToDay((Date)tCoursesession.getStarttime()), DateUtils.getHHmmString((Date)tCoursesession.getStarttime(), (Integer)tCoursesession.getDuration()), DateUtils.getChineseWeekNumberOfDate((Date)tCoursesession.getStarttime()));
                tSendEmailRecord = new TSendEmailRecord();
                tSendEmailRecord.setUserType(TalkillaConstant.SendEmailUserType.STUDENT);
                tSendEmailRecord.setEmail(studentLogin.getLoginName());
                tSendEmailRecord.setEmailType(TalkillaConstant.SendEmailType.SEND_STUDENT_BY_TEACHER_LEAVE_CLASS);
                tSendEmailRecord.setRecordType(TalkillaConstant.SendEmailType.SEND_STUDENT_BY_TEACHER_LEAVE_CLASS);
                tSendEmailRecord.setCid(tCourse.getCid());
                tSendEmailRecord.setStuId(tStudent.getStuId());
                tSendEmailRecord.setTeacherId(tCourse.getTeacherId());
                this.tSendEmailRecordDao.insertSelective(tSendEmailRecord);
                WechatCourseStatusChangeForm wechatCourseStatusChangeForm = new WechatCourseStatusChangeForm();
                wechatCourseStatusChangeForm.setSessionid(tCoursesession.getSessionid());
                wechatCourseStatusChangeForm.setStudentRealName(tStudent.getRealName());
                wechatCourseStatusChangeForm.setTeacherFirstName(tTeacher.getFirstName());
                if (Objects.nonNull(studentConsultant)) {
                    wechatCourseStatusChangeForm.setConsultantName(studentConsultant.getConsultantName());
                    TConsultant consultant = this.tConsultantDao.findOne(studentConsultant.getConsultantId());
                    wechatCourseStatusChangeForm.setOnsultantPhone(consultant.getMobile());
                }
                wechatCourseStatusChangeForm.setCourseStatusDesc(TalkillaConstant.transferCourseStatus((Integer)status));
                if (Objects.nonNull(tWechat)) {
                    wechatCourseStatusChangeForm.setOpenId(tWechat.getOpenid());
                }
                wechatCourseStatusChangeForm.setStartTime(DateUtils.formatDate((Date)tCoursesession.getStarttime(), (String)"yyyy\u5e74MM\u6708dd\u65e5"));
                wechatCourseStatusChangeForm.setWeek(DateUtils.getChineseWeekNumberOfDate((Date)tCoursesession.getStarttime()));
                wechatCourseStatusChangeForm.setComments(form.getNote());
                wechatCourseStatusChangeForm.setClassName(tCourse.getClassname());
                wechatCourseStatusChangeForm.setAddComment("\u4e0d\u8ba1\u8bfe\u65f6\uff0c\u8bfe\u7a0b\u5c06\u987a\u5ef6\u3002");
                this.wechatMessageService.sendTaskTemplateMessageForCourseStatusChange(wechatCourseStatusChangeForm);
            }
            String timezone = tTeacher.getTimezone();
            TCustTimezone tCustTimezone = this.tCustTimezoneDao.findByTimezone(timezone);
            Date starttime = tCustTimezone != null ? TimeZoneUtil.findTimeByCustomerDate(tCoursesession.getStarttime(), tCustTimezone) : TimeZoneUtil.Date2TimezoneDefault(tCoursesession.getStarttime(), timezone);
            TalkillaEmailMessageUtils.sendTeacherByLeaveClassEmail(teacherLogin.getLoginName(), tTeacher, tCourse.getStuEnName(), DateUtils.formatDateToDay((Date)starttime), DateUtils.getHHmmString((Date)starttime, (Integer)tCoursesession.getDuration()), DateUtils.getEnglishWeekNumberOfDate((Date)starttime));
            tSendEmailRecord = new TSendEmailRecord();
            tSendEmailRecord.setUserType(TalkillaConstant.SendEmailUserType.TEACHER);
            tSendEmailRecord.setEmail(teacherLogin.getLoginName());
            tSendEmailRecord.setEmailType(TalkillaConstant.SendEmailType.SEND_TEACHER_BY_LEAVE_CLASS_EMAIL);
            tSendEmailRecord.setRecordType(TalkillaConstant.SendEmailType.SEND_TEACHER_BY_LEAVE_CLASS_EMAIL);
            tSendEmailRecord.setCid(tCourse.getCid());
            tSendEmailRecord.setStuId(tCourse.getStuId());
            tSendEmailRecord.setTeacherId(tCourse.getTeacherId());
            this.tSendEmailRecordDao.insertSelective(tSendEmailRecord);
        }
        messageResult.setMessage(message);
        return messageResult;
    }
}

