/*
 * Decompiled with CFR 0.152.
 */
package com.talkilla.service.impl.admin;

import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.talkilla.constant.SystemConfig;
import com.talkilla.constant.TalkillaConstant;
import com.talkilla.form.admin.AdminOrderEditSaveForm;
import com.talkilla.form.admin.AdminOrderListForm;
import com.talkilla.mysql.domain.TLogin;
import com.talkilla.mysql.domain.TSellCourse;
import com.talkilla.mysql.domain.TSellCourseOrder;
import com.talkilla.mysql.domain.TSendEmailRecord;
import com.talkilla.mysql.domain.TStudent;
import com.talkilla.mysql.domain.TStudentConsultant;
import com.talkilla.mysql.mapper.TLoginDao;
import com.talkilla.mysql.mapper.TSellCourseDao;
import com.talkilla.mysql.mapper.TSellCourseOrderDao;
import com.talkilla.mysql.mapper.TSendEmailRecordDao;
import com.talkilla.mysql.mapper.TStudentConsultantDao;
import com.talkilla.mysql.mapper.TStudentDao;
import com.talkilla.result.ReturnMessageResult;
import com.talkilla.result.admin.AdminOrderEditResult;
import com.talkilla.result.admin.base.PageObj;
import com.talkilla.service.admin.AdminOrderManageService;
import com.talkilla.serviceUtils.TalkillaEmailMessageUtils;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service(value="adminOrderManageService")
public class AdminOrderManageServiceImpl
implements AdminOrderManageService {
    @Autowired
    private TSellCourseOrderDao tSellCourseOrderDao;
    @Autowired
    private TSellCourseDao tSellCourseDao;
    @Autowired
    private TStudentDao tStudentDao;
    @Autowired
    private TLoginDao tLoginDao;
    @Autowired
    private TStudentConsultantDao tStudentConsultantDao;
    @Autowired
    private TSendEmailRecordDao tSendEmailRecordDao;

    @Override
    public PageObj orderList(AdminOrderListForm form) {
        Integer pageNo = form.getPageNo();
        Integer pageSize = form.getPageSize();
        if (pageNo == null || pageNo < 1) {
            pageNo = 1;
            form.setPageNo(pageNo);
        }
        if (pageSize == null || pageSize < 0) {
            pageSize = 20;
            form.setPageSize(pageSize);
        }
        Page page = PageHelper.startPage((int)pageNo, (int)pageSize);
        List results = this.tSellCourseOrderDao.sellCourceOrderList(form);
        PageObj pageObj = new PageObj();
        pageObj.setCurrPageNumber(pageNo);
        pageObj.setFirstPageNumber(Integer.valueOf(1));
        pageObj.setLastPageNumber(pageObj.processTotalPage(page.getTotal(), Integer.valueOf(page.getPageSize())));
        pageObj.setPreviousPageNumber(pageObj.processPreviousPage(pageNo));
        pageObj.setNextPageNumber(pageObj.processNextPage());
        pageObj.setPageElements(page.getResult());
        pageObj.setPageSize(pageSize);
        pageObj.setTotalCount(Long.valueOf(page.getTotal()));
        return pageObj;
    }

    @Override
    public AdminOrderEditResult orderEdit(Integer id) {
        AdminOrderEditResult result = new AdminOrderEditResult();
        TSellCourseOrder sellCourseOrder = this.tSellCourseOrderDao.findOne(id);
        BeanUtils.copyProperties((Object)sellCourseOrder, (Object)result, (String[])new String[]{"updateTime"});
        if (result.getPayType() == 2) {
            result.setPay("\u652f\u4ed8\u5b9d");
        }
        if (result.getPayType() == 1) {
            result.setPay("\u5fae\u4fe1\u652f\u4ed8");
        }
        if (result.getPayType() == 3) {
            result.setPay("\u94f6\u8054\u8f6c\u8d26");
        }
        return result;
    }

    @Override
    @Transactional(rollbackFor={Throwable.class}, propagation=Propagation.REQUIRED)
    public ReturnMessageResult orderEditSave(AdminOrderEditSaveForm form) {
        ReturnMessageResult messageResult = new ReturnMessageResult();
        TSellCourseOrder tSellCourseOrder = this.tSellCourseOrderDao.findOne(form.getId());
        tSellCourseOrder.setStatus(form.getStatus());
        this.tSellCourseOrderDao.updateByIdSelective(tSellCourseOrder);
        if (tSellCourseOrder.getStatus() == 2) {
            TSellCourse tSellCourse = this.tSellCourseDao.findOne(tSellCourseOrder.getSellCourseId());
            TStudent tStudent = this.tStudentDao.findOne(tSellCourseOrder.getStudentId());
            TLogin tLogin = this.tLoginDao.findOne(tStudent.getLoginId());
            TStudentConsultant tStudentConsultant = this.tStudentConsultantDao.findByStudentId(tStudent.getStuId());
            ArrayList<String> addressList = new ArrayList<String>();
            addressList.add(SystemConfig.Admin.ADMIN_EMAIL);
            if (tStudentConsultant != null && !"admin".equals(tStudentConsultant.getConsultantEmail())) {
                addressList.add(tStudentConsultant.getConsultantEmail());
            }
            TalkillaEmailMessageUtils.sendStudentByPaysuccess(tLogin.getLoginName(), addressList, tStudent, tSellCourseOrder, tSellCourse);
            TSendEmailRecord tSendEmailRecord = new TSendEmailRecord();
            tSendEmailRecord.setUserType(TalkillaConstant.SendEmailUserType.STUDENT);
            tSendEmailRecord.setEmail(tLogin.getLoginName());
            tSendEmailRecord.setEmailType(TalkillaConstant.SendEmailType.SEND_STUDENT_BY_PAY_SUCCESS);
            tSendEmailRecord.setRecordType(TalkillaConstant.SendEmailType.SEND_STUDENT_BY_PAY_SUCCESS);
            tSendEmailRecord.setCid(tSellCourse.getId());
            tSendEmailRecord.setStuId(tStudent.getStuId());
            tSendEmailRecord.setTeacherId(Integer.valueOf(0));
            this.tSendEmailRecordDao.insertSelective(tSendEmailRecord);
        }
        messageResult.setFlag(Integer.valueOf(0));
        messageResult.setMessage("\u66f4\u65b0\u6210\u529f");
        return messageResult;
    }

    @Override
    @Transactional(rollbackFor={Throwable.class}, propagation=Propagation.REQUIRED)
    public ReturnMessageResult orderDelete(Integer id) {
        ReturnMessageResult messageResult = new ReturnMessageResult();
        this.tSellCourseOrderDao.deleteById(id);
        messageResult.setFlag(Integer.valueOf(0));
        messageResult.setMessage("\u5220\u9664\u6210\u529f");
        return messageResult;
    }
}

