/*
 * Decompiled with CFR 0.152.
 */
package com.talkilla.service.impl.admin;

import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.talkilla.constant.SystemConfig;
import com.talkilla.constant.TalkillaConstant;
import com.talkilla.constant.enums.CalculatePriceTypeEnums;
import com.talkilla.event.common.CommonEvent;
import com.talkilla.form.admin.AdminCoursePackageAddSaveForm;
import com.talkilla.form.admin.AdminCoursePackageAddStudentSaveForm;
import com.talkilla.form.admin.AdminCoursePackageDeleteStudentSaveForm;
import com.talkilla.form.admin.AdminCoursePackageQueryForm;
import com.talkilla.form.admin.AdminCoursePackageSettingSaveForm;
import com.talkilla.form.admin.AdminSellCourseEditSaveForm;
import com.talkilla.form.admin.AdminSellCourseListForm;
import com.talkilla.form.admin.CoursePackageAwardConfirmForm;
import com.talkilla.form.admin.CoursePackageAwardSaveForm;
import com.talkilla.local.CourseCommonService;
import com.talkilla.mysql.domain.TAwardCourse;
import com.talkilla.mysql.domain.TCourse;
import com.talkilla.mysql.domain.TCourseRule;
import com.talkilla.mysql.domain.TCourseSessionStudent;
import com.talkilla.mysql.domain.TCourseStudent;
import com.talkilla.mysql.domain.TCoursesession;
import com.talkilla.mysql.domain.TLogin;
import com.talkilla.mysql.domain.TSellCourse;
import com.talkilla.mysql.domain.TSellCourseImg;
import com.talkilla.mysql.domain.TSellCourseOrder;
import com.talkilla.mysql.domain.TSendEmailRecord;
import com.talkilla.mysql.domain.TStudent;
import com.talkilla.mysql.domain.TStudentConsultant;
import com.talkilla.mysql.domain.TTeacher;
import com.talkilla.mysql.domain.TWechat;
import com.talkilla.mysql.mapper.TAwardCourseDao;
import com.talkilla.mysql.mapper.TCourseDao;
import com.talkilla.mysql.mapper.TCourseRuleDao;
import com.talkilla.mysql.mapper.TCourseSessionStudentDao;
import com.talkilla.mysql.mapper.TCourseStudentDao;
import com.talkilla.mysql.mapper.TCoursesessionDao;
import com.talkilla.mysql.mapper.TLoginDao;
import com.talkilla.mysql.mapper.TSellCourseDao;
import com.talkilla.mysql.mapper.TSellCourseImgDao;
import com.talkilla.mysql.mapper.TSellCourseOrderDao;
import com.talkilla.mysql.mapper.TSendEmailRecordDao;
import com.talkilla.mysql.mapper.TStudentConsultantDao;
import com.talkilla.mysql.mapper.TStudentDao;
import com.talkilla.mysql.mapper.TTeacherDao;
import com.talkilla.otherbean.DateBean;
import com.talkilla.result.CoursePackageAwardConfirmResult;
import com.talkilla.result.LeaveCourseResult;
import com.talkilla.result.ReturnMessageResult;
import com.talkilla.result.admin.AdminCoursePackageAddResult;
import com.talkilla.result.admin.AdminCoursePackageDetailResult;
import com.talkilla.result.admin.AdminCoursePackageEditResult;
import com.talkilla.result.admin.AdminCoursePackageRenewResult;
import com.talkilla.result.admin.AdminCoursePackageSettingResult;
import com.talkilla.result.admin.AdminSellCourseListResult;
import com.talkilla.result.admin.CoursePackageAwardResult;
import com.talkilla.result.admin.base.PageObj;
import com.talkilla.service.TAwardCourseService;
import com.talkilla.service.TCourseService;
import com.talkilla.service.TCoursesessionService;
import com.talkilla.service.TStudentService;
import com.talkilla.service.TWechatService;
import com.talkilla.service.admin.AdminCourseService;
import com.talkilla.serviceUtils.TalkillaEmailMessageUtils;
import com.talkilla.utils.DateUtils;
import com.talkilla.utils.MathUtils;
import com.talkilla.wechat.form.WeChatTimeRewardNoticeForm;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;
import org.nestframework.commons.utils.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service(value="adminCourseService")
public class AdminCourseServiceImpl
implements AdminCourseService {
    private static final Logger logger = LoggerFactory.getLogger(AdminCourseServiceImpl.class);
    @Autowired
    private TSellCourseDao tSellCourseDao;
    @Autowired
    private TSellCourseImgDao tSellCourseImgDao;
    @Autowired
    private TCourseDao tCourseDao;
    @Autowired
    private TCoursesessionDao tCoursesessionDao;
    @Autowired
    private TTeacherDao tTeacherDao;
    @Autowired
    private TStudentDao tStudentDao;
    @Autowired
    private TCourseRuleDao tCourseRuleDao;
    @Autowired
    private TSellCourseOrderDao tSellCourseOrderDao;
    @Autowired
    private TLoginDao tLoginDao;
    @Autowired
    private TStudentConsultantDao tStudentConsultantDao;
    @Autowired
    private TAwardCourseService tAwardCourseService;
    @Autowired
    private TStudentService tStudentService;
    @Autowired
    private TWechatService tWechatService;
    @Autowired
    private TAwardCourseDao tAwardCourseDao;
    @Autowired
    private CommonEvent commonEvent;
    @Autowired
    private TCourseStudentDao tCourseStudentDao;
    @Autowired
    private TCourseSessionStudentDao tCourseSessionStudentDao;
    @Autowired
    private TSendEmailRecordDao tSendEmailRecordDao;
    @Autowired
    private CourseCommonService courseCommonService;
    @Autowired
    private TCourseService tCourseService;
    @Autowired
    private TCoursesessionService tCoursesessionService;

    @Override
    public PageObj sellCourseList(AdminSellCourseListForm form) {
        Integer pageNo = form.getPageNo();
        Integer pageSize = form.getPageSize();
        if (pageNo == null || pageNo < 1) {
            pageNo = 1;
        }
        if (pageSize == null || pageSize < 0) {
            pageSize = 20;
        }
        Page page = PageHelper.startPage((int)pageNo, (int)pageSize);
        List result = this.tSellCourseDao.sellCourseList(form);
        PageObj pageObj = new PageObj();
        pageObj.setCurrPageNumber(pageNo);
        pageObj.setFirstPageNumber(Integer.valueOf(1));
        pageObj.setLastPageNumber(pageObj.processTotalPage(page.getTotal(), Integer.valueOf(page.getPageSize())));
        pageObj.setPreviousPageNumber(pageObj.processPreviousPage(pageNo));
        pageObj.setNextPageNumber(pageObj.processNextPage());
        pageObj.setPageElements(page.getResult());
        pageObj.setPageSize(pageSize);
        pageObj.setTotalCount(Long.valueOf(page.getTotal()));
        return pageObj;
    }

    @Override
    public AdminSellCourseListResult sellCourseEdit(Integer id) {
        AdminSellCourseListResult result = this.tSellCourseDao.findById(id);
        result.setImgs(this.tSellCourseImgDao.findListBySellCourseId(id));
        return result;
    }

    @Override
    @Transactional(rollbackFor={Throwable.class}, propagation=Propagation.REQUIRED)
    public ReturnMessageResult sellCourseEditSave(AdminSellCourseEditSaveForm form) {
        String[] imgs;
        ReturnMessageResult messageResult = new ReturnMessageResult();
        if (StringUtils.isBlank((String)form.getAlipay()) || StringUtils.isBlank((String)form.getApply()) || StringUtils.isBlank((String)form.geteName()) || StringUtils.isBlank((String)form.getImg()) || StringUtils.isBlank((String)form.getName()) || StringUtils.isBlank((String)form.getType()) || StringUtils.isBlank((String)form.getUnionpay()) || StringUtils.isBlank((String)form.getWechatpay()) || StringUtils.isBlank((String)form.getDes()) || 0 == form.getPrice() || 0 == form.getHour()) {
            messageResult.setFlag(Integer.valueOf(1));
            messageResult.setMessage("\u8bf7\u586b\u5199\u5b8c\u6574\u53c2\u6570");
            return messageResult;
        }
        TSellCourse tSellCourse = this.tSellCourseDao.findOne(form.getId());
        BeanUtils.copyProperties((Object)form, (Object)tSellCourse);
        this.tSellCourseDao.updateByIdSelective(tSellCourse);
        List imgList = this.tSellCourseImgDao.findListBySellCourseId(form.getId());
        for (TSellCourseImg tSellCourseImg : imgList) {
            this.tSellCourseImgDao.deleteById(tSellCourseImg.getId());
        }
        for (String img : imgs = form.getImgs()) {
            TSellCourseImg tSellCourseImg = new TSellCourseImg();
            tSellCourseImg.setSellCourseId(form.getId());
            tSellCourseImg.setImg(img);
            this.tSellCourseImgDao.insertSelective(tSellCourseImg);
        }
        messageResult.setFlag(Integer.valueOf(0));
        messageResult.setMessage("\u66f4\u65b0\u6210\u529f");
        return messageResult;
    }

    @Override
    @Transactional(rollbackFor={Throwable.class}, propagation=Propagation.REQUIRED)
    public ReturnMessageResult sellCourseAddSave(AdminSellCourseEditSaveForm form) {
        String[] imgs;
        ReturnMessageResult messageResult = new ReturnMessageResult();
        if (StringUtils.isBlank((String)form.getAlipay()) || StringUtils.isBlank((String)form.getApply()) || StringUtils.isBlank((String)form.geteName()) || StringUtils.isBlank((String)form.getImg()) || StringUtils.isBlank((String)form.getName()) || StringUtils.isBlank((String)form.getType()) || StringUtils.isBlank((String)form.getUnionpay()) || StringUtils.isBlank((String)form.getWechatpay()) || StringUtils.isBlank((String)form.getDes()) || 0 == form.getPrice() || 0 == form.getHour()) {
            messageResult.setFlag(Integer.valueOf(1));
            messageResult.setMessage("\u8bf7\u586b\u5199\u5b8c\u6574\u53c2\u6570");
            return messageResult;
        }
        TSellCourse tSellCourse = new TSellCourse();
        BeanUtils.copyProperties((Object)form, (Object)tSellCourse);
        this.tSellCourseDao.insertSelective(tSellCourse);
        for (String img : imgs = form.getImgs()) {
            TSellCourseImg tSellCourseImg = new TSellCourseImg();
            tSellCourseImg.setSellCourseId(tSellCourse.getId());
            tSellCourseImg.setImg(img);
            this.tSellCourseImgDao.insertSelective(tSellCourseImg);
        }
        messageResult.setFlag(Integer.valueOf(0));
        messageResult.setMessage("\u6dfb\u52a0\u6210\u529f");
        return messageResult;
    }

    @Override
    public PageObj findCoursePackageQuerys(AdminCoursePackageQueryForm form) {
        Integer pageNo = form.getPageNo();
        Integer pageSize = form.getPageSize();
        if (pageNo == null || pageNo < 1) {
            pageNo = 1;
        }
        if (pageSize == null || pageSize < 0) {
            pageSize = 20;
        }
        Page page = PageHelper.startPage((int)pageNo, (int)pageSize);
        List result = this.tCourseDao.findCoursePackageQuerys(form);
        PageObj pageObj = new PageObj();
        pageObj.setCurrPageNumber(pageNo);
        pageObj.setFirstPageNumber(Integer.valueOf(1));
        pageObj.setLastPageNumber(pageObj.processTotalPage(page.getTotal(), Integer.valueOf(page.getPageSize())));
        pageObj.setPreviousPageNumber(pageObj.processPreviousPage(pageNo));
        pageObj.setNextPageNumber(pageObj.processNextPage());
        pageObj.setPageElements(page.getResult());
        pageObj.setPageSize(pageSize);
        pageObj.setTotalCount(Long.valueOf(page.getTotal()));
        return pageObj;
    }

    @Override
    @Transactional(rollbackFor={Throwable.class}, propagation=Propagation.REQUIRED)
    public ReturnMessageResult coursePackageDelete(Integer cid) {
        ReturnMessageResult messageResult = new ReturnMessageResult();
        this.tCourseRuleDao.deleteTCourseRuleByCid(cid);
        this.tCoursesessionDao.deleteAllTCoursesessionByCid(cid);
        TCourse course = this.tCourseDao.findOne(cid);
        course.setIsDelete(DateUtils.getNowSeconds());
        this.tCourseDao.updateByIdSelective(course);
        List coursesessions = this.tCoursesessionDao.findListByCidDesc(cid);
        for (TCoursesession coursesession : coursesessions) {
            coursesession.setIsDelete(DateUtils.getNowSeconds());
            coursesession.setUpdateTime(new Date());
            this.tCoursesessionDao.updateByIdSelective(coursesession);
        }
        messageResult.setFlag(Integer.valueOf(0));
        messageResult.setMessage("\u5220\u9664\u6210\u529f");
        return messageResult;
    }

    @Override
    public AdminCoursePackageDetailResult coursePackageDetail(Integer cid) {
        AdminCoursePackageDetailResult result = new AdminCoursePackageDetailResult();
        Double hourStudentLeave = 0.0;
        Double hourTeacherLeave = 0.0;
        Double hourStudentAbsent = 0.0;
        Double hourTeacherAbsent = 0.0;
        TCourse tCourse = this.tCourseDao.findOne(cid);
        List tCoursesessionList = this.tCoursesessionDao.findListByCidDesc(cid);
        TTeacher tTeacher = this.tTeacherDao.findOne(tCourse.getTeacherId());
        List studentList = this.tCourseStudentDao.findStudentListByCid(cid);
        TStudent tStudent = this.tStudentDao.findOne(tCourse.getStuId());
        for (TCoursesession tCoursesession : tCoursesessionList) {
            if (tCoursesession.getStatus() != null && tCoursesession.getStatus() == 101004) {
                hourTeacherAbsent = hourTeacherAbsent + (double)(tCoursesession.getDuration() / 60);
            }
            if (tCoursesession.getStatus() != null && tCoursesession.getStatus() == 101005) {
                hourStudentAbsent = hourStudentAbsent + (double)(tCoursesession.getDuration() / 60);
            }
            if (tCoursesession.getStatus() != null && tCoursesession.getStatus() == 101002) {
                hourTeacherLeave = hourTeacherLeave + (double)(tCoursesession.getDuration() / 60);
            }
            if (tCoursesession.getStatus() == null || tCoursesession.getStatus() != 101003) continue;
            hourStudentLeave = hourStudentLeave + (double)(tCoursesession.getDuration() / 60);
        }
        result.setClassname(tCourse.getClassname());
        result.setTeacherId(tTeacher.getTeacherId());
        result.setFirstName(tTeacher.getFirstName());
        result.setLastName(tTeacher.getLastName());
        result.setStuId(tStudent.getStuId());
        result.setStuNames(tStudent.getRealName() + "(" + tStudent.getEnglishName() + ")");
        result.setPhone(tStudent.getPhone());
        result.setHourawarded(tCourse.getHourawarded());
        result.setHourpending(tCourse.getHourpending());
        result.setHourpurchase(tCourse.getHourpurchase());
        result.setHourcomplete(tCourse.getHourcomplete());
        result.setHourStudentAbsent(hourStudentAbsent);
        result.setHourStudentLeave(hourStudentLeave);
        result.setHourTeacherAbsent(hourTeacherAbsent);
        result.setHourTeacherLeave(hourTeacherLeave);
        result.setItems(tCoursesessionList);
        if (tCourse.getSellCourseOrderId() != null && tCourse.getSellCourseOrderId() != 0) {
            TSellCourseOrder tSellCourseOrder = this.tSellCourseOrderDao.findOne(tCourse.getSellCourseOrderId());
            TSellCourse tSellCourse = this.tSellCourseDao.findOne(tSellCourseOrder.getSellCourseId());
            result.setImg(tSellCourse.getImg());
        }
        result.setStudentList(studentList);
        return result;
    }

    @Override
    @Transactional(rollbackFor={Throwable.class}, propagation=Propagation.REQUIRED)
    public ReturnMessageResult coursePackageTimeClear(Integer cid) {
        Double delhour = 0.0;
        List noCompleteListByCid = this.tCoursesessionDao.findNoCompleteListByCid(cid);
        TCourse tCourse = this.tCourseDao.findOne(cid);
        for (TCoursesession tCoursesession : noCompleteListByCid) {
            if (tCoursesession == null || tCoursesession.getStarttime().getTime() <= System.currentTimeMillis()) continue;
            tCoursesession.setIsDelete(DateUtils.getNowSeconds());
            tCoursesession.setUpdateTime(new Date());
            this.tCoursesessionDao.updateByIdSelective(tCoursesession);
            delhour = delhour + (double)(tCoursesession.getDuration() / 15) * 0.25;
        }
        if (delhour != 0.0) {
            tCourse.setUnassigned(Double.valueOf(tCourse.getUnassigned() + delhour));
            this.tCourseDao.updateByIdSelective(tCourse);
        }
        return ReturnMessageResult.success((String)"\u6e05\u7a7a\u8bfe\u65f6\u6210\u529f");
    }

    @Override
    @Transactional(rollbackFor={Throwable.class}, propagation=Propagation.REQUIRED)
    public synchronized AdminCoursePackageAddResult coursePackageAdd(Integer id) {
        AdminCoursePackageAddResult result = new AdminCoursePackageAddResult();
        List hours = DateUtils.hours;
        List minuts = DateUtils.minuts;
        List teacherList = this.tTeacherDao.findAllTeacherList();
        SimpleDateFormat sdf = new SimpleDateFormat("yyMMddHHmm");
        result.setHours(hours);
        result.setMinuts(minuts);
        result.setTeacherList(teacherList);
        result.setClassid(sdf.format(new Date()));
        if (id != null && id != 0) {
            TSellCourseOrder sellCourseOrder = this.tSellCourseOrderDao.findOne(id);
            TSellCourse sellCourse = this.tSellCourseDao.findOne(sellCourseOrder.getSellCourseId());
            result.setSellCourseOrder(sellCourseOrder);
            result.setSellCourse(sellCourse);
            TStudent student = this.tStudentDao.findOne(sellCourseOrder.getStudentId());
            result.setStuid(student.getStuId());
            result.setStuname(student.getRealName());
        }
        return result;
    }

    @Override
    public AdminCoursePackageEditResult coursePackageEdit(Integer cid) {
        AdminCoursePackageEditResult result = new AdminCoursePackageEditResult();
        List hours = DateUtils.hours;
        List minuts = DateUtils.minuts;
        List teacherList = this.tTeacherDao.findAllTeacherList();
        HashMap<String, Integer> querymap = new HashMap<String, Integer>();
        querymap.put("cid", cid);
        List courseStudentList = this.tStudentDao.findCourseStudentList(querymap);
        TCourse course = this.tCourseDao.findOne(cid);
        TStudent student = this.tStudentDao.findOne(course.getStuId());
        result.setStudent(student);
        result.setStudentDtos(courseStudentList);
        SimpleDateFormat sdf = new SimpleDateFormat("yyMMddHHmm");
        result.setHours(hours);
        result.setMinuts(minuts);
        result.setTeacherList(teacherList);
        result.setClassid(sdf.format(new Date()));
        TCourse one = this.tCourseDao.findOne(cid);
        one.setPackageprice(one.getPackageprice());
        result.setCourse(one);
        return result;
    }

    @Override
    public AdminCoursePackageRenewResult coursePackageRenew(Integer cid) {
        AdminCoursePackageRenewResult result = new AdminCoursePackageRenewResult();
        List hours = DateUtils.hours;
        List minuts = DateUtils.minuts;
        List teacherList = this.tTeacherDao.findAllTeacherList();
        HashMap<String, Integer> querymap = new HashMap<String, Integer>();
        querymap.put("cid", cid);
        List courseStudentList = this.tStudentDao.findCourseStudentList(querymap);
        TCourse course = this.tCourseDao.findOne(cid);
        TStudent student = this.tStudentDao.findOne(course.getStuId());
        result.setStudent(student);
        result.setStudentDtos(courseStudentList);
        SimpleDateFormat sdf = new SimpleDateFormat("yyMMddHHmm");
        result.setHours(hours);
        result.setMinuts(minuts);
        result.setTeacherList(teacherList);
        result.setClassid(sdf.format(new Date()));
        TCourse one = this.tCourseDao.findOne(cid);
        one.setPackageprice(one.getPackageprice());
        one.setUnassigned(course.getHourpurchase());
        result.setCourse(one);
        ArrayList<AdminCoursePackageRenewResult.ClassRule> classRulesList = new ArrayList<AdminCoursePackageRenewResult.ClassRule>();
        for (int i = 0; i < 7; ++i) {
            classRulesList.add(new AdminCoursePackageRenewResult.ClassRule());
        }
        List tCoursesessionList = this.tCoursesessionDao.findListByCidForBuy(cid);
        if (!CollectionUtils.isEmpty((Collection)tCoursesessionList)) {
            result.setDuration(((TCoursesession)tCoursesessionList.get(0)).getDuration());
            for (TCoursesession tCoursesession : tCoursesessionList) {
                Date starttime = tCoursesession.getStarttime();
                Integer weekNumberOfDate = DateUtils.getWeekNumberOfDate((Date)starttime);
                AdminCoursePackageRenewResult.ClassRule classRule = (AdminCoursePackageRenewResult.ClassRule)classRulesList.get(weekNumberOfDate);
                if (classRule.getTime_3() == null) {
                    classRule.setTime_1(DateUtils.getHourOfDate((Date)starttime));
                    classRule.setTime_2(DateUtils.getMinuterOfDate((Date)starttime));
                    classRule.setTime_3(Integer.valueOf(1));
                    continue;
                }
                classRule.setTime_3(Integer.valueOf(classRule.getTime_3() + 1));
            }
            result.setClassRule1((AdminCoursePackageRenewResult.ClassRule)classRulesList.get(0));
            result.setClassRule2((AdminCoursePackageRenewResult.ClassRule)classRulesList.get(1));
            result.setClassRule3((AdminCoursePackageRenewResult.ClassRule)classRulesList.get(2));
            result.setClassRule4((AdminCoursePackageRenewResult.ClassRule)classRulesList.get(3));
            result.setClassRule5((AdminCoursePackageRenewResult.ClassRule)classRulesList.get(4));
            result.setClassRule6((AdminCoursePackageRenewResult.ClassRule)classRulesList.get(5));
            result.setClassRule7((AdminCoursePackageRenewResult.ClassRule)classRulesList.get(6));
        }
        double total8 = 0.0;
        for (AdminCoursePackageRenewResult.ClassRule classRule : classRulesList) {
            Integer time_3 = classRule.getTime_3();
            if (time_3 == null) continue;
            total8 += (double)(time_3 * result.getDuration());
        }
        result.setTotal8(total8 / 60.0);
        return result;
    }

    @Override
    @Transactional(rollbackFor={Throwable.class}, propagation=Propagation.REQUIRED)
    public synchronized ReturnMessageResult coursePackageAddSave(AdminCoursePackageAddSaveForm form) {
        TAwardCourse sids;
        TCourse course;
        ReturnMessageResult messageResult = new ReturnMessageResult();
        if (form.getSellCourseOrderId() != null && (course = this.tCourseDao.findCourceListBySellCourseOrderId(form.getSellCourseOrderId())) != null) {
            messageResult.setFlag(Integer.valueOf(1));
            messageResult.setMessage("\u60a8\u5df2\u7ecf\u521b\u5efa\u8fc7\u8bfe\u7a0b\u4e86");
            return messageResult;
        }
        Integer oldCid = form.getOldCid();
        if (oldCid != null) {
            TCourse olderCourse = this.tCourseDao.findOne(oldCid);
            olderCourse.setRenewStatus(Integer.valueOf(1));
            olderCourse.setUpdateTime(new Date());
            this.tCourseDao.updateByIdSelective(olderCourse);
        }
        String stuids = form.getStuids();
        if (StringUtil.isEmpty((String)form.getStuids()) || StringUtil.isEmpty((String)form.getTime1()) || StringUtil.isEmpty((String)form.getTime2()) || StringUtil.isEmpty((String)form.getTime3())) {
            messageResult.setFlag(Integer.valueOf(1));
            messageResult.setMessage("\u53c2\u6570\u9519\u8bef");
            return messageResult;
        }
        if (StringUtil.isNotEmpty((String)form.getNotes())) {
            form.setNotes(form.getNotes().trim());
        }
        if (stuids.endsWith(",")) {
            stuids = stuids.substring(0, stuids.length() - 1);
        }
        if (stuids.startsWith(",")) {
            stuids = stuids.substring(1, stuids.length());
        }
        if (((String[])(sids = stuids.split(","))).length > 1 && !form.getType().equals(100002)) {
            messageResult.setFlag(Integer.valueOf(1));
            messageResult.setMessage("\u975e\u5c0f\u7ec4\u8bfe\u4e0d\u652f\u6301\u591a\u7ec4\u5b66\u751f\u521b\u5efa\u8bfe\u7a0b\u5305");
            return messageResult;
        }
        Integer stuId = Integer.valueOf(sids[0]);
        ArrayList<String> timeList = new ArrayList<String>();
        ArrayList<Integer> durationList = new ArrayList<Integer>();
        Integer duration = null;
        if (!form.getTime1().endsWith("-0-0")) {
            timeList.add(form.getTime1());
            durationList.add(form.getDuration1());
            duration = form.getDuration1();
        } else {
            timeList.add(form.getTime1());
            durationList.add(form.getDuration1());
        }
        if (!form.getTime2().endsWith("-0-0")) {
            timeList.add(form.getTime2());
            durationList.add(form.getDuration2());
            if (duration != null && duration != form.getDuration2()) {
                messageResult.setFlag(Integer.valueOf(1));
                messageResult.setMessage("\u53c2\u6570\u9519\u8bef");
                return messageResult;
            }
            duration = form.getDuration2();
        } else {
            timeList.add(form.getTime2());
            durationList.add(form.getDuration2());
        }
        if (!form.getTime3().endsWith("-0-0")) {
            timeList.add(form.getTime3());
            durationList.add(form.getDuration3());
            if (duration != null && duration != form.getDuration3()) {
                messageResult.setFlag(Integer.valueOf(1));
                messageResult.setMessage("\u53c2\u6570\u9519\u8bef");
                return messageResult;
            }
            duration = form.getDuration3();
        } else {
            timeList.add(form.getTime3());
            durationList.add(form.getDuration3());
        }
        if (!form.getTime4().endsWith("-0-0")) {
            timeList.add(form.getTime4());
            durationList.add(form.getDuration4());
            if (duration != null && duration != form.getDuration4()) {
                messageResult.setFlag(Integer.valueOf(1));
                messageResult.setMessage("\u53c2\u6570\u9519\u8bef");
                return messageResult;
            }
            duration = form.getDuration4();
        } else {
            timeList.add(form.getTime4());
            durationList.add(form.getDuration4());
        }
        if (!form.getTime5().endsWith("-0-0")) {
            timeList.add(form.getTime5());
            durationList.add(form.getDuration5());
            if (duration != null && duration != form.getDuration5()) {
                messageResult.setFlag(Integer.valueOf(1));
                messageResult.setMessage("\u53c2\u6570\u9519\u8bef");
                return messageResult;
            }
            duration = form.getDuration5();
        } else {
            timeList.add(form.getTime5());
            durationList.add(form.getDuration5());
        }
        if (!form.getTime6().endsWith("-0-0")) {
            timeList.add(form.getTime6());
            durationList.add(form.getDuration6());
            if (duration != null && duration != form.getDuration6()) {
                messageResult.setFlag(Integer.valueOf(1));
                messageResult.setMessage("\u53c2\u6570\u9519\u8bef");
                return messageResult;
            }
            duration = form.getDuration6();
        } else {
            timeList.add(form.getTime6());
            durationList.add(form.getDuration6());
        }
        if (!form.getTime7().endsWith("-0-0")) {
            timeList.add(form.getTime7());
            durationList.add(form.getDuration7());
            if (duration != null && duration != form.getDuration7()) {
                messageResult.setFlag(Integer.valueOf(1));
                messageResult.setMessage("\u53c2\u6570\u9519\u8bef");
                return messageResult;
            }
            duration = form.getDuration7();
        } else {
            timeList.add(form.getTime7());
            durationList.add(form.getDuration7());
        }
        Integer awared = MathUtils.getIntegerFromDouble((Double)MathUtils.getCoursesTimes((Double)form.getHourawarded(), (Integer)duration));
        TStudent student = this.tStudentDao.findOne(stuId);
        List courceByStuId = this.tCourseDao.findCourceByStuId(stuId);
        if (form.getType().equals(100001) && student.getRecommendType() == TalkillaConstant.RECOMMEND_TYPE_STUDENT && courceByStuId.size() < 1) {
            this.tAwardCourseService.process(student.getStuId(), 2.0, TalkillaConstant.CourseAward.FIRST_AWARD_RECOMMEND, "\u63a8\u8350\u5b66\u751f\u4f5c\u4e3a\u4ecb\u7ecd\u4eba\u83b7\u5f97\u5956\u52b1", form.getCid());
            try {
                TStudent recommendPerson = this.tStudentService.findOne(student.getRecommendId());
                List cource_stu = this.tCourseDao.findCourceByRecommendId(student.getRecommendId());
                if (cource_stu != null) {
                    WeChatTimeRewardNoticeForm form_ = new WeChatTimeRewardNoticeForm();
                    TWechat tWechat_ = this.tWechatService.getTWechatInfoByLoginId(recommendPerson.getLoginId());
                    TAwardCourse awardCourse_ = this.tAwardCourseDao.findOneByStuId(recommendPerson.getStuId());
                    form_.setStudentRealName(student.getRealName());
                    form_.setStudentRefereeName(recommendPerson.getRealName());
                    form_.setHourAwarded(String.valueOf(2.0));
                    form_.setHourAwardedPool(String.valueOf(awardCourse_.getCourseNum()));
                    form_.setType(1);
                    form_.setCoursePackageId(form.getClassid());
                    form_.setOpenId(tWechat_.getOpenid());
                    form_.setStuId(recommendPerson.getStuId());
                    this.commonEvent.publishTimeRewardNoticeEvent(form_);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        StringBuilder stuNames = new StringBuilder();
        StringBuilder stuEnNames = new StringBuilder();
        String classRoom = form.getClassRoom();
        ArrayList<Integer> stuIdList = new ArrayList<Integer>();
        for (String sid : sids) {
            stuIdList.add(Integer.valueOf(sid));
        }
        List tStudentList = this.tStudentDao.findByStuIdList(stuIdList);
        if (form.getType().equals(100002)) {
            for (TStudent tStudent : tStudentList) {
                stuNames.append(tStudent.getStuId()).append("_").append(tStudent.getRealName()).append("_").append(tStudent.getEnglishName()).append(";");
                stuEnNames.append(tStudent.getEnglishName()).append(";");
            }
        } else {
            for (TStudent tStudent : tStudentList) {
                stuNames.append(tStudent.getRealName()).append(";");
                stuEnNames.append(tStudent.getEnglishName()).append(";");
            }
        }
        String stuName = stuNames.substring(0, stuNames.length() - 1);
        String stuEnName = stuEnNames.substring(0, stuEnNames.length() - 1);
        if (StringUtils.isBlank((String)classRoom)) {
            TTeacher tTeacher = this.tTeacherDao.findOne(form.getTeacherId());
            classRoom = tTeacher.getZhumuId();
        }
        durationList.add(form.getDuration7());
        List<DateBean> sessionTime = this.getSessionTime(timeList, durationList, form.getDate(), form.getHourpurchase() + form.getHourawarded());
        TCourse tCourse = new TCourse();
        tCourse.setStuId(stuId);
        tCourse.setTeacherId(form.getTeacherId());
        tCourse.setClassid(form.getClassid());
        tCourse.setClassname(form.getClassname());
        tCourse.setType(form.getType());
        tCourse.setTrainingmaterials(form.getTrainingmaterials());
        tCourse.setDuration(duration);
        tCourse.setHourpurchase(form.getHourpurchase());
        tCourse.setHourawarded(form.getHourawarded());
        tCourse.setHourcomplete(Double.valueOf(0.0));
        tCourse.setHourpending(Double.valueOf(form.getHourawarded() + form.getHourpurchase()));
        if (tCourse.getHourpending() == 0.0) {
            tCourse.setTeachStatus(Integer.valueOf(2));
        }
        tCourse.setNotes(form.getNotes());
        tCourse.setRate(form.getRate());
        tCourse.setDelayday(form.getDate());
        tCourse.setPackageprice(form.getPackageprice());
        tCourse.setSellCourseOrderId(Integer.valueOf(0));
        tCourse.setTotalhour(Double.valueOf(form.getHourawarded() + form.getHourpurchase()));
        tCourse.setFrequency(Integer.valueOf(0));
        tCourse.setCreater(form.getLoginId() + "");
        tCourse.setCreatedate(new Date());
        tCourse.setStuName(stuName);
        tCourse.setStuEnName(stuEnName);
        tCourse.setClassRoom(classRoom);
        this.tCourseDao.insertSelective(tCourse);
        ArrayList<TCourseStudent> tCourseStudents = new ArrayList<TCourseStudent>();
        for (TAwardCourse sid : sids) {
            Integer studentId = Integer.valueOf((String)sid);
            TCourseStudent tCourseStudent = new TCourseStudent();
            tCourseStudent.setCourseId(tCourse.getCid());
            tCourseStudent.setStudentId(studentId);
            tCourseStudent.setCreater(String.valueOf(form.getLoginId()));
            tCourseStudents.add(tCourseStudent);
        }
        this.tCourseStudentDao.batchInsert(tCourseStudents);
        BigDecimal price = BigDecimal.ZERO;
        int buySize = sessionTime.size() - awared;
        if (buySize > 0) {
            price = MathUtils.div((BigDecimal)BigDecimal.valueOf(form.getPackageprice()), (BigDecimal)BigDecimal.valueOf(buySize), (int)2);
        }
        Integer totalDuration = 0;
        ArrayList<TCourseSessionStudent> tCourseSessionStudents = new ArrayList<TCourseSessionStudent>();
        for (int i = 0; i < sessionTime.size(); ++i) {
            DateBean dateBean = sessionTime.get(i);
            TCoursesession tCoursesession = new TCoursesession();
            tCoursesession.setCid(tCourse.getCid());
            tCoursesession.setStatus(null);
            tCoursesession.setStarttime(dateBean.getDate());
            tCoursesession.setIspay(Integer.valueOf(1));
            tCoursesession.setPrice(price);
            tCoursesession.setNote("");
            tCoursesession.setDuration(dateBean.getDuration());
            tCoursesession.setTeacherId(form.getTeacherId());
            tCoursesession.setRate(form.getRate());
            tCoursesession.setIsSystem(Integer.valueOf(0));
            tCoursesession.setCourseType(form.getType());
            tCoursesession.setStuId(tCourse.getStuId());
            if (awared > 0 && i >= sessionTime.size() - awared) {
                tCoursesession.setIspay(Integer.valueOf(0));
                tCoursesession.setPrice(BigDecimal.ZERO);
            }
            tCoursesession.setStuName(stuName);
            tCoursesession.setStuEnName(stuEnName);
            tCoursesession.setClassRoom(classRoom);
            totalDuration = totalDuration + dateBean.getDuration();
            this.tCoursesessionDao.insertSelective(tCoursesession);
            for (TAwardCourse sid : sids) {
                Integer studentId = Integer.valueOf((String)sid);
                TCourseSessionStudent tCourseSessionStudent = new TCourseSessionStudent();
                tCourseSessionStudent.setCourseSessionId(tCoursesession.getSessionid());
                tCourseSessionStudent.setStudentId(studentId);
                tCourseSessionStudent.setCreater(String.valueOf(form.getLoginId()));
                tCourseSessionStudents.add(tCourseSessionStudent);
            }
        }
        Double hourTotalDuration = MathUtils.add((Double)form.getHourawarded(), (Double)form.getHourpurchase()) * 60.0;
        if (hourTotalDuration.compareTo(totalDuration.doubleValue()) != 0) {
            messageResult.setFlag(Integer.valueOf(1));
            messageResult.setMessage("\u5b89\u6392\u7684\u8bfe\u65f6\u4e0e\u5b9e\u9645\u8bfe\u65f6\u4e0d\u76f8\u7b49\uff0c\u8bf7\u91cd\u65b0\u5b89\u6392");
            return messageResult;
        }
        this.tCourseSessionStudentDao.batchInsert(tCourseSessionStudents);
        if (form.getType().equals(100001) && awared > 0) {
            if (courceByStuId.size() < 1) {
                if (StringUtils.isNotBlank((String)form.getAwarComment())) {
                    this.tAwardCourseService.process(student.getStuId(), form.getHourawarded(), TalkillaConstant.CourseAward.FIRST_AWARD_STUDENT, form.getAwarComment(), form.getCid());
                    this.tAwardCourseService.process(student.getStuId(), form.getHourawarded(), TalkillaConstant.CourseAward.MINUS_FOR_ADMIN, form.getAwarComment(), tCourse.getCid());
                } else {
                    this.tAwardCourseService.process(student.getStuId(), form.getHourawarded(), TalkillaConstant.CourseAward.FIRST_AWARD_STUDENT, "\u65b0\u5b66\u5458\u8bfe\u7a0b\u5956\u52b1", form.getCid());
                    this.tAwardCourseService.process(student.getStuId(), form.getHourawarded(), TalkillaConstant.CourseAward.MINUS_FOR_ADMIN, "\u65b0\u5b66\u5458\u7b2c\u4e00\u6b21\u521b\u5efa\u8bfe\u7a0b\u6838\u9500", tCourse.getCid());
                }
            } else if (StringUtils.isNotBlank((String)form.getAwarComment())) {
                this.tAwardCourseService.process(student.getStuId(), form.getHourawarded(), TalkillaConstant.CourseAward.AWARD_FOR_ADMIN, form.getAwarComment(), form.getCid());
                this.tAwardCourseService.process(student.getStuId(), form.getHourawarded(), TalkillaConstant.CourseAward.MINUS_FOR_ADMIN, form.getAwarComment(), tCourse.getCid());
            } else {
                this.tAwardCourseService.process(student.getStuId(), form.getHourawarded(), TalkillaConstant.CourseAward.AWARD_FOR_ADMIN, "\u7ba1\u7406\u5458\u65b0\u5efa\u8bfe\u7a0b\u5305\u5956\u52b1\u8bfe\u65f6", form.getCid());
                this.tAwardCourseService.process(student.getStuId(), form.getHourawarded(), TalkillaConstant.CourseAward.MINUS_FOR_ADMIN, "\u7ba1\u7406\u5458\u65b0\u5efa\u8bfe\u7a0b\u5305\u6838\u9500\u5956\u52b1\u8bfe\u65f6", tCourse.getCid());
            }
            try {
                WeChatTimeRewardNoticeForm _form = new WeChatTimeRewardNoticeForm();
                TStudent _tStudent = this.tStudentService.findOne(stuId);
                TWechat tWechat = this.tWechatService.getTWechatInfoByLoginId(student.getLoginId());
                TAwardCourse awardCourse = this.tAwardCourseDao.findOneByStuId(stuId);
                _form.setStudentRealName(_tStudent.getRealName());
                _form.setHourAwarded(String.valueOf(form.getHourawarded()));
                _form.setHourAwardedPool(String.valueOf(awardCourse.getCourseNum()));
                _form.setType(2);
                _form.setComment(form.getAwarComment());
                _form.setCoursePackageId(form.getClassid());
                _form.setOpenId(tWechat.getOpenid());
                _form.setCoursePackageName(form.getClassname());
                this.commonEvent.publishTimeRewardNoticeEvent(_form);
            }
            catch (Exception e) {
                logger.error("\u9519\u8bef\u5f02\u5e38", (Object)e.getMessage());
                e.printStackTrace();
            }
        }
        TTeacher tTeacher = this.tTeacherDao.findOne(form.getTeacherId());
        TLogin tLogin = this.tLoginDao.findOne(tTeacher.getLoginId());
        TStudent tStudent = this.tStudentDao.findOne(stuId);
        TStudentConsultant tStudentConsultant = this.tStudentConsultantDao.findByStudentId(stuId);
        ArrayList<String> addressList = new ArrayList<String>();
        addressList.add(SystemConfig.Admin.ADMIN_EMAIL);
        if (tStudentConsultant != null && !"admin".equals(tStudentConsultant.getConsultantEmail())) {
            addressList.add(tStudentConsultant.getConsultantEmail());
        } else {
            tStudentConsultant = new TStudentConsultant();
        }
        TalkillaEmailMessageUtils.sendTeacherByCreateCourseEmail(tLogin.getLoginName(), addressList, tStudent, tTeacher, tCourse.getHourpurchase() + tCourse.getHourawarded(), tStudentConsultant);
        TSendEmailRecord tSendEmailRecord = new TSendEmailRecord();
        tSendEmailRecord.setUserType(TalkillaConstant.SendEmailUserType.TEACHER);
        tSendEmailRecord.setEmail(tLogin.getLoginName());
        tSendEmailRecord.setEmailType(TalkillaConstant.SendEmailType.SEND_TEACHER_BY_CREATE_COURSE_EMAIL);
        tSendEmailRecord.setRecordType(TalkillaConstant.SendEmailType.SEND_TEACHER_BY_CREATE_COURSE_EMAIL);
        tSendEmailRecord.setCid(tCourse.getCid());
        tSendEmailRecord.setStuId(stuId);
        tSendEmailRecord.setTeacherId(form.getTeacherId());
        this.tSendEmailRecordDao.insertSelective(tSendEmailRecord);
        for (String time : timeList) {
            if (time.endsWith("-0")) continue;
            TCourseRule tCourseRule = new TCourseRule();
            tCourseRule.setCid(tCourse.getCid());
            tCourseRule.setWeekday(Integer.valueOf(Integer.valueOf(time.split("-")[0]) + 1));
            String hour = time.split("-")[1].length() == 2 ? time.split("-")[1] : "0" + time.split("-")[1];
            String minutes = time.split("-")[2].length() == 2 ? time.split("-")[2] : "0" + time.split("-")[2];
            String dayTime = hour + ":" + minutes + ":00";
            tCourseRule.setDaytime(dayTime);
            tCourseRule.setCreater(form.getLoginId() + "");
            tCourseRule.setDuration(duration);
            this.tCourseRuleDao.insertSelective(tCourseRule);
        }
        messageResult.setFlag(Integer.valueOf(0));
        messageResult.setMessage("\u4fdd\u5b58\u6210\u529f");
        return messageResult;
    }

    @Override
    @Transactional(rollbackFor={Throwable.class}, propagation=Propagation.REQUIRED)
    public ReturnMessageResult coursePackageEditSave(AdminCoursePackageAddSaveForm form) {
        ReturnMessageResult messageResult = new ReturnMessageResult();
        String stuids = form.getStuids();
        if (form.getCid() == null || form.getCid() == 0 || StringUtil.isEmpty((String)form.getStuids())) {
            messageResult.setFlag(Integer.valueOf(1));
            messageResult.setMessage("\u53c2\u6570\u9519\u8bef");
            return messageResult;
        }
        stuids = stuids.substring(0, stuids.length() - 1);
        String[] sids = stuids.split(",");
        ArrayList<String> timeList = new ArrayList<String>();
        ArrayList<Integer> durationList = new ArrayList<Integer>();
        Integer duration = null;
        if (!form.getTime1().endsWith("-0-0")) {
            timeList.add(form.getTime1());
            durationList.add(form.getDuration1());
            duration = form.getDuration1();
        } else {
            timeList.add(form.getTime1());
            durationList.add(form.getDuration1());
        }
        if (!form.getTime2().endsWith("-0-0")) {
            timeList.add(form.getTime2());
            durationList.add(form.getDuration2());
            if (duration != null && duration != form.getDuration2()) {
                messageResult.setFlag(Integer.valueOf(1));
                messageResult.setMessage("\u53c2\u6570\u9519\u8bef");
                return messageResult;
            }
            duration = form.getDuration2();
        } else {
            timeList.add(form.getTime2());
            durationList.add(form.getDuration2());
        }
        if (!form.getTime3().endsWith("-0-0")) {
            timeList.add(form.getTime3());
            durationList.add(form.getDuration3());
            if (duration != null && duration != form.getDuration3()) {
                messageResult.setFlag(Integer.valueOf(1));
                messageResult.setMessage("\u53c2\u6570\u9519\u8bef");
                return messageResult;
            }
            duration = form.getDuration3();
        } else {
            timeList.add(form.getTime3());
            durationList.add(form.getDuration3());
        }
        if (!form.getTime4().endsWith("-0-0")) {
            timeList.add(form.getTime4());
            durationList.add(form.getDuration4());
            if (duration != null && duration != form.getDuration4()) {
                messageResult.setFlag(Integer.valueOf(1));
                messageResult.setMessage("\u53c2\u6570\u9519\u8bef");
                return messageResult;
            }
            duration = form.getDuration4();
        } else {
            timeList.add(form.getTime4());
            durationList.add(form.getDuration4());
        }
        if (!form.getTime5().endsWith("-0-0")) {
            timeList.add(form.getTime5());
            durationList.add(form.getDuration5());
            if (duration != null && duration != form.getDuration5()) {
                messageResult.setFlag(Integer.valueOf(1));
                messageResult.setMessage("\u53c2\u6570\u9519\u8bef");
                return messageResult;
            }
            duration = form.getDuration5();
        } else {
            timeList.add(form.getTime5());
            durationList.add(form.getDuration5());
        }
        if (!form.getTime6().endsWith("-0-0")) {
            timeList.add(form.getTime6());
            durationList.add(form.getDuration6());
            if (duration != null && duration != form.getDuration6()) {
                messageResult.setFlag(Integer.valueOf(1));
                messageResult.setMessage("\u53c2\u6570\u9519\u8bef");
                return messageResult;
            }
            duration = form.getDuration6();
        } else {
            timeList.add(form.getTime6());
            durationList.add(form.getDuration6());
        }
        if (!form.getTime7().endsWith("-0-0")) {
            timeList.add(form.getTime7());
            durationList.add(form.getDuration7());
            if (duration != null && duration != form.getDuration7()) {
                messageResult.setFlag(Integer.valueOf(1));
                messageResult.setMessage("\u53c2\u6570\u9519\u8bef");
                return messageResult;
            }
            duration = form.getDuration7();
        } else {
            timeList.add(form.getTime7());
            durationList.add(form.getDuration7());
        }
        durationList.add(form.getDuration7());
        List<DateBean> sessionTime = this.getSessionTime(timeList, durationList, form.getDate(), form.getHourpurchase() + form.getHourawarded());
        String classRoom = form.getClassRoom();
        if (StringUtils.isBlank((String)classRoom)) {
            TTeacher tTeacher = this.tTeacherDao.findOne(form.getTeacherId());
            classRoom = tTeacher.getZhumuId();
        }
        TCourse course = this.tCourseDao.findOne(form.getCid());
        BigDecimal validPrice = this.tCoursesessionDao.countPriceForCompleted(form.getCid());
        course.setPackageprice(form.getPackageprice());
        course.setUnassigned(Double.valueOf(0.0));
        course.setUpdateTime(new Date());
        course.setTeacherId(form.getTeacherId());
        course.setClassname(form.getClassname());
        course.setTrainingmaterials(form.getTrainingmaterials());
        course.setNotes(form.getNotes());
        course.setDelayday(form.getDate());
        course.setClassRoom(classRoom);
        course.setRate(form.getRate());
        course.setTeachStatus(Integer.valueOf(0));
        this.tCourseDao.updateByIdSelective(course);
        BigDecimal price = BigDecimal.ZERO;
        int buySize = sessionTime.size();
        if (buySize > 0) {
            price = MathUtils.div((BigDecimal)BigDecimal.valueOf(form.getPackageprice() - validPrice.doubleValue()), (BigDecimal)BigDecimal.valueOf(buySize), (int)2);
        }
        ArrayList<TCourseSessionStudent> tCourseSessionStudents = new ArrayList<TCourseSessionStudent>();
        for (DateBean dateBean : sessionTime) {
            TCoursesession tCoursesession = new TCoursesession();
            tCoursesession.setCid(form.getCid());
            tCoursesession.setStatus(null);
            tCoursesession.setStarttime(dateBean.getDate());
            tCoursesession.setIspay(Integer.valueOf(1));
            tCoursesession.setPrice(price);
            tCoursesession.setNote("");
            tCoursesession.setDuration(dateBean.getDuration());
            tCoursesession.setTeacherId(form.getTeacherId());
            tCoursesession.setRate(form.getRate());
            tCoursesession.setIsSystem(Integer.valueOf(0));
            tCoursesession.setStuId(course.getStuId());
            tCoursesession.setStuName(course.getStuName());
            tCoursesession.setStuEnName(course.getStuEnName());
            tCoursesession.setCourseType(course.getType());
            tCoursesession.setClassRoom(classRoom);
            this.tCoursesessionDao.insertSelective(tCoursesession);
            for (String sid : sids) {
                Integer studentId = Integer.valueOf(sid);
                TCourseSessionStudent tCourseSessionStudent = new TCourseSessionStudent();
                tCourseSessionStudent.setCourseSessionId(tCoursesession.getSessionid());
                tCourseSessionStudent.setStudentId(studentId);
                tCourseSessionStudent.setCreater(String.valueOf(form.getLoginId()));
                tCourseSessionStudents.add(tCourseSessionStudent);
            }
        }
        this.tCourseSessionStudentDao.batchInsert(tCourseSessionStudents);
        List rules = this.tCourseRuleDao.findOneByCid(course.getCid());
        for (TCourseRule rule : rules) {
            rule.setIsDelete(DateUtils.getNowSeconds());
            rule.setUpdateTime(new Date());
            this.tCourseRuleDao.updateByIdSelective(rule);
        }
        for (String time : timeList) {
            if (time.endsWith("-0")) continue;
            TCourseRule tCourseRule = new TCourseRule();
            tCourseRule.setCid(course.getCid());
            tCourseRule.setWeekday(Integer.valueOf(Integer.valueOf(time.split("-")[0]) + 1));
            String hour = time.split("-")[1].length() == 2 ? time.split("-")[1] : "0" + time.split("-")[1];
            String minutes = time.split("-")[2].length() == 2 ? time.split("-")[2] : "0" + time.split("-")[2];
            String dayTime = hour + ":" + minutes + ":00";
            tCourseRule.setDaytime(dayTime);
            tCourseRule.setCreater(form.getLoginId() + "");
            tCourseRule.setDuration(duration);
            this.tCourseRuleDao.insertSelective(tCourseRule);
        }
        messageResult.setFlag(Integer.valueOf(0));
        messageResult.setMessage("\u4fdd\u5b58\u6210\u529f");
        return messageResult;
    }

    @Override
    @Transactional(rollbackFor={Throwable.class}, propagation=Propagation.REQUIRED)
    public ReturnMessageResult coursePackageAddStudentSave(AdminCoursePackageAddStudentSaveForm form) {
        Integer teacherId2;
        Double addPackageprice;
        ReturnMessageResult messageResult = new ReturnMessageResult();
        String stuids = form.getStuids();
        Integer cid = form.getCid();
        Integer teacherId = form.getTeacherId();
        String classRoom = form.getClassRoom();
        if (cid == null || cid == 0 || StringUtil.isEmpty((String)stuids) || Objects.isNull(teacherId) || StringUtils.isBlank((String)classRoom)) {
            messageResult.setFlag(Integer.valueOf(1));
            messageResult.setMessage("\u53c2\u6570\u9519\u8bef");
            return messageResult;
        }
        stuids = stuids.substring(0, stuids.length() - 1);
        String[] sids = stuids.split(",");
        ArrayList<Integer> inStudentIdList = new ArrayList<Integer>();
        for (String sid : sids) {
            inStudentIdList.add(Integer.valueOf(sid));
        }
        List addBeforeStudentIdList = this.tCourseStudentDao.findStudentIdListByCid(cid);
        inStudentIdList.removeAll(addBeforeStudentIdList);
        if (CollectionUtils.isEmpty(inStudentIdList)) {
            messageResult.setFlag(Integer.valueOf(1));
            messageResult.setMessage("\u6ca1\u6709\u53ef\u6dfb\u52a0\u7684\u5b66\u751f");
            return messageResult;
        }
        List noCompleteListByCid = this.tCoursesessionDao.findNoCompleteListByCid(cid);
        if (CollectionUtils.isEmpty((Collection)noCompleteListByCid)) {
            messageResult.setFlag(Integer.valueOf(1));
            messageResult.setMessage("\u8be5\u8bfe\u7a0b\u5305\uff0c\u6ca1\u6709\u672a\u4e0a\u7684\u8bfe\u4e86");
            return messageResult;
        }
        TCourse tCourse = this.tCourseDao.findOne(cid);
        Integer type = tCourse.getType();
        if (!type.equals(100002)) {
            messageResult.setFlag(Integer.valueOf(1));
            messageResult.setMessage("\u53ea\u6709\u5c0f\u7ec4\u8bfe\uff0c\u624d\u80fd\u6dfb\u52a0\u5b66\u751f");
            return messageResult;
        }
        ArrayList<TCourseStudent> tCourseStudentList = new ArrayList<TCourseStudent>();
        for (Integer n : inStudentIdList) {
            TCourseStudent tCourseStudent = new TCourseStudent();
            tCourseStudent.setCourseId(cid);
            tCourseStudent.setStudentId(n);
            tCourseStudent.setCreater(String.valueOf(form.getLoginId()));
            tCourseStudentList.add(tCourseStudent);
        }
        this.tCourseStudentDao.batchInsert(tCourseStudentList);
        ArrayList<TCourseSessionStudent> tCourseSessionStudentList = new ArrayList<TCourseSessionStudent>();
        for (TCoursesession tCoursesession : noCompleteListByCid) {
            for (Integer stuId : inStudentIdList) {
                TCourseSessionStudent tCourseSessionStudent = new TCourseSessionStudent();
                tCourseSessionStudent.setCourseSessionId(tCoursesession.getSessionid());
                tCourseSessionStudent.setStudentId(stuId);
                tCourseSessionStudent.setCreater(String.valueOf(form.getLoginId()));
                tCourseSessionStudentList.add(tCourseSessionStudent);
            }
        }
        this.tCourseSessionStudentDao.batchInsert(tCourseSessionStudentList);
        List list = this.tCourseStudentDao.findStudentIdListByCid(cid);
        List studentList = this.tStudentDao.findByStuIdList(list);
        String stuName = "";
        String stuEnName = "";
        StringBuilder stuNameSb = new StringBuilder();
        StringBuilder stuEnNameSb = new StringBuilder();
        for (TStudent tStudent : studentList) {
            stuNameSb.append(tStudent.getStuId()).append("_").append(tStudent.getRealName()).append("_").append(tStudent.getEnglishName()).append(";");
            stuEnNameSb.append(tStudent.getEnglishName()).append(";");
        }
        if (stuNameSb.length() > 1) {
            stuName = stuNameSb.substring(0, stuNameSb.length() - 1);
        }
        if (stuEnNameSb.length() > 1) {
            stuEnName = stuEnNameSb.substring(0, stuEnNameSb.length() - 1);
        }
        if (Objects.nonNull(addPackageprice = form.getAddPackageprice()) && addPackageprice.compareTo(0.0) > 0) {
            tCourse.setPackageprice(Double.valueOf(tCourse.getPackageprice() + addPackageprice));
        }
        if (!(teacherId2 = tCourse.getTeacherId()).equals(teacherId)) {
            tCourse.setTeacherId(teacherId);
        }
        tCourse.setStuName(stuName);
        tCourse.setStuEnName(stuEnName);
        tCourse.setClassRoom(classRoom);
        this.tCourseDao.updateByIdSelective(tCourse);
        int size = this.tCoursesessionDao.countNoCompleteAndIsPayByCid(cid);
        for (TCoursesession tCoursesession : noCompleteListByCid) {
            String classRoom1;
            Integer teacherId1;
            if (tCoursesession.getIspay() == 1 && Objects.nonNull(addPackageprice) && addPackageprice.compareTo(0.0) > 0) {
                double addPrice = addPackageprice / (double)size;
                tCoursesession.setPrice(tCoursesession.getPrice().add(BigDecimal.valueOf(addPrice)));
            }
            if (!(teacherId1 = tCoursesession.getTeacherId()).equals(teacherId)) {
                tCoursesession.setTeacherId(teacherId);
            }
            if (!classRoom.equals(classRoom1 = tCoursesession.getClassRoom())) {
                tCoursesession.setClassRoom(classRoom);
            }
            tCoursesession.setStuName(stuName);
            tCoursesession.setStuEnName(stuEnName);
            this.tCoursesessionDao.updateByIdSelective(tCoursesession);
        }
        messageResult.setFlag(Integer.valueOf(0));
        messageResult.setMessage("\u4fdd\u5b58\u6210\u529f");
        return messageResult;
    }

    @Override
    @Transactional(rollbackFor={Throwable.class}, propagation=Propagation.REQUIRED)
    public ReturnMessageResult coursePackageDeleteStudentSave(AdminCoursePackageDeleteStudentSaveForm form) {
        Integer teacherId2;
        Double reducePackageprice;
        ReturnMessageResult messageResult = new ReturnMessageResult();
        String stuids = form.getStuids();
        Integer cid = form.getCid();
        Integer teacherId = form.getTeacherId();
        String classRoom = form.getClassRoom();
        if (cid == null || cid == 0 || StringUtil.isEmpty((String)stuids) || Objects.isNull(teacherId) || StringUtils.isBlank((String)classRoom)) {
            messageResult.setFlag(Integer.valueOf(1));
            messageResult.setMessage("\u53c2\u6570\u9519\u8bef");
            return messageResult;
        }
        stuids = stuids.substring(0, stuids.length() - 1);
        String[] sids = stuids.split(",");
        ArrayList<Integer> inStudentIdList = new ArrayList<Integer>();
        for (String sid : sids) {
            inStudentIdList.add(Integer.valueOf(sid));
        }
        List noCompleteListByCid = this.tCoursesessionDao.findNoCompleteListByCid(cid);
        if (CollectionUtils.isEmpty((Collection)noCompleteListByCid)) {
            messageResult.setFlag(Integer.valueOf(1));
            messageResult.setMessage("\u8be5\u8bfe\u7a0b\u5305\uff0c\u6ca1\u6709\u672a\u4e0a\u7684\u8bfe\u4e86");
            return messageResult;
        }
        TCourse tCourse = this.tCourseDao.findOne(cid);
        Integer type = tCourse.getType();
        if (!type.equals(100002)) {
            messageResult.setFlag(Integer.valueOf(1));
            messageResult.setMessage("\u53ea\u6709\u5c0f\u7ec4\u8bfe\uff0c\u624d\u80fd\u5220\u9664\u5b66\u751f");
            return messageResult;
        }
        this.tCourseStudentDao.deleteByCidAndStuIdList(cid, inStudentIdList, String.valueOf(form.getLoginId()));
        for (TCoursesession tCoursesession : noCompleteListByCid) {
            this.tCourseSessionStudentDao.deleteBySessionIdAndStuIdList(tCoursesession.getSessionid(), inStudentIdList, String.valueOf(form.getLoginId()));
        }
        List studentIdListByCid = this.tCourseStudentDao.findStudentIdListByCid(cid);
        List studentList = this.tStudentDao.findByStuIdList(studentIdListByCid);
        String stuName = "";
        String stuEnName = "";
        StringBuilder stuNameSb = new StringBuilder();
        StringBuilder stuEnNameSb = new StringBuilder();
        for (TStudent tStudent : studentList) {
            stuNameSb.append(tStudent.getStuId()).append("_").append(tStudent.getRealName()).append("_").append(tStudent.getEnglishName()).append(";");
            stuEnNameSb.append(tStudent.getEnglishName()).append(";");
        }
        if (stuNameSb.length() > 1) {
            stuName = stuNameSb.substring(0, stuNameSb.length() - 1);
        }
        if (stuEnNameSb.length() > 1) {
            stuEnName = stuEnNameSb.substring(0, stuEnNameSb.length() - 1);
        }
        if (Objects.nonNull(reducePackageprice = form.getReducePackageprice()) && reducePackageprice.compareTo(0.0) > 0) {
            tCourse.setPackageprice(Double.valueOf(tCourse.getPackageprice() - reducePackageprice));
        }
        if (!(teacherId2 = tCourse.getTeacherId()).equals(teacherId)) {
            tCourse.setTeacherId(teacherId);
        }
        tCourse.setStuName(stuName);
        tCourse.setStuEnName(stuEnName);
        this.tCourseDao.updateByIdSelective(tCourse);
        int size = this.tCoursesessionDao.countNoCompleteAndIsPayByCid(cid);
        for (TCoursesession tCoursesession : noCompleteListByCid) {
            String classRoom1;
            Integer teacherId1;
            if (tCoursesession.getIspay() == 1 && Objects.nonNull(reducePackageprice) && reducePackageprice.compareTo(0.0) > 0) {
                double reducePrice = reducePackageprice / (double)size;
                tCoursesession.setPrice(tCoursesession.getPrice().subtract(BigDecimal.valueOf(reducePrice)));
            }
            if (!(teacherId1 = tCoursesession.getTeacherId()).equals(teacherId)) {
                tCoursesession.setTeacherId(teacherId);
            }
            if (!classRoom.equals(classRoom1 = tCoursesession.getClassRoom())) {
                tCoursesession.setClassRoom(classRoom);
            }
            tCoursesession.setStuName(stuName);
            tCoursesession.setStuEnName(stuEnName);
            this.tCoursesessionDao.updateByIdSelective(tCoursesession);
        }
        messageResult.setFlag(Integer.valueOf(0));
        messageResult.setMessage("\u4fdd\u5b58\u6210\u529f");
        return messageResult;
    }

    @Override
    @Transactional(rollbackFor={Throwable.class}, propagation=Propagation.REQUIRED)
    public void test() {
        List studentIdListByCid = this.tCourseStudentDao.findStudentIdListByCid(Integer.valueOf(1));
        System.out.println(studentIdListByCid);
        TCourseStudent tCourseStudent = new TCourseStudent();
        tCourseStudent.setCourseId(Integer.valueOf(1));
        tCourseStudent.setStudentId(Integer.valueOf(1));
        tCourseStudent.setCreater(String.valueOf(1));
        ArrayList<TCourseStudent> list = new ArrayList<TCourseStudent>();
        list.add(tCourseStudent);
        this.tCourseStudentDao.batchInsert(list);
        List studentIdListByCid2 = this.tCourseStudentDao.findStudentIdListByCid(Integer.valueOf(1));
        System.out.println(studentIdListByCid2);
    }

    @Override
    public CoursePackageAwardResult coursePackageAward(Integer cid) {
        TCourse course = this.tCourseDao.findOne(cid);
        TStudent student = this.tStudentDao.findOne(course.getStuId());
        TTeacher teacher = this.tTeacherDao.findOne(course.getTeacherId());
        CoursePackageAwardResult result = new CoursePackageAwardResult();
        result.setCid(cid);
        result.setClassName(course.getClassname());
        result.setStuId(student.getStuId());
        result.setStuName(student.getRealName() + " " + student.getEnglishName());
        result.setTeacherId(teacher.getTeacherId());
        result.setTeacherName(teacher.getFirstName() + " " + teacher.getLastName());
        result.setClassId(course.getClassid());
        return result;
    }

    @Override
    public CoursePackageAwardConfirmResult coursePackageAwardConfirm(CoursePackageAwardConfirmForm form) {
        CoursePackageAwardConfirmResult result = new CoursePackageAwardConfirmResult();
        result.setFlag(Integer.valueOf(0));
        TCourse course = this.tCourseDao.findOne(form.getCid());
        BigDecimal bonusHour = MathUtils.getHourByDuration((Integer)(form.getBonusNum() * course.getDuration()));
        TAwardCourse awardCourse = this.tAwardCourseDao.findOneByStuId(form.getStuId());
        if (awardCourse == null || awardCourse.getCourseNum() < bonusHour.doubleValue()) {
            result.setFlag(Integer.valueOf(1));
            result.setMessage("\u5956\u52b1\u6c60\u8bfe\u65f6\u4e0d\u591f\uff0c\u65e0\u6cd5\u5956\u52b1");
            return result;
        }
        result.setBonusNum(form.getBonusNum());
        result.setReason(form.getReason());
        result.setCid(form.getCid());
        result.setStuId(form.getStuId());
        result.setTeacherId(form.getTeacherId());
        result.setBonusNumStr(MathUtils.getHourStrByDuration((Integer)(form.getBonusNum() * course.getDuration())));
        result.setPoolBonus(awardCourse.getCourseNum() + "\u5c0f\u65f6");
        result.setCanBonus(MathUtils.div((BigDecimal)new BigDecimal(awardCourse.getCourseNum() * 60.0), (BigDecimal)new BigDecimal(course.getDuration()), (int)2) + "\u6b21(\u6838\u9500" + awardCourse.getCourseNum() + "\u5c0f\u65f6\uff09");
        result.setDurationStr(MathUtils.getHourStrByDuration((Integer)course.getDuration()));
        result.setPoolRemaining(MathUtils.sub((BigDecimal)new BigDecimal(awardCourse.getCourseNum()), (BigDecimal)new BigDecimal(form.getBonusNum())) + "\u5c0f\u65f6");
        return result;
    }

    @Override
    @Transactional(rollbackFor={Throwable.class}, propagation=Propagation.REQUIRED)
    public ReturnMessageResult coursePackageAwardSave(CoursePackageAwardSaveForm form) throws ParseException {
        ReturnMessageResult result = new ReturnMessageResult();
        TCourse tCourse = this.tCourseDao.findOne(form.getCid());
        TAwardCourse awardCourse = this.tAwardCourseDao.findOneByStuId(tCourse.getStuId());
        if (awardCourse != null && awardCourse.getCourseNum() > 0.0) {
            if (!MathUtils.isBiggerOrEquals((BigDecimal)new BigDecimal(awardCourse.getCourseNum() * 60.0), (BigDecimal)new BigDecimal(form.getBonusNum() * tCourse.getDuration())).booleanValue()) {
                result.setFlag(Integer.valueOf(1));
                result.setMessage("\u5956\u52b1\u6c60\u8bfe\u65f6\u4f59\u989d\u4e0d\u8db3\uff0c\u65e0\u6cd5\u4f7f\u7528\u5956\u52b1\u6c60\u5185\u7684\u8bfe\u65f6");
                return result;
            }
        } else {
            result.setFlag(Integer.valueOf(1));
            result.setMessage("\u5956\u52b1\u6c60\u8bfe\u65f6\u4f59\u989d\u4e0d\u8db3\uff0c\u65e0\u6cd5\u4f7f\u7528\u5956\u52b1\u6c60\u5185\u7684\u8bfe\u65f6");
            return result;
        }
        Double beginCourseNum = awardCourse.getCourseNum();
        BigDecimal nowCourseNum = MathUtils.sub((BigDecimal)new BigDecimal(beginCourseNum), (BigDecimal)MathUtils.div((Double)((double)form.getBonusNum().intValue() * tCourse.getDuration().doubleValue()), (double)60.0, (int)2));
        TCoursesession tCoursesession = this.tCoursesessionDao.findLastOneByCid(form.getCid());
        TTeacher teacher = this.tTeacherDao.findOne(tCoursesession.getTeacherId());
        List students = this.tCourseStudentDao.findStudentIdListByCid(tCourse.getCid());
        for (int i = 0; i < form.getBonusNum(); ++i) {
            TCoursesession newCoursesession = new TCoursesession();
            List<LeaveCourseResult> leaveCourseResults = this.tCoursesessionService.leaveCoursePlan(form.getCid(), 1);
            if (leaveCourseResults == null || leaveCourseResults.size() <= 0) continue;
            LeaveCourseResult leaveCourseResult = leaveCourseResults.get(0);
            BeanUtils.copyProperties((Object)tCoursesession, (Object)newCoursesession, (String[])new String[]{"updateTime"});
            newCoursesession.setTeacherId(tCoursesession.getTeacherId());
            newCoursesession.setCreateTime(null);
            newCoursesession.setDuration(Integer.valueOf(leaveCourseResult.getTimeLength()));
            newCoursesession.setSessionid(null);
            newCoursesession.setStatus(null);
            newCoursesession.setStarttime(DateUtils.parseDateToSecond((String)leaveCourseResult.getStartTime()));
            newCoursesession.setIsSystem(Integer.valueOf(1));
            newCoursesession.setIspay(Integer.valueOf(0));
            newCoursesession.setRate(new BigDecimal(teacher.getOneOnOne()));
            this.tCoursesessionDao.insertSelective(newCoursesession);
            for (Integer stuId : students) {
                TCourseSessionStudent tCourseSessionStudent = new TCourseSessionStudent();
                tCourseSessionStudent.setCourseSessionId(newCoursesession.getSessionid());
                tCourseSessionStudent.setStudentId(stuId);
                this.tCourseSessionStudentDao.insertSelective(tCourseSessionStudent);
            }
        }
        BigDecimal price = this.courseCommonService.calculateCoursesessionPrice(CalculatePriceTypeEnums.ADDTIME_SAMEPRICE, tCourse.getCid(), form.getBonusNum(), null);
        this.tCoursesessionDao.updatePriceByCidForNoCompleteAndIsPay(tCourse.getCid(), price);
        this.tCourseService.processCourseCount(tCourse.getCid(), (double)(form.getBonusNum() * tCourse.getDuration()) / 60.0, TalkillaConstant.CourseCountType.ADMIN_ADD_AWARD_COURSE);
        if (StringUtils.isNotBlank((String)form.getReason())) {
            this.tAwardCourseService.process(tCourse.getStuId(), (double)(form.getBonusNum() * tCourse.getDuration()) / 60.0, TalkillaConstant.CourseAward.MINUS_FOR_ADMIN, form.getReason(), form.getCid());
        } else {
            this.tAwardCourseService.process(tCourse.getStuId(), (double)(form.getBonusNum() * tCourse.getDuration()) / 60.0, TalkillaConstant.CourseAward.MINUS_FOR_ADMIN, "\u540e\u53f0\u7ba1\u7406\u5458\u65b0\u589e\u8bfe\u7a0b\u76f4\u63a5\u6838\u9500", form.getCid());
        }
        try {
            WeChatTimeRewardNoticeForm _form = new WeChatTimeRewardNoticeForm();
            TStudent _tStudent = this.tStudentService.findOne(tCourse.getStuId());
            TWechat tWechat = this.tWechatService.getTWechatInfoByLoginId(_tStudent.getLoginId());
            awardCourse = this.tAwardCourseDao.findOneByStuId(tCourse.getStuId());
            _form.setStudentRealName(_tStudent.getRealName());
            _form.setHourAwarded(String.valueOf((double)(form.getBonusNum() * tCourse.getDuration()) / 60.0));
            _form.setHourAwardedPool(beginCourseNum.toString());
            _form.setHourAwardedPoolRemaining(nowCourseNum.doubleValue());
            _form.setType(4);
            _form.setComment(form.getReason());
            TCourse _tCourse = this.tCourseDao.findOne(form.getCid());
            _form.setCoursePackageId(_tCourse.getClassid() + "(" + teacher.getFirstName() + " " + teacher.getLastName().substring(0, 1).toUpperCase() + ".)");
            _form.setCoursePackageName(_tCourse.getClassname());
            _form.setOpenId(tWechat.getOpenid());
            this.commonEvent.publishTimeRewardNoticeEvent(_form);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        result.setFlag(Integer.valueOf(0));
        return result;
    }

    @Override
    public AdminCoursePackageSettingResult coursePackageSetting(Integer cid) {
        TCourse tCourse = this.tCourseDao.findOne(cid);
        AdminCoursePackageSettingResult result = new AdminCoursePackageSettingResult();
        BeanUtils.copyProperties((Object)tCourse, (Object)result);
        result.setStudentNames(tCourse.getStuName());
        TTeacher tTeacher = this.tTeacherDao.findOne(tCourse.getTeacherId());
        if (tTeacher != null) {
            result.setTeacherName(tTeacher.getFirstName() + " " + tTeacher.getLastName());
        }
        return result;
    }

    @Override
    @Transactional(rollbackFor={Throwable.class})
    public ReturnMessageResult coursePackageSettingSave(AdminCoursePackageSettingSaveForm form) {
        Integer teachStatus;
        Integer cid = form.getCid();
        TCourse tCourse = this.tCourseDao.findOne(cid);
        Integer operateType = form.getOperateType();
        if (operateType == 0) {
            this.coursePackageTimeClear(cid);
            tCourse.setTeachStatus(Integer.valueOf(1));
        }
        if (operateType == 1 && (teachStatus = tCourse.getTeachStatus()) != 1) {
            this.coursePackageTimeClear(cid);
            tCourse.setTeachStatus(Integer.valueOf(1));
        }
        if (operateType == 2) {
            teachStatus = tCourse.getTeachStatus();
            if (teachStatus != 1) {
                this.coursePackageTimeClear(cid);
                tCourse.setTeachStatus(Integer.valueOf(1));
            }
            tCourse.setTotalhour(tCourse.getHourcomplete());
            tCourse.setHourpending(Double.valueOf(0.0));
            if (tCourse.getHourpending() == 0.0) {
                tCourse.setTeachStatus(Integer.valueOf(2));
            }
            tCourse.setRenewStatus(Integer.valueOf(3));
        }
        if (operateType == 3) {
            tCourse.setTotalhour(form.getTotalhour());
            tCourse.setHourcomplete(form.getHourcomplete());
            tCourse.setHourpending(form.getHourpending());
            if (tCourse.getHourpending() == 0.0) {
                tCourse.setTeachStatus(Integer.valueOf(2));
            }
            tCourse.setClassRoom(form.getClassRoom());
            tCourse.setClassname(form.getClassname());
            tCourse.setNotes(form.getNotes());
            tCourse.setPackageprice(form.getPackageprice());
            tCourse.setTeachStatus(form.getTeachStatus());
            tCourse.setRenewStatus(form.getRenewStatus());
            tCourse.setReportStatus(form.getReportStatus());
        }
        this.tCourseDao.updateByIdSelective(tCourse);
        return ReturnMessageResult.success((String)"\u64cd\u4f5c\u6210\u529f");
    }

    private List<DateBean> getSessionTime(List<String> timeList, List<Integer> durationList, Date delay, double totalHour) {
        ArrayList<DateBean> dateBeanList = new ArrayList<DateBean>();
        int totalMin = (int)(totalHour * 60.0);
        int useMin = 0;
        Calendar ca = Calendar.getInstance();
        ca.setTime(delay);
        ArrayList<Integer> repateList = new ArrayList<Integer>();
        for (String time : timeList) {
            repateList.add(Integer.parseInt(time.split("-")[3]));
        }
        while (true) {
            int week;
            if (durationList.get(week = ca.get(7) - 1) != null && durationList.get(week) != 0) {
                Integer repate = (Integer)repateList.get(week);
                if (repate <= 0) {
                    ca.add(5, 1);
                    continue;
                }
                repateList.set(week, repate - 1);
                int hourofday = Integer.valueOf(timeList.get(week).split("-")[1]);
                int minuteofhour = Integer.valueOf(timeList.get(week).split("-")[2]);
                ca.set(11, hourofday);
                ca.set(12, minuteofhour);
                DateBean date = new DateBean();
                date.setDate(ca.getTime());
                date.setDuration(durationList.get(week));
                dateBeanList.add(date);
                if ((useMin += durationList.get(week).intValue()) > totalMin) {
                    return null;
                }
            }
            if (useMin >= totalMin) break;
            ca.add(5, 1);
        }
        return dateBeanList;
    }
}

