/*
 * Decompiled with CFR 0.152.
 */
package com.talkilla.service.impl.admin;

import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.talkilla.constant.TalkillaConstant;
import com.talkilla.form.admin.AdminCourseConsultantAddSaveForm;
import com.talkilla.form.admin.AdminCourseConsultantEditSaveForm;
import com.talkilla.form.admin.AdminCourseConsultantListForm;
import com.talkilla.mysql.domain.TConsultant;
import com.talkilla.mysql.domain.TLogin;
import com.talkilla.mysql.domain.TSendEmailRecord;
import com.talkilla.mysql.domain.TStudentConsultant;
import com.talkilla.mysql.mapper.TConsultantDao;
import com.talkilla.mysql.mapper.TLoginDao;
import com.talkilla.mysql.mapper.TSendEmailRecordDao;
import com.talkilla.mysql.mapper.TStudentConsultantDao;
import com.talkilla.result.ReturnMessageResult;
import com.talkilla.result.admin.base.PageObj;
import com.talkilla.service.admin.AdminCourseConsultantService;
import com.talkilla.serviceUtils.TalkillaEmailMessageUtils;
import com.talkilla.utils.DateUtils;
import com.talkilla.utils.PasswordUtil;
import java.util.List;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service(value="adminCourseConsultantService")
public class AdminCourseConsultantServiceImpl
implements AdminCourseConsultantService {
    @Autowired
    private TConsultantDao tConsultantDao;
    @Autowired
    private TStudentConsultantDao tStudentConsultantDao;
    @Autowired
    private TLoginDao tLoginDao;
    @Autowired
    private TSendEmailRecordDao tSendEmailRecordDao;

    @Override
    public PageObj courseConsultantList(AdminCourseConsultantListForm form) {
        Integer pageNo = form.getPageNo();
        Integer pageSize = form.getPageSize();
        if (pageNo == null || pageNo < 1) {
            pageNo = 1;
        }
        if (pageSize == null || pageSize < 0) {
            pageSize = 20;
        }
        Page page = PageHelper.startPage((int)pageNo, (int)pageSize);
        List result = this.tConsultantDao.courseConsultantList(form);
        PageObj pageObj = new PageObj();
        pageObj.setCurrPageNumber(pageNo);
        pageObj.setFirstPageNumber(Integer.valueOf(1));
        pageObj.setLastPageNumber(pageObj.processTotalPage(page.getTotal(), Integer.valueOf(page.getPageSize())));
        pageObj.setPreviousPageNumber(pageObj.processPreviousPage(pageNo));
        pageObj.setNextPageNumber(pageObj.processNextPage());
        pageObj.setPageElements(page.getResult());
        pageObj.setPageSize(pageSize);
        pageObj.setTotalCount(Long.valueOf(page.getTotal()));
        return pageObj;
    }

    @Override
    public TConsultant courseConsultantEdit(Integer id) {
        return this.tConsultantDao.findOne(id);
    }

    @Override
    @Transactional(rollbackFor={Throwable.class}, propagation=Propagation.REQUIRED)
    public ReturnMessageResult courseConsultantEditSave(AdminCourseConsultantEditSaveForm form) {
        ReturnMessageResult messageResult = new ReturnMessageResult();
        TConsultant tConsultant = this.tConsultantDao.findOne(form.getId());
        BeanUtils.copyProperties((Object)form, (Object)tConsultant, (String[])new String[]{"updateTime"});
        this.tConsultantDao.updateByIdSelective(tConsultant);
        List stus = this.tStudentConsultantDao.findByConsultantId(tConsultant.getConsultantId());
        for (TStudentConsultant stu : stus) {
            stu.setMobile(tConsultant.getMobile());
            stu.setConsultantEmail(tConsultant.getEmail());
            stu.setConsultantName(tConsultant.getName());
            this.tStudentConsultantDao.updateByIdSelective(stu);
        }
        TLogin tLogin = this.tLoginDao.findOne(tConsultant.getLoginId());
        if (tLogin != null) {
            if (tConsultant.getStatus() == 0) {
                tLogin.setIsDelete(DateUtils.getNowSeconds());
            } else {
                tLogin.setIsDelete(Integer.valueOf(0));
            }
            this.tLoginDao.updateByIdSelective(tLogin);
        }
        messageResult.setFlag(Integer.valueOf(0));
        messageResult.setMessage("\u66f4\u65b0\u6210\u529f");
        return messageResult;
    }

    @Override
    @Transactional(rollbackFor={Throwable.class}, propagation=Propagation.REQUIRED)
    public ReturnMessageResult courseConsultantDelete(Integer id) {
        ReturnMessageResult messageResult = new ReturnMessageResult();
        if (id == 1) {
            messageResult.setFlag(Integer.valueOf(0));
            messageResult.setMessage("\u7ba1\u7406\u5458\u9ed8\u8ba4\u7684\u4e0d\u80fd\u5220\u9664");
            return messageResult;
        }
        this.tConsultantDao.deleteById(id);
        messageResult.setFlag(Integer.valueOf(0));
        messageResult.setMessage("\u5220\u9664\u6210\u529f");
        return messageResult;
    }

    @Override
    @Transactional(rollbackFor={Throwable.class}, propagation=Propagation.REQUIRED)
    public ReturnMessageResult courseConsultantAddSave(AdminCourseConsultantAddSaveForm form) {
        ReturnMessageResult messageResult = new ReturnMessageResult();
        TLogin byLoginName = this.tLoginDao.findByLoginName(form.getLoginName());
        if (byLoginName != null) {
            messageResult.setFlag(Integer.valueOf(1));
            messageResult.setMessage(form.getLoginName() + " \u5df2\u7ecf\u88ab\u4f7f\u7528\u4e86\u3002");
            return messageResult;
        }
        TLogin tLogin = new TLogin();
        tLogin.setLoginName(form.getLoginName());
        tLogin.setLoginPwd(PasswordUtil.encrypt2((String)form.getLoginPwd()).toLowerCase());
        tLogin.setRoleId(Integer.valueOf(4));
        this.tLoginDao.insertSelective(tLogin);
        TConsultant tConsultant = new TConsultant();
        tConsultant.setLoginId(tLogin.getLoginId());
        tConsultant.setName(form.getName());
        tConsultant.seteName(form.geteName());
        tConsultant.setEmail(form.getLoginName());
        tConsultant.setMobile(form.getMobile());
        tConsultant.setStatus(Integer.valueOf(1));
        tConsultant.setSkypeId(form.getSkypeId());
        tConsultant.setGender(form.getGender());
        this.tConsultantDao.insertSelective(tConsultant);
        TalkillaEmailMessageUtils.sendConsultByRegisterSuccess(tLogin.getLoginName(), tConsultant, tLogin.getLoginName(), form.getLoginPwd());
        TSendEmailRecord tSendEmailRecord = new TSendEmailRecord();
        tSendEmailRecord.setUserType(TalkillaConstant.SendEmailUserType.CONSULTANT);
        tSendEmailRecord.setEmail(tLogin.getLoginName());
        tSendEmailRecord.setEmailType(TalkillaConstant.SendEmailType.SEND_CONSULT_BY_REGISTER_SUCCESS);
        tSendEmailRecord.setRecordType(TalkillaConstant.SendEmailType.SEND_CONSULT_BY_REGISTER_SUCCESS);
        tSendEmailRecord.setCid(Integer.valueOf(0));
        tSendEmailRecord.setStuId(Integer.valueOf(0));
        tSendEmailRecord.setTeacherId(Integer.valueOf(0));
        this.tSendEmailRecordDao.insertSelective(tSendEmailRecord);
        messageResult.setFlag(Integer.valueOf(0));
        messageResult.setMessage("\u6dfb\u52a0\u6210\u529f");
        return messageResult;
    }
}

