/*
 * Decompiled with CFR 0.152.
 */
package com.talkilla.service.impl;

import com.talkilla.exception.BusinessException;
import com.talkilla.form.student.MobileForm;
import com.talkilla.form.student.ModifyEmailForm;
import com.talkilla.mysql.domain.TLogin;
import com.talkilla.mysql.domain.TStudent;
import com.talkilla.mysql.mapper.TLoginDao;
import com.talkilla.mysql.mapper.TStudentDao;
import com.talkilla.service.TLoginService;
import java.util.Date;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="tLoginService")
public class TLoginServiceImpl
implements TLoginService {
    @Autowired
    private TLoginDao tLoginDao;
    @Autowired
    private TStudentDao tStudentDao;

    @Override
    public TLogin findOne(Integer loginId) {
        return this.tLoginDao.findOne(loginId);
    }

    @Override
    public void saveMobile(MobileForm form) throws BusinessException {
        TStudent student = this.tStudentDao.findOne(form.getStuId());
        TLogin login = this.tLoginDao.findOne(student.getLoginId());
        if (StringUtils.isNotBlank((String)form.getMobile())) {
            TLogin byMobile = this.tLoginDao.findByMobile(form.getMobile());
            if (byMobile == null || form.getMobile().equals(login.getMobile())) {
                login.setMobile(form.getMobile());
                login.setUpdateTime(new Date());
                this.tLoginDao.updateByIdSelective(login);
            } else {
                throw new BusinessException((Object)"10001", "\u624b\u673a\u53f7\u5df2\u7ecf\u5b58\u5728");
            }
        }
    }

    @Override
    public void saveEmail(ModifyEmailForm form) throws BusinessException {
        TStudent student = this.tStudentDao.findOne(form.getStuId());
        TLogin login = this.tLoginDao.findOne(student.getLoginId());
        if (StringUtils.isNotBlank((String)form.getEmail())) {
            TLogin byLoginName = this.tLoginDao.findByLoginName(form.getEmail());
            if (byLoginName == null || form.getEmail().equals(login.getLoginName())) {
                login.setLoginName(form.getEmail());
                login.setUpdateTime(new Date());
                this.tLoginDao.updateByIdSelective(login);
            } else {
                throw new BusinessException((Object)"1001", "\u90ae\u7bb1\u5df2\u7ecf\u5b58\u5728");
            }
        }
    }
}

