/*
 * Decompiled with CFR 0.152.
 */
package com.talkilla.service.impl;

import com.talkilla.constant.TalkillaConstant;
import com.talkilla.mysql.domain.TCourse;
import com.talkilla.mysql.domain.TCoursesession;
import com.talkilla.mysql.mapper.TCourseDao;
import com.talkilla.mysql.mapper.TCoursesessionDao;
import com.talkilla.otherbean.StudentDto;
import com.talkilla.result.admin.AdminFindAllCoursesResult;
import com.talkilla.result.student.CourseNameAndCidAtPresentResult;
import com.talkilla.service.TCourseService;
import com.talkilla.utils.DateUtils;
import com.talkilla.utils.MathUtils;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="tCourseService")
public class TCourseServiceImpl
implements TCourseService {
    private static final Logger logger = LoggerFactory.getLogger(TCourseServiceImpl.class);
    @Autowired
    private TCourseDao tCourseDao;
    @Autowired
    private TCoursesessionDao tCoursesessionDao;

    @Override
    public List<TCourse> findCourceListByStudentId(Integer studentId, Integer type) {
        if (Objects.nonNull(type) && type == 2) {
            return this.tCourseDao.findCompletedCourceListByStudentId(studentId);
        }
        return this.tCourseDao.findNoCompletedCourceListByStudentId(studentId);
    }

    @Override
    public TCourse findOne(Integer cid) {
        return this.tCourseDao.findOne(cid);
    }

    @Override
    public CourseNameAndCidAtPresentResult findCourceNameAtPresent(Integer stuId) {
        return this.tCourseDao.findCourceNameAtPresent(stuId);
    }

    @Override
    public Integer findCourcesessionCompleted(String cidStr) {
        return this.tCourseDao.findCourcesessionCompleted(cidStr);
    }

    @Override
    public Integer findCourcesessionUnCompleted(String cidStr) {
        return this.tCourseDao.findCourcesessionUnCompleted(cidStr);
    }

    @Override
    public Integer findCourcessionCompletedNoFeedback(String cidStr) {
        return this.tCourseDao.findCourcessionCompletedNoFeedback(cidStr);
    }

    @Override
    public StudentDto findStudentsByCid(Integer cid) {
        return new StudentDto();
    }

    @Override
    public List<AdminFindAllCoursesResult> findAllCourses() {
        return this.tCourseDao.findAllCourses();
    }

    @Override
    public void processCourseCount(Integer cid, Double courseNum, Integer processType) {
        TCourse course = this.tCourseDao.findOne(cid);
        course.setUpdateTime(new Date());
        if (Objects.equals(processType, TalkillaConstant.CourseCountType.STUDENT_ABSENT) || Objects.equals(processType, TalkillaConstant.CourseCountType.NORMAL_COMPLETE)) {
            course.setHourpending(MathUtils.sub((Double)course.getHourpending(), (Double)courseNum));
            if (course.getHourpending() == 0.0) {
                course.setTeachStatus(Integer.valueOf(2));
            }
            course.setHourcomplete(MathUtils.add((Double)course.getHourcomplete(), (Double)courseNum));
            this.tCourseDao.updateByIdSelective(course);
        } else if (Objects.equals(processType, TalkillaConstant.CourseCountType.TEACHER_ABSENT) || Objects.equals(processType, TalkillaConstant.CourseCountType.ADMIN_ADD_AWARD_COURSE) || Objects.equals(processType, TalkillaConstant.CourseCountType.STUDENT_HEXIAO)) {
            course.setHourpending(MathUtils.add((Double)course.getHourpending(), (Double)courseNum));
            if (course.getHourpending() == 0.0) {
                course.setTeachStatus(Integer.valueOf(2));
            }
            course.setHourawarded(MathUtils.add((Double)course.getHourawarded(), (Double)courseNum));
            course.setTotalhour(MathUtils.add((Double)course.getTotalhour(), (Double)courseNum));
            this.tCourseDao.updateByIdSelective(course);
        } else if (Objects.equals(processType, TalkillaConstant.CourseCountType.ADMIN_ADD_NORMAL_COURSE)) {
            course.setHourpending(MathUtils.add((Double)course.getHourpending(), (Double)courseNum));
            if (course.getHourpending() == 0.0) {
                course.setTeachStatus(Integer.valueOf(2));
            }
            course.setHourpurchase(MathUtils.add((Double)course.getHourpurchase(), (Double)courseNum));
            course.setTotalhour(MathUtils.add((Double)course.getTotalhour(), (Double)courseNum));
            this.tCourseDao.updateByIdSelective(course);
        } else if (Objects.equals(processType, TalkillaConstant.CourseCountType.ADMIN_DELETE_AWARD_COURSE_1)) {
            course.setHourcomplete(MathUtils.sub((Double)course.getHourcomplete(), (Double)courseNum));
            course.setHourawarded(MathUtils.sub((Double)course.getHourawarded(), (Double)courseNum));
            course.setTotalhour(MathUtils.sub((Double)course.getTotalhour(), (Double)courseNum));
            this.tCourseDao.updateByIdSelective(course);
        } else if (Objects.equals(processType, TalkillaConstant.CourseCountType.ADMIN_DELETE_AWARD_COURSE_2)) {
            course.setHourpending(MathUtils.sub((Double)course.getHourpending(), (Double)courseNum));
            if (course.getHourpending() == 0.0) {
                course.setTeachStatus(Integer.valueOf(2));
            }
            course.setHourawarded(MathUtils.sub((Double)course.getHourawarded(), (Double)courseNum));
            course.setTotalhour(MathUtils.sub((Double)course.getTotalhour(), (Double)courseNum));
            this.tCourseDao.updateByIdSelective(course);
        } else if (Objects.equals(processType, TalkillaConstant.CourseCountType.ADMIN_DELETE_NORMAL_COURSE_1)) {
            course.setHourcomplete(MathUtils.sub((Double)course.getHourcomplete(), (Double)courseNum));
            course.setHourpurchase(MathUtils.sub((Double)course.getHourpurchase(), (Double)courseNum));
            course.setTotalhour(MathUtils.sub((Double)course.getTotalhour(), (Double)courseNum));
            this.tCourseDao.updateByIdSelective(course);
        } else if (Objects.equals(processType, TalkillaConstant.CourseCountType.ADMIN_DELETE_NORMAL_COURSE_2)) {
            course.setHourpending(MathUtils.sub((Double)course.getHourpending(), (Double)courseNum));
            if (course.getHourpending() == 0.0) {
                course.setTeachStatus(Integer.valueOf(2));
            }
            course.setHourpurchase(MathUtils.sub((Double)course.getHourpurchase(), (Double)courseNum));
            course.setTotalhour(MathUtils.sub((Double)course.getTotalhour(), (Double)courseNum));
            this.tCourseDao.updateByIdSelective(course);
        } else if (Objects.equals(processType, TalkillaConstant.CourseCountType.ADMIN_DELETE_TEACHER_ABSENT_COURSE)) {
            course.setHourpending(MathUtils.sub((Double)course.getHourpending(), (Double)courseNum));
            if (course.getHourpending() == 0.0) {
                course.setTeachStatus(Integer.valueOf(2));
            }
            course.setHourawarded(MathUtils.sub((Double)course.getHourawarded(), (Double)courseNum));
            course.setTotalhour(MathUtils.sub((Double)course.getTotalhour(), (Double)courseNum));
            this.tCourseDao.updateByIdSelective(course);
            TCoursesession coursesession = this.tCoursesessionDao.findOneByCidAndIsPay(course.getCid());
            if (coursesession != null) {
                coursesession.setIsDelete(DateUtils.getNowSeconds());
                this.tCoursesessionDao.updateByIdSelective(coursesession);
            } else {
                logger.error("\u6ca1\u6709\u67e5\u8be2\u5230\u5956\u52b1\u8bfe\u65f6" + course.getCid());
            }
        }
    }
}

