/*
 * Decompiled with CFR 0.152.
 */
package com.talkilla.service.impl;

import com.talkilla.constant.TalkillaConstant;
import com.talkilla.mysql.domain.TAwardCourse;
import com.talkilla.mysql.domain.TAwardCourseRecord;
import com.talkilla.mysql.domain.TStudent;
import com.talkilla.mysql.mapper.TAwardCourseDao;
import com.talkilla.mysql.mapper.TAwardCourseRecordDao;
import com.talkilla.mysql.mapper.TStudentDao;
import com.talkilla.service.TAwardCourseService;
import com.talkilla.utils.MathUtils;
import java.math.BigDecimal;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="tAwardCourseService")
public class TAwardCourseServiceImpl
implements TAwardCourseService {
    @Autowired
    TAwardCourseDao tAwardCourseDao;
    @Autowired
    TAwardCourseRecordDao tAwardCourseRecordDao;
    @Autowired
    TStudentDao tStudentDao;

    private void addAward(Integer studId, Double courseNum) {
        TAwardCourse awardCourse = this.getAwardCourse(studId);
        BigDecimal add = MathUtils.add((BigDecimal)new BigDecimal(awardCourse.getCourseNum()), (BigDecimal)new BigDecimal(courseNum));
        awardCourse.setCourseNum(Double.valueOf(add.doubleValue()));
        this.tAwardCourseDao.updateByIdSelective(awardCourse);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TAwardCourse getAwardCourse(Integer studId) {
        TAwardCourse awardCourse;
        TAwardCourseServiceImpl tAwardCourseServiceImpl = this;
        synchronized (tAwardCourseServiceImpl) {
            awardCourse = this.tAwardCourseDao.findOneByStuId(studId);
            if (awardCourse == null) {
                awardCourse = new TAwardCourse();
                awardCourse.setStuId(studId);
                awardCourse.setIsDelete(Integer.valueOf(0));
                this.tAwardCourseDao.insertSelective(awardCourse);
                awardCourse = this.tAwardCourseDao.findOneByStuId(studId);
            }
        }
        return awardCourse;
    }

    private void minusAward(Integer studId, Double courseNum) {
        TAwardCourse awardCourse = this.getAwardCourse(studId);
        BigDecimal add = MathUtils.sub((BigDecimal)new BigDecimal(awardCourse.getCourseNum()), (BigDecimal)new BigDecimal(courseNum));
        if (MathUtils.isBiggerOrEquals((BigDecimal)add, (BigDecimal)new BigDecimal(0)).booleanValue()) {
            awardCourse.setCourseNum(Double.valueOf(add.doubleValue()));
        } else {
            awardCourse.setCourseNum(Double.valueOf(0.0));
        }
        this.tAwardCourseDao.updateByIdSelective(awardCourse);
    }

    @Override
    public void process(Integer stuId, Double courseNum, Integer awardType, String comment, Integer cid) {
        TStudent student = this.tStudentDao.findOne(stuId);
        if (awardType == TalkillaConstant.CourseAward.FIRST_AWARD_RECOMMEND) {
            if (student.getRecommendType() == TalkillaConstant.RECOMMEND_TYPE_STUDENT) {
                this.addAward(student.getRecommendId(), courseNum);
                TAwardCourse awardCourse = this.tAwardCourseDao.findOneByStuId(student.getRecommendId());
                TAwardCourseRecord tAwardCourseRecord = new TAwardCourseRecord();
                tAwardCourseRecord.setComment(comment);
                tAwardCourseRecord.setCourseNum(courseNum);
                tAwardCourseRecord.setRecordType(awardType);
                tAwardCourseRecord.setCourseType(TalkillaConstant.ADD);
                tAwardCourseRecord.setStuId(student.getRecommendId());
                tAwardCourseRecord.setRecommendId(student.getStuId());
                tAwardCourseRecord.setCourseTotal(awardCourse.getCourseNum());
                this.tAwardCourseRecordDao.insertSelective(tAwardCourseRecord);
            }
        } else if (awardType == TalkillaConstant.CourseAward.FIRST_AWARD_STUDENT || awardType == TalkillaConstant.CourseAward.AWARD_FOR_ADMIN) {
            this.addAward(student.getStuId(), courseNum);
            TAwardCourse awardCourse = this.tAwardCourseDao.findOneByStuId(stuId);
            TAwardCourseRecord tAwardCourseRecord = new TAwardCourseRecord();
            tAwardCourseRecord.setComment(comment);
            tAwardCourseRecord.setCourseNum(courseNum);
            tAwardCourseRecord.setRecordType(awardType);
            tAwardCourseRecord.setCourseType(TalkillaConstant.ADD);
            tAwardCourseRecord.setStuId(student.getStuId());
            tAwardCourseRecord.setCourseTotal(awardCourse.getCourseNum());
            this.tAwardCourseRecordDao.insertSelective(tAwardCourseRecord);
        } else if (awardType == TalkillaConstant.CourseAward.MINUS_FOR_ADMIN || awardType == TalkillaConstant.CourseAward.MINUS_FOR_USER) {
            this.minusAward(student.getStuId(), courseNum);
            TAwardCourse awardCourse = this.tAwardCourseDao.findOneByStuId(stuId);
            TAwardCourseRecord tAwardCourseRecord = new TAwardCourseRecord();
            tAwardCourseRecord.setComment(comment);
            tAwardCourseRecord.setCourseNum(courseNum);
            tAwardCourseRecord.setRecordType(awardType);
            tAwardCourseRecord.setCourseType(TalkillaConstant.MINUS);
            tAwardCourseRecord.setStuId(student.getStuId());
            tAwardCourseRecord.setCid(cid);
            tAwardCourseRecord.setCourseTotal(awardCourse.getCourseNum());
            this.tAwardCourseRecordDao.insertSelective(tAwardCourseRecord);
        }
    }
}

