/*
 * Decompiled with CFR 0.152.
 */
package com.talkilla.service.impl;

import com.alibaba.fastjson.JSON;
import com.talkilla.constant.SystemConfig;
import com.talkilla.exception.BusinessException;
import com.talkilla.mysql.domain.TMobileCode;
import com.talkilla.mysql.domain.TRegion;
import com.talkilla.mysql.mapper.TDTimezoneDao;
import com.talkilla.mysql.mapper.TMobileCodeDao;
import com.talkilla.mysql.mapper.TNationDao;
import com.talkilla.mysql.mapper.TRegionDao;
import com.talkilla.otherbean.NationDto;
import com.talkilla.service.CommonService;
import com.talkilla.utils.CheckFormatUtils;
import com.talkilla.utils.DateUtils;
import com.talkilla.utils.HttpsUtils;
import com.talkilla.utils.JSONUtil;
import com.talkilla.utils.MoblieMessageUtil;
import com.talkilla.utils.RandomUtil;
import com.talkilla.utils.TaobaoApiSignUtil;
import java.io.IOException;
import java.text.ParseException;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="commonService")
public class CommonServiceImpl
implements CommonService {
    private static final Logger logger = LoggerFactory.getLogger(CommonServiceImpl.class);
    @Autowired
    TNationDao tNationDao;
    @Autowired
    TDTimezoneDao tdTimezoneDao;
    @Autowired
    TMobileCodeDao tMobileCodeDao;
    @Autowired
    TRegionDao tRegionDao;

    @Override
    public List<NationDto> getNations() {
        return this.tNationDao.findAllNationDto();
    }

    @Override
    public List<String> getZones() {
        return this.tdTimezoneDao.findNames();
    }

    @Override
    public HashMap<String, String> sendcode(String mobile) throws IOException, BusinessException, ParseException {
        logger.info("\u53d1\u9001\u9a8c\u8bc1\u7801\u7684\u624b\u673a\u53f7\u662f:" + mobile);
        HashMap<String, String> result = new HashMap<String, String>();
        if (!CheckFormatUtils.isMobile((String)mobile)) {
            result.put("flag", "1");
            result.put("message", "\u624b\u673a\u53f7\u683c\u5f0f\u4e0d\u5bf9");
            return result;
        }
        String code = RandomUtil.getRandomVerifyCode();
        Integer count = this.tMobileCodeDao.countCodeByMobile(mobile, DateUtils.getTodayBeginDate());
        if (count > 10) {
            result.put("flag", "1");
            result.put("message", "\u5f53\u5929\u53d1\u9001\u7684\u9a8c\u8bc1\u7801\u4e0d\u80fd\u8d85\u8fc710\u6761");
            return result;
        }
        MoblieMessageUtil.sendIdentifyingCode((String)mobile, (String)code);
        TMobileCode mobileCode = new TMobileCode();
        mobileCode.setCode(code);
        mobileCode.setMobile(mobile);
        this.tMobileCodeDao.insertSelective(mobileCode);
        result.put("flag", "0");
        result.put("message", "\u53d1\u9001\u6210\u529f");
        return result;
    }

    @Override
    public Boolean checkCode(String phone, String messageCode) {
        if (SystemConfig.CATEGORY.equals("debug")) {
            return true;
        }
        TMobileCode codeByMobile = this.tMobileCodeDao.findCodeByMobile(phone, DateUtils.get3MinuteBeforeTime());
        if (codeByMobile != null && StringUtils.isNotBlank((CharSequence)messageCode) && messageCode.equals(codeByMobile.getCode())) {
            return true;
        }
        return false;
    }

    private boolean sendRegister(String mobile, String code) throws IOException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("code", code);
        return this.send(map, mobile, SystemConfig.Sms.SMS_TEMPLATECODE_SEND);
    }

    private boolean send(Map<String, String> data, String mobile, String templateCode) throws IOException {
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("method", "alibaba.aliqin.fc.sms.num.send");
        param.put("app_key", SystemConfig.Sms.SMS_KEY);
        param.put("timestamp", DateUtils.formatDate((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
        param.put("format", "json");
        param.put("v", "2.0");
        param.put("sign_method", "md5");
        param.put("sms_type", "normal");
        param.put("rec_num", mobile);
        param.put("sms_template_code", templateCode);
        param.put("sms_free_sign_name", SystemConfig.Sms.SMS_PRODUCTNAME);
        param.put("sms_param", JSONUtil.objToStr(data));
        String sign = TaobaoApiSignUtil.sign(param, (String)SystemConfig.Sms.SMS_SECRET);
        param.put("sign", sign);
        String res = HttpsUtils.httpsGetForSms((String)"https://eco.taobao.com/router/rest", param, (String)"UTF-8");
        logger.info(res);
        if (StringUtils.isNotBlank((CharSequence)res) && JSON.parseObject((String)res).getJSONObject("alibaba_aliqin_fc_sms_num_send_response").getJSONObject("result").getBoolean("success").booleanValue()) {
            return true;
        }
        logger.error("\u963f\u91cc\u5927\u9c7c\u8fd4\u56de\u4fe1\u606f:" + res);
        return false;
    }

    @Override
    public Boolean checkRand(HttpSession session, String rand) {
        String saveRand = (String)session.getAttribute("rand");
        if (rand != null && saveRand.equals(rand)) {
            return true;
        }
        return false;
    }

    @Override
    public Object getRegions(Integer regionId) {
        List list = this.tRegionDao.findListByFid(regionId);
        return JSONUtil.objToStr((Object)list);
    }

    @Override
    public List<TRegion> getRegionList() {
        List list = this.tRegionDao.findRegionList();
        return list;
    }

    @Override
    public List<TRegion> getCitys(Integer regionId) {
        List list = this.tRegionDao.findListCitys(regionId);
        return list;
    }

    @Override
    public TRegion findCityById(Integer id) {
        TRegion tRegion = this.tRegionDao.findCityById(id);
        return tRegion;
    }
}

