/*
 * Decompiled with CFR 0.152.
 */
package com.talkilla.result.wechat;

import com.talkilla.constant.SubjectType;
import com.talkilla.mysql.domain.TNation;
import com.talkilla.mysql.domain.TSysdict;
import com.talkilla.mysql.domain.TTeacher;
import java.time.Instant;
import java.time.LocalDate;
import java.time.Period;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import org.springframework.beans.BeanUtils;

public class TeacherDetailResult
extends TTeacher {
    private List<String> typeList = new ArrayList<String>();
    private int age = 0;
    private String countryName = "";
    private String typeName = "";

    public TeacherDetailResult(TTeacher tTeacher, List<TNation> nations, List<TSysdict> teacherFenlei) {
        ZoneId zoneId = ZoneId.systemDefault();
        Instant now = Instant.now();
        BeanUtils.copyProperties((Object)tTeacher, (Object)this);
        if (this.getBirthday() != null) {
            LocalDate birthdayDate = this.getBirthday().toInstant().atZone(zoneId).toLocalDate();
            Period between = Period.between(birthdayDate, now.atZone(zoneId).toLocalDate());
            this.age = between.getYears();
        }
        if (this.getSubject() != null && this.getSubject() > 0) {
            Stream.of(SubjectType.values()).forEach(subjectType -> {
                if ((subjectType.code & this.getSubject()) > 0) {
                    this.typeList.add(subjectType.cname);
                }
            });
        }
        if (this.getCountry() != null && this.getCountry() > 0) {
            this.countryName = nations.stream().filter(tNation -> tNation.getWaterid().equals(this.getCountry())).findAny().orElseGet(() -> new TNation()).getName();
        }
        if (this.getTeacherType() != null && this.getTeacherType() > 0) {
            this.typeName = teacherFenlei.stream().filter(tSysdict -> tSysdict.getDictid().equals(this.getTeacherType())).findAny().orElseGet(() -> new TSysdict()).getDictname();
        }
    }

    public List<String> getTypeList() {
        return this.typeList;
    }

    public void setTypeList(List<String> typeList) {
        this.typeList = typeList;
    }

    public int getAge() {
        return this.age;
    }

    public void setAge(int age) {
        this.age = age;
    }

    public String getCountryName() {
        return this.countryName;
    }

    public void setCountryName(String countryName) {
        this.countryName = countryName;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }
}

