/*
 * Decompiled with CFR 0.152.
 */
package com.talkilla.result.teacher;

import com.talkilla.otherbean.TTeacherWorkTimeBean;
import com.talkilla.utils.DateUtils;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Period;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class TeacherWorkTimeResult {
    private List<DateTitle> dateTitles;
    private List<TimeRangeId> timeRangeIds;
    private Map<String, List<TimeItem>> timeList;

    public List<DateTitle> getDateTitles() {
        return this.dateTitles;
    }

    public void setDateTitles(List<DateTitle> dateTitles) {
        this.dateTitles = dateTitles;
    }

    public List<TimeRangeId> getTimeRangeIds() {
        return this.timeRangeIds;
    }

    public void setTimeRangeIds(List<TimeRangeId> timeRangeIds) {
        this.timeRangeIds = timeRangeIds;
    }

    public void setTimeList(Map<String, List<TimeItem>> timeList) {
        this.timeList = timeList;
    }

    public Map<String, List<TimeItem>> getTimeList() {
        return this.timeList;
    }

    public static void main(String[] args) {
        Date now = new Date();
        long between = ChronoUnit.HOURS.between(now.toInstant(), org.apache.commons.lang.time.DateUtils.addDays((Date)now, (int)-1).toInstant());
        System.out.println(between);
    }

    public static class TimeItem {
        private String id;
        private int status;

        public TimeItem(TTeacherWorkTimeBean bean) {
            this.status = bean.getStatus();
            this.id = bean.getDay() + "-" + bean.getTimeRangeId();
        }

        public String getId() {
            return this.id;
        }

        public int getStatus() {
            return this.status;
        }
    }

    public static class DateTitle {
        private int weekDay;
        private String weekDayName;
        private String dayName;
        private String date;

        public DateTitle(Date date) {
            this.date = DateUtils.formatDate((Date)date, (String)"yyyyMMdd");
            this.weekDay = date.toInstant().atZone(ZoneId.systemDefault()).getDayOfWeek().getValue();
            this.weekDayName = DateUtils.getEnglishWeekNumberOfDate((Date)date);
            this.dayName = DateUtils.formatDate((Date)date, (String)"MM-dd");
        }

        public int getWeekDay() {
            return this.weekDay;
        }

        public String getWeekDayName() {
            return this.weekDayName;
        }

        public String getDayName() {
            return this.dayName;
        }

        public String getDate() {
            return this.date;
        }
    }

    public class TimeRangeId {
        private int rangeId;
        private String bjStart;
        private String bjEnd;
        private String teaStart;
        private String teaEnd;
        private int dayDiffence;

        public TimeRangeId(int rangeId, Long between) {
            this.rangeId = rangeId;
            if (rangeId % 2 != 0) {
                this.bjStart = rangeId / 2 + ":00";
                this.bjEnd = rangeId / 2 + ":30";
            } else {
                this.bjStart = rangeId / 2 - 1 + ":30";
                this.bjEnd = rangeId / 2 + ":00";
            }
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm");
            try {
                Date dateBjEnd = dateFormat.parse("2017-12-12 " + this.bjEnd);
                Date dateBjStart = dateFormat.parse("2017-12-12 " + this.bjStart);
                Date dateTeaEnd = org.apache.commons.lang.time.DateUtils.addMinutes((Date)dateBjEnd, (int)between.intValue());
                Date dateTeaStart = org.apache.commons.lang.time.DateUtils.addMinutes((Date)dateFormat.parse("2017-12-12 " + this.bjStart), (int)between.intValue());
                this.teaStart = DateUtils.formatDate((Date)dateTeaStart, (String)"HH:mm");
                this.teaEnd = DateUtils.formatDate((Date)dateTeaEnd, (String)"HH:mm");
                ZoneId zoneId = ZoneId.systemDefault();
                int days = Period.between(dateBjStart.toInstant().atZone(zoneId).toLocalDate(), dateTeaStart.toInstant().atZone(zoneId).toLocalDate()).getDays();
                if (days < 0) {
                    this.dayDiffence = -1;
                }
                if (days > 0) {
                    this.dayDiffence = 1;
                }
            }
            catch (ParseException e) {
                throw new RuntimeException(e);
            }
        }

        public String getTeaEnd() {
            return this.teaEnd;
        }

        public int getRangeId() {
            return this.rangeId;
        }

        public String getBjStart() {
            return this.bjStart;
        }

        public String getBjEnd() {
            return this.bjEnd;
        }

        public String getTeaStart() {
            return this.teaStart;
        }

        public int getDayDiffence() {
            return this.dayDiffence;
        }
    }
}

