/*
 * Decompiled with CFR 0.152.
 */
package com.talkilla.mysql.sql;

import com.talkilla.form.admin.AdminCoursePackageQueryForm;
import com.talkilla.form.admin.AdminNeedPayStudentListForm;
import com.talkilla.form.admin.AdminTeachingRecordsForm;
import com.talkilla.form.student.CourseListForm;
import com.talkilla.form.wechat.TAwardCourseRecordForm;
import com.talkilla.utils.DateUtils;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TcourseDaoSqlProvider {
    private static final Logger logger = LoggerFactory.getLogger(TcourseDaoSqlProvider.class);
    private static SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    public String findCourceNameAtPresent(Integer stuId) {
        StringBuffer sql = new StringBuffer();
        sql.append(" select group_concat(distinct a.classname) couteachingRecordListrceNameStr,group_concat(distinct a.cid) cidStr ");
        sql.append(" from t_course a join t_course_student on t_course_student.course_id = a.cid and t_course_student.is_delete = 0  ");
        sql.append(" left join t_coursesession b on a.cid = b.cid and b.is_delete = 0  ");
        sql.append("  where b.starttime >= '" + sdf.format(new Date()) + "' ");
        sql.append(" and t_course_student.student_id =  " + stuId);
        sql.append(" and a.is_delete = 0 ");
        sql.append(" and b.is_delete = 0 ");
        String sqlResult = sql.toString();
        logger.debug("\u901a\u8fc7Provider\u62fc\u63a5\u597d\u7684SQL-->{}", (Object)sqlResult);
        return sqlResult;
    }

    public String findCourcesessionCompleted(String cidStr) {
        StringBuffer sql = new StringBuffer();
        sql.append(" select count(1) ");
        sql.append(" from t_coursesession ");
        sql.append("  where starttime >= '" + sdf.format(new Date()) + "' ");
        sql.append(" and cid in (" + cidStr + ") ");
        sql.append(" and ( status = 101001 or status=101005 ) ");
        sql.append(" and is_delete = 0 ");
        String sqlResult = sql.toString();
        logger.debug("\u901a\u8fc7Provider\u62fc\u63a5\u597d\u7684SQL-->{}", (Object)sqlResult);
        return sqlResult;
    }

    public String findCourcesessionUnCompleted(String cidStr) {
        StringBuffer sql = new StringBuffer();
        sql.append(" select count(1) ");
        sql.append(" from t_coursesession ");
        sql.append("  where starttime >= '" + sdf.format(new Date()) + "' ");
        sql.append(" and cid in (" + cidStr + ") ");
        sql.append(" and status is null ");
        sql.append(" and is_delete = 0 ");
        String sqlResult = sql.toString();
        logger.debug("\u901a\u8fc7Provider\u62fc\u63a5\u597d\u7684SQL-->{}", (Object)sqlResult);
        return sqlResult;
    }

    public String findCourcessionCompletedNoFeedback(int cidStr) {
        StringBuffer sql = new StringBuffer();
        sql.append(" select count(1) ");
        sql.append(" from t_coursesession a");
        sql.append(" left join t_teacher_comments b on a.sessionid=b.sessionid and b.is_delete=0 ");
        sql.append(" left join t_stu_feeback c on a.sessionid=c.sessionid ");
        sql.append("  where 1=1 and ");
        sql.append(" and  b.sessionid is not null ");
        sql.append(" and  c.sessionid is  null ");
        sql.append(" and a.starttime >= '" + sdf.format(new Date()) + "' ");
        sql.append(" and a.cid in (" + cidStr + ") ");
        sql.append(" and a.status =101001  ");
        sql.append(" and a.is_delete = 0 ");
        sql.append(" and c.is_delete = 0 ");
        String sqlResult = sql.toString();
        logger.debug("\u901a\u8fc7Provider\u62fc\u63a5\u597d\u7684SQL-->{}", (Object)sqlResult);
        return sqlResult;
    }

    public String courseList(CourseListForm form) {
        StringBuffer sql = new StringBuffer();
        sql.append("select cid,classname,hourpurchase,hourawarded,hourcomplete,hourpending,duration ");
        sql.append(" from t_course a join t_course_student on t_course_student.course_id = a.cid and t_course_student.is_delete = 0 ");
        sql.append(" left join t_teacher b on a.teacher_id=b.teacher_id ");
        sql.append(" where 1=1 and ");
        if (StringUtils.isNotEmpty((String)form.getClassid())) {
            sql.append(" a.classid like concat('%',#{classid},'%') and ");
        }
        if (StringUtils.isNotEmpty((String)form.getClassname())) {
            sql.append(" a.classname like concat('%',#{classname},'%') and ");
        }
        if (StringUtils.isNotEmpty((String)form.getFirstname())) {
            sql.append(" b.first_name like concat('%',#{firstname},'%') and ");
        }
        sql.append(" t_course_student.student_id=#{stuId} and ");
        sql.append(" a.is_delete=0 and");
        sql.append(" b.is_delete=0 ");
        String sqlResult = sql.toString();
        logger.debug("\u901a\u8fc7Provider\u62fc\u63a5\u597d\u7684SQL-->{}", (Object)sqlResult);
        return sqlResult;
    }

    public String needPayStudentList(AdminNeedPayStudentListForm form) {
        Integer teachStatus;
        Integer reportStatus;
        Integer renewStatus;
        StringBuffer sql = new StringBuffer();
        sql.append(" \n select group_concat(distinct a.stu_name) as real_name, group_concat(distinct b.parent_name) as parent_name,group_concat(distinct b.phone) as phone,group_concat(distinct b.english_name) as english_name,(a.hourpending*60/a.duration)  as sessions,a.cid,a.notes,a.hourpending, a.classname,a.classid,a.is_renew,a.is_report,b.weixinhao,b.skypeid,MAX(d.starttime) as time,CONCAT(c.first_name,' ',c.last_name) as teacherName,a.renew_status,a.report_status,a.teach_status  from                 t_coursesession d \n left join t_course a on a.cid = d.cid and d.is_delete = 0 join t_course_student on t_course_student.course_id = a.cid and t_course_student.is_delete = 0 \n left join t_teacher c on a.teacher_id = c.teacher_id\n left join t_student b on t_course_student.student_id = b.stu_id\n where  a.is_delete = 0   ");
        boolean isQuery = false;
        if (StringUtils.isNotEmpty((String)form.getClassid())) {
            sql.append(" and a.classid like concat('%',#{classid},'%')");
            isQuery = true;
        }
        if (StringUtils.isNotEmpty((String)form.getStuname())) {
            sql.append(" and b.real_name like concat('%',#{stuname},'%')");
            isQuery = true;
        }
        if (StringUtils.isNotEmpty((String)form.getEnglishName())) {
            sql.append(" and b.english_name like concat('%',#{englishName},'%')");
            isQuery = true;
        }
        if (StringUtils.isNotEmpty((String)form.getFirstname())) {
            sql.append(" and c.first_name like concat('%',#{firstname},'%')");
            isQuery = true;
        }
        if (!isQuery) {
            sql.append(" and (a.is_renew = 0 or is_report = 0 )");
        }
        if (Objects.nonNull(renewStatus = form.getRenewStatus())) {
            sql.append(" and a.renew_status = #{renewStatus}");
        }
        if (Objects.nonNull(reportStatus = form.getReportStatus())) {
            sql.append(" and a.report_status = #{reportStatus}");
        }
        if (Objects.nonNull(teachStatus = form.getTeachStatus())) {
            sql.append(" and a.teach_status = #{teachStatus}");
        }
        sql.append(" group by a.cid having time > '2018-01-01'  \n");
        Date lastClassSearchTime = form.getLastClassSearchTime();
        if (lastClassSearchTime != null) {
            String date = DateUtils.formatDate((Date)lastClassSearchTime, (String)"yyyy-MM");
            sql.append(" and DATE_FORMAT(time,'%Y-%m') = '" + date + "'");
        }
        sql.append("  order by time asc,sessions asc,d.starttime desc  \n");
        String sqlResult = sql.toString();
        logger.debug("\u901a\u8fc7Provider\u62fc\u63a5\u597d\u7684SQL-->{}", (Object)sqlResult);
        return sqlResult;
    }

    public String findCourse(Integer cid) {
        StringBuffer sql = new StringBuffer();
        sql.append(" select a.cid,a.classid,a.classname,a.duration,a.stu_name realName,a.stu_en_name englishName,c.first_name firstName,c.last_name lastName");
        sql.append(" from t_course a join t_course_student on t_course_student.course_id = a.cid and t_course_student.is_delete = 0 ");
        sql.append(" left join t_teacher c on a.teacher_id = c.teacher_id ");
        sql.append(" where a.cid = #{cid}");
        sql.append(" and a.is_delete = 0 ");
        sql.append(" and c.is_delete = 0 limit 1 ");
        String sqlResult = sql.toString();
        logger.debug("\u901a\u8fc7Provider\u62fc\u63a5\u597d\u7684SQL-->{}", (Object)sqlResult);
        return sqlResult;
    }

    public String findCourseCopy(Integer cid) {
        StringBuffer sql = new StringBuffer();
        sql.append(" select a.cid,a.classid,a.classname,a.duration,b.real_name realName,b.english_name englishName,c.first_name firstName,c.last_name lastName");
        sql.append(" from t_course a join t_course_student on t_course_student.course_id = a.cid and t_course_student.is_delete = 0 ");
        sql.append(" left join t_student b on t_course_student.student_id = b.stu_id ");
        sql.append(" left join t_teacher c on a.teacher_id = c.teacher_id ");
        sql.append(" where a.cid = #{cid}");
        sql.append(" and a.is_delete = 0 ");
        sql.append(" and b.is_delete = 0 ");
        sql.append(" and c.is_delete = 0 ");
        String sqlResult = sql.toString();
        logger.debug("\u901a\u8fc7Provider\u62fc\u63a5\u597d\u7684SQL-->{}", (Object)sqlResult);
        return sqlResult;
    }

    public String teachingRecordList(AdminTeachingRecordsForm form) {
        StringBuffer sql = new StringBuffer();
        sql.append(" select a.classid,a.classname,a.type,a.duration,e.starttime,e.sessionid,e.status,e.note,b.teacher_id,concat(b.first_name,\"  \",b.last_name) as teachername,b.timezone, concat(e.stu_name,'/',e.stu_en_name)  as stuname ");
        sql.append(" from  t_coursesession e ");
        sql.append(" left join t_course a on e.cid = a.cid join t_course_student on t_course_student.course_id = a.cid and t_course_student.is_delete = 0 ");
        sql.append(" left join t_teacher b on e.teacher_id = b.teacher_id and b.is_delete = 0  ");
        sql.append(" where 1=1 and e.is_delete = 0 ");
        if (StringUtils.isNotEmpty((String)form.getStudentename())) {
            sql.append(" and e.stu_en_name like concat('%',#{studentename},'%') ");
        }
        if (StringUtils.isNotEmpty((String)form.getStudentname())) {
            sql.append(" and e.stu_name like concat('%',#{studentname},'%') ");
        }
        if (StringUtils.isNotEmpty((String)form.getClassid())) {
            sql.append(" and a.classid like concat('%',#{classid},'%') ");
        }
        if (StringUtils.isNotEmpty((String)form.getFirstname())) {
            sql.append(" and b.first_name like concat('%',#{firstname},'%') ");
        }
        if (StringUtils.isNotEmpty((String)form.getLastname())) {
            sql.append(" and b.last_name like concat('%',#{lastname},'%') ");
        }
        if (form.getStartDate() != null) {
            sql.append(" and e.starttime >= #{startDate} ");
        }
        if (form.getEndDate() != null) {
            sql.append(" and e.starttime <= #{endDate} ");
        }
        if (form.getDayStart() != null) {
            sql.append(" and e.starttime between #{dayStart} and #{dayEnd} ");
        }
        if (form.getStatus() != null && !form.getStatus().equals(0)) {
            sql.append(" and e.status = #{status} ");
        }
        if (form.getRepetitionQuery() != null && form.getRepetitionQuery().booleanValue()) {
            sql.append("  and exists ( select count(*) as count from t_coursesession where  teacher_id =  e.teacher_id  and starttime = e.starttime and is_delete = 0  having count > 1) ");
        }
        sql.append("group by e.sessionid ");
        if (form.getRepetitionQuery() != null && form.getRepetitionQuery().booleanValue()) {
            sql.append("order by e.teacher_id,  e.starttime asc ");
        } else {
            sql.append("order by  e.starttime asc ");
        }
        String sqlResult = sql.toString();
        logger.debug("\u901a\u8fc7Provider\u62fc\u63a5\u597d\u7684SQL-->{}", (Object)sqlResult);
        return sqlResult;
    }

    public String teachingRecordListCopy(AdminTeachingRecordsForm form) {
        StringBuffer sql = new StringBuffer();
        sql.append(" select a.classid,a.classname,a.type,a.duration,e.starttime,e.sessionid,e.status,e.note,b.teacher_id,concat(b.first_name,\"  \",b.last_name) as teachername,b.timezone,stu.real_name as stuname ");
        sql.append(" from  t_coursesession e ");
        sql.append(" left join t_course a on e.cid = a.cid join t_course_student on t_course_student.course_id = a.cid and t_course_student.is_delete = 0 ");
        sql.append(" left join t_teacher b on e.teacher_id = b.teacher_id and b.is_delete = 0  ");
        sql.append(" left join t_student stu on t_course_student.student_id = stu.stu_id and stu.is_delete = 0 ");
        sql.append(" where 1=1 and e.is_delete = 0 ");
        if (StringUtils.isNotEmpty((String)form.getStudentename())) {
            sql.append(" and stu.english_name like concat('%',#{studentename},'%') ");
        }
        if (StringUtils.isNotEmpty((String)form.getStudentname())) {
            sql.append(" and stu.real_name like concat('%',#{studentname},'%') ");
        }
        if (StringUtils.isNotEmpty((String)form.getClassid())) {
            sql.append(" and a.classid like concat('%',#{classid},'%') ");
        }
        if (StringUtils.isNotEmpty((String)form.getFirstname())) {
            sql.append(" and b.first_name like concat('%',#{firstname},'%') ");
        }
        if (StringUtils.isNotEmpty((String)form.getLastname())) {
            sql.append(" and b.last_name like concat('%',#{lastname},'%') ");
        }
        if (form.getStartDate() != null) {
            sql.append(" and e.starttime >= #{startDate} ");
        }
        if (form.getEndDate() != null) {
            sql.append(" and e.starttime <= #{endDate} ");
        }
        if (form.getDayStart() != null) {
            sql.append(" and e.starttime between #{dayStart} and #{dayEnd} ");
        }
        if (form.getStatus() != null && !form.getStatus().equals(0)) {
            sql.append(" and e.status = #{status} ");
        }
        sql.append("order by  e.starttime asc ");
        String sqlResult = sql.toString();
        logger.debug("\u901a\u8fc7Provider\u62fc\u63a5\u597d\u7684SQL-->{}", (Object)sqlResult);
        return sqlResult;
    }

    public String findCoursePackageQuerys(AdminCoursePackageQueryForm form) {
        StringBuffer sql = new StringBuffer();
        sql.append(" select  a.* ,b.first_name,b.last_name, group_concat(distinct a.stu_name) as zname,  group_concat(distinct a.stu_en_name) as zenname ");
        sql.append(" from t_course a join t_course_student on t_course_student.course_id = a.cid and t_course_student.is_delete = 0 ");
        sql.append(" join t_teacher b on a.teacher_id = b.teacher_id and b.is_delete = 0 and a.is_delete = 0  ");
        sql.append(" where 1=1 ");
        if (StringUtils.isNotEmpty((String)form.getClassname())) {
            sql.append(" and a.classname like concat('%',#{classname},'%')");
        }
        if (form.getType() != null) {
            sql.append(" and a.type = #{type} ");
        }
        if (form.getIsdelete() != null) {
            sql.append(" and a.is_delete = #{isdelete} ");
        }
        if (StringUtils.isNotEmpty((String)form.getStuname())) {
            sql.append(" and a.stu_name like concat('%',#{stuname},'%') ");
        }
        if (StringUtils.isNotEmpty((String)form.getFirstname())) {
            sql.append(" and b.first_name like concat('%',#{firstname},'%') ");
        }
        if (StringUtils.isNotEmpty((String)form.getLastname())) {
            sql.append(" and b.last_name like concat('%',#{lastname},'%') ");
        }
        if (StringUtils.isNotEmpty((String)form.getClassid())) {
            sql.append(" and a.classid like concat('%',#{classid},'%') ");
        }
        if (StringUtils.isNotEmpty((String)form.geteName())) {
            sql.append(" and a.stu_en_name like concat('%',#{eName},'%') ");
        }
        sql.append(" group by a.cid order by a.create_time desc");
        String sqlResult = sql.toString();
        logger.debug("\u901a\u8fc7Provider\u62fc\u63a5\u597d\u7684SQL-->{}", (Object)sqlResult);
        return sqlResult;
    }

    public String findErrorCoursePackageQuerys(AdminCoursePackageQueryForm form) {
        StringBuffer sql = new StringBuffer();
        sql.append(" select  a.* ,b.first_name,b.last_name, group_concat(distinct a.stu_name) as zname,  group_concat(distinct a.stu_en_name) as zenname ");
        sql.append(" from t_course a join t_course_student on t_course_student.course_id = a.cid and t_course_student.is_delete = 0 ");
        sql.append(" join t_teacher b on a.teacher_id = b.teacher_id and b.is_delete = 0 and a.is_delete = 0  ");
        sql.append(" where 1=1  and (a.hourpurchase + a.hourawarded) != a.totalhour\nor (a.hourcomplete + a.hourpending) != a.totalhour ");
        if (StringUtils.isNotEmpty((String)form.getClassname())) {
            sql.append(" and a.classname like concat('%',#{classname},'%')");
        }
        if (form.getType() != null) {
            sql.append(" and a.type = #{type} ");
        }
        if (form.getIsdelete() != null) {
            sql.append(" and a.is_delete = #{isdelete} ");
        }
        if (StringUtils.isNotEmpty((String)form.getStuname())) {
            sql.append(" and a.stu_name like concat('%',#{stuname},'%') ");
        }
        if (StringUtils.isNotEmpty((String)form.getFirstname())) {
            sql.append(" and b.first_name like concat('%',#{firstname},'%') ");
        }
        if (StringUtils.isNotEmpty((String)form.getLastname())) {
            sql.append(" and b.last_name like concat('%',#{lastname},'%') ");
        }
        if (StringUtils.isNotEmpty((String)form.getClassid())) {
            sql.append(" and a.classid like concat('%',#{classid},'%') ");
        }
        if (StringUtils.isNotEmpty((String)form.geteName())) {
            sql.append(" and a.stu_en_name like concat('%',#{eName},'%') ");
        }
        sql.append(" group by a.cid order by a.create_time desc");
        String sqlResult = sql.toString();
        logger.debug("\u901a\u8fc7Provider\u62fc\u63a5\u597d\u7684SQL-->{}", (Object)sqlResult);
        return sqlResult;
    }

    public String findCoursePackageQuerysCopy(AdminCoursePackageQueryForm form) {
        StringBuffer sql = new StringBuffer();
        sql.append(" select  a.* ,b.first_name,b.last_name,group_concat(distinct CONCAT(c.real_name,'/',c.english_name)) as zname ");
        sql.append(" from t_course a join t_course_student on t_course_student.course_id = a.cid and t_course_student.is_delete = 0 ");
        sql.append(" join t_teacher b on a.teacher_id = b.teacher_id and b.is_delete = 0 and a.is_delete = 0  ");
        sql.append(" left join t_student c on t_course_student.student_id = c.stu_id and c.is_delete = 0  ");
        sql.append(" where 1=1 ");
        if (StringUtils.isNotEmpty((String)form.getClassname())) {
            sql.append(" and a.classname like concat('%',#{classname},'%')");
        }
        if (form.getType() != null) {
            sql.append(" and a.type = #{type} ");
        }
        if (form.getIsdelete() != null) {
            sql.append(" and a.is_delete = #{isdelete} ");
        }
        if (StringUtils.isNotEmpty((String)form.getStuname())) {
            sql.append(" and c.real_name like concat('%',#{stuname},'%') ");
        }
        if (StringUtils.isNotEmpty((String)form.getFirstname())) {
            sql.append(" and b.first_name like concat('%',#{firstname},'%') ");
        }
        if (StringUtils.isNotEmpty((String)form.getLastname())) {
            sql.append(" and b.last_name like concat('%',#{lastname},'%') ");
        }
        if (StringUtils.isNotEmpty((String)form.getClassid())) {
            sql.append(" and a.classid like concat('%',#{classid},'%') ");
        }
        if (StringUtils.isNotEmpty((String)form.geteName())) {
            sql.append(" and c.english_name like concat('%',#{eName},'%') ");
        }
        sql.append(" group by a.cid order by a.create_time desc");
        String sqlResult = sql.toString();
        logger.debug("\u901a\u8fc7Provider\u62fc\u63a5\u597d\u7684SQL-->{}", (Object)sqlResult);
        return sqlResult;
    }

    public static void main(String[] args) {
        TcourseDaoSqlProvider tcourseDaoSqlProvider = new TcourseDaoSqlProvider();
    }

    public String findTAwardCourseRecordList(TAwardCourseRecordForm form) {
        StringBuffer sql = new StringBuffer();
        sql.append(" select * from t_award_course_record where ");
        sql.append(" stu_id = #{stuId} ");
        sql.append(" and is_delete = 0 order by create_time desc ");
        String sqlResult = sql.toString();
        logger.debug("\u901a\u8fc7Provider\u62fc\u63a5\u597d\u7684SQL-->{}", (Object)sqlResult);
        return sqlResult;
    }
}

