/*
 * Decompiled with CFR 0.152.
 */
package com.talkilla.mysql.sql;

import com.talkilla.form.SearchStudentsForm;
import com.talkilla.form.teacher.StudentListForm;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.ibatis.jdbc.SQL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TStudentDaoSqlProvider {
    private static final Logger logger = LoggerFactory.getLogger(TStudentDaoSqlProvider.class);

    public String studentList(StudentListForm form) {
        StringBuffer sql = new StringBuffer();
        sql.append("select a.stu_id,a.english_name,a.avatar  ");
        sql.append(" from t_student a ");
        sql.append(" left join t_course_student b  on a.stu_id = b.student_id and b.is_delete = 0  ");
        sql.append(" left join t_course c on c.cid = b.course_id ");
        sql.append(" where 1=1 ");
        sql.append(" and c.teacher_id=#{teacherId} ");
        sql.append(" and c.is_delete=0 ");
        sql.append(" and a.is_delete=0 ");
        if (StringUtils.isNotBlank((String)form.getEnglishName())) {
            sql.append(" and a.english_name like '%" + form.getEnglishName() + "%'");
        }
        sql.append(" GROUP BY a.stu_id ");
        String sqlResult = sql.toString();
        logger.debug("\u901a\u8fc7Provider\u62fc\u63a5\u597d\u7684SQL-->{}", (Object)sqlResult);
        return sqlResult;
    }

    public String findCourseStudentList(Map<String, Integer> param) {
        StringBuffer sql = new StringBuffer();
        sql.append("select a.student_id,b.real_name,b.english_name from t_course_student a join t_student b on a.student_id=b.stu_id and a.is_delete = 0  where true ");
        if (null != param.get("cid")) {
            sql.append("and a.course_id=#{cid}");
        }
        sql.append(" GROUP BY a.student_id ");
        String sqlResult = sql.toString();
        logger.debug("\u901a\u8fc7Provider\u62fc\u63a5\u597d\u7684SQL-->{}", (Object)sqlResult);
        return sqlResult;
    }

    public String findCourseStudentList2(Map<String, Integer> param) {
        StringBuffer sql = new StringBuffer();
        sql.append("select a.student_id,b.real_name,b.english_name from t_course_student a join t_student b on a.student_id=b.stu_id and a.is_delete = 0  where true ");
        if (null != param.get("cid")) {
            sql.append("and a.course_id=#{cid}");
        }
        sql.append(" GROUP BY a.student_id ");
        String sqlResult = sql.toString();
        logger.debug("\u901a\u8fc7Provider\u62fc\u63a5\u597d\u7684SQL-->{}", (Object)sqlResult);
        return sqlResult;
    }

    public String studentDetailList(Map<String, Object> param) {
        StringBuffer sql = new StringBuffer();
        sql.append(" select *,z.total*(z.duration/60.0)*z.rate as money , z.total*(z.duration/60.0) as completedHours ,(z.hourpurchase+z.hourawarded-z.total*z.duration)/60.0 as pendingHours ");
        sql.append(" from ( ");
        sql.append(" select  a.stu_id,a.english_name,b.classid,b.classname,b.trainingmaterials,b.hourpurchase,b.hourawarded,b.duration,b.rate,b.notes,count(c.sessionid) total");
        sql.append(" from t_student a ");
        sql.append(" left join t_course_student on t_course_student.student_id = a.stu_id and t_course_student.is_delete = 0  left join t_course b on t_course_student.course_id = b.cid ");
        sql.append(" left join t_coursesession c on b.cid = c.cid ");
        sql.append(" where 1=1 ");
        sql.append(" and b.is_delete = 0 ");
        sql.append(" and c.ispay = 1 and c.status = 101001");
        sql.append(" and b.teacher_id = #{teacherId} ");
        sql.append(" and a.stu_id = #{stuId} ");
        sql.append(" group by a.stu_id,b.cid ");
        sql.append("  ) z ");
        String sqlResult = sql.toString();
        logger.debug("\u901a\u8fc7Provider\u62fc\u63a5\u597d\u7684SQL-->{}", (Object)sqlResult);
        return sqlResult;
    }

    public String findNewQuerysStudent(Map<String, String> param) {
        StringBuffer sql = new StringBuffer();
        sql.append(" select a.stu_id stuId ,a.login_id loginId,a.real_name realname,a.english_name englishname,a.gender stugender,a.parent_name parentname,a.phone phone,a.avatar photoPath,a.birthday birthday,a.city stucity,a.skypeid stuskypeid,a.age age,a.tag tag, b.login_name from t_student a join t_login b on a.login_id = b.login_id\n      join t_course_student on t_course_student.student_id  = a.stu_id and t_course_student.is_delete = 0   join t_course  c  on  t_course_student.course_id = c.cid  \n        where 1 = 1 ");
        if (StringUtils.isNotBlank((String)param.get("startDate"))) {
            sql.append("and c.createdate  >= #{startDate}");
        }
        if (StringUtils.isNotBlank((String)param.get("endDate"))) {
            sql.append("and c.createdate  < #{endDate}");
        }
        String sqlResult = sql.toString();
        logger.debug("\u901a\u8fc7Provider\u62fc\u63a5\u597d\u7684SQL-->{}", (Object)sqlResult);
        return sqlResult;
    }

    public String findQueryStudentList(Map<String, String> param) {
        StringBuffer sql = new StringBuffer();
        sql.append(" select IFNULL(c.course_num,0) as courseNum,a.remark,a.stu_id stuId ,a.login_id loginId,b.login_name loginName,a.real_name realname,a.english_name englishname,a.gender stugender,a.parent_name parentname,a.recommend_id,a.recommend_type,a.phone phone,a.avatar photoPath,a.birthday birthday,a.city stucity,a.skypeid stuskypeid,a.age age,a.tag tag,a.create_time create_time, b.login_name,a.weixinhao from t_student a left join t_login b on a.login_id = b.login_id\n        left join t_award_course  c  on c.stu_id  = a.stu_id\n        where 1 = 1  and a.is_delete = 0 ");
        if (StringUtils.isNotBlank((String)param.get("name"))) {
            sql.append("and a.real_name like '%" + param.get("name") + "%'");
        }
        if (StringUtils.isNotBlank((String)param.get("eName"))) {
            sql.append("and a.english_name like '%" + param.get("eName") + "%'");
        }
        if (StringUtils.isNotBlank((String)param.get("phone"))) {
            sql.append("and a.phone like '%" + param.get("phone") + "%'");
        }
        if (StringUtils.isNotBlank((String)param.get("stugender"))) {
            sql.append("and a.gender = #{stugender}");
        }
        if (StringUtils.isNotBlank((String)param.get("weixinhao"))) {
            sql.append("and a.weixinhao  like '%" + param.get("weixinhao") + "%'");
        }
        if (StringUtils.isNotBlank((String)param.get("tag"))) {
            sql.append("and a.tag = #{tag}");
        }
        if (StringUtils.isNotBlank((String)param.get("email"))) {
            sql.append("and a.consultant_email = #{email}");
        }
        if (StringUtils.isNotBlank((String)param.get("startDate"))) {
            sql.append("and b.create_time  >= #{startDate}");
        }
        if (StringUtils.isNotBlank((String)param.get("endDate"))) {
            sql.append("and b.create_time  < #{endDate}");
        }
        sql.append(" order by a.create_time desc");
        String sqlResult = sql.toString();
        logger.debug("\u901a\u8fc7Provider\u62fc\u63a5\u597d\u7684SQL-->{}", (Object)sqlResult);
        return sqlResult;
    }

    public String findStudentCourseList(Map<String, String> param) {
        StringBuffer sql = new StringBuffer();
        sql.append(" select a.cid,e.teacher_id,a.classname,a.classid,a.type,a.trainingmaterials,a.frequency,e.duration,a.hourpurchase,a.hourawarded, a.hourcomplete,a.hourpending,a.is_delete,a.notes,a.rate,a.delayday,a.createdate,a.packageprice, a.sell_course_order_id ,e.starttime,b.first_name,b.last_name,b.timezone,e.status, e.sessionid,e.isgenerate,e.isconfirm,e.ispay,CONCAT(d.real_name,'/',a.stu_en_name ) as realname,a.stu_name as zname,a.stu_en_name as zenname  FROM t_coursesession e  left join t_course a on e.cid = a.cid join t_course_student on t_course_student.course_id = a.cid and t_course_student.is_delete = 0   left join t_teacher b on e.teacher_id = b.teacher_id   left join t_student d on t_course_student.student_id = d.stu_id         where 1 = 1 ");
        if (StringUtils.isNotBlank((String)param.get("start"))) {
            sql.append(" and e.starttime  >'" + param.get("start") + "'");
        }
        if (StringUtils.isNotBlank((String)param.get("stuid"))) {
            sql.append(" and d.stu_id   =" + param.get("stuid"));
        }
        if (StringUtils.isNotBlank((String)param.get("end"))) {
            sql.append(" and e.starttime   <'" + param.get("end") + "'");
        }
        if (StringUtils.isNotBlank((String)param.get("classname"))) {
            sql.append(" and (a.classname like '%" + param.get("classname") + "%')");
        }
        if (StringUtils.isNotBlank((String)param.get("classid"))) {
            sql.append(" and (a.classid like '%" + param.get("classid") + "%')");
        }
        if (StringUtils.isNotBlank((String)param.get("isgenerate"))) {
            sql.append(" and e.isgenerate   =" + param.get("isgenerate"));
        }
        if (StringUtils.isNotBlank((String)param.get("stuname"))) {
            sql.append(" and (d.real_name   like '%" + param.get("stuname") + "%')");
        }
        if (StringUtils.isNotBlank((String)param.get("eName"))) {
            sql.append(" and (d.english_name  like '%" + param.get("eName") + "%')");
        }
        if (StringUtils.isNotBlank((String)param.get("firstname"))) {
            sql.append(" and (b.first_name   like '%" + param.get("firstname") + "%')");
        }
        if (StringUtils.isNotBlank((String)param.get("lastname"))) {
            sql.append(" and (b.last_name  like '%" + param.get("lastname") + "%')");
        }
        sql.append(" and a.is_delete = 0 and e.is_delete = 0 and d.is_delete=0  group by e.sessionid  order by  e.starttime asc");
        String sqlResult = sql.toString();
        logger.debug("\u901a\u8fc7Provider\u62fc\u63a5\u597d\u7684SQL-->{}", (Object)sqlResult);
        return sqlResult;
    }

    public String findListsbyRemoveIds(SearchStudentsForm form) {
        StringBuffer sql = new StringBuffer();
        if (StringUtils.isBlank((String)form.getPids())) {
            form.setPids("-1");
        }
        sql.append("SELECT a.*, b.*  FROM t_student a join t_login b on a.login_id = b.login_id where a.stu_id not in (" + form.getPids() + ") ");
        return this.addSearchFields(form, sql);
    }

    public String findByPids(SearchStudentsForm form) {
        StringBuffer sql = new StringBuffer();
        if (StringUtils.isBlank((String)form.getPids())) {
            form.setPids("-1");
        }
        sql.append("SELECT a.*, b.*  FROM t_student a join t_login b on a.login_id = b.login_id where a.stu_id in (" + form.getPids() + ") ");
        return this.addSearchFields(form, sql);
    }

    private String addSearchFields(SearchStudentsForm form, StringBuffer sql) {
        if (StringUtils.isNotBlank((String)form.getStudentNameOpe())) {
            sql.append("  and a.real_name like '%" + form.getStudentNameOpe() + "%'");
        }
        if (StringUtils.isNotBlank((String)form.getLoginNameOpen())) {
            sql.append("  and b.login_name like '%" + form.getLoginNameOpen() + "%'");
        }
        if (StringUtils.isNotBlank((String)form.getWeixinhao())) {
            sql.append("  and a.weixinhao like '%" + form.getWeixinhao() + "%'");
        }
        if (StringUtils.isNotBlank((String)form.getParentName())) {
            sql.append("  and a.parent_name like '%" + form.getParentName() + "%'");
        }
        if (StringUtils.isNotBlank((String)form.getEnglishName())) {
            sql.append("  and a.english_name like '%" + form.getEnglishName() + "%'");
        }
        if (StringUtils.isNotBlank((String)form.getMobile())) {
            sql.append("  and a.phone like '%" + form.getMobile() + "%'");
        }
        sql.append("and a.is_delete = 0 and b.is_delete = 0");
        String sqlResult = sql.toString();
        logger.debug("\u901a\u8fc7Provider\u62fc\u63a5\u597d\u7684SQL-->{}", (Object)sqlResult);
        return sqlResult;
    }

    public String findByStuIdList(Map<String, List<Integer>> param) {
        final List<Integer> stuIdList = param.get("stuIdList");
        return new SQL(){
            {
                this.SELECT("*");
                this.FROM("t_student");
                this.WHERE("stu_id in (" + StringUtils.join((Object[])stuIdList.toArray(), (String)",") + ")");
                ((SQL)this.AND()).WHERE("is_delete = 0");
            }
        }.toString();
    }
}

