/*
 * Decompiled with CFR 0.152.
 */
package com.talkilla.mysql.sql;

import com.talkilla.form.student.CoursesessionListForm;
import com.talkilla.form.teacher.CourseTeachingListForm;
import com.talkilla.form.teacher.FindIncomeForm;
import com.talkilla.form.wechat.CoursesessionCalenderForm;
import com.talkilla.mysql.domain.TCoursesession;
import com.talkilla.utils.sql.BatchInsertSQLBuilder;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.ibatis.jdbc.SQL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TCoursesessionDaoSqlProvider {
    private static final Logger logger = LoggerFactory.getLogger(TCoursesessionDaoSqlProvider.class);

    public String findCoursesessionListByStudentIdAndSearchDate(CoursesessionCalenderForm form) {
        SQL sql = new SQL();
        sql.SELECT("cs.*");
        sql.FROM("t_course c join t_course_student on t_course_student.course_id = c.cid and t_course_student.is_delete = 0 ");
        sql.LEFT_OUTER_JOIN("t_coursesession cs ON c.cid=cs.cid");
        sql.WHERE("FROM_UNIXTIME(UNIX_TIMESTAMP(cs.starttime),\"%Y-%m-%d\") = #{searchDate}");
        sql.WHERE("cs.is_delete = 0");
        sql.WHERE("c.is_delete = 0");
        sql.WHERE("t_course_student.student_id = #{studentId}");
        sql.ORDER_BY("cs.starttime ");
        String sqlResult = sql.toString();
        logger.debug("\u901a\u8fc7Provider\u62fc\u63a5\u597d\u7684SQL-->{}", (Object)sqlResult);
        return sqlResult;
    }

    public String findListBycidStr(String cidStr) {
        StringBuffer sql = new StringBuffer();
        sql.append(" select  b.classname,a.starttime,a.duration,a.sessionid,a.status ");
        sql.append(" from t_coursesession a ");
        sql.append(" left join t_course b on a.cid=b.cid ");
        sql.append(" where 1=1 ");
        sql.append(" and a.is_delete=0 ");
        sql.append(" and b.is_delete=0 ");
        sql.append(" and a.cid in (" + cidStr + ")");
        String sqlResult = sql.toString();
        logger.debug("\u901a\u8fc7Provider\u62fc\u63a5\u597d\u7684SQL-->{}", (Object)sqlResult);
        return sqlResult;
    }

    public String coursesessionList(CoursesessionListForm form) {
        StringBuffer sql = new StringBuffer();
        sql.append(" select a.sessionid,b.classname,a.starttime,a.duration,a.status,e.last_name,e.first_name,c.comments,d.feeback ");
        sql.append(" from t_coursesession a  ");
        sql.append(" left join t_course b on a.cid=b.cid ");
        sql.append(" left join t_teacher_comments c on c.sessionid=a.sessionid ");
        sql.append(" left join t_stu_feeback d on d.sessionid=a.sessionid ");
        sql.append(" left join t_teacher e on e.teacher_id=a.teacher_id ");
        sql.append(" where 1=1 ");
        sql.append(" and a.cid=#{cid} ");
        sql.append(" and a.is_delete=0 ");
        sql.append(" and b.is_delete=0 ");
        sql.append(" and c.is_delete=0 ");
        sql.append(" and d.is_delete=0 ");
        sql.append(" and e.is_delete=0 ");
        String sqlResult = sql.toString();
        logger.debug("\u901a\u8fc7Provider\u62fc\u63a5\u597d\u7684SQL-->{}", (Object)sqlResult);
        return sqlResult;
    }

    public String findIncome1ByTeacherId(FindIncomeForm form) {
        StringBuffer sql = new StringBuffer();
        sql.append(" select ifnull(sum((duration/60.0)*rate),0.0)  ");
        sql.append(" from t_coursesession ");
        sql.append(" where 1=1 ");
        sql.append(" and (status=101001 or status=101005) ");
        sql.append(" and starttime >= #{startTime} and starttime <= #{endTime} ");
        sql.append(" and teacher_id=#{teacherId} ");
        sql.append(" and is_delete=0 ");
        String sqlResult = sql.toString();
        logger.debug("\u901a\u8fc7Provider\u62fc\u63a5\u597d\u7684SQL-->{}", (Object)sqlResult);
        return sqlResult;
    }

    public String findIncome2ByTeacherId(FindIncomeForm form) {
        StringBuffer sql = new StringBuffer();
        sql.append(" select ifnull(sum((duration/60.0)*rate),0.0) ");
        sql.append(" from t_coursesession ");
        sql.append(" where 1=1 ");
        sql.append(" and status = 101004 ");
        sql.append(" and starttime >= #{startTime} and starttime <= #{endTime} ");
        sql.append(" and teacher_id = #{teacherId} ");
        sql.append(" and is_delete = 0 ");
        String sqlResult = sql.toString();
        logger.debug("\u901a\u8fc7Provider\u62fc\u63a5\u597d\u7684SQL-->{}", (Object)sqlResult);
        return sqlResult;
    }

    public String findListByTeacherId(Integer teacherId) {
        StringBuffer sql = new StringBuffer();
        sql.append(" select  b.classname,a.starttime,a.duration,a.sessionid,a.status,a.`stu_en_name` ");
        sql.append(" from t_coursesession a ");
        sql.append(" left join t_course b on a.cid=b.cid");
        sql.append(" where 1=1 ");
        sql.append(" and a.is_delete=0 ");
        sql.append(" and b.is_delete=0 ");
        sql.append(" and a.teacher_id=#{teacherId} ");
        String sqlResult = sql.toString();
        logger.debug("\u901a\u8fc7Provider\u62fc\u63a5\u597d\u7684SQL-->{}", (Object)sqlResult);
        return sqlResult;
    }

    public String findListByTeacherIdCopy(Integer teacherId) {
        StringBuffer sql = new StringBuffer();
        sql.append(" select  b.classname,a.starttime,a.duration,a.sessionid,a.status,ts.`english_name` ");
        sql.append(" from t_coursesession a ");
        sql.append(" left join t_course b on a.cid=b.cid join t_course_student on t_course_student.course_id = b.cid and t_course_student.is_delete = 0 ");
        sql.append("left join t_student ts on ts.stu_id = t_course_student.student_id");
        sql.append(" where 1=1 ");
        sql.append(" and a.is_delete=0 ");
        sql.append(" and b.is_delete=0 ");
        sql.append("and ts.is_delete=0");
        sql.append(" and a.teacher_id=#{teacherId} ");
        String sqlResult = sql.toString();
        logger.debug("\u901a\u8fc7Provider\u62fc\u63a5\u597d\u7684SQL-->{}", (Object)sqlResult);
        return sqlResult;
    }

    public String courseTeachingList(CourseTeachingListForm form) {
        StringBuffer sql = new StringBuffer();
        sql.append(" select a.sessionid, b.classid,b.type,a.starttime,a.stu_en_name as stunames,b.stu_id,a.duration,CASE WHEN  ( a.status = 101001 or a.status = 101005)   THEN  (a.rate*a.duration/60.0) WHEN  a.status = 101004   THEN  (a.rate*a.duration/60.0)*-1 ELSE 0 END as money,a.status,a.note");
        sql.append(" from t_coursesession a ");
        sql.append(" left join t_course b on a.cid=b.cid ");
        sql.append(" where 1=1 ");
        if (StringUtils.isNotEmpty((String)form.getStartDate())) {
            sql.append(" and a.starttime >= #{startDate} ");
        }
        if (StringUtils.isNotEmpty((String)form.getEndDate())) {
            sql.append(" and a.starttime <= #{endDate} ");
        }
        if (StringUtils.isNotEmpty((String)form.getClassid())) {
            sql.append(" and b.classid like concat('%', #{classid},'%') ");
        }
        if (StringUtils.isNotEmpty((String)form.getStuName())) {
            sql.append(" and a.stu_en_name like concat('%', #{stuName},'%') ");
        }
        sql.append(" and a.is_delete=0 ");
        sql.append(" and b.is_delete=0 ");
        sql.append(" and a.teacher_id=#{teacherId} ");
        sql.append(" order by a.starttime ");
        String sqlResult = sql.toString();
        logger.debug("\u901a\u8fc7Provider\u62fc\u63a5\u597d\u7684SQL-->{}", (Object)sqlResult);
        return sqlResult;
    }

    public String courseTeachingListForUnConfirmed(CourseTeachingListForm form) {
        StringBuffer sql = new StringBuffer();
        sql.append(" select a.sessionid, b.classid,b.type,a.starttime,a.stu_en_name as stunames,b.stu_id,a.duration,CASE WHEN  ( a.status = 101001 or a.status = 101005)   THEN  (a.rate*a.duration/60.0) WHEN  a.status = 101004   THEN  (a.rate*a.duration/60.0)*-1 ELSE 0 END as money,a.status,a.note");
        sql.append(" from t_coursesession a ");
        sql.append(" left join t_course b on a.cid=b.cid ");
        sql.append(" where 1=1 ");
        if (StringUtils.isNotEmpty((String)form.getStartDate())) {
            sql.append(" and a.starttime >= #{startDate} ");
        }
        if (StringUtils.isNotEmpty((String)form.getEndDate())) {
            sql.append(" and a.starttime <= #{endDate} ");
        }
        if (StringUtils.isNotEmpty((String)form.getClassid())) {
            sql.append(" and b.classid like concat('%', #{classid},'%') ");
        }
        if (StringUtils.isNotEmpty((String)form.getStuName())) {
            sql.append(" and a.stu_en_name like concat('%', #{stuName},'%') ");
        }
        sql.append(" and a.is_delete=0 ");
        sql.append(" and b.is_delete=0 ");
        sql.append(" and a.teacher_id=#{teacherId}  and (a.status is null or a.status = 101007)");
        sql.append(" order by a.starttime ");
        String sqlResult = sql.toString();
        logger.debug("\u901a\u8fc7Provider\u62fc\u63a5\u597d\u7684SQL-->{}", (Object)sqlResult);
        return sqlResult;
    }

    public String courseTeachingListCopy(CourseTeachingListForm form) {
        StringBuffer sql = new StringBuffer();
        sql.append(" select a.sessionid, b.classid,b.type,a.starttime,c.english_name as stunames,b.stu_id,a.duration,CASE WHEN  ( a.status = 101001 or a.status = 101005)   THEN  (a.rate*a.duration/60.0) WHEN  a.status = 101004   THEN  (a.rate*a.duration/60.0)*-1 ELSE 0 END as money,a.status,a.note");
        sql.append(" from t_coursesession a ");
        sql.append(" left join t_course b on a.cid=b.cid  join t_course_student on t_course_student.course_id = b.cid and t_course_student.is_delete = 0 ");
        sql.append(" left join t_student c on c.stu_id=t_course_student.student_id ");
        sql.append(" where 1=1 ");
        if (StringUtils.isNotEmpty((String)form.getStartDate())) {
            sql.append(" and a.starttime >= #{startDate} ");
        }
        if (StringUtils.isNotEmpty((String)form.getEndDate())) {
            sql.append(" and a.starttime <= #{endDate} ");
        }
        if (StringUtils.isNotEmpty((String)form.getClassid())) {
            sql.append(" and b.classid like concat('%', #{classid},'%') ");
        }
        if (StringUtils.isNotEmpty((String)form.getStuName())) {
            sql.append(" and c.english_name like concat('%', #{stuName},'%') ");
        }
        sql.append(" and a.is_delete=0 ");
        sql.append(" and b.is_delete=0 ");
        sql.append(" and c.is_delete=0 ");
        sql.append(" and a.teacher_id=#{teacherId} ");
        sql.append(" order by a.starttime ");
        String sqlResult = sql.toString();
        logger.debug("\u901a\u8fc7Provider\u62fc\u63a5\u597d\u7684SQL-->{}", (Object)sqlResult);
        return sqlResult;
    }

    public String studentCoursesessionInfo(Integer sessionid) {
        StringBuffer sql = new StringBuffer();
        sql.append("select a.sessionid,a.teacher_id,a.rate,a.duration,a.starttime,b.cid,b.classid,b.classname,a.stu_name as realName");
        sql.append(" from t_coursesession a ");
        sql.append(" left join t_course b on a.cid = b.cid  ");
        sql.append(" where a.sessionid = #{sessionid}");
        sql.append(" and a.is_delete=0 ");
        sql.append(" and b.is_delete=0 ");
        String sqlResult = sql.toString();
        logger.debug("\u901a\u8fc7Provider\u62fc\u63a5\u597d\u7684SQL-->{}", (Object)sqlResult);
        return sqlResult;
    }

    public String studentCoursesessionInfoCopy(Integer sessionid) {
        StringBuffer sql = new StringBuffer();
        sql.append("select a.sessionid,a.teacher_id,a.rate,a.duration,a.starttime,b.cid,b.classid,b.classname,c.real_name");
        sql.append(" from t_coursesession a ");
        sql.append(" left join t_course b on a.cid = b.cid join t_course_student on t_course_student.course_id = b.cid and t_course_student.is_delete = 0 ");
        sql.append(" left join t_student c on c.stu_id = t_course_student.student_id ");
        sql.append(" where a.sessionid = #{sessionid}");
        sql.append(" and a.is_delete=0 ");
        sql.append(" and b.is_delete=0 ");
        sql.append(" and c.is_delete=0 ");
        String sqlResult = sql.toString();
        logger.debug("\u901a\u8fc7Provider\u62fc\u63a5\u597d\u7684SQL-->{}", (Object)sqlResult);
        return sqlResult;
    }

    public String teachingRecordEdit(Integer sessionid) {
        StringBuffer sql = new StringBuffer();
        sql.append(" select a.sessionid,a.note,a.status,a.starttime,a.duration,a.teacher_id,b.classname ");
        sql.append(" from t_coursesession a ");
        sql.append(" left join t_course b on a.cid = b.cid ");
        sql.append(" where a.sessionid = #{sessionid} ");
        sql.append(" and a.is_delete=0 ");
        sql.append(" and b.is_delete=0 ");
        String sqlResult = sql.toString();
        logger.debug("\u901a\u8fc7Provider\u62fc\u63a5\u597d\u7684SQL-->{}", (Object)sqlResult);
        return sqlResult;
    }

    public String geTodaySession() throws ParseException {
        Calendar ca = Calendar.getInstance();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        Date date1 = ca.getTime();
        ca.add(5, 1);
        StringBuffer sql = new StringBuffer();
        sql.append(" select * ");
        sql.append(" from t_coursesession  ");
        sql.append(" where starttime>= '" + sdf.format(date1) + "' and starttime<='" + sdf.format(ca.getTime()) + "' and status is null");
        sql.append(" and is_delete=0 ");
        String sqlResult = sql.toString();
        logger.debug("\u901a\u8fc7Provider\u62fc\u63a5\u597d\u7684SQL-->{}", (Object)sqlResult);
        return sqlResult;
    }

    public String geTodayStudentLeaveSession() throws ParseException {
        Calendar ca = Calendar.getInstance();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        Date date1 = ca.getTime();
        ca.add(5, 2);
        StringBuffer sql = new StringBuffer();
        sql.append(" select * ");
        sql.append(" from t_coursesession  ");
        sql.append(" where starttime>= '" + sdf.format(date1) + "' and starttime<='" + sdf.format(ca.getTime()) + "' and status = 101003 ");
        sql.append(" and is_delete=0 ");
        String sqlResult = sql.toString();
        logger.debug("\u901a\u8fc7Provider\u62fc\u63a5\u597d\u7684SQL-->{}", (Object)sqlResult);
        return sqlResult;
    }

    public String geTodayTeacherLeaveSession() throws ParseException {
        Calendar ca = Calendar.getInstance();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        Date date1 = ca.getTime();
        ca.add(5, 2);
        StringBuffer sql = new StringBuffer();
        sql.append(" select * ");
        sql.append(" from t_coursesession  ");
        sql.append(" where starttime>= '" + sdf.format(date1) + "' and starttime<='" + sdf.format(ca.getTime()) + "' and status in (101002,101006) ");
        sql.append(" and is_delete=0 ");
        String sqlResult = sql.toString();
        logger.debug("\u901a\u8fc7Provider\u62fc\u63a5\u597d\u7684SQL-->{}", (Object)sqlResult);
        return sqlResult;
    }

    public String findStudentNameAndIdListBySessionid(Integer sessionid) {
        StringBuffer sql = new StringBuffer();
        sql.append(" select c.stu_id,c.english_name ");
        sql.append(" from t_coursesession a ");
        sql.append(" inner join t_course b on a.cid = b.cid join t_course_student on t_course_student.course_id = b.cid and t_course_student.is_delete = 0 ");
        sql.append(" inner join t_student c on c.stu_id = t_course_student.student_id ");
        sql.append(" where a.sessionid = #{sessionid} ");
        sql.append(" and a.is_delete=0 ");
        sql.append(" and b.is_delete=0 ");
        sql.append(" and c.is_delete=0 ");
        String sqlResult = sql.toString();
        logger.debug("\u901a\u8fc7Provider\u62fc\u63a5\u597d\u7684SQL-->{}", (Object)sqlResult);
        return sqlResult;
    }

    public String findStudentNameAndIdListBySessionidCopy(Integer sessionid) {
        StringBuffer sql = new StringBuffer();
        sql.append(" select c.stu_id,c.english_name ");
        sql.append(" from t_coursesession a ");
        sql.append(" inner join t_course b on a.cid = b.cid join t_course_student on t_course_student.course_id = b.cid and t_course_student.is_delete = 0 ");
        sql.append(" inner join t_student c on c.stu_id = t_course_student.student_id ");
        sql.append(" where a.sessionid = #{sessionid} ");
        sql.append(" and a.is_delete=0 ");
        sql.append(" and b.is_delete=0 ");
        sql.append(" and c.is_delete=0 ");
        String sqlResult = sql.toString();
        logger.debug("\u901a\u8fc7Provider\u62fc\u63a5\u597d\u7684SQL-->{}", (Object)sqlResult);
        return sqlResult;
    }

    public String findNeedSendUnconfirmedEmailTeacherId(Map<String, String> param) {
        StringBuffer sql = new StringBuffer();
        sql.append("select distinct(teacher_id) from t_coursesession where  starttime < '" + param.get("endTime") + "'");
        sql.append(" and starttime > '" + param.get("startTime") + "'");
        sql.append(" and status = 101007 and is_delete = 0 order by starttime desc ");
        String sqlResult = sql.toString();
        logger.debug("\u901a\u8fc7Provider\u62fc\u63a5\u597d\u7684SQL-->{}", (Object)sqlResult);
        return sqlResult;
    }

    public String findNoCompleteListByCidAndStuIdList(Map<String, Object> param) {
        final List stuIdList = (List)param.get("stuIdList");
        return new SQL(){
            {
                this.SELECT("*");
                this.FROM("t_coursesession");
                this.WHERE("cid=#{cid} and status is null and is_delete=0 and stu_id in (" + StringUtils.join((Object[])stuIdList.toArray(), (String)",") + ") ");
            }
        }.toString();
    }

    public String batchInsert(Map<String, List<TCoursesession>> param) {
        List<TCoursesession> coursesessionList = param.get("coursesessionList");
        BatchInsertSQLBuilder builder = new BatchInsertSQLBuilder();
        builder.setInsertTable("t_coursesession");
        builder.setSelective(true);
        for (TCoursesession data : coursesessionList) {
            builder.setData((Object)data);
        }
        return builder.toString();
    }
}

