/*
 * Decompiled with CFR 0.152.
 */
package com.talkilla.mysql.sql;

import com.talkilla.form.admin.AdminTeacherWagesForm;
import com.talkilla.form.admin.AdminTeacherWagesFormOld;
import com.talkilla.form.student.QueryTeacherByTempCourseForm;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.ibatis.jdbc.SQL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class TTeacherDaoSqlProvider {
    Logger logger = LoggerFactory.getLogger(TTeacherDaoSqlProvider.class);

    public String findTeacherList(Map<String, Object> param) {
        StringBuffer sql = new StringBuffer();
        sql.append("select a.* from t_teacher a \n        where 1 = 1 and a.is_delete = 0 ");
        if (StringUtils.isNotBlank((String)((String)param.get("fname")))) {
            sql.append("and a.first_name like '%" + param.get("fname") + "%'");
        }
        if (StringUtils.isNotBlank((String)((String)param.get("lname")))) {
            sql.append("and a.last_name like '%" + param.get("lname") + "%'");
        }
        if (param.get("country") != null && (Integer)param.get("country") != 0 && (Integer)param.get("country") != 11) {
            sql.append("and a.country = #{country}");
        }
        if (param.get("fenlei") != null && (Integer)param.get("fenlei") != 0 && (Integer)param.get("fenlei") != 11) {
            sql.append("and a.teacher_type = #{fenlei}");
        }
        sql.append(" order by a.create_time ");
        String sqlResult = sql.toString();
        this.logger.debug("\u901a\u8fc7Provider\u62fc\u63a5\u597d\u7684SQL-->{}", (Object)sqlResult);
        return sqlResult;
    }

    public String findByTeacherIds(Map<String, Object> params) {
        SQL sql = new SQL();
        sql.SELECT("*");
        sql.FROM("t_teacher");
        List teacherIds = (List)params.get("teacherIds");
        if (CollectionUtils.isEmpty((Collection)teacherIds)) {
            sql.WHERE("1!=1");
        } else {
            sql.WHERE(" teacher_id in (" + StringUtils.join((Collection)teacherIds, (String)",") + ")");
        }
        return sql.toString();
    }

    public String getAllTeachers() {
        StringBuffer sql = new StringBuffer();
        sql.append("select a.teacher_id,a.login_id,a.first_name,a.last_name,a.timezone,b.login_name ");
        sql.append(" from t_teacher a left join t_login b on a.login_id = b.login_id ");
        sql.append(" where a.is_delete = 0 and b.is_delete = 0 ");
        String sqlResult = sql.toString();
        this.logger.debug("\u901a\u8fc7Provider\u62fc\u63a5\u597d\u7684SQL-->{}", (Object)sqlResult);
        return sqlResult;
    }

    public String teacherWageList(AdminTeacherWagesFormOld form) {
        StringBuffer sql = new StringBuffer();
        sql.append("select \n\nsum(\ncase a.status\n when 101005 then  (a.duration/60.0)*a.rate \n when '101001'  then\t (a.duration/60.0)*a.rate  \t\t\nwhen '101004'  then\t (0-(a.duration/60.0)*a.rate )\nelse (a.duration/60.0)*a.rate end\n) \n as money2,\n\na.teacher_id,b.first_name,b.last_name,b.avatar,b.paypal_account\n\t\t\t\t from  `t_coursesession` a \n                left join t_teacher b on a.teacher_id = b.teacher_id\n                where (a.status = 101005 or a.status = 101001  or a.status = 101004) and b.is_delete = 0  and a.is_delete = 0 \n   ");
        if (null != form.getDate1()) {
            sql.append(" and a.starttime  >= #{date1} ");
        }
        if (null != form.getDate2()) {
            sql.append(" and a.starttime  <= #{date2} ");
        }
        if (StringUtils.isNotEmpty((String)form.getFirstname())) {
            sql.append(" and b.first_name like concat('%', #{firstname},'%') ");
        }
        if (StringUtils.isNotEmpty((String)form.getLastname())) {
            sql.append(" and b.last_name like concat('%', #{lastname},'%') ");
        }
        sql.append(" group by a.teacher_id ");
        sql.append(" order by money2 desc ");
        String sqlResult = sql.toString();
        this.logger.debug("\u901a\u8fc7Provider\u62fc\u63a5\u597d\u7684SQL-->{}", (Object)sqlResult);
        return sqlResult;
    }

    public String teacherWageList2(AdminTeacherWagesForm form) {
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT a.teacher_id, b.first_name, b.last_name, b.avatar, b.paypal_account\n\t, SUM(if(a.course_type != 100002, a.duration / 60.0, 0)) AS oneToOneClassTime\n\t, SUM(if(a.course_type != 100002, CASE a.status\n\t\tWHEN 101005 THEN a.duration / 60.0 * a.rate\n\t\tWHEN 101001 THEN a.duration / 60.0 * a.rate\n\t\tWHEN 101004 THEN 0 - a.duration / 60.0 * a.rate\n\t\tELSE a.duration / 60.0 * a.rate\n\tEND, 0)) AS oneToOneMoney\n\t, SUM(if(a.course_type = 100002, a.duration / 60.0, 0)) AS groupClassTime\n\t, SUM(if(a.course_type = 100002, CASE a.status\n\t\tWHEN 101005 THEN a.duration / 60.0 * a.rate\n\t\tWHEN 101001 THEN a.duration / 60.0 * a.rate\n\t\tWHEN 101004 THEN 0 - a.duration / 60.0 * a.rate\n\t\tELSE a.duration / 60.0 * a.rate\n\tEND, 0)) AS groupMoney\n\t, SUM(a.duration / 60.0) AS totalClassTime\n\t, SUM(CASE a.status\n\t\tWHEN 101005 THEN a.duration / 60.0 * a.rate\n\t\tWHEN 101001 THEN a.duration / 60.0 * a.rate\n\t\tWHEN 101004 THEN 0 - a.duration / 60.0 * a.rate\n\t\tELSE a.duration / 60.0 * a.rate\n\tEND) AS shouldPayMoney\n\t, ifnull(c.actual_pay_money, 0) AS actualPayMoney\n\t, SUM(if(a.status = 101001\n\t\tOR a.status = 101005, a.price, 0)) AS classIncome\n\t, ifnull(c.remarks, '') AS remarks\nFROM `t_coursesession` a\n\tLEFT JOIN t_course course ON course.cid = a.cid\n\tLEFT JOIN t_teacher b ON a.teacher_id = b.teacher_id\n\tLEFT JOIN t_teacher_month_income_record c\n\tON c.teacher_id = b.teacher_id\n\t\tAND c.year_month_str =  if('" + form.getDate1() + "' = 'null', '9999-99',date_format(starttime, '%Y-%m')) and c.is_delete = 0\nWHERE (a.status = 101005\n\t\tOR a.status = 101001\n\t\tOR a.status = 101004)\n\tAND b.is_delete = 0\n\tAND course.cid is not null \n\tAND a.is_delete = 0");
        if (null != form.getDate1()) {
            sql.append(" and a.starttime  >= #{date1} ");
        }
        if (null != form.getDate2()) {
            sql.append(" and a.starttime  <= #{date2} ");
        }
        if (StringUtils.isNotEmpty((String)form.getFirstname())) {
            sql.append(" and b.first_name like concat('%', #{firstname},'%') ");
        }
        if (StringUtils.isNotEmpty((String)form.getLastname())) {
            sql.append(" and b.last_name like concat('%', #{lastname},'%') ");
        }
        sql.append(" group by a.teacher_id ");
        sql.append(" order by shouldPayMoney desc ");
        String sqlResult = sql.toString();
        this.logger.debug("\u901a\u8fc7Provider\u62fc\u63a5\u597d\u7684SQL-->{}", (Object)sqlResult);
        return sqlResult;
    }

    public static void main(String[] args) {
        TTeacherDaoSqlProvider sqlProvider = new TTeacherDaoSqlProvider();
        AdminTeacherWagesForm form = new AdminTeacherWagesForm();
        sqlProvider.findWageDetailsByTeacherId2(form);
    }

    public String teacherTempCourseContion(final QueryTeacherByTempCourseForm form) {
        return new SQL(){
            {
                this.SELECT("*");
                this.FROM("t_teacher");
                if (StringUtils.isNotBlank((String)form.getFirstName())) {
                    this.WHERE("first_name like concat('%', #{firstName},'%')");
                }
                if (StringUtils.isNotBlank((String)form.getLastName())) {
                    this.WHERE("last_name like concat('%', #{lastName},'%')");
                }
                if (form.getCountry() != null && form.getCountry() > 0) {
                    this.WHERE("country= #{country}");
                }
                if (form.getGender() != null && form.getGender() > -1) {
                    this.WHERE("gender= #{gender}");
                }
                if (form.getType() != null && form.getType() > 0) {
                    this.WHERE("teacher_type= #{type}");
                } else if (form.getRejectType() > 0) {
                    this.WHERE("teacher_type != #{rejectType}");
                }
                if (form.getSubject() != null && form.getSubject() > 0) {
                    this.WHERE("subject &" + form.getSubject() + " >0");
                }
                this.WHERE("is_delete = 0 ");
            }
        }.toString();
    }

    public String findWageDetailsByTeacherId(AdminTeacherWagesFormOld form) {
        StringBuffer sql = new StringBuffer();
        sql.append("   select a.first_name,a.last_name,b.classid,b.classname,c.starttime,c.status,c.duration ,\n \n case c.status\n when '101005' then  (c.duration/60.0)*c.rate \nwhen '101001'  then\t (c.duration/60.0)*c.rate  \t\t\nwhen '101004'  then\t (0-(c.duration/60.0)*c.rate ) \t\t\t \n\t \nelse '0.0' end\nas money\n \t\t\t ,\n \n c.`stu_name` as zname \n\n     from  t_coursesession c \n                        left join t_teacher a on a.teacher_id = c.teacher_id  \n                         left join t_course b on c.cid = b.cid\n");
        sql.append(" where  c.teacher_id = #{teacherid} ");
        sql.append(" and  c.is_delete = 0  and ( c.status = 101005 or c.status = 101001 or c.status = 101004 ) ");
        if (null != form.getDate1()) {
            sql.append(" and c.starttime >=  #{date1} ");
        }
        if (null != form.getDate2()) {
            sql.append(" and c.starttime <=  #{date2} ");
        }
        sql.append(" order by  c.starttime asc ");
        String sqlResult = sql.toString();
        this.logger.debug("\u901a\u8fc7Provider\u62fc\u63a5\u597d\u7684SQL-->{}", (Object)sqlResult);
        return sqlResult;
    }

    public String findWageDetailsByTeacherId2(AdminTeacherWagesForm form) {
        Integer courceType;
        StringBuffer sql = new StringBuffer();
        sql.append("select a.first_name,\n       a.last_name,\n       b.classid,\n       b.classname,\n       b.type,\n       if(c.course_type = 100002,c.stu_name,concat(c.stu_name ,'/',c.stu_en_name)) as stuName,\n       c.starttime,\n       if(c.status = 101004,-c.duration / 60.0,c.duration / 60.0) as duration,\n       c.status,\n       c.rate,\n       c.ispay,\n       case c.status\n           when '101005' then (c.duration / 60.0) * c.rate\n           when '101001' then (c.duration / 60.0) * c.rate\n           when '101004' then (0 - (c.duration / 60.0) * c.rate)\n           else '0.0' end as money,\n       if(c.status = 101001 OR c.status = 101005, c.price, 0) as price\nfrom t_coursesession c\n         left join t_teacher a on a.teacher_id = c.teacher_id\n         left join t_course b on c.cid = b.cid");
        sql.append(" where  c.teacher_id = #{teacherid} ");
        sql.append(" and  c.is_delete = 0  and ( c.status = 101005 or c.status = 101001 or c.status = 101004 ) and b.type is not null ");
        if (null != form.getDate1()) {
            sql.append(" and c.starttime >=  #{date1} ");
        }
        if (null != form.getDate2()) {
            sql.append(" and c.starttime <=  #{date2} ");
        }
        if ((courceType = form.getCourceType()) != null) {
            sql.append(courceType == 1 ? " and c.course_type != 100002" : "and c.course_type = 100002");
        }
        sql.append(" order by  c.starttime asc ");
        String sqlResult = sql.toString();
        this.logger.debug("\u901a\u8fc7Provider\u62fc\u63a5\u597d\u7684SQL-->{}", (Object)sqlResult);
        return sqlResult;
    }

    public String findWageDetailsByTeacherIdCopy(AdminTeacherWagesForm form) {
        StringBuffer sql = new StringBuffer();
        sql.append("   select a.first_name,a.last_name,b.classid,b.classname,c.starttime,c.status,c.duration ,\n \n case c.status\n when '101005' then  (c.duration/60.0)*c.rate \nwhen '101001'  then\t (c.duration/60.0)*c.rate  \t\t\nwhen '101004'  then\t (0-(c.duration/60.0)*c.rate ) \t\t\t \n\t \nelse '0.0' end\nas money\n \t\t\t ,\n \n d.`real_name` as zname \n\n     from  t_coursesession c  join t_course_session_student on t_course_session_student.course_session_id = c.sessionid and t_course_session_student.is_delete = 0 \n                        left join t_teacher a on a.teacher_id = c.teacher_id  \n                         left join t_course b on c.cid = b.cid\n                      \t\tleft  join t_student d on t_course_session_student.student_id = d.stu_id ");
        sql.append(" where  c.teacher_id = #{teacherid} ");
        sql.append(" and  c.is_delete = 0  and ( c.status = 101005 or c.status = 101001 or c.status = 101004 ) ");
        if (null != form.getDate1()) {
            sql.append(" and c.starttime >=  #{date1} ");
        }
        if (null != form.getDate2()) {
            sql.append(" and c.starttime <=  #{date2} ");
        }
        sql.append(" order by  c.starttime asc ");
        String sqlResult = sql.toString();
        this.logger.debug("\u901a\u8fc7Provider\u62fc\u63a5\u597d\u7684SQL-->{}", (Object)sqlResult);
        return sqlResult;
    }

    public String findAllTeacherList() {
        StringBuffer sql = new StringBuffer();
        sql.append(" select  a.*,b.login_name ");
        sql.append(" from t_teacher a left join t_login b on a.login_id = b.login_id ");
        sql.append(" where a.teacher_type in (102001,102002,102003) ");
        sql.append(" and a.is_delete = 0 and b.is_delete = 0 ");
        sql.append(" order by a.first_name ");
        String sqlResult = sql.toString();
        this.logger.debug("\u901a\u8fc7Provider\u62fc\u63a5\u597d\u7684SQL-->{}", (Object)sqlResult);
        return sqlResult;
    }
}

