/*
 * Decompiled with CFR 0.152.
 */
package com.talkilla.mysql.sql;

import com.talkilla.form.admin.AdminOrderListForm;
import com.talkilla.form.wechat.OrderListForm;
import org.apache.commons.lang.StringUtils;
import org.apache.ibatis.jdbc.SQL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TSellCourseOrderDaoSqlProvider {
    private static final Logger logger = LoggerFactory.getLogger(TSellCourseOrderDaoSqlProvider.class);

    public String orderList(OrderListForm form) {
        SQL sql = new SQL();
        sql.SELECT("*");
        sql.FROM("t_sell_course_order");
        sql.WHERE("student_id=#{stuId}");
        if (form.getStatus() != null) {
            sql.WHERE("status=#{status}");
        }
        sql.ORDER_BY("create_time desc");
        String sqlResult = sql.toString();
        logger.debug("\u901a\u8fc7Provider\u62fc\u63a5\u597d\u7684SQL-->{}", (Object)sqlResult);
        return sqlResult;
    }

    public String sellCourceOrderList(AdminOrderListForm form) {
        StringBuilder sql = new StringBuilder();
        sql.append(" select c.* ,st.real_name,st.phone ");
        sql.append(" from t_sell_course_order c ");
        sql.append(" left join t_student st on c.student_id = st.stu_id ");
        sql.append(" left join t_student_consultant d on st.stu_id = d.stu_id ");
        sql.append(" where 1 = 1 ");
        if (StringUtils.isNotEmpty((String)form.getName())) {
            sql.append(" and c.sell_course_name like concat('%',#{name},'%') ");
        }
        if (StringUtils.isNotEmpty((String)form.getOrderNo())) {
            sql.append(" and c.order_no like concat('%',#{orderNo},'%') ");
        }
        if (form.getStatus() != null) {
            sql.append(" and c.status = #{status} ");
        }
        if (StringUtils.isNotEmpty((String)form.getStuName())) {
            sql.append(" and st.real_name like concat('%',#{stuName},'%') ");
        }
        if (StringUtils.isNotEmpty((String)form.getPhone())) {
            sql.append(" and st.phone like concat('%',#{phone},'%') ");
        }
        if (StringUtils.isNotEmpty((String)form.getEmail())) {
            sql.append(" and d.consultant_email = #{email} ");
        }
        sql.append(" order by c.create_time desc ");
        String sqlResult = sql.toString();
        logger.debug("\u901a\u8fc7Provider\u62fc\u63a5\u597d\u7684SQL-->{}", (Object)sqlResult);
        return sqlResult;
    }
}

