/*
 * Decompiled with CFR 0.152.
 */
package com.talkilla.mysql.mapper;

import com.talkilla.form.admin.AdminCoursePackageQueryForm;
import com.talkilla.form.admin.AdminNeedPayStudentListForm;
import com.talkilla.form.admin.AdminTeachingRecordsForm;
import com.talkilla.form.student.CourseListForm;
import com.talkilla.mysql.domain.TCourse;
import com.talkilla.mysql.sql.TcourseDaoSqlProvider;
import com.talkilla.otherbean.CalendarDto;
import com.talkilla.result.StudentLastCourseResult;
import com.talkilla.result.admin.AdminCoursePackageQueryResult;
import com.talkilla.result.admin.AdminFindAllCoursesResult;
import com.talkilla.result.admin.AdminFindCourseResult;
import com.talkilla.result.admin.AdminTeachingRecordListResult;
import com.talkilla.result.admin.NeedPayResult;
import com.talkilla.result.student.CourseDetailResult;
import com.talkilla.result.student.CourseListResult;
import com.talkilla.result.student.CourseNameAndCidAtPresentResult;
import java.sql.Timestamp;
import java.util.List;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;
import org.apache.ibatis.annotations.SelectProvider;
import org.apache.ibatis.annotations.Update;
import org.springframework.stereotype.Component;

@Component(value="tCourseDao")
public interface TCourseDao {
    public int deleteById(Integer var1);

    public int insert(TCourse var1);

    public int insertSelective(TCourse var1);

    public TCourse findOne(Integer var1);

    public int updateByIdSelective(TCourse var1);

    @Select(value={"select t_course.* from t_course left join t_course_student on t_course_student.course_id = t_course.cid and t_course_student.is_delete = 0 where t_course_student.student_id = #{stuId} and t_course.is_delete = 0"})
    public List<TCourse> findCourceByStuId(Integer var1);

    @Select(value={"select * from t_course where sell_course_order_id=#{0}"})
    public TCourse findCourceListBySellCourseOrderId(Integer var1);

    @Select(value={"select t_course.* from t_course left join t_course_student on t_course_student.course_id = t_course.cid and t_course_student.is_delete = 0 where t_course_student.student_id = #{studentId} and t_course.is_delete = 0"})
    public List<TCourse> findCourceListByStudentId(Integer var1);

    @SelectProvider(type=TcourseDaoSqlProvider.class, method="findCourceNameAtPresent")
    public CourseNameAndCidAtPresentResult findCourceNameAtPresent(Integer var1);

    @SelectProvider(type=TcourseDaoSqlProvider.class, method="findCourcesessionCompleted")
    public Integer findCourcesessionCompleted(String var1);

    @SelectProvider(type=TcourseDaoSqlProvider.class, method="findCourcesessionUnCompleted")
    public Integer findCourcesessionUnCompleted(String var1);

    @SelectProvider(type=TcourseDaoSqlProvider.class, method="findCourcesessionUnCompleted")
    public Integer findCourcessionCompletedNoFeedback(String var1);

    @SelectProvider(type=TcourseDaoSqlProvider.class, method="courseList")
    public List<CourseListResult> courseList(CourseListForm var1);

    @Select(value={"select t_course.* from t_course left join t_course_student on t_course_student.course_id = t_course.cid and t_course_student.is_delete = 0  where t_course_student.student_id = #{0} and t_course.classid = #{1} and t_course.is_delete = 0"})
    public TCourse fingStudentClassDetail(Integer var1, String var2);

    @Select(value={"SELECT count(1) FROM t_course a join t_coursesession b on a.cid = b.cid  where b.starttime >= #{startTime} and b.starttime <  #{endTime} "})
    public Integer countThisWeekCoursessions(@Param(value="startTime") Timestamp var1, @Param(value="endTime") Timestamp var2);

    @Select(value={"SELECT count(1) FROM t_course a join t_coursesession b on a.cid = b.cid  where b.starttime >= #{startTime} and b.starttime <  #{endTime} and status = 101001 "})
    public Integer countThisWeekConfirmCoursessions(@Param(value="startTime") Timestamp var1, @Param(value="endTime") Timestamp var2);

    @Select(value={"SELECT count(1) FROM t_course a join t_coursesession b on a.cid = b.cid  where isgenerate = 1  and isconfirm is null  and a.is_delete != 1"})
    public Integer countThisWeekAutoMakeCoursessions();

    @Select(value={"SELECT group_concat(distinct a.classname) FROM t_course  a join t_course_student on t_course_student.course_id = a.cid and t_course_student.is_delete = 0 join t_coursesession b on a.cid = b.cid and a.is_delete = 0  and b.status is null and b.starttime >= now() and t_course_student.student_id = (select stu_id from t_student where login_id = #{loginId})"})
    public String getStudentNowClassname(@Param(value="loginId") Integer var1);

    @Select(value={"SELECT count(1) FROM t_coursesession where cid in ( SELECT distinct a.cid FROM t_course  a join t_course_student on t_course_student.course_id = a.cid and t_course_student.is_delete = 0   join t_coursesession b on a.cid = b.cid and a.is_delete != 1 and b.status is null and b.starttime >= now() and t_course_student.student_id = (select stu_id from t_student where login_id = #{loginId}) ) and (if(isnull(status),0,status) = 101001 || if(isnull(status),0,status) = 101005 )"})
    public Integer countStudentCompleteCourse(@Param(value="loginId") Integer var1);

    @Select(value={"SELECT count(1) FROM t_coursesession where cid in ( SELECT distinct a.cid FROM t_course  a join t_course_student on t_course_student.course_id = a.cid and t_course_student.is_delete = 0 join t_coursesession b on a.cid = b.cid and a.is_delete != 1 and b.status is null and b.starttime >= now() and t_course_student.student_id = (select stu_id from t_student where login_id = #{loginId} ) ) and status is null "})
    public Integer countNotCompleteCoursessions(@Param(value="loginId") Integer var1);

    @Select(value={"SELECT count(1) FROM t_course  a join t_course_student on t_course_student.course_id = a.cid and t_course_student.is_delete = 0 join t_coursesession b on a.cid = b.cid and a.is_delete = 0  and b.status = 101001 and b.starttime >= now() and t_course_student.student_id = (select stu_id from t_student where login_id = #{loginId} ) join t_teacher_comments d on d.sessionid = b.sessionid and not exists (select 1 from t_stu_feeback where sessionid = d.sessionid and stu_id = t_course_student.student_id)"})
    public Integer countStudentComments(@Param(value="loginId") Integer var1);

    @SelectProvider(type=TcourseDaoSqlProvider.class, method="needPayStudentList")
    public List<NeedPayResult> needPayStudentList(AdminNeedPayStudentListForm var1);

    @Select(value={"select a.classname,a.trainingmaterials,c.first_name,c.last_name from t_course a join t_course_student on t_course_student.course_id = a.cid and t_course_student.is_delete = 0 \n     join t_teacher c on a.teacher_id = c.teacher_id where t_course_student.student_id = #{id} order by a.create_time desc limit 1"})
    public StudentLastCourseResult getStudentLastCourseResultById(Integer var1);

    @Select(value={"select cid , classid ,classname from t_course where is_delete = 0 order by classid desc"})
    public List<AdminFindAllCoursesResult> findAllCourses();

    @SelectProvider(type=TcourseDaoSqlProvider.class, method="findCourse")
    public AdminFindCourseResult findCourse(Integer var1);

    @SelectProvider(type=TcourseDaoSqlProvider.class, method="teachingRecordList")
    public List<AdminTeachingRecordListResult> teachingRecordList(AdminTeachingRecordsForm var1);

    @Select(value={"SELECT t.first_name,t.last_name,c.sessionid,b.classid,b.classname,c.starttime,c.status ,c.duration,t.first_name,t.last_name, max(d.comments) as comments , max(f.feebackid) as feebackid, max(f.feeback) as feeback  \n\t\t\t\t\tFROM  t_course b join t_course_student on t_course_student.course_id = b.cid and t_course_student.is_delete = 0 \n\t\t\t\t\tjoin t_coursesession c on c.cid = b.cid \n\t\t\t\t\tand  t_course_student.student_id = #{0}\t\t\t\t\tand b.cid = #{1}\t\t\t\t\tleft join t_teacher_comments d on c.sessionid = d.sessionid\n\t\t\t\t\tleft join t_stu_feeback f on f.sessionid = c.sessionid and f.stu_id = t_course_student.student_id\n\t\t\t\t\tleft join t_teacher t on c.teacher_id = t.teacher_id \n\t\t\t\t\tgroup by c.sessionid,b.classid,b.classname,c.starttime,c.status ,b.duration\n\t\t\t\t\torder by c.starttime desc        "})
    public List<CourseDetailResult> getStudentCourseDetailById(Integer var1, Integer var2);

    @SelectProvider(type=TcourseDaoSqlProvider.class, method="findCoursePackageQuerys")
    public List<AdminCoursePackageQueryResult> findCoursePackageQuerys(AdminCoursePackageQueryForm var1);

    @Update(value={" update t_course set is_delete = 1 where cid = #{0} "})
    public void deleteTCourseByCid(Integer var1);

    @Select(value={"SELECT a.cid,classid,classname,b.duration,starttime,status,sessionid,first_name\n  FROM t_course a join t_course_student on t_course_student.course_id = a.cid and t_course_student.is_delete = 0 join t_coursesession b on a.cid = b.cid and a.is_delete !=1 \n  and t_course_student.student_id = (select stu_id from t_student where login_id = #{loginId}) join\n   t_teacher d on b.teacher_id = d.teacher_id and a.is_delete = 0 and b.is_delete = 0 "})
    public List<CalendarDto> findStudentAllCalendarsByLoginId(Integer var1);

    @Select(value={"\tselect a.* from t_course  a\n  join t_course_student on t_course_student.course_id = a.cid and t_course_student.is_delete = 0 \tleft join `t_coursesession` b on a.cid=b.cid and b.status is null  and b.is_delete = 0\n\t where t_course_student.student_id=#{studentId} and a.is_delete = 0 and b.cid is not null   group by a.cid order by a.create_time desc\n"})
    public List<TCourse> findNoCompletedCourceListByStudentId(Integer var1);

    @Select(value={"\t select a.* from t_course  a join t_course_student on t_course_student.course_id = a.cid and t_course_student.is_delete = 0 where a.cid not in (select cid from t_coursesession b join t_course_session_student on t_course_session_student.course_session_id = b.sessionid and t_course_session_student.is_delete = 0 where b.status is null and b.is_delete = 0 and t_course_session_student.student_id = #{studentId} group by b.cid) and t_course_student.student_id = #{studentId} and a.is_delete = 0 order by a.create_time desc\n"})
    public List<TCourse> findCompletedCourceListByStudentId(Integer var1);

    @Select(value={"select t_course.* from t_course join t_course_student on t_course_student.course_id = t_course.cid and t_course_student.is_delete = 0 where t_course_student.student_id = #{stuId} and t_course.is_delete = 0 and t_course.type = 100001"})
    public List<TCourse> findCourceByRecommendId(Integer var1);
}

