/*
 * Decompiled with CFR 0.152.
 */
package com.talkilla.controller;

import com.talkilla.constant.TalkillaConstant;
import com.talkilla.exception.BusinessException;
import com.talkilla.form.admin.AdminStudentCoursesessionAddSaveForm;
import com.talkilla.form.admin.AdminStudentCoursesessionInfoEditForm;
import com.talkilla.form.admin.AdminStudentSummaryEditForm;
import com.talkilla.form.admin.AdminStudentSummaryListForm;
import com.talkilla.mysql.domain.TCourse;
import com.talkilla.mysql.domain.TStudentSummary;
import com.talkilla.otherbean.AssignedCell;
import com.talkilla.otherbean.ExportExcelParameter;
import com.talkilla.otherbean.StudentCourseDto;
import com.talkilla.otherbean.StudentDto;
import com.talkilla.otherbean.UserDto;
import com.talkilla.result.ReturnMessageResult;
import com.talkilla.result.admin.AdminFindCourseResult;
import com.talkilla.result.admin.AdminStudentCoursesessionInfoResult;
import com.talkilla.result.admin.StudentEditInfoResult;
import com.talkilla.result.admin.base.PageObj;
import com.talkilla.result.teacher.StudentDetailResult;
import com.talkilla.service.TCourseService;
import com.talkilla.service.TTeacherService;
import com.talkilla.service.admin.AdminExportService;
import com.talkilla.service.admin.AdminNeedPayStudentService;
import com.talkilla.service.admin.AdminService;
import com.talkilla.service.admin.AdminStudentService;
import com.talkilla.service.form.AdminStudentEditSaveForm;
import com.talkilla.service.form.QueryAreaNameForm;
import com.talkilla.service.form.QueryForm;
import com.talkilla.service.form.QueryStudentDetailForm;
import com.talkilla.service.form.QueryStudentEditForm;
import com.talkilla.service.form.QueryStudentListForm;
import com.talkilla.service.form.StudentCourseListQueryForm;
import com.talkilla.service.form.StudentPayListForm;
import com.talkilla.service.impl.InitDictionUtil;
import com.talkilla.utils.DateUtils;
import com.talkilla.utils.JSONUtil;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.StringUtils;
import org.nestframework.commons.utils.StringUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;

@Controller
@RequestMapping(value={"/student"})
public class ConsultantStudentController {
    @Autowired
    AdminService adminService;
    @Autowired
    AdminStudentService adminStudentService;
    @Autowired
    AdminNeedPayStudentService adminNeedPayStudentService;
    @Autowired
    AdminExportService adminExportService;
    @Autowired
    InitDictionUtil initDictionUtil;
    @Autowired
    TTeacherService tTeacherService;
    @Autowired
    TCourseService tCourseService;
    private SimpleDateFormat s = new SimpleDateFormat("yyyy-MM");

    @RequestMapping(value={"/list"})
    public String studentList(HttpServletRequest request, Model model, QueryStudentListForm form) {
        if (StringUtils.isNotBlank((String)form.getDoExport())) {
            return "forward:/student/list/export";
        }
        PageObj pageObj = this.adminStudentService.findQueryStudentList(form);
        model.addAttribute("pageObj", (Object)pageObj);
        model.addAttribute("form", (Object)form);
        return "studentsList";
    }

    @RequestMapping(value={"/list/export"})
    public Object studentListExport(HttpServletRequest request, HttpServletResponse response, HttpSession session, Model model, QueryStudentListForm form) throws BusinessException {
        PageObj pageObj = this.adminStudentService.findQueryStudentList(form);
        model.addAttribute("pageObj", (Object)pageObj);
        model.addAttribute("form", (Object)form);
        List bs = pageObj.getPageElements();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        ExportExcelParameter para = new ExportExcelParameter();
        ArrayList<AssignedCell[]> data = new ArrayList<AssignedCell[]>();
        try {
            para.setTemplateName("WEB-INF/template/\u5b66\u751f.xls");
            para.setDataRow(new AssignedCell(1, 0, (Object)""));
            para.setNeedCopyTemplateRow(true);
            para.setDataRowSpan(1);
            para.setTotalCol(10);
            if (null != bs) {
                int i = 1;
                int cs = 0;
                for (Object tObj : bs) {
                    StudentDto dto = (StudentDto)tObj;
                    AssignedCell[] row1 = new AssignedCell[]{new AssignedCell(0, 0, (Object)dto.getRealname(), cs), new AssignedCell(0, 1, (Object)dto.getLoginname(), cs), new AssignedCell(0, 2, (Object)dto.getStuskypeid(), cs), new AssignedCell(0, 3, (Object)(dto.getStugender() == 1 ? "\u7537" : "\u5973"), cs), new AssignedCell(0, 4, (Object)(dto.getBirthday() != null ? sdf.format(dto.getBirthday()) : ""), cs), new AssignedCell(0, 5, (Object)dto.getAge(), cs), new AssignedCell(0, 6, (Object)dto.getParentname(), cs)};
                    data.add(row1);
                    ++i;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.adminExportService.exportExcelByTemplate(para, "\u5b66\u751f\u5217\u8868" + DateUtils.formatDateToSecond2((Date)new Date()) + ".xls", response, session, data);
    }

    @RequestMapping(value={"/delete"})
    public String delete(HttpServletRequest request, Model model, @RequestParam(value="stuId") Integer stuId) {
        this.adminStudentService.deleteStudent(stuId);
        model.addAttribute("message", (Object)"\u5220\u9664\u6210\u529f");
        return "redirect:/student/list";
    }

    @RequestMapping(value={"/detail"})
    public String studentDetail(HttpServletRequest request, Model model, QueryStudentDetailForm queryForm) {
        StudentDetailResult result = this.adminStudentService.getStudentDetailById(queryForm.getId());
        model.addAttribute("result", (Object)result);
        return "studentInfo";
    }

    @RequestMapping(value={"/edit"})
    public String doEdit(HttpServletRequest request, Model model, QueryStudentEditForm queryForm) {
        StudentEditInfoResult result = this.adminStudentService.getStudentEditInfo(queryForm.getStuid());
        model.addAttribute("list", (Object)result.getNations());
        model.addAttribute("zones", (Object)result.getZones());
        model.addAttribute("student", (Object)result.getStudent());
        model.addAttribute("birthday", (Object)result.getBirthday());
        model.addAttribute("create_time", (Object)result.getCreate_time());
        model.addAttribute("consultantList", (Object)result.getConsultantList());
        result.setRawName(this.initDictionUtil.getCityNameById(result.getStudent().getCity() == null ? "" : result.getStudent().getCity().toString()));
        model.addAttribute("rawName", (Object)result.getRawName());
        model.addAttribute("consultant_email", (Object)result.getConsultantEmail());
        model.addAttribute("consultant_name", (Object)result.getConsultantName());
        return "studentEdit";
    }

    @RequestMapping(value={"/edit/save"})
    public String doSave(HttpServletRequest request, Model model, AdminStudentEditSaveForm form, @RequestParam(value="fileItem") MultipartFile fileItem) {
        this.adminStudentService.saveStudent(form, fileItem);
        model.addAttribute("message", (Object)"\u4fdd\u5b58\u6210\u529f");
        return "redirect:/student/list";
    }

    @RequestMapping(value={"/need/pay/list"})
    public String needPayStudent(HttpServletRequest request, Model model, QueryForm queryForm) {
        UserDto user = (UserDto)request.getSession().getAttribute(TalkillaConstant.SESSION_CONSULTANT_LOGIN_PREFIX);
        PageObj pageObj = this.adminNeedPayStudentService.findNeedPayStudentList(queryForm);
        model.addAttribute("pageObj", (Object)pageObj);
        model.addAttribute("form", (Object)queryForm);
        return "needPayList";
    }

    @RequestMapping(value={"need/pay/no/renew/notice"})
    @ResponseBody
    public Object needPayStudentNoRenewNotice(HttpServletRequest request, Model model, Integer cid) {
        ReturnMessageResult messageResult = this.adminNeedPayStudentService.needPayStudentNoRenewNotice(cid);
        messageResult.setMessage("\u4fee\u6539\u6210\u529f");
        messageResult.setFlag(Integer.valueOf(1));
        return messageResult;
    }

    @RequestMapping(value={"need/pay/no/renew/notice2"})
    @ResponseBody
    public Object needPayStudentNoRenewNotice2(HttpServletRequest request, Model model, Integer cid) {
        ReturnMessageResult messageResult = this.adminNeedPayStudentService.needPayStudentNoRenewNotice2(cid);
        messageResult.setMessage("\u4fee\u6539\u6210\u529f");
        messageResult.setFlag(Integer.valueOf(1));
        return messageResult;
    }

    @RequestMapping(value={"need/pay/report/status/modify"})
    @ResponseBody
    public Object needPayReportStatusModify(HttpServletRequest request, Model model, Integer cid, Integer status) {
        ReturnMessageResult messageResult = this.adminNeedPayStudentService.needPayReportStatusModify(cid, status);
        messageResult.setMessage("\u4fee\u6539\u6210\u529f");
        messageResult.setFlag(Integer.valueOf(1));
        return messageResult;
    }

    @RequestMapping(value={"/need/pay/list/view/class/note"})
    public Object needPayListViewClassNote(HttpServletRequest request, Model model, Integer cid) {
        TCourse tCourse = this.adminNeedPayStudentService.needPayListViewClassNote(cid);
        model.addAttribute("tCourse", (Object)tCourse);
        return "viewCourseNotes";
    }

    @RequestMapping(value={"/need/pay/list/view/class/note/update"})
    @ResponseBody
    public Object needPayListViewClassNoteUpdate(HttpServletRequest request, Model model, Integer cid, String notes) {
        ReturnMessageResult messageResult = this.adminNeedPayStudentService.needPayListViewClassNoteUpdate(cid, notes);
        messageResult.setMessage("\u4fee\u6539\u6210\u529f");
        messageResult.setFlag(Integer.valueOf(1));
        return messageResult;
    }

    @RequestMapping(value={"/new/pay/list"})
    public String newPayStudent(HttpServletRequest request, Model model, StudentPayListForm queryForm) {
        Calendar c;
        Date d;
        if (StringUtils.isNotBlank((String)queryForm.getNewDoExport())) {
            return "forward:/student/new/pay/list/export";
        }
        String date1 = queryForm.getDate1();
        String date2 = queryForm.getDate2();
        if (StringUtil.isEmpty((String)date1)) {
            d = null;
            c = Calendar.getInstance();
            c.add(2, -1);
            d = c.getTime();
            date1 = this.s.format(d);
        }
        if (StringUtil.isEmpty((String)date2)) {
            d = null;
            c = Calendar.getInstance();
            d = c.getTime();
            date2 = this.s.format(d);
        }
        HashMap<String, String> querymap = new HashMap<String, String>();
        querymap.put("startDate", date1 + "-01");
        querymap.put("endDate", date2 + "-01");
        PageObj pageObj = this.adminStudentService.findnewQuerys(querymap, queryForm.getPageSize(), queryForm.getPageNo());
        model.addAttribute("pageObj", (Object)pageObj);
        model.addAttribute("queryForm", (Object)queryForm);
        return "newStudentsList";
    }

    @RequestMapping(value={"/new/pay/list/export"})
    public Object newPayListExport(HttpServletRequest request, HttpServletResponse response, HttpSession session, Model model, StudentPayListForm queryForm) throws BusinessException {
        Calendar c;
        Date d;
        String date1 = queryForm.getDate1();
        String date2 = queryForm.getDate2();
        if (StringUtil.isEmpty((String)date1)) {
            d = null;
            c = Calendar.getInstance();
            c.add(2, -1);
            d = c.getTime();
            date1 = this.s.format(d);
        }
        if (StringUtil.isEmpty((String)date2)) {
            d = null;
            c = Calendar.getInstance();
            d = c.getTime();
            date2 = this.s.format(d);
        }
        HashMap<String, String> querymap = new HashMap<String, String>();
        querymap.put("startDate", date1 + "-01");
        querymap.put("endDate", date2 + "-01");
        PageObj pageObj = this.adminStudentService.findnewQuerys(querymap, queryForm.getPageSize(), queryForm.getPageNo());
        List bs = pageObj.getPageElements();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        ExportExcelParameter para = new ExportExcelParameter();
        ArrayList<AssignedCell[]> data = new ArrayList<AssignedCell[]>();
        try {
            para.setTemplateName("WEB-INF/template/\u5b66\u751f.xls");
            para.setDataRow(new AssignedCell(1, 0, (Object)""));
            para.setNeedCopyTemplateRow(true);
            para.setDataRowSpan(1);
            para.setTotalCol(10);
            if (null != bs) {
                int i = 1;
                int cs = 0;
                for (Object tObj : bs) {
                    StudentDto dto = (StudentDto)tObj;
                    AssignedCell[] row1 = new AssignedCell[]{new AssignedCell(0, 0, (Object)dto.getRealname(), cs), new AssignedCell(0, 1, (Object)dto.getLoginname(), cs), new AssignedCell(0, 2, (Object)dto.getStuskypeid(), cs), new AssignedCell(0, 3, (Object)(dto.getStugender() == 1 ? "\u7537" : "\u5973"), cs), new AssignedCell(0, 4, (Object)(dto.getBirthday() != null ? sdf.format(dto.getBirthday()) : ""), cs), new AssignedCell(0, 5, (Object)dto.getAge(), cs), new AssignedCell(0, 6, (Object)dto.getParentname(), cs)};
                    data.add(row1);
                    ++i;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.adminExportService.exportExcelByTemplate(para, "\u65b0\u7f34\u8d39\u5b66\u751f" + DateUtils.formatDateToSecond2((Date)new Date()) + ".xls", response, session, data);
    }

    @RequestMapping(value={"/query/area/name"})
    @ResponseBody
    public Object queryAreaName(HttpServletRequest request, Model model, QueryAreaNameForm queryForm) {
        List x = this.adminService.findAllBZone(queryForm.getQueryName());
        ArrayList l = new ArrayList(x);
        int idx = -1;
        for (int i = 0; i < l.size(); ++i) {
            Map m = (Map)l.get(i);
            if (!"\u65e0".equals(m.get("text"))) continue;
            idx = i;
            break;
        }
        if (idx != -1) {
            l.remove(idx);
        }
        return l;
    }

    public static void main(String[] args) {
    }

    @RequestMapping(value={"/course/list"})
    public String courseList(HttpServletRequest request, Model model, StudentCourseListQueryForm form) throws ParseException {
        if (StringUtils.isNotBlank((String)form.getDoExport())) {
            return "forward:/student/course/list/export";
        }
        PageObj pageObj = this.adminStudentService.getStudentCourseList(form, request);
        model.addAttribute("pageObj", (Object)pageObj);
        model.addAttribute("form", (Object)form);
        return "studentCoursesessionList";
    }

    @RequestMapping(value={"/course/list/export"})
    public Object courseListExport(HttpServletRequest request, HttpServletResponse response, HttpSession session, Model model, StudentCourseListQueryForm form) throws BusinessException, ParseException {
        PageObj pageObj = this.adminStudentService.getStudentCourseList(form, request);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        ExportExcelParameter para = new ExportExcelParameter();
        ArrayList<AssignedCell[]> data = new ArrayList<AssignedCell[]>();
        try {
            para.setTemplateName("WEB-INF/template/\u8bfe\u7a0b\u8868.xls");
            para.setDataRow(new AssignedCell(1, 0, (Object)""));
            para.setNeedCopyTemplateRow(true);
            para.setDataRowSpan(1);
            para.setTotalCol(10);
            if (null != pageObj) {
                int i = 1;
                int cs = 0;
                for (Object tObj : pageObj.getPageElements()) {
                    StudentCourseDto dto = (StudentCourseDto)tObj;
                    AssignedCell[] row1 = new AssignedCell[]{new AssignedCell(0, 0, (Object)dto.getClassname(), cs), new AssignedCell(0, 1, (Object)sdf.format(dto.getSessiontime()), cs), new AssignedCell(0, 2, (Object)dto.getDuration(), cs), new AssignedCell(0, 3, (Object)dto.getTeachername(), cs), new AssignedCell(0, 4, (Object)dto.getStunames(), cs), new AssignedCell(0, 5, (Object)this.initDictionUtil.getDictNameByDictId(dto.getStatus() == null ? "" : dto.getStatus().toString()), cs), new AssignedCell(0, 6, (Object)dto.getFeedback(), cs)};
                    data.add(row1);
                    ++i;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Date date = form.getDate() == null ? new Date() : form.getDate();
        return this.adminExportService.exportExcelByTemplate(para, "\u8bfe\u7a0b\u8868(" + (date == null ? "" : date) + ").xls", response, session, data);
    }

    @RequestMapping(value={"/summary/list"})
    public String studentSummaryList(HttpServletRequest request, Model model, AdminStudentSummaryListForm form) {
        PageObj pageObj = this.adminStudentService.studentSummaryList(form);
        model.addAttribute("pageObj", (Object)pageObj);
        model.addAttribute("form", (Object)form);
        return "studentSummaryList";
    }

    @RequestMapping(value={"/summary/detail"})
    public String studentSummaryDetail(HttpServletRequest request, Model model, Integer id) {
        TStudentSummary tStudentSummary = this.adminStudentService.studentSummaryDetail(id);
        model.addAttribute("summary", (Object)tStudentSummary);
        return "studentSummaryDetail";
    }

    @RequestMapping(value={"/summary/edit"})
    @ResponseBody
    public Object studentSummaryEdit(HttpServletRequest request, Model model, AdminStudentSummaryEditForm form) throws BusinessException {
        ReturnMessageResult messageResult = this.adminStudentService.studentSummaryEdit(form);
        model.addAttribute("messageResult", (Object)messageResult);
        return JSONUtil.objToStr((Object)messageResult);
    }

    @RequestMapping(value={"/coursesession/edit"})
    public Object studentCoursesessionInfo(HttpServletRequest request, Model model, String cid_sessionid) throws BusinessException {
        List teacherList = this.tTeacherService.getAllTeachers();
        AdminStudentCoursesessionInfoResult studentCoursesessionInfo = this.adminStudentService.studentCoursesessionInfo(cid_sessionid);
        model.addAttribute("hours", (Object)DateUtils.hours);
        model.addAttribute("minuts", (Object)DateUtils.minuts);
        model.addAttribute("teachers", (Object)teacherList);
        model.addAttribute("dto", (Object)studentCoursesessionInfo);
        return "studentCoursesessionEdit";
    }

    @RequestMapping(value={"/coursesession/edit/save"})
    public Object studentCoursesessionInfoEdit(HttpServletRequest request, Model model, AdminStudentCoursesessionInfoEditForm form) throws BusinessException {
        String message = this.adminStudentService.studentCoursesessionInfoEdit(form);
        model.addAttribute("message", (Object)message);
        return "forward:/student/course/list";
    }

    @RequestMapping(value={"/coursesession/add"})
    public Object studentCoursesessionAdd(HttpServletRequest request, Model model, Integer sessionid) throws BusinessException {
        List coursesResultList = this.tCourseService.findAllCourses();
        if (sessionid == null || sessionid == 0) {
            System.out.println(request.getSession().getAttribute("coursesessionid"));
            sessionid = (Integer)request.getSession().getAttribute("coursesessionid");
        }
        AdminStudentCoursesessionInfoResult studentCoursesessionInfo = this.adminStudentService.studentCoursesessionAdd(sessionid);
        model.addAttribute("courses", (Object)coursesResultList);
        model.addAttribute("dtos", (Object)studentCoursesessionInfo);
        model.addAttribute("hours", (Object)DateUtils.hours);
        model.addAttribute("minuts", (Object)DateUtils.minuts);
        return "studentCoursesessionAdd";
    }

    @RequestMapping(value={"/find/course"})
    @ResponseBody
    public Object findCourse(HttpServletRequest request, Model model, Integer cid) throws BusinessException {
        AdminFindCourseResult courseResult = this.adminStudentService.findCourse(cid);
        return courseResult;
    }

    @RequestMapping(value={"/coursesession/add/save"})
    public Object studentCoursesessionAddSave(HttpServletRequest request, Model model, AdminStudentCoursesessionAddSaveForm form) throws BusinessException {
        UserDto user = (UserDto)request.getSession().getAttribute(TalkillaConstant.SESSION_CONSULTANT_LOGIN_PREFIX);
        form.setLoginId(user.getLoginId());
        ReturnMessageResult result = this.adminStudentService.studentCoursesessionAddSave(form);
        model.addAttribute("message", (Object)result.getMessage());
        request.getSession().setAttribute("coursesessionid", (Object)form.getSessionid());
        System.out.println(request.getSession().getAttribute("coursesessionid"));
        if (result.getFlag() == 0) {
            return "forward:/student/course/list";
        }
        return "forward:/student/coursesession/add";
    }

    @RequestMapping(value={"/coursesession/delete"})
    public Object studentCoursesessionDelete(HttpServletRequest request, Model model, Integer sessionid) throws BusinessException {
        UserDto user = (UserDto)request.getSession().getAttribute(TalkillaConstant.SESSION_CONSULTANT_LOGIN_PREFIX);
        ReturnMessageResult message = this.adminStudentService.studentCoursesessionDelete(user, sessionid);
        model.addAttribute("message", (Object)message.getMessage());
        return "forward:/student/course/list";
    }
}

