/*
 * Decompiled with CFR 0.152.
 */
package com.talkilla.controller;

import com.talkilla.constant.TalkillaConstant;
import com.talkilla.form.consultant.ConsultantQueryMessageForm;
import com.talkilla.mysql.domain.TConsultant;
import com.talkilla.mysql.domain.TMessage;
import com.talkilla.mysql.mapper.TConsultantDao;
import com.talkilla.otherbean.UserDto;
import com.talkilla.result.admin.base.PageObj;
import com.talkilla.service.teacher.ConsultantMessageService;
import javax.servlet.http.HttpSession;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
@RequestMapping(value={"/consultant/message"})
public class ConsultantMessageController {
    @Autowired
    private ConsultantMessageService consultantMessageService;
    @Autowired
    private TConsultantDao tConsultantDao;

    @RequestMapping(value={"/newest"})
    public String newest(Model model, HttpSession session) {
        UserDto userDto = (UserDto)session.getAttribute(TalkillaConstant.SESSION_CONSULTANT_LOGIN_PREFIX);
        Integer loginId = userDto.getLoginId();
        TConsultant tConsultant = this.tConsultantDao.findByLoginId(loginId);
        TMessage tMessage = this.consultantMessageService.getNewestUnReadMessage(tConsultant);
        model.addAttribute("message", (Object)tMessage);
        return "message/detail";
    }

    @RequestMapping(value={"/list"})
    public String list(ConsultantQueryMessageForm form, Model model, HttpSession session) {
        UserDto userDto = (UserDto)session.getAttribute(TalkillaConstant.SESSION_CONSULTANT_LOGIN_PREFIX);
        Integer loginId = userDto.getLoginId();
        TConsultant tConsultant = this.tConsultantDao.findByLoginId(loginId);
        form.setConsultantId(tConsultant.getConsultantId());
        PageObj pageObj = this.consultantMessageService.findPageMessage(form);
        model.addAttribute("pageObj", (Object)pageObj);
        model.addAttribute("form", (Object)form);
        return "message/list";
    }

    @RequestMapping(value={"/detail"})
    public String info(Model model, HttpSession session, Integer messageId) {
        UserDto userDto = (UserDto)session.getAttribute(TalkillaConstant.SESSION_CONSULTANT_LOGIN_PREFIX);
        Integer loginId = userDto.getLoginId();
        TConsultant tConsultant = this.tConsultantDao.findByLoginId(loginId);
        TMessage tMessage = this.consultantMessageService.fetchAndFreshMessageStatus(tConsultant, messageId);
        model.addAttribute("message", (Object)tMessage);
        return "message/detail";
    }

    @RequestMapping(value={"/mark/read"})
    public void readedStatusUpdate(Integer messageId, HttpSession session) {
        UserDto userDto = (UserDto)session.getAttribute(TalkillaConstant.SESSION_CONSULTANT_LOGIN_PREFIX);
        Integer loginId = userDto.getLoginId();
        TConsultant tConsultant = this.tConsultantDao.findByLoginId(loginId);
        this.consultantMessageService.readedStatusUpdate(messageId, tConsultant);
    }
}

