/*
 * Decompiled with CFR 0.152.
 */
package com.talkilla.controller;

import com.talkilla.constant.TalkillaConstant;
import com.talkilla.exception.UserException;
import com.talkilla.exception.base.ExceptionUtil;
import com.talkilla.form.admin.AdminLoginForm;
import com.talkilla.mysql.domain.TConsultant;
import com.talkilla.mysql.domain.TLogin;
import com.talkilla.mysql.domain.TMessage;
import com.talkilla.mysql.mapper.TConsultantDao;
import com.talkilla.otherbean.UserDto;
import com.talkilla.otherbean.ZTreeNode;
import com.talkilla.service.admin.AdminService;
import com.talkilla.service.teacher.ConsultantMessageService;
import com.talkilla.utils.DateUtils;
import com.talkilla.utils.PasswordUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.nestframework.commons.utils.StringUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/user"})
public class ConsultantController {
    @Autowired
    AdminService adminService;
    @Autowired
    private ConsultantMessageService consultantMessageService;
    @Autowired
    private TConsultantDao tConsultantDao;

    @ExceptionHandler(value={Exception.class})
    public ModelAndView handleException(Exception ex) {
        return ExceptionUtil.printErrorInfo((Exception)ex);
    }

    @RequestMapping(value={"/toLoginPage"}, method={RequestMethod.GET})
    public String loginIndex() {
        return "login";
    }

    @RequestMapping(value={"/login"})
    public String login(HttpServletRequest request, HttpSession session, Model model, AdminLoginForm form) throws UserException {
        form.setPassword(PasswordUtil.encrypt2((String)form.getPassword()).toLowerCase());
        TLogin loginUser = this.adminService.userLogin(form);
        if (loginUser != null) {
            if (loginUser.getRoleId() != TalkillaConstant.KEY_LOGIN_TYPE_CONSULTANT) {
                throw new UserException((Object)"1002", "\u8bf7\u4f7f\u7528\u6b63\u786e\u7684\u7528\u6237\u89d2\u8272\u767b\u5f55");
            }
        } else {
            model.addAttribute("message", (Object)"\u8d26\u53f7\u6216\u8005\u5bc6\u7801\u9519\u8bef");
            return "login";
        }
        UserDto d = new UserDto();
        d.setLoginId(loginUser.getLoginId());
        d.setLoginName(loginUser.getLoginName());
        d.setUsertype(100001);
        d.setLoginPwd(loginUser.getLoginPwd());
        d.setLoginCount(loginUser.getLoginCount());
        d.setIsConsultant(Integer.valueOf(1));
        request.getSession().setAttribute(TalkillaConstant.SESSION_CONSULTANT_LOGIN_PREFIX, (Object)d);
        return "redirect:/user/adminIndex";
    }

    @RequestMapping(value={"/adminIndex"}, method={RequestMethod.GET})
    public String adminIndex(HttpSession session, Model model) {
        UserDto user = (UserDto)session.getAttribute(TalkillaConstant.SESSION_CONSULTANT_LOGIN_PREFIX);
        model.addAttribute("sessionUser", (Object)user);
        return "index";
    }

    @RequestMapping(value={"/loginOut"}, method={RequestMethod.GET})
    public String loginOut(HttpServletRequest request, HttpSession session) {
        request.getSession().invalidate();
        return "login";
    }

    @RequestMapping(value={"/default"}, method={RequestMethod.GET})
    public String defaults(HttpServletRequest request, Model model) {
        UserDto userDto = (UserDto)request.getSession().getAttribute(TalkillaConstant.SESSION_CONSULTANT_LOGIN_PREFIX);
        if (userDto == null) {
            return "login";
        }
        String[] paras = this.adminService.processAdminInfosByLoginId();
        model.addAttribute("paras", (Object)paras);
        model.addAttribute("userDto", (Object)userDto);
        model.addAttribute("date", (Object)DateUtils.formatDateToDay((Date)new Date()));
        List cals = this.adminService.findAllCalendarsByLoginIdAndType(userDto.getLoginId(), Integer.valueOf(userDto.getUsertype()));
        model.addAttribute("cals", (Object)cals);
        Integer loginId = userDto.getLoginId();
        TConsultant tConsultant = this.tConsultantDao.findByLoginId(loginId);
        TMessage tMessage = this.consultantMessageService.getNewestUnReadMessage(tConsultant);
        if (Objects.nonNull(tMessage)) {
            model.addAttribute("messageId", (Object)tMessage.getId());
        }
        return "default";
    }

    @RequestMapping(value={"/menu"}, method={RequestMethod.POST})
    @ResponseBody
    public Object menu(HttpServletRequest request) {
        List rs = new ArrayList();
        UserDto userDto = (UserDto)request.getSession().getAttribute(TalkillaConstant.SESSION_CONSULTANT_LOGIN_PREFIX);
        if (userDto == null) {
            return rs;
        }
        rs = this.adminService.getMenuByConsult();
        String ctx = request.getContextPath();
        if (ctx.equals("/")) {
            ctx = "";
        }
        if (rs != null && rs.size() > 0) {
            for (ZTreeNode znode : rs) {
                if (StringUtil.isNotEmpty((String)znode.getUrl())) {
                    znode.setUrl(ctx + znode.getUrl());
                } else {
                    znode.setUrl("javascript:return false;");
                }
                znode.setMore("\u66f4\u591a");
            }
        }
        return rs;
    }

    @RequestMapping(value={"/forget/password"}, method={RequestMethod.GET})
    public String forgetPassword() {
        return "default";
    }
}

