/*
 * Decompiled with CFR 0.152.
 */
package com.talkilla.controller;

import com.talkilla.constant.TalkillaConstant;
import com.talkilla.form.SearchStudentsForm;
import com.talkilla.form.admin.AdminCoursePackageAddSaveForm;
import com.talkilla.form.admin.AdminCoursePackageQueryForm;
import com.talkilla.form.admin.AdminSellCourseEditSaveForm;
import com.talkilla.form.admin.AdminSellCourseListForm;
import com.talkilla.mysql.mapper.TSellCourseDao;
import com.talkilla.mysql.mapper.TSellCourseOrderDao;
import com.talkilla.otherbean.UserDto;
import com.talkilla.result.ReturnMessageResult;
import com.talkilla.result.admin.AdminCoursePackageAddResult;
import com.talkilla.result.admin.AdminCoursePackageDetailResult;
import com.talkilla.result.admin.AdminCoursePackageEditResult;
import com.talkilla.result.admin.AdminSellCourseListResult;
import com.talkilla.result.admin.base.PageObj;
import com.talkilla.service.TCourseService;
import com.talkilla.service.TLoginService;
import com.talkilla.service.TStudentService;
import com.talkilla.service.TTeacherService;
import com.talkilla.service.admin.AdminCourseService;
import com.talkilla.service.admin.AdminExportService;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/course"})
public class ConsultantCourseManageController {
    private SimpleDateFormat s = new SimpleDateFormat("yyyy-MM");
    @Autowired
    AdminCourseService adminCourseService;
    @Autowired
    TTeacherService tTeacherService;
    @Autowired
    TStudentService tStudentService;
    @Autowired
    TLoginService tLoginService;
    @Autowired
    TCourseService tCourseService;
    @Autowired
    AdminExportService adminExportService;
    @Autowired
    TSellCourseOrderDao tSellCourseOrderDao;
    @Autowired
    TSellCourseDao tSellCourseDao;

    @RequestMapping(value={"/sell/course/list"})
    public String sellCourseList(HttpServletRequest request, Model model, AdminSellCourseListForm form) {
        PageObj pageObj = this.adminCourseService.sellCourseList(form);
        model.addAttribute("pageObj", (Object)pageObj);
        model.addAttribute("form", (Object)form);
        return "sellCourseList";
    }

    @RequestMapping(value={"/sell/course/edit"})
    public String sellCourseEdit(HttpServletRequest request, Model model, Integer id) {
        AdminSellCourseListResult result = this.adminCourseService.sellCourseEdit(id);
        model.addAttribute("sellCourse", (Object)result);
        return "sellCourseDetail";
    }

    @RequestMapping(value={"/sell/course/edit/save"})
    @ResponseBody
    public Object sellCourseEditSave(HttpServletRequest request, Model model, AdminSellCourseEditSaveForm form) {
        ReturnMessageResult messageResult = this.adminCourseService.sellCourseEditSave(form);
        return messageResult;
    }

    @RequestMapping(value={"/sell/course/add"})
    public String sellCourseAdd() {
        return "sellCourseAdd";
    }

    @RequestMapping(value={"/sell/course/add/save"})
    @ResponseBody
    public Object sellCourseAddSave(HttpServletRequest request, Model model, AdminSellCourseEditSaveForm form) {
        ReturnMessageResult messageResult = this.adminCourseService.sellCourseAddSave(form);
        model.addAttribute("messageResult", (Object)messageResult);
        return messageResult;
    }

    @RequestMapping(value={"/course/package/list"})
    public String coursePackageList(HttpServletRequest req, HttpServletResponse res, HttpSession session, Model model, AdminCoursePackageQueryForm form) {
        PageObj pageObj = this.adminCourseService.findCoursePackageQuerys(form);
        model.addAttribute("pageObj", (Object)pageObj);
        model.addAttribute("form", (Object)form);
        return "coursePackageManageList";
    }

    @RequestMapping(value={"/course/package/delete"})
    @ResponseBody
    public Object coursePackageDelete(HttpServletRequest req, HttpServletResponse res, HttpSession session, Model model, Integer cid) {
        ReturnMessageResult messageResult = this.adminCourseService.coursePackageDelete(cid);
        return messageResult;
    }

    @RequestMapping(value={"/course/package/time/clear"})
    @ResponseBody
    public Object coursePackageTimeClear(HttpServletRequest req, HttpServletResponse res, HttpSession session, Model model, Integer cid) {
        ReturnMessageResult messageResult = this.adminCourseService.coursePackageTimeClear(cid);
        return messageResult;
    }

    @RequestMapping(value={"/course/package/detail"})
    public String coursePackageDetail(HttpServletRequest req, HttpServletResponse res, HttpSession session, Model model, Integer cid) {
        AdminCoursePackageDetailResult result = this.adminCourseService.coursePackageDetail(cid);
        model.addAttribute("courseDto", (Object)result);
        return "courseDetail";
    }

    @RequestMapping(value={"/course/package/add"})
    public String coursePackageAdd(HttpServletRequest req, HttpServletResponse res, Integer id, HttpSession session, Model model) {
        AdminCoursePackageAddResult result = this.adminCourseService.coursePackageAdd(id);
        model.addAttribute("result", (Object)result);
        model.addAttribute("sellCourseName", (Object)result.getSellCourseName());
        model.addAttribute("stuid", (Object)result.getStuid());
        model.addAttribute("stuname", (Object)result.getStuname());
        model.addAttribute("classid", (Object)new SimpleDateFormat("yyMMddHHmm").format(new Date()));
        model.addAttribute("sellCourseOrder", (Object)result.getSellCourseOrder());
        model.addAttribute("sellCourse", (Object)result.getSellCourse());
        model.addAttribute("date", (Object)new Date());
        model.addAttribute("showloginList", new ArrayList());
        return "coursePackageAdd";
    }

    @RequestMapping(value={"/course/package/add/save"})
    public String coursePackageAddSave(AdminCoursePackageAddSaveForm form, HttpServletRequest req, HttpServletResponse res, HttpSession session, Model model) {
        UserDto userDto = (UserDto)session.getAttribute(TalkillaConstant.SESSION_ADMIN_LOGIN_PREFIX);
        form.setLoginId(userDto.getLoginId());
        ReturnMessageResult messageResult = this.adminCourseService.coursePackageAddSave(form);
        model.addAttribute("message", (Object)messageResult.getMessage());
        return "forward:/course/course/package/list";
    }

    @RequestMapping(value={"/search/students"})
    public String searchStudents(HttpServletRequest req, HttpServletResponse res, SearchStudentsForm form, HttpSession session, Model model) {
        List list = this.tStudentService.findListsbyRemoveIds(form);
        model.addAttribute("list", (Object)list);
        model.addAttribute("form", (Object)form);
        return "openStudents";
    }

    @RequestMapping(value={"/course/package/edit"})
    public String coursePackageEdit(Model model, Integer cid) {
        AdminCoursePackageEditResult result = this.adminCourseService.coursePackageEdit(cid);
        model.addAttribute("result", (Object)result);
        model.addAttribute("sellCourseName", (Object)result.getSellCourseName());
        model.addAttribute("stuid", (Object)result.getStuid());
        model.addAttribute("stuname", (Object)result.getStuname());
        model.addAttribute("classid", (Object)new SimpleDateFormat("yyMMddHHmm").format(new Date()));
        model.addAttribute("date", (Object)new Date());
        model.addAttribute("showloginList", (Object)result.getStudentDtos());
        model.addAttribute("instance", (Object)result.getCourse());
        return "coursePackageEdit";
    }

    @RequestMapping(value={"/course/package/edit/save"})
    public String coursePackageEditSave(Model model, HttpSession session, AdminCoursePackageAddSaveForm form) {
        UserDto userDto = (UserDto)session.getAttribute(TalkillaConstant.SESSION_ADMIN_LOGIN_PREFIX);
        form.setLoginId(userDto.getLoginId());
        ReturnMessageResult messageResult = this.adminCourseService.coursePackageEditSave(form);
        model.addAttribute("message", (Object)messageResult.getMessage());
        return "forward:/course/course/package/list";
    }
}

