/*
 * Decompiled with CFR 0.152.
 */
package com.talkilla.utils.sql;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class SQLUtil {
    public static String addColumnAlias(String sqlColumns) {
        if (StringUtils.isEmpty((CharSequence)sqlColumns)) {
            return "";
        }
        String[] columns = sqlColumns.split(",");
        StringBuffer sql = new StringBuffer();
        int length = columns.length;
        for (int i = 0; i < length; ++i) {
            String column = columns[i];
            sql.append(column);
            if (column.indexOf("*") < 0) {
                String columnName = column.replaceAll(".*\\.", "");
                String alias = SQLUtil.underlineTohump(columnName);
                sql.append(" ").append(alias);
            }
            if (i >= length - 1) continue;
            sql.append(",");
        }
        return sql.toString();
    }

    public static String underlineTohump(String underlineString) {
        if (StringUtils.isEmpty((CharSequence)underlineString)) {
            return "";
        }
        String prefix = "";
        if (underlineString.charAt(0) == '_') {
            underlineString = underlineString.substring(1, underlineString.length());
            prefix = "_";
        }
        String regexStr = "_[0-9a-z]";
        Matcher matcher = Pattern.compile(regexStr).matcher(underlineString);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            String g = matcher.group();
            g = String.valueOf(g.charAt(1));
            matcher.appendReplacement(sb, g.toUpperCase());
        }
        matcher.appendTail(sb);
        sb.insert(0, prefix);
        return sb.toString();
    }

    public static String humpToUnderline(String humpString) {
        if (StringUtils.isEmpty((CharSequence)humpString)) {
            return "";
        }
        String prefix = "";
        if (humpString.charAt(0) == '_') {
            humpString = humpString.substring(1, humpString.length());
            prefix = "_";
        }
        String regexStr = "[A-Z]";
        Matcher matcher = Pattern.compile(regexStr).matcher(humpString);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            String g = matcher.group();
            matcher.appendReplacement(sb, "_" + g.toLowerCase());
        }
        matcher.appendTail(sb);
        if (sb.charAt(0) == '_') {
            sb.delete(0, 1);
        }
        sb.insert(0, prefix);
        return sb.toString();
    }

    public static String humpToUnderline2(String humpString) {
        if (StringUtils.isEmpty((CharSequence)humpString)) {
            return "";
        }
        String prefix = "";
        if (humpString.charAt(0) == '_') {
            humpString = humpString.substring(1, humpString.length());
            prefix = "_";
        }
        String regexStr = "[A-Z0-9]";
        Matcher matcher = Pattern.compile(regexStr).matcher(humpString);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            String g = matcher.group();
            matcher.appendReplacement(sb, "_" + g.toLowerCase());
        }
        matcher.appendTail(sb);
        if (sb.charAt(0) == '_') {
            sb.delete(0, 1);
        }
        sb.insert(0, prefix);
        return sb.toString();
    }

    public static void main(String[] args) {
        System.out.println(SQLUtil.underlineTohump("_afdsu_aoifudi_1"));
        System.out.println(SQLUtil.underlineTohump("_afdsu_aoifudi_1_0"));
        System.out.println(SQLUtil.underlineTohump("_afdsu_aoifudi_10"));
        System.out.println(SQLUtil.underlineTohump("_afdsuaoifudi"));
        System.out.println(SQLUtil.underlineTohump("_afdsu_aoifudi"));
        System.out.println(SQLUtil.underlineTohump("afdsu_aoi_fudi"));
        System.out.println(SQLUtil.humpToUnderline2(SQLUtil.underlineTohump("_afdsu_aoifudi_1")));
        System.out.println(SQLUtil.humpToUnderline2(SQLUtil.underlineTohump("_afdsu_aoifudi_10")));
        System.out.println(SQLUtil.humpToUnderline(SQLUtil.underlineTohump("_afdsuaoifudi")));
        System.out.println(SQLUtil.humpToUnderline(SQLUtil.underlineTohump("_afdsu_aoifudi")));
        System.out.println(SQLUtil.humpToUnderline(SQLUtil.underlineTohump("afdsu_aoi_fudi")));
        String src = "b.*_abd, user_id,store_id,store_name,owner_name,telephone,region_name,type,status,create_time ";
        System.out.println(SQLUtil.addColumnAlias(src));
        System.out.println(src.indexOf(".*") > 0);
    }
}

