/*
 * Decompiled with CFR 0.152.
 */
package com.talkilla.utils.sql;

import com.talkilla.utils.sql.SQLUtil;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import org.springframework.util.Assert;

public class BatchUpdateSQLBuilder<T> {
    private String tableName;
    private String primaryKey;
    private TreeSet<String> fields;
    private boolean selective = true;
    private List<T> dataList;
    private Set primaryValueList;
    private StringBuffer sb;
    private final String OPEN = " (";
    private final String CLOSE = ") ";
    private final String CONJUNCTION = ", ";
    private final String SET = " SET ";
    private final String EQUAL = " = ";
    private final String WHEN = " WHEN ";
    private final String CASE = " CASE ";
    private final String THEN = " THEN ";
    private final String END = " END ";
    private final String WHERE = " WHERE ";
    private final String IN = " IN ";

    public BatchUpdateSQLBuilder() {
        if (this.dataList == null) {
            this.dataList = new LinkedList<T>();
        }
        if (this.sb == null) {
            this.sb = new StringBuffer();
        }
        if (this.fields == null) {
            this.fields = new TreeSet();
        }
        if (this.primaryValueList == null) {
            this.primaryValueList = new HashSet();
        }
    }

    public BatchUpdateSQLBuilder setUpdateTable(String tableName, String primaryKey) {
        Assert.notNull((Object)tableName, (String)"update table name is empty");
        Assert.notNull((Object)primaryKey, (String)"primaryKey is empty");
        this.tableName = tableName;
        this.primaryKey = primaryKey;
        return this;
    }

    public BatchUpdateSQLBuilder setSelective(boolean selective) {
        this.selective = selective;
        return this;
    }

    public BatchUpdateSQLBuilder setData(T obj) {
        Class<?> clazz = obj.getClass();
        Method[] methods = clazz.getMethods();
        boolean flag = false;
        for (Method method : methods) {
            if (!method.getName().startsWith("get") || method.getName().equalsIgnoreCase("getClass")) continue;
            if (this.selective) {
                try {
                    if (Objects.isNull(method.invoke(obj, new Object[0]))) continue;
                    if (!flag) {
                        flag = true;
                    }
                    this.fields.add(method.getName());
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                }
                continue;
            }
            if (!flag) {
                flag = true;
            }
            this.fields.add(method.getName());
        }
        if (flag) {
            this.dataList.add(obj);
        }
        return this;
    }

    private String getBeanFieldName(String getMethodName) {
        String substring = getMethodName.substring(3);
        String substring1 = substring.substring(0, 1);
        String s = substring1.toLowerCase();
        String substring2 = substring.substring(1);
        return s + substring2;
    }

    public String toString() {
        if (!this.sb.toString().isEmpty()) {
            return this.sb.toString();
        }
        if (this.tableName == null || this.tableName.isEmpty()) {
            throw new IllegalArgumentException("update table name is null");
        }
        if (this.fields == null || this.fields.isEmpty()) {
            throw new IllegalArgumentException("field is null");
        }
        this.sb.append("UPDATE ").append(this.tableName).append(" SET ");
        Iterator<String> it = this.fields.iterator();
        while (it.hasNext()) {
            String field = it.next();
            String sqlField = this.specialHandleFieldName(SQLUtil.humpToUnderline2(this.getBeanFieldName(field)));
            this.sb.append(sqlField).append(" = ");
            this.sb.append(" CASE ").append(this.primaryKey);
            Iterator<T> iterator = this.dataList.iterator();
            while (iterator.hasNext()) {
                this.sb.append(" WHEN ");
                T next = iterator.next();
                Class<?> clazz = next.getClass();
                try {
                    Field primary = clazz.getDeclaredField(SQLUtil.underlineTohump(this.primaryKey));
                    primary.setAccessible(true);
                    try {
                        Object value = primary.get(next);
                        if (value != null && value instanceof String) {
                            String s = value.toString();
                            value = s.replace("'", "\\'");
                        }
                        Assert.notNull((Object)value, (String)"primary key value is null");
                        this.primaryValueList.add(value);
                        try {
                            Method method = clazz.getMethod(field, new Class[0]);
                            Object invoke = method.invoke(next, new Object[0]);
                            if (invoke != null && invoke instanceof String) {
                                String s = invoke.toString();
                                invoke = s.replace("'", "\\'");
                            }
                            if (invoke == null) {
                                this.sb.append(value).append(" THEN ").append(sqlField);
                            } else {
                                this.sb.append(value).append(" THEN ").append("'" + invoke + "'");
                            }
                            this.sb.append("");
                        }
                        catch (InvocationTargetException e) {
                            e.printStackTrace();
                        }
                        catch (NoSuchMethodException e) {
                            e.printStackTrace();
                        }
                    }
                    catch (IllegalAccessException e) {
                        e.printStackTrace();
                    }
                }
                catch (NoSuchFieldException e) {
                    e.printStackTrace();
                }
            }
            this.sb.append(" END ");
            if (!it.hasNext()) continue;
            this.sb.append(", ");
        }
        this.sb.append(" WHERE ").append(this.primaryKey).append(" IN ").append(" (");
        Iterator iterator = this.primaryValueList.iterator();
        while (iterator.hasNext()) {
            Object next = iterator.next();
            this.sb.append(next);
            if (!iterator.hasNext()) continue;
            this.sb.append(", ");
        }
        this.sb.append(") ");
        return this.sb.toString();
    }

    private String specialHandleFieldName(String fieldName) {
        return "`" + fieldName + "`";
    }
}

