/*
 * Decompiled with CFR 0.152.
 */
package com.talkilla.utils;

import java.math.BigDecimal;
import org.springframework.util.Assert;

public class MathUtils {
    public static BigDecimal add(BigDecimal d1, BigDecimal d2) {
        return d1.add(d2);
    }

    public static BigDecimal getMinusDecimal(BigDecimal decimal) {
        if (MathUtils.isBiggerOrEquals(decimal, new BigDecimal(0)).booleanValue()) {
            return decimal.multiply(new BigDecimal(-1));
        }
        return decimal;
    }

    public static BigDecimal add(BigDecimal d1, BigDecimal d2, BigDecimal d3) {
        return d1.add(d2).add(d3);
    }

    public static BigDecimal sub(BigDecimal d1, BigDecimal d2) {
        return d1.subtract(d2);
    }

    public static BigDecimal mul(BigDecimal d1, BigDecimal d2) {
        Double one = d1.doubleValue() * 1000.0;
        Double two = d2.doubleValue() * 1000.0;
        BigDecimal b1 = new BigDecimal(one);
        BigDecimal b2 = new BigDecimal(two);
        return MathUtils.div(b1.multiply(b2), new BigDecimal(1000000), 2);
    }

    public static BigDecimal div(BigDecimal d1, BigDecimal d2, int len) {
        return d1.divide(d2, len, 3);
    }

    public static BigDecimal div(Double d1, double d2, int len) {
        BigDecimal b1 = new BigDecimal(d1);
        BigDecimal b2 = new BigDecimal(d2);
        return b1.divide(b2, len, 3);
    }

    public static Boolean isBiggerOrEquals(BigDecimal d1, BigDecimal d2) {
        if (d1 == null) {
            return false;
        }
        if (d2 == null) {
            return true;
        }
        return d1.compareTo(d2) >= 0;
    }

    public static Boolean isBetweenZeroAndOneundred(BigDecimal d1) {
        Boolean result = false;
        if (d1 == null) {
            return false;
        }
        if (MathUtils.isBiggerOrEquals(d1, BigDecimal.ZERO).booleanValue() && d1.compareTo(new BigDecimal("100")) < 0) {
            result = true;
        }
        return result;
    }

    public static BigDecimal round(BigDecimal d1, int len) {
        BigDecimal b2 = new BigDecimal(1);
        return d1.divide(b2, len, 4);
    }

    public static BigDecimal floatRate(BigDecimal a, BigDecimal b) {
        Assert.notNull((Object)a, (String)"\u8ba1\u7b97\u503c\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.notNull((Object)b, (String)"\u8ba1\u7b97\u503c\u4e0d\u80fd\u4e3a\u7a7a");
        boolean flag = false;
        if (a.compareTo(b) < 0) {
            BigDecimal c = a;
            a = b;
            b = c;
            flag = true;
        } else if (a.compareTo(b) == 0) {
            return BigDecimal.ZERO;
        }
        if (b.compareTo(BigDecimal.ZERO) == 0) {
            BigDecimal mul = MathUtils.mul(a, new BigDecimal(100));
            if (flag) {
                mul = MathUtils.getMinusDecimal(mul);
            }
            return mul;
        }
        BigDecimal sub = MathUtils.sub(a, b);
        BigDecimal div = MathUtils.div(sub, b, 4);
        BigDecimal mul = MathUtils.mul(div, new BigDecimal(100));
        if (flag) {
            mul = MathUtils.getMinusDecimal(mul);
        }
        return mul;
    }

    public static BigDecimal percentage(BigDecimal a, BigDecimal b) {
        Assert.notNull((Object)a, (String)"\u8ba1\u7b97\u503c\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.notNull((Object)b, (String)"\u8ba1\u7b97\u503c\u4e0d\u80fd\u4e3a\u7a7a");
        if (a.compareTo(BigDecimal.ZERO) == 0 || b.compareTo(BigDecimal.ZERO) == 0) {
            return BigDecimal.ZERO;
        }
        BigDecimal div = MathUtils.div(a, b, 4);
        BigDecimal mul = MathUtils.mul(div, new BigDecimal(100));
        return mul;
    }

    public static Double getCoursesTimes(Double hour, Integer duration) {
        return hour * 60.0 / (double)duration.intValue();
    }

    public static Integer getIntegerFromDouble(Double dou) {
        double d = dou;
        String s1 = String.valueOf(d);
        String s2 = s1.substring(0, s1.indexOf("."));
        int i = Integer.parseInt(s2);
        return i;
    }

    public static Double add(Double d1, Double d2) {
        BigDecimal b1 = new BigDecimal(d1);
        BigDecimal b2 = new BigDecimal(d2);
        return b1.add(b2).doubleValue();
    }

    public static Double sub(Double d1, Double d2) {
        BigDecimal b1 = new BigDecimal(d1);
        BigDecimal b2 = new BigDecimal(d2);
        return b1.subtract(b2).doubleValue();
    }

    public static String getHourStrByDuration(Integer duration) {
        BigDecimal div = MathUtils.div(new BigDecimal(duration), new BigDecimal(60), 2);
        return div + "\u5c0f\u65f6";
    }

    public static String getStr(BigDecimal duration) {
        return duration.stripTrailingZeros().toString();
    }

    public static BigDecimal getHourByDuration(Integer duration) {
        BigDecimal div = MathUtils.div(new BigDecimal(duration), new BigDecimal(60), 2);
        return div;
    }

    public static void main(String[] args) {
        System.out.println(MathUtils.getHourStrByDuration(45));
        String str = MathUtils.getStr(new BigDecimal(11.0));
        System.out.println(str);
    }
}

