/*
 * Decompiled with CFR 0.152.
 */
package com.talkilla.utils;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JSONUtil {
    private static Logger logger = LoggerFactory.getLogger(JSONUtil.class);
    private static ObjectMappingCustomer selfMapper = new ObjectMappingCustomer();
    private static ObjectMappingCustomer dynamicSelfMapper = new ObjectMappingCustomer();

    public static String objToStr(Object obj) {
        return JSONUtil.objToStr(obj, false);
    }

    public static String objToStr(Object obj, boolean writeNull) {
        try {
            return writeNull ? selfMapper.writeValueAsString(obj) : dynamicSelfMapper.writeValueAsString(obj);
        }
        catch (Exception e) {
            logger.error("Error: {}", (Throwable)e);
            return null;
        }
    }

    public static <T> T strToObj(String str, Class<T> claz) {
        return JSONUtil.strToObj(str, claz, false);
    }

    public static <T> T strToObj(String str, Class<T> claz, boolean writeNull) {
        try {
            return (T)(writeNull ? selfMapper.readValue(str, claz) : dynamicSelfMapper.readValue(str, claz));
        }
        catch (Exception e) {
            logger.error("Error: {},{}", (Object)str, (Object)e);
            return null;
        }
    }

    public static <T> T cloneObj(T obj) {
        return (T)JSONUtil.cloneObj(obj, obj.getClass());
    }

    public static <T> T cloneObj(Object obj, Class<T> claz) {
        try {
            return (T)dynamicSelfMapper.readValue(dynamicSelfMapper.writeValueAsString(obj), claz);
        }
        catch (Exception e) {
            logger.error("Error: {},{}", (Object)claz.getName(), (Object)e);
            return null;
        }
    }

    public static String getParam(String content, String key) {
        Map result = JSONUtil.strToObj(content, Map.class);
        return String.valueOf(result.get(key));
    }

    static {
        dynamicSelfMapper.setSerializationInclusion(JsonInclude.Include.NON_EMPTY);
        dynamicSelfMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        dynamicSelfMapper.configure(JsonParser.Feature.ALLOW_UNQUOTED_CONTROL_CHARS, true);
    }

    public static class ObjectMappingCustomer
    extends ObjectMapper {
        private static final long serialVersionUID = 1L;

        public ObjectMappingCustomer() {
            this.getSerializerProvider().setNullKeySerializer((JsonSerializer)new JsonSerializer<Object>(){

                public void serialize(Object value, JsonGenerator gen, SerializerProvider serializers) throws IOException, JsonProcessingException {
                    gen.writeString("beiquan-null-key");
                }
            });
            this.getSerializerProvider().setNullValueSerializer((JsonSerializer)new JsonSerializer<Object>(){

                public void serialize(Object value, JsonGenerator gen, SerializerProvider serializers) throws IOException, JsonProcessingException {
                    gen.writeString("");
                }
            });
        }
    }
}

