/*
 * Decompiled with CFR 0.152.
 */
package com.talkilla.utils;

import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.acegisecurity.providers.encoding.PasswordEncoder;
import org.springframework.dao.DataAccessException;

public class Encryption
implements PasswordEncoder {
    public static String computeDigest(String str, String alg) {
        MessageDigest currentAlgorithm = null;
        try {
            currentAlgorithm = MessageDigest.getInstance(alg);
        }
        catch (NoSuchAlgorithmException e) {
            return str;
        }
        currentAlgorithm.reset();
        currentAlgorithm.update(str.getBytes());
        byte[] hash = currentAlgorithm.digest();
        String d = "";
        int usbyte = 0;
        for (int i = 0; i < hash.length; ++i) {
            usbyte = hash[i] & 0xFF;
            d = usbyte < 16 ? d + "0" + Integer.toHexString(usbyte) : d + Integer.toHexString(usbyte);
        }
        return d.toUpperCase();
    }

    public static String computeDigest(String str) {
        return Encryption.computeDigest(str, "MD5");
    }

    public static String createRegisterCode(String str) {
        return Encryption.computeDigest(str);
    }

    public static String encrypt(String str) {
        String s = "";
        try {
            s = new String(str.getBytes("iso8859-1"), "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            s = str;
        }
        if (!s.contains("?")) {
            str = s;
        }
        String digestStr = Encryption.computeDigest(str);
        return Encryption.computeDigest(digestStr);
    }

    public static String encode(String str) {
        byte[] bytesStr = str.getBytes();
        int i = 0;
        while (i < bytesStr.length) {
            int n = i++;
            bytesStr[n] = (byte)(bytesStr[n] ^ 0x1A);
        }
        return new String(bytesStr);
    }

    public static String decode(String str) {
        byte[] bytesStr = str.getBytes();
        int i = 0;
        while (i < bytesStr.length) {
            int n = i++;
            bytesStr[n] = (byte)(bytesStr[n] ^ 0x1A);
        }
        return new String(bytesStr);
    }

    public String encodePassword(String rawPass, Object salt) throws DataAccessException {
        return Encryption.encrypt(rawPass);
    }

    public boolean isPasswordValid(String encPass, String rawPass, Object salt) throws DataAccessException {
        return encPass.equals(Encryption.encrypt(rawPass));
    }
}

