/*
 * Decompiled with CFR 0.152.
 */
package com.talkilla.utils;

import com.talkilla.utils.Bean.MailSenderInfo;
import com.talkilla.utils.Bean.MyAuthenticator;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.springframework.util.CollectionUtils;

public class EmailUtils {
    public static boolean sendTextMail(MailSenderInfo mailInfo) {
        MyAuthenticator authenticator = null;
        Properties pro = mailInfo.getProperties();
        if (mailInfo.isValidate()) {
            authenticator = new MyAuthenticator(mailInfo.getUserName(), mailInfo.getPassword());
        }
        Session sendMailSession = Session.getDefaultInstance((Properties)pro, authenticator);
        try {
            MimeMessage mailMessage = new MimeMessage(sendMailSession);
            InternetAddress from = new InternetAddress(mailInfo.getFromAddress());
            mailMessage.setFrom((Address)from);
            InternetAddress to = new InternetAddress(mailInfo.getToAddress());
            mailMessage.setRecipient(Message.RecipientType.TO, (Address)to);
            mailMessage.setSubject(mailInfo.getSubject());
            mailMessage.setSentDate(new Date());
            String mailContent = mailInfo.getContent();
            mailMessage.setContent((Object)mailContent, "text/html;charset=UTF-8");
            List<String> addressList = mailInfo.getAddressList();
            if (!CollectionUtils.isEmpty(addressList)) {
                for (String address : addressList) {
                    mailMessage.setRecipient(Message.RecipientType.CC, (Address)new InternetAddress(address));
                }
            }
            Transport.send((Message)mailMessage);
            return true;
        }
        catch (MessagingException ex) {
            ex.printStackTrace();
            return false;
        }
    }

    public static boolean sendTextMail(MailSenderInfo mailInfo, List<String> addressList) {
        MyAuthenticator authenticator = null;
        Properties pro = mailInfo.getProperties();
        if (mailInfo.isValidate()) {
            authenticator = new MyAuthenticator(mailInfo.getUserName(), mailInfo.getPassword());
        }
        Session sendMailSession = Session.getDefaultInstance((Properties)pro, authenticator);
        try {
            MimeMessage mailMessage = new MimeMessage(sendMailSession);
            InternetAddress from = new InternetAddress(mailInfo.getFromAddress());
            mailMessage.setFrom((Address)from);
            InternetAddress to = new InternetAddress(mailInfo.getToAddress());
            mailMessage.setRecipient(Message.RecipientType.TO, (Address)to);
            if (addressList != null && addressList.size() > 0) {
                for (int i = 0; i < addressList.size(); ++i) {
                    mailMessage.addRecipient(Message.RecipientType.TO, (Address)new InternetAddress(addressList.get(i)));
                }
            }
            mailMessage.setSubject(mailInfo.getSubject());
            mailMessage.setSentDate(new Date());
            String mailContent = mailInfo.getContent();
            mailMessage.setText(mailContent);
            Transport.send((Message)mailMessage);
            return true;
        }
        catch (MessagingException ex) {
            ex.printStackTrace();
            return false;
        }
    }

    public static boolean sendHtmlMail(MailSenderInfo mailInfo) {
        MyAuthenticator authenticator = null;
        Properties pro = mailInfo.getProperties();
        if (mailInfo.isValidate()) {
            authenticator = new MyAuthenticator(mailInfo.getUserName(), mailInfo.getPassword());
        }
        Session sendMailSession = Session.getDefaultInstance((Properties)pro, authenticator);
        try {
            MimeMessage mailMessage = new MimeMessage(sendMailSession);
            InternetAddress from = new InternetAddress(mailInfo.getFromAddress());
            mailMessage.setFrom((Address)from);
            InternetAddress to = new InternetAddress(mailInfo.getToAddress());
            mailMessage.setRecipient(Message.RecipientType.TO, (Address)to);
            mailMessage.setSubject(mailInfo.getSubject());
            mailMessage.setSentDate(new Date());
            MimeMultipart mainPart = new MimeMultipart();
            MimeBodyPart html = new MimeBodyPart();
            html.setContent((Object)mailInfo.getContent(), "text/html; charset=utf-8");
            mainPart.addBodyPart((BodyPart)html);
            mailMessage.setContent((Multipart)mainPart);
            Transport.send((Message)mailMessage);
            return true;
        }
        catch (MessagingException ex) {
            ex.printStackTrace();
            return false;
        }
    }

    public static void main(String[] args) {
        MailSenderInfo mailInfo = new MailSenderInfo();
        mailInfo.setSubject("aa");
        mailInfo.setToAddress("552764143@qq.com");
        mailInfo.setContent("\u6d4b\u8bd5\n\u6d4b\u8bd51");
        EmailUtils sms = new EmailUtils();
        EmailUtils.sendTextMail(mailInfo);
    }
}

