/*
 * Decompiled with CFR 0.152.
 */
package com.talkilla.exception.base;

import com.talkilla.exception.base.BaseException;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.json.MappingJackson2JsonView;

public class ExceptionUtil {
    static final Logger logger = LoggerFactory.getLogger(ExceptionUtil.class);

    public static ModelAndView printErrorInfo(Exception ex) {
        ModelAndView mav = new ModelAndView();
        if (ex instanceof BaseException) {
            BaseException e = (BaseException)ex;
            logger.error("Error : ", (Throwable)ex);
            mav.addObject("code", e.getCode());
            mav.addObject("message", (Object)e.getMessage());
        } else {
            logger.error("Error : ", (Throwable)ex);
            mav.addObject("code", (Object)"9999");
            mav.addObject("message", (Object)"\u7f51\u7edc\u5f02\u5e38");
        }
        mav.setView((View)new MappingJackson2JsonView());
        return mav;
    }

    public static ModelAndView printVasClientErrorInfo(Exception ex) {
        ModelAndView mav = new ModelAndView();
        if (ex instanceof BaseException) {
            BaseException e = (BaseException)ex;
            logger.error("Error : ", (Throwable)ex);
            mav.addObject("code", (Object)Integer.parseInt(e.getCode().toString()));
            mav.addObject("message", (Object)e.getMessage());
        } else {
            logger.error("Error : ", (Throwable)ex);
            mav.addObject("code", (Object)Integer.parseInt("9999"));
            mav.addObject("message", (Object)"\u7f51\u7edc\u5f02\u5e38");
        }
        mav.setView((View)new MappingJackson2JsonView());
        return mav;
    }

    public static ModelAndView printStackTrace(Exception ex) {
        ModelAndView mav = new ModelAndView();
        logger.error("Error : ", (Throwable)ex);
        mav.addObject((Object)ex);
        mav.setView((View)new MappingJackson2JsonView());
        return mav;
    }

    public static void log(Logger logger, Throwable e) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        PrintStream pout = new PrintStream(out);
        e.printStackTrace(pout);
        String sw = new String(out.toByteArray());
        pout.close();
        try {
            out.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        logger.error(sw.toString());
    }
}

