/*
 * Decompiled with CFR 0.152.
 */
package com.talkilla.utils.sql;

import com.talkilla.utils.DateUtils;
import com.talkilla.utils.sql.SQLUtil;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.TreeSet;
import org.springframework.util.Assert;

public class BatchInsertSQLBuilder<T> {
    private String tableName;
    private TreeSet<String> fields;
    private boolean selective = true;
    private List<T> dataList;
    private StringBuffer sb;
    private final String open = " (";
    private final String close = ") ";
    private final String conjunction = ", ";

    public BatchInsertSQLBuilder() {
        if (this.dataList == null) {
            this.dataList = new LinkedList<T>();
        }
        if (this.sb == null) {
            this.sb = new StringBuffer();
        }
        if (this.fields == null) {
            this.fields = new TreeSet();
        }
    }

    public BatchInsertSQLBuilder setInsertTable(String tableName) {
        Assert.notNull((Object)tableName, (String)"insert table is empty");
        this.tableName = tableName;
        return this;
    }

    public BatchInsertSQLBuilder setSelective(boolean selective) {
        this.selective = selective;
        return this;
    }

    public BatchInsertSQLBuilder setData(T obj) {
        Class<?> clazz = obj.getClass();
        Method[] methods = clazz.getMethods();
        boolean flag = false;
        for (Method method : methods) {
            if (!method.getName().startsWith("get") || method.getName().equalsIgnoreCase("getClass")) continue;
            if (this.selective) {
                try {
                    if (Objects.isNull(method.invoke(obj, new Object[0]))) continue;
                    if (!flag) {
                        flag = true;
                    }
                    this.fields.add(method.getName());
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                }
                continue;
            }
            if (!flag) {
                flag = true;
            }
            this.fields.add(method.getName());
        }
        if (flag) {
            this.dataList.add(obj);
        }
        return this;
    }

    private String getBeanFieldName(String getMethodName) {
        String substring = getMethodName.substring(3);
        String substring1 = substring.substring(0, 1);
        String s = substring1.toLowerCase();
        String substring2 = substring.substring(1);
        return s + substring2;
    }

    public String toString() {
        if (!this.sb.toString().isEmpty()) {
            return this.sb.toString();
        }
        if (this.tableName == null || this.tableName.isEmpty()) {
            throw new IllegalArgumentException("insert table name is null");
        }
        if (this.fields == null || this.fields.isEmpty()) {
            throw new IllegalArgumentException("field is null");
        }
        this.sb.append("INSERT INTO " + this.tableName);
        this.sb.append(" (");
        Iterator<String> iterator = this.fields.iterator();
        while (iterator.hasNext()) {
            String field = iterator.next();
            this.sb.append(this.specialHandleFieldName(SQLUtil.humpToUnderline2(this.getBeanFieldName(field))));
            if (!iterator.hasNext()) continue;
            this.sb.append(", ");
        }
        this.sb.append(") ");
        this.sb.append("VALUES ");
        Iterator<T> iterator1 = this.dataList.iterator();
        while (iterator1.hasNext()) {
            T t = iterator1.next();
            this.sb.append(" (");
            iterator = this.fields.iterator();
            while (iterator.hasNext()) {
                String field = iterator.next();
                try {
                    Method method = t.getClass().getMethod(field, new Class[0]);
                    try {
                        String s;
                        Object invoke = method.invoke(t, new Object[0]);
                        if (invoke != null && invoke instanceof String) {
                            s = invoke.toString();
                            invoke = s.replace("'", "\\'");
                        } else if (invoke != null && invoke instanceof Date) {
                            invoke = DateUtils.formatDate((Date)invoke, "yyyy-MM-dd HH:mm:ss");
                            s = invoke.toString();
                            invoke = s.replace("'", "\\'");
                        }
                        this.sb.append(invoke == null ? "null" : "'" + invoke + "'");
                        if (!iterator.hasNext()) continue;
                        this.sb.append(", ");
                    }
                    catch (IllegalAccessException e) {
                        e.printStackTrace();
                    }
                    catch (InvocationTargetException e) {
                        e.printStackTrace();
                    }
                }
                catch (NoSuchMethodException e) {
                    e.printStackTrace();
                }
            }
            this.sb.append(") ");
            if (!iterator1.hasNext()) continue;
            this.sb.append(", ");
        }
        return this.sb.toString();
    }

    private String specialHandleFieldName(String fieldName) {
        return "`" + fieldName + "`";
    }
}

