/*
 * Decompiled with CFR 0.152.
 */
package com.talkilla.utils;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.multipart.MultipartFile;

public class UploadPhotoUtils {
    private static final Logger logger = LoggerFactory.getLogger(UploadPhotoUtils.class);

    public static String savePhoto(MultipartFile photo, String oldPhotoPath, String generatePath) {
        try {
            String filePath = "";
            String photoDir = "/tmp/photo";
            if (logger.isDebugEnabled()) {
                logger.info("\u5b58\u7167\u7247\u7684\u8def\u5f84photoDir=" + photoDir);
            }
            if (photo != null) {
                File tempFile;
                String absolutePath = "";
                if (null != oldPhotoPath && !"".equals(oldPhotoPath) && (tempFile = new File(absolutePath = photoDir + File.separator + oldPhotoPath)).exists()) {
                    tempFile.delete();
                }
                String res = generatePath + File.separator + System.currentTimeMillis() + "." + UploadPhotoUtils.getExtName(photo.getOriginalFilename());
                filePath = photoDir + File.separator + res;
                File file = new File(filePath);
                photo.transferTo(file);
                filePath = res;
                if (logger.isDebugEnabled()) {
                    logger.info(filePath);
                }
            }
            return filePath;
        }
        catch (FileNotFoundException e) {
            logger.error(e.getMessage() + e.fillInStackTrace());
        }
        catch (IOException ioe) {
            logger.error(ioe.getMessage() + ioe.fillInStackTrace());
        }
        catch (Exception ep) {
            logger.error("\u4fdd\u5b58\u7167\u7247\u5f02\u5e38", (Throwable)ep);
        }
        return null;
    }

    private static String getExtName(String filename) {
        String extName = "";
        if (filename != null) {
            extName = filename.substring(filename.lastIndexOf(".") + 1);
        }
        return extName;
    }
}

