/*
 * Decompiled with CFR 0.152.
 */
package com.talkilla.utils;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.MultiFormatWriter;
import com.google.zxing.WriterException;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.util.Hashtable;
import javax.imageio.ImageIO;

public class QRCodeUtil {
    private static final String CHARSET = "UTF-8";
    private static final String FORMAT_NAME = "JPG";
    private static final int QRCODE_SIZE = 209;
    private static Color color1 = new Color(222, 125, 106);
    private static Color color2 = new Color(246, 196, 71);
    private static Color color3 = new Color(232, 139, 72);
    private static Color color4 = new Color(87, 190, 197);

    private static BufferedImage createImage(String content, String bgImagePath) throws WriterException, IOException {
        Hashtable<EncodeHintType, Object> hints = new Hashtable<EncodeHintType, Object>();
        hints.put(EncodeHintType.ERROR_CORRECTION, ErrorCorrectionLevel.H);
        hints.put(EncodeHintType.CHARACTER_SET, CHARSET);
        hints.put(EncodeHintType.MARGIN, 1);
        BitMatrix bitMatrix = new MultiFormatWriter().encode(content, BarcodeFormat.QR_CODE, 209, 209, hints);
        int width = bitMatrix.getWidth();
        int height = bitMatrix.getHeight();
        BufferedImage image = new BufferedImage(width, height, 1);
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                int rgb = 0;
                rgb = x < width / 4 ? color1.getRGB() : (x < width * 2 / 4 ? color2.getRGB() : (x < width * 3 / 4 ? color3.getRGB() : color4.getRGB()));
                image.setRGB(x, y, bitMatrix.get(x, y) ? rgb : -1);
            }
        }
        if (bgImagePath == null || "".equals(bgImagePath)) {
            return image;
        }
        return QRCodeUtil.insertImage(image, bgImagePath);
    }

    private static BufferedImage insertImage(BufferedImage source2, String bgImagePath) throws IOException {
        URL url = new URL(bgImagePath);
        BufferedImage bgImg = ImageIO.read(url.openStream());
        int x = 773;
        int y = 1363;
        Graphics2D bgGraph = bgImg.createGraphics();
        bgGraph.drawImage(source2, x, y, 209, 209, null);
        return bgImg;
    }

    public static void encode(String content, String bgImagePath, OutputStream output) throws Exception {
        BufferedImage image = QRCodeUtil.createImage(content, bgImagePath);
        ImageIO.write((RenderedImage)image, FORMAT_NAME, output);
    }
}

