/*
 * Decompiled with CFR 0.152.
 */
package com.talkilla.utils;

import com.aliyuncs.AcsRequest;
import com.aliyuncs.DefaultAcsClient;
import com.aliyuncs.dysmsapi.model.v20170525.SendSmsRequest;
import com.aliyuncs.dysmsapi.model.v20170525.SendSmsResponse;
import com.aliyuncs.exceptions.ClientException;
import com.aliyuncs.profile.DefaultProfile;
import com.aliyuncs.profile.IClientProfile;
import com.talkilla.constant.SystemConfig;
import com.talkilla.exception.BusinessException;
import com.talkilla.utils.HashMapUtil;
import com.talkilla.utils.JSONUtil;
import java.util.Map;

public class MoblieMessageUtil {
    private static final String product = "Dysmsapi";
    private static final String domain = "dysmsapi.aliyuncs.com";
    private static String accessKeyId = SystemConfig.Sms.SMS_KEY;
    private static String accessKeySecret = SystemConfig.Sms.SMS_SECRET;
    private static String signName = SystemConfig.Sms.SMS_PRODUCTNAME;
    private static String identifyingTempleteCode = SystemConfig.Sms.SMS_TEMPLATECODE_SEND;
    private static String registTempleteCode = SystemConfig.Sms.SMS_TEMPLATECODE_SEND;

    public static void init(String accessKeyId, String accessKeySecret, String signName, String identifyingTempleteCode, String registTempleteCode) {
        MoblieMessageUtil.accessKeyId = accessKeyId;
        MoblieMessageUtil.accessKeySecret = accessKeySecret;
        MoblieMessageUtil.signName = signName;
        MoblieMessageUtil.identifyingTempleteCode = identifyingTempleteCode;
        MoblieMessageUtil.registTempleteCode = registTempleteCode;
    }

    public static SendSmsResponse sendSms(String mobile, Map<String, Object> templateParam, String templateCode) throws ClientException {
        System.setProperty("sun.net.client.defaultConnectTimeout", "10000");
        System.setProperty("sun.net.client.defaultReadTimeout", "10000");
        DefaultProfile profile = DefaultProfile.getProfile((String)"cn-hangzhou", (String)accessKeyId, (String)accessKeySecret);
        DefaultProfile.addEndpoint((String)"cn-hangzhou", (String)"cn-hangzhou", (String)product, (String)domain);
        DefaultAcsClient acsClient = new DefaultAcsClient((IClientProfile)profile);
        SendSmsRequest request = new SendSmsRequest();
        request.setPhoneNumbers(mobile);
        request.setSignName(signName);
        request.setTemplateCode(templateCode);
        request.setTemplateParam(JSONUtil.objToStr(templateParam));
        SendSmsResponse sendSmsResponse = (SendSmsResponse)acsClient.getAcsResponse((AcsRequest)request);
        return sendSmsResponse;
    }

    public static SendSmsResponse sendNewUserNotice(String mobile, String username, String password) throws BusinessException {
        try {
            return MoblieMessageUtil.sendSms(mobile, HashMapUtil.build().append("username", username).append("password", password).fetchAll(), registTempleteCode);
        }
        catch (ClientException e) {
            throw new BusinessException((Object)"1001", e.getMessage());
        }
    }

    public static SendSmsResponse sendIdentifyingCode(String mobile, String code) throws BusinessException {
        try {
            return MoblieMessageUtil.sendSms(mobile, HashMapUtil.build().append("code", code).fetchAll(), identifyingTempleteCode);
        }
        catch (ClientException e) {
            throw new BusinessException((Object)"1001", e.getMessage());
        }
    }
}

