/*
 * Decompiled with CFR 0.152.
 */
package com.talkilla.utils;

import com.talkilla.utils.EncryptUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.util.URIUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpUtils {
    static Logger logger = LoggerFactory.getLogger(HttpUtils.class);
    public static int readTimeout = 30000;
    public static int connectionTimeout = 30000;
    public static String defaultEncoding = "UTF-8";
    public static Integer POST_TYPE_FORM = 1;
    public static Integer POST_TYPE_JSON = 2;

    public static String httpGet(String urlStr, Map<String, Object> param, String paramEncoding) {
        if (paramEncoding == null || "".equals(paramEncoding.trim())) {
            paramEncoding = defaultEncoding;
        }
        try {
            StringBuffer paramStr = new StringBuffer();
            if (param != null && param.size() > 0) {
                for (String key : param.keySet()) {
                    Object value = param.get(key);
                    if (value == null) {
                        value = "";
                    }
                    if (value instanceof String) {
                        value = URLEncoder.encode(value.toString(), paramEncoding);
                    }
                    paramStr.append("&").append(key).append("=").append(value);
                }
            }
            return HttpUtils.httpGet(urlStr, paramStr.length() > 1 ? paramStr.substring(1) : null, paramEncoding, null, null);
        }
        catch (Exception e) {
            logger.error("GET:" + urlStr, (Throwable)e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String httpGet(String urlStr, String param, String paramEncoding, String resultEncoding, Integer conTimeout) {
        if (paramEncoding == null || "".equals(paramEncoding.trim())) {
            paramEncoding = defaultEncoding;
        }
        if (resultEncoding == null || "".equals(resultEncoding.trim())) {
            resultEncoding = defaultEncoding;
        }
        HttpURLConnection con = null;
        BufferedReader reader = null;
        try {
            String line;
            if (param != null && !"".equals(param.trim())) {
                urlStr = urlStr.contains("?") ? urlStr + "&" + param : urlStr + "?" + param;
            }
            URL url = new URL(urlStr);
            con = (HttpURLConnection)url.openConnection();
            if (conTimeout == null) {
                con.setConnectTimeout(connectionTimeout);
            } else {
                con.setConnectTimeout(conTimeout * 1000);
            }
            con.setReadTimeout(readTimeout);
            con.connect();
            reader = new BufferedReader(new InputStreamReader(con.getInputStream(), resultEncoding));
            StringBuffer result = new StringBuffer();
            while ((line = reader.readLine()) != null) {
                result.append(line + "\n");
            }
            String string = result.toString();
            return string;
        }
        catch (Exception e) {
            logger.error("GET:" + urlStr, (Throwable)e);
        }
        finally {
            try {
                reader.close();
            }
            catch (Exception e) {
                logger.error("GET:" + urlStr, (Throwable)e);
            }
            try {
                con.disconnect();
            }
            catch (Exception e) {
                logger.error("GET:" + urlStr, (Throwable)e);
            }
        }
        return null;
    }

    public static String httpPost(String urlStr, Map<String, Object> param, String paramEncoding) {
        if (paramEncoding == null || "".equals(paramEncoding.trim())) {
            paramEncoding = defaultEncoding;
        }
        try {
            StringBuffer paramStr = new StringBuffer();
            if (param != null && param.size() > 0) {
                for (String key : param.keySet()) {
                    Object value = param.get(key);
                    if (value == null) {
                        value = "";
                    }
                    paramStr.append("&").append(key).append("=").append(value);
                }
            }
            return HttpUtils.httpPost(urlStr, paramStr.length() > 1 ? paramStr.substring(1) : null, POST_TYPE_FORM, paramEncoding, null, null);
        }
        catch (Exception e) {
            logger.error("GET:" + urlStr, (Throwable)e);
            return null;
        }
    }

    public static String httpPost(String urlStr, String params) {
        return HttpUtils.httpPost(urlStr, params, POST_TYPE_JSON, "UTF-8", null, null);
    }

    public static String httpPost(String urlStr, String params, String paramEncoding, String resultEncoding, Integer conTimeout) {
        return HttpUtils.httpPost(urlStr, params, POST_TYPE_FORM, paramEncoding, resultEncoding, conTimeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String httpPost(String urlStr, String params, Integer type, String paramEncoding, String resultEncoding, Integer conTimeout) {
        HttpURLConnection urlConn = null;
        BufferedReader in = null;
        try {
            String line;
            if (paramEncoding == null || paramEncoding.trim().equals("")) {
                paramEncoding = defaultEncoding;
            }
            if (resultEncoding == null || resultEncoding.trim().equals("")) {
                resultEncoding = defaultEncoding;
            }
            StringBuffer result = new StringBuffer();
            URL destURL = new URL(urlStr);
            urlConn = (HttpURLConnection)destURL.openConnection();
            if (POST_TYPE_FORM.equals(type)) {
                urlConn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded; charset=" + paramEncoding.toLowerCase());
            } else if (POST_TYPE_JSON.equals(type)) {
                urlConn.setRequestProperty("Content-Type", "application/json; charset=" + paramEncoding.toLowerCase());
            }
            urlConn.setDoOutput(true);
            urlConn.setDoInput(true);
            urlConn.setAllowUserInteraction(false);
            urlConn.setUseCaches(false);
            urlConn.setRequestMethod("POST");
            if (conTimeout == null) {
                urlConn.setConnectTimeout(connectionTimeout);
            } else {
                urlConn.setConnectTimeout(conTimeout * 1000);
            }
            urlConn.setReadTimeout(readTimeout);
            OutputStream os = urlConn.getOutputStream();
            if (params != null) {
                os.write(params.getBytes(paramEncoding));
            }
            in = new BufferedReader(new InputStreamReader(urlConn.getInputStream(), resultEncoding));
            while ((line = in.readLine()) != null) {
                result.append(line + "\n");
            }
            String string = result.toString();
            return string;
        }
        catch (Exception e) {
            logger.error("POST:" + urlStr, (Throwable)e);
        }
        finally {
            try {
                in.close();
            }
            catch (IOException e) {
                logger.error("POST:" + urlStr, (Throwable)e);
            }
            try {
                urlConn.disconnect();
            }
            catch (Exception e) {
                logger.error("POST:" + urlStr, (Throwable)e);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void downloadFile(String urlStr, String fileName) {
        HttpURLConnection con = null;
        BufferedInputStream input = null;
        FilterOutputStream output = null;
        try {
            URL url = new URL(urlStr);
            con = (HttpURLConnection)url.openConnection();
            con.connect();
            String disposition = con.getHeaderField("Content-Disposition");
            String suffix = ".unknow";
            if (disposition != null && disposition.contains("filename")) {
                suffix = disposition.replaceAll("\"", "").substring(disposition.lastIndexOf(".") - 1);
            }
            input = new BufferedInputStream(con.getInputStream());
            output = new BufferedOutputStream(new FileOutputStream(fileName + suffix));
            int len = 3096;
            byte[] buffer = new byte[len];
            while ((len = input.read(buffer)) != -1) {
                ((BufferedOutputStream)output).write(buffer, 0, len);
            }
            ((BufferedOutputStream)output).flush();
        }
        catch (Exception e) {
            logger.error("GET:" + urlStr, (Throwable)e);
        }
        finally {
            try {
                input.close();
            }
            catch (Exception e) {
                logger.error("GET:" + urlStr, (Throwable)e);
            }
            try {
                output.close();
            }
            catch (Exception e) {
                logger.error("GET:" + urlStr, (Throwable)e);
            }
            try {
                con.disconnect();
            }
            catch (Exception e) {
                logger.error("GET:" + urlStr, (Throwable)e);
            }
        }
    }

    public static String postByToken(Map<String, String> parameter, String url, String token) throws IOException {
        Set<Map.Entry<String, String>> set = parameter.entrySet();
        Iterator<Map.Entry<String, String>> iterator = set.iterator();
        ArrayList<String> list = new ArrayList<String>();
        String digest = "";
        while (iterator.hasNext()) {
            Map.Entry<String, String> data = iterator.next();
            list.add(data.getKey() + "=" + data.getValue());
        }
        Collections.sort(list);
        NameValuePair[] param = new NameValuePair[list.size() + 1];
        for (int i = 0; i < list.size(); ++i) {
            String[] temp = ((String)list.get(i)).split("=");
            param[i] = new NameValuePair(temp[0], temp[1]);
            digest = digest + (String)list.get(i) + "&";
        }
        digest = digest + token;
        System.out.println("new digest sort" + digest);
        String salt = EncryptUtil.encryptMD5(digest);
        param[list.size()] = new NameValuePair("salt", salt);
        HttpClient client = new HttpClient();
        PostMethod post = new PostMethod(url);
        post.setRequestHeader("apt-version", "1.0");
        post.setRequestHeader("client", "mrzjClient");
        post.setRequestHeader("Content-Type", "application/x-www-form-urlencoded;charset=utf8");
        post.setRequestBody(param);
        post.releaseConnection();
        int statusCode = client.executeMethod((HttpMethod)post);
        if (statusCode != 200) {
            System.err.println("Method failed: " + post.getStatusLine());
        }
        byte[] responseBody = post.getResponseBody();
        return new String(responseBody, "utf-8");
    }

    public static String getByToken(Map<String, String> parameter, String url, String token) throws IOException {
        Set<Map.Entry<String, String>> set = parameter.entrySet();
        Iterator<Map.Entry<String, String>> iterator = set.iterator();
        ArrayList<String> list = new ArrayList<String>();
        String digest = "";
        while (iterator.hasNext()) {
            Map.Entry<String, String> data = iterator.next();
            list.add(data.getKey() + "=" + data.getValue());
        }
        Collections.sort(list);
        for (int i = 0; i < list.size(); ++i) {
            digest = digest + (String)list.get(i) + "&";
        }
        String path = digest;
        digest = digest + token;
        String salt = EncryptUtil.encryptMD5(digest);
        path = path + "salt=" + salt;
        GetMethod method = new GetMethod(URIUtil.encodeQuery((String)(url + "?" + path)));
        method.setRequestHeader("apt-version", "1.0");
        method.setRequestHeader("client", "mrzjClient");
        method.setRequestHeader("Content-Type", "application/x-www-form-urlencoded;charset=utf8");
        HttpClient client = new HttpClient();
        int statusCode = client.executeMethod((HttpMethod)method);
        if (statusCode != 200) {
            System.err.println("Method failed: " + method.getStatusLine());
        }
        byte[] responseBody = method.getResponseBody();
        return new String(responseBody, "utf-8");
    }
}

