/*
 * Decompiled with CFR 0.152.
 */
package com.talkilla.utils;

import com.talkilla.utils.DateUtils;
import java.beans.PropertyDescriptor;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFDateUtil;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.poifs.filesystem.FileMagic;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.DataFormat;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.ss.util.RegionUtil;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;
import org.springframework.web.multipart.MultipartFile;

public class ExcelUtils {
    private static final Logger logger = LoggerFactory.getLogger(ExcelUtils.class);
    private static final String VERSION_2003 = "2003";
    private static final String VERSION_2007 = "2007";
    private static final String VERSION_2003_SUFFIX = "xls";
    private static final String VERSION_2007_SUFFIX = "xlsx";
    private static final String ENTER_SIGN = "(\n)";
    private static final Short FONT_SIZE = 11;
    private static final String FONT_NAME = "\u5fae\u8f6f\u96c5\u9ed1";
    private static final int DEFAULT_EXCEL_ROW_NUM = 5000;
    private static final int MAX_HEADER_ROW_NUM = 20;
    private static final int DEFAULT_CELL_WIDTH = 25;
    private static final int DEFAULT_ROW_HEIGHT = 500;
    private static final int DEFAULT_CELL_WIDTH_MULTIPLE = 256;
    private static final String DEFAULT_SERIAL_NUM = "\u5e8f\u53f7";
    private static final String DATE_FORMAT = "yyyy/MM/dd";
    private static final String DATETIME_FORMAT = "yyyy-MM-dd hh:mm:ss";
    private static final String CHINESE_REGEX = "\ufeff([\u3001-\u3003]|[\u4e00-\u9fa5]|[\ufe30-\uffa0])+";
    private static final int EVEN = 2;
    private static final String CHINA_LEFT_BRACKET = "\uff08";
    private static final String NEW_LINE_SIGN = "\r\n";

    public static <T> void checkExcelTemplateIsCorrect(InputStream in, Class<T> clazz, int startRow) throws Exception {
        Field[] fields;
        HashMap<String, String> headerNames = new HashMap<String, String>();
        HashMap extendColumns = new HashMap();
        for (Field m : fields = clazz.getDeclaredFields()) {
            if (!m.isAnnotationPresent(Header.class)) continue;
            Header anno = m.getAnnotation(Header.class);
            headerNames.put(anno.name(), m.getName());
        }
        if (headerNames.isEmpty()) {
            in.close();
            throw new RuntimeException("\u6a21\u677f\u5bfc\u5165\u5934\u90e8\u683c\u5f0f\u9519\u8bef");
        }
        Workbook xwb = ExcelUtils.newExcelByInputStream(in);
        Sheet sheet = xwb.getSheetAt(0);
        Row headerRow = sheet.getRow(startRow - 1);
        if (headerRow == null) {
            throw new RuntimeException("\u5bfc\u5165Excel\u6587\u4ef6\u4e3a\u7a7a");
        }
        Set keySet = headerNames.keySet();
        int rowNum = headerRow.getLastCellNum();
        if (keySet.size() != 0 && rowNum > 0) {
            for (int i = 0; i < rowNum; ++i) {
                String cell = headerRow.getCell(i).getStringCellValue();
                if (keySet.contains(cell)) continue;
                throw new RuntimeException("\u672a\u4e0a\u4f20\u6b63\u786e\u6a21\u677f");
            }
        }
    }

    public static <T> List<T> loadFromExcel(MultipartFile file, Class<T> clazz) throws Exception {
        InputStream in = file.getInputStream();
        return ExcelUtils.loadFromExcel(in, clazz);
    }

    public static <T> List<T> loadFromExcel(String filePath, Class<T> clazz) throws Exception {
        FileInputStream in = new FileInputStream(new File(filePath));
        return ExcelUtils.loadFromExcel(in, clazz);
    }

    public static <T> List<T> loadFromExcel(InputStream in, Class<T> clazz) throws Exception {
        LinkedHashMap<String, String> headerNames = new LinkedHashMap<String, String>(10);
        ExcelUtils.getTitles(in, clazz, headerNames);
        Workbook xwb = ExcelUtils.newExcelByInputStream(in);
        Sheet sheet = xwb.getSheetAt(0);
        Row headerRow = ExcelUtils.validExcelFormatAndGetHeaderRow(sheet, headerNames);
        List<T> list = ExcelUtils.transferExcelData(clazz, headerNames, sheet, headerRow);
        return list;
    }

    public static <T> boolean writeToExcel(OutputStream out, Class<T> clazz, List<T> list) {
        return ExcelUtils.writeToExcel(out, clazz, list, null);
    }

    public static <T> void downloadExcelForTemplate(HttpServletResponse response, Class<T> clazz, String fileNamePrefix, String specialTitleContent, List<Integer> columnNoList) {
        try {
            response.setContentType("application/form-data");
            String fileName = new String(fileNamePrefix.getBytes("utf-8"), "ISO8859-1");
            response.setHeader("Content-Disposition", "attachment;filename=" + fileName + DateUtils.formatDate(new Date(), "yyyy-MM-dd") + ".xlsx");
            Workbook workbook = ExcelUtils.writeToWorkbookForTemplate(clazz, specialTitleContent, columnNoList);
            if (null != workbook) {
                workbook.write((OutputStream)response.getOutputStream());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static <T> boolean writeToExcelForTemplate(OutputStream out, Class<T> clazz, String specialTitleContent, List<Integer> columnNoList) {
        Workbook workbook = ExcelUtils.writeToWorkbookForTemplate(clazz, specialTitleContent, columnNoList);
        if (null == workbook) {
            return false;
        }
        boolean returnVal = false;
        try {
            workbook.write(out);
            returnVal = true;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return returnVal;
    }

    public static <T> Workbook writeToWorkbookForTemplate(Class<T> clazz, String specialTitleContent, List<Integer> columnNoList) {
        HashMap<String, String> headerTitles = new HashMap<String, String>();
        Field[] fields = clazz.getDeclaredFields();
        List<String> headerNames = ExcelUtils.getTitles(headerTitles, fields);
        if (headerTitles.isEmpty()) {
            return null;
        }
        Workbook workbook = ExcelUtils.newExcelByVersion(clazz);
        CellStyle specialHeaderStyle = ExcelUtils.newTableSpecialHeaderStyle(workbook, specialTitleContent);
        CellStyle headerStyle = ExcelUtils.newTableHeaderStyle(workbook);
        CellStyle evenStyle = ExcelUtils.newTableEvenCellStyle(workbook);
        CellStyle oddStyle = ExcelUtils.newTableOddCellStyle(workbook);
        CellStyle defaultCellStyle = workbook.createCellStyle();
        DataFormat dataFormat = workbook.createDataFormat();
        defaultCellStyle.setDataFormat(dataFormat.getFormat("@"));
        int rowNumber = 0;
        Sheet sheet = null;
        Short rowHeight = 500;
        LinkedHashMap<Integer, Integer> columnWidths = new LinkedHashMap<Integer, Integer>();
        if (rowNumber == 0 || rowNumber % 5000 == 0) {
            rowNumber = 0;
            sheet = workbook.createSheet();
            if (!CollectionUtils.isEmpty(columnNoList)) {
                for (Integer columnNo : columnNoList) {
                    sheet.setDefaultColumnStyle(columnNo.intValue(), defaultCellStyle);
                }
            }
            ExcelUtils.setExcelSpecialTitleDatas(sheet, specialTitleContent, headerNames, specialHeaderStyle, rowHeight, columnWidths, rowNumber);
            if (!StringUtils.isBlank((CharSequence)specialTitleContent)) {
                ++rowNumber;
            }
            ExcelUtils.setExcelTitleDatas(sheet, headerNames, headerStyle, rowHeight, columnWidths, rowNumber);
            ++rowNumber;
        }
        ++rowNumber;
        ExcelUtils.setColumnsWidth(sheet, columnWidths);
        return workbook;
    }

    public static <T> boolean writeToExcel(OutputStream out, Class<T> clazz, List<T> list, String specialTitleContent) {
        if (list == null) {
            throw new RuntimeException("\u5bfc\u51fa\u7684\u5185\u5bb9\u4e3a\u7a7a");
        }
        if (list.isEmpty()) {
            throw new RuntimeException("\u5bfc\u51fa\u7684\u5185\u5bb9\u4e3a\u7a7a");
        }
        Workbook workbook = ExcelUtils.writeToWorkbook(clazz, list, specialTitleContent);
        if (null == workbook) {
            return false;
        }
        boolean returnVal = false;
        try {
            workbook.write(out);
            returnVal = true;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return returnVal;
    }

    public static <T> Workbook writeToWorkbook(Class<T> clazz, List<T> list, String specialTitleContent) {
        HashMap<String, String> headerTitles = new HashMap<String, String>();
        Field[] fields = clazz.getDeclaredFields();
        List<String> headerNames = ExcelUtils.getTitles(headerTitles, fields);
        if (headerTitles.isEmpty()) {
            return null;
        }
        Workbook workbook = ExcelUtils.newExcelByVersion(clazz);
        CellStyle specialHeaderStyle = ExcelUtils.newTableSpecialHeaderStyle(workbook, specialTitleContent);
        CellStyle headerStyle = ExcelUtils.newTableHeaderStyle(workbook);
        CellStyle evenStyle = ExcelUtils.newTableEvenCellStyle(workbook);
        CellStyle oddStyle = ExcelUtils.newTableOddCellStyle(workbook);
        int rowNumber = 0;
        Sheet sheet = null;
        Short rowHeight = 500;
        LinkedHashMap<Integer, Integer> columnWidths = new LinkedHashMap<Integer, Integer>();
        int length = list.size();
        for (int i = 0; i < length; ++i) {
            if (rowNumber == 0 || rowNumber % 5000 == 0) {
                rowNumber = 0;
                sheet = workbook.createSheet();
                ExcelUtils.setExcelSpecialTitleDatas(sheet, specialTitleContent, headerNames, specialHeaderStyle, rowHeight, columnWidths, rowNumber);
                if (!StringUtils.isBlank((CharSequence)specialTitleContent)) {
                    ++rowNumber;
                }
                ExcelUtils.setExcelTitleDatas(sheet, headerNames, headerStyle, rowHeight, columnWidths, rowNumber);
                ++rowNumber;
            }
            Row row = sheet.createRow(rowNumber % 5000);
            row.setHeight(rowHeight.shortValue());
            for (int j = 0; j < headerNames.size(); ++j) {
                ExcelUtils.setExcelCellData(row, list, headerTitles, headerNames, evenStyle, oddStyle, rowNumber, columnWidths, i, j);
            }
            ++rowNumber;
            ExcelUtils.setColumnsWidth(sheet, columnWidths);
        }
        return workbook;
    }

    public static <T> Workbook writeToWorkbook2(Class<T> clazz, List<T> list, String specialTitleContent) throws Exception {
        HashMap<String, String> headerTitles = new HashMap<String, String>();
        Field[] fields = clazz.getDeclaredFields();
        List<String> headerNames = ExcelUtils.getTitles(headerTitles, fields);
        if (headerTitles.isEmpty()) {
            return null;
        }
        HSSFWorkbook workbook = new HSSFWorkbook();
        CellStyle specialHeaderStyle = ExcelUtils.newTableSpecialHeaderStyle((Workbook)workbook, specialTitleContent);
        CellStyle headerStyle = ExcelUtils.newTableHeaderStyle((Workbook)workbook);
        CellStyle evenStyle = ExcelUtils.newTableEvenCellStyle((Workbook)workbook);
        CellStyle oddStyle = ExcelUtils.newTableOddCellStyle((Workbook)workbook);
        int rowNumber = 0;
        Sheet sheet = null;
        Short rowHeight = 500;
        LinkedHashMap<Integer, Integer> columnWidths = new LinkedHashMap<Integer, Integer>();
        int length = list.size();
        for (int i = 0; i < length; ++i) {
            if (rowNumber == 0 || rowNumber % 5000 == 0) {
                rowNumber = 0;
                sheet = workbook.createSheet();
                ExcelUtils.setExcelSpecialTitleDatas(sheet, specialTitleContent, headerNames, specialHeaderStyle, rowHeight, columnWidths, rowNumber);
                ExcelUtils.setExcelTitleDatas(sheet, headerNames, headerStyle, rowHeight, columnWidths, rowNumber);
                ++rowNumber;
            }
            Row row = sheet.createRow(rowNumber % 5000);
            row.setHeight(rowHeight.shortValue());
            for (int j = 0; j < headerNames.size(); ++j) {
                ExcelUtils.setExcelCellData2(sheet, row, list, headerTitles, headerNames, evenStyle, oddStyle, rowNumber, columnWidths, i, j);
            }
            ++rowNumber;
        }
        return workbook;
    }

    private static <T> List<T> transferExcelData(Class<T> clazz, Map<String, String> headerNames, Sheet sheet, Row headerRow) throws Exception {
        Row row;
        ArrayList<T> list = new ArrayList<T>();
        boolean hasOneRight = false;
        Integer firstNum = sheet.getFirstRowNum();
        Integer beginRowNum = headerRow.getRowNum();
        if (beginRowNum > firstNum) {
            firstNum = beginRowNum;
        }
        for (int i = firstNum + 1; i <= 5000 && null != (row = sheet.getRow(i)); ++i) {
            T t = clazz.newInstance();
            if (ExcelUtils.getExcelLineData(headerNames, headerRow, row, t)) {
                t = null;
            }
            list.add(t);
            hasOneRight = true;
        }
        if (!hasOneRight) {
            throw new RuntimeException("\u81f3\u5c11\u9700\u8981\u6709\u4e00\u884c\u6570\u636e\uff01");
        }
        if (list.size() > 5000) {
            throw new RuntimeException("\u8d85\u51fa\u6a21\u677f\u5355sheet\u884c\u6570\u9650\u5236");
        }
        return list;
    }

    private static <T> boolean getExcelLineData(Map<String, String> headerNames, Row headerRow, Row row, T t) throws Exception {
        boolean isAllBlank = true;
        for (int j = 0; j < row.getLastCellNum(); ++j) {
            Cell cell = row.getCell(j);
            String propertyName = headerNames.get(ExcelUtils.getCellValueByType(headerRow.getCell(j), String.class));
            if (!StringUtils.isNotBlank((CharSequence)propertyName)) continue;
            PropertyDescriptor descriptor = PropertyUtils.getPropertyDescriptor(t, (String)propertyName);
            Class<?> type = descriptor.getPropertyType();
            String cellValue = ExcelUtils.getCellValueByType(cell, type);
            if (!StringUtils.isBlank((CharSequence)cellValue)) {
                isAllBlank = false;
            }
            PropertyUtils.setSimpleProperty(t, (String)propertyName, (Object)ExcelUtils.transferStringToObject(type, cellValue));
        }
        return isAllBlank;
    }

    private static Row validExcelFormatAndGetHeaderRow(Sheet sheet, Map<String, String> headerNames) throws Exception {
        Integer firstRowNum = sheet.getFirstRowNum();
        Integer maxNum = firstRowNum + 20;
        for (int j = firstRowNum.intValue(); j < maxNum; ++j) {
            Row headerRow = sheet.getRow(j);
            if (null == headerRow && j < maxNum - 1) continue;
            if (null == headerRow) {
                logger.error("Excel\u6709\u6548\u884c\u548c\u8868\u5934\u4e4b\u95f4\u95f4\u9694\u8d85\u8fc720\u884c");
                break;
            }
            boolean isAllTitleRight = true;
            int cellNum = headerRow.getLastCellNum();
            for (int i = 0; i < cellNum; ++i) {
                String titleName = headerRow.getCell(i).getStringCellValue();
                String fieldName = headerNames.get(titleName);
                if (!StringUtils.isEmpty((CharSequence)fieldName)) continue;
                isAllTitleRight = false;
            }
            if (isAllTitleRight) {
                return headerRow;
            }
            if (j != maxNum - 1) continue;
            logger.error("Excel\u6709\u6548\u884c\u548c\u8868\u5934\u4e4b\u95f4\u95f4\u9694\u8fbe\u523020\u884c");
            break;
        }
        throw new RuntimeException("\u6587\u4ef6\u6a21\u677f\u9519\u8bef\uff0c\u8bf7\u66f4\u6539\u6a21\u677f\u683c\u5f0f\uff01");
    }

    private static Workbook newExcelByInputStream(InputStream in) throws IOException, InvalidFormatException {
        if (!in.markSupported()) {
            in = new BufferedInputStream(in);
        }
        if (FileMagic.OLE2.equals((Object)FileMagic.valueOf((InputStream)in))) {
            return new HSSFWorkbook(in);
        }
        if (FileMagic.OOXML.equals((Object)FileMagic.valueOf((InputStream)in))) {
            return new XSSFWorkbook(OPCPackage.open((InputStream)in));
        }
        throw new IllegalArgumentException("Excel\u6587\u4ef6\u683c\u5f0f\u9519\u8bef,\u8bf7\u4f7f\u75282003\u7248\u672c\u7684Excel\u4e0a\u4f20\uff01");
    }

    private static <T> Workbook newExcelByVersion(Class<T> clazz) {
        Version version = clazz.getAnnotation(Version.class);
        if (null == version) {
            return new XSSFWorkbook();
        }
        if (VERSION_2007.equals(version.number())) {
            return new XSSFWorkbook();
        }
        if (VERSION_2003.equals(version.number())) {
            return new HSSFWorkbook();
        }
        return new XSSFWorkbook();
    }

    private static String getCellValueByType(Cell cell, Class clazz) {
        try {
            if (null == cell) {
                return "";
            }
            if (cell.getCellType() == 3) {
                return "";
            }
            if (cell.getCellType() == 0) {
                if (HSSFDateUtil.isCellDateFormatted((Cell)cell)) {
                    SimpleDateFormat sdf = new SimpleDateFormat(DATE_FORMAT);
                    return sdf.format(HSSFDateUtil.getJavaDate((double)cell.getNumericCellValue()));
                }
                DecimalFormat df = new DecimalFormat("0");
                if (clazz.equals(BigDecimal.class)) {
                    df = new DecimalFormat("0.00");
                }
                df.setRoundingMode(RoundingMode.DOWN);
                return df.format(cell.getNumericCellValue());
            }
            if (cell.getCellType() == 1) {
                return cell.getStringCellValue();
            }
            if (cell.getCellType() == 2) {
                return cell.getCellFormula();
            }
            if (cell.getCellType() == 4) {
                return String.valueOf(cell.getBooleanCellValue());
            }
            if (cell.getCellType() == 5) {
                return String.valueOf(cell.getErrorCellValue());
            }
            return cell.getStringCellValue();
        }
        catch (RuntimeException e) {
            logger.error("\u5355\u5143\u683c\u5b57\u7b26\u503c\u83b7\u53d6,\u9519\u8bef\u4fe1\u606f{}", (Object)e.getMessage());
            return "";
        }
    }

    private static void setCellValueByType(Cell cell, Object value) {
        if (null == value) {
            return;
        }
        if (value instanceof BigDecimal) {
            cell.setCellValue(String.valueOf(value));
        } else if (value instanceof Long) {
            cell.setCellValue((double)((Long)value).longValue());
        } else if (value instanceof Integer) {
            cell.setCellValue((double)((Integer)value).intValue());
        } else if (value instanceof Float) {
            cell.setCellValue(String.valueOf(value));
        } else if (value instanceof Double) {
            cell.setCellValue(String.valueOf(value));
        } else if (value instanceof Boolean) {
            cell.setCellValue(((Boolean)value).booleanValue());
        } else if (value instanceof Byte) {
            cell.setCellValue((double)((Byte)value).byteValue());
        } else if (value instanceof String) {
            cell.setCellValue(String.valueOf(value));
        } else if (value instanceof Timestamp) {
            SimpleDateFormat dateFormat = new SimpleDateFormat(DATETIME_FORMAT);
            cell.setCellValue(dateFormat.format(value));
        }
    }

    private static Object transferStringToObject(Class<?> clazz, String str) throws Exception {
        Object o = str;
        if (clazz == BigDecimal.class) {
            o = StringUtils.isBlank((CharSequence)str) ? BigDecimal.valueOf(0L) : new BigDecimal(str);
        } else if (clazz == Long.class) {
            o = StringUtils.isBlank((CharSequence)str) ? (Number)0 : (Number)new Long(str);
        } else if (clazz == Integer.class) {
            o = StringUtils.isBlank((CharSequence)str) ? Integer.valueOf(0) : new Integer(str);
        } else if (clazz == Integer.TYPE) {
            o = Integer.parseInt(str);
        } else if (clazz == Float.TYPE) {
            o = Float.valueOf(Float.parseFloat(str));
        } else if (clazz == Boolean.TYPE) {
            o = Boolean.parseBoolean(str);
        } else if (clazz == Byte.TYPE) {
            o = Byte.parseByte(str);
        }
        return o;
    }

    private static <T> void getTitles(InputStream in, Class<T> clazz, Map<String, String> headerNames) throws Exception {
        Field[] fields;
        for (Field m : fields = clazz.getDeclaredFields()) {
            if (!m.isAnnotationPresent(Header.class)) continue;
            Header anno = m.getAnnotation(Header.class);
            headerNames.put(anno.name(), m.getName());
        }
        if (headerNames.isEmpty()) {
            if (null != in) {
                in.close();
            }
            throw new RuntimeException("\u6a21\u677f\u6587\u4ef6\u9519\u8bef");
        }
    }

    private static List<String> getTitles(Map<String, String> headerTitles, Field[] fields) {
        ArrayList<String> headerNames = new ArrayList<String>();
        for (Field m : fields) {
            if (!m.isAnnotationPresent(Header.class)) continue;
            Header anno = m.getAnnotation(Header.class);
            headerTitles.put(anno.name(), m.getName());
            headerNames.add(anno.name());
        }
        return headerNames;
    }

    private static CellStyle newTableSpecialHeaderStyle(Workbook wb, String specialTitleContent) {
        if (StringUtils.isBlank((CharSequence)specialTitleContent)) {
            return null;
        }
        CellStyle style = wb.createCellStyle();
        style.setBorderRight(BorderStyle.THIN);
        style.setRightBorderColor(IndexedColors.BLACK.getIndex());
        style.setBorderBottom(BorderStyle.THIN);
        style.setBottomBorderColor(IndexedColors.BLACK.getIndex());
        style.setBorderLeft(BorderStyle.THIN);
        style.setLeftBorderColor(IndexedColors.BLACK.getIndex());
        style.setBorderTop(BorderStyle.THIN);
        style.setTopBorderColor(IndexedColors.BLACK.getIndex());
        style.setAlignment(HorizontalAlignment.LEFT);
        style.setVerticalAlignment(VerticalAlignment.CENTER);
        style.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        style.setFillForegroundColor(IndexedColors.WHITE.getIndex());
        style.setWrapText(true);
        Font font = wb.createFont();
        font.setColor(IndexedColors.RED.index);
        font.setFontHeightInPoints(FONT_SIZE.shortValue());
        font.setFontName(FONT_NAME);
        style.setFont(font);
        return style;
    }

    private static CellStyle newTableHeaderStyle(Workbook wb) {
        CellStyle style = wb.createCellStyle();
        style.setBorderRight(BorderStyle.THIN);
        style.setRightBorderColor(IndexedColors.BLACK.getIndex());
        style.setBorderBottom(BorderStyle.THIN);
        style.setBottomBorderColor(IndexedColors.BLACK.getIndex());
        style.setBorderLeft(BorderStyle.THIN);
        style.setLeftBorderColor(IndexedColors.BLACK.getIndex());
        style.setBorderTop(BorderStyle.THIN);
        style.setTopBorderColor(IndexedColors.BLACK.getIndex());
        style.setAlignment(HorizontalAlignment.CENTER);
        style.setVerticalAlignment(VerticalAlignment.CENTER);
        style.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        style.setFillForegroundColor(IndexedColors.BLUE_GREY.getIndex());
        style.setWrapText(true);
        Font font = wb.createFont();
        font.setBold(true);
        font.setFontHeightInPoints(FONT_SIZE.shortValue());
        font.setFontName(FONT_NAME);
        style.setFont(font);
        return style;
    }

    private static CellStyle newTableEvenCellStyle(Workbook wb) {
        CellStyle style = wb.createCellStyle();
        style.setBorderRight(BorderStyle.THIN);
        style.setRightBorderColor(IndexedColors.BLACK.getIndex());
        style.setBorderBottom(BorderStyle.THIN);
        style.setBottomBorderColor(IndexedColors.BLACK.getIndex());
        style.setBorderLeft(BorderStyle.THIN);
        style.setLeftBorderColor(IndexedColors.BLACK.getIndex());
        style.setBorderTop(BorderStyle.THIN);
        style.setTopBorderColor(IndexedColors.BLACK.getIndex());
        style.setAlignment(HorizontalAlignment.CENTER);
        style.setWrapText(true);
        style.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        style.setFillForegroundColor(IndexedColors.GREY_25_PERCENT.getIndex());
        Font font = wb.createFont();
        font.setFontHeightInPoints(FONT_SIZE.shortValue());
        font.setFontName(FONT_NAME);
        style.setFont(font);
        return style;
    }

    private static CellStyle newTableOddCellStyle(Workbook wb) {
        CellStyle style = wb.createCellStyle();
        style.setBorderRight(BorderStyle.THIN);
        style.setRightBorderColor(IndexedColors.BLACK.getIndex());
        style.setBorderBottom(BorderStyle.THIN);
        style.setBottomBorderColor(IndexedColors.BLACK.getIndex());
        style.setBorderLeft(BorderStyle.THIN);
        style.setLeftBorderColor(IndexedColors.BLACK.getIndex());
        style.setBorderTop(BorderStyle.THIN);
        style.setTopBorderColor(IndexedColors.BLACK.getIndex());
        style.setAlignment(HorizontalAlignment.CENTER);
        style.setWrapText(true);
        Font font = wb.createFont();
        font.setFontHeightInPoints(FONT_SIZE.shortValue());
        font.setFontName(FONT_NAME);
        style.setFont(font);
        return style;
    }

    private static void gatherColumnsWidth(Map<Integer, Integer> columnWidths, String headerName, String content, int j) {
        int length = content.getBytes().length;
        if (headerName.equalsIgnoreCase(content)) {
            if (headerName.indexOf(CHINA_LEFT_BRACKET) > 0) {
                headerName = headerName.replace(CHINA_LEFT_BRACKET, "\r\n\uff08");
                String lengthStr = headerName.substring(0, headerName.indexOf(CHINA_LEFT_BRACKET));
                length = lengthStr.getBytes().length;
            }
            columnWidths.put(j, length);
        } else {
            int oldLength;
            if (!content.matches(CHINESE_REGEX)) {
                length *= 2;
            }
            int n = oldLength = null == columnWidths.get(j) ? 0 : columnWidths.get(j);
            oldLength = length > 25 ? (oldLength > 25 ? oldLength : 25) : (oldLength > length ? oldLength : length);
            columnWidths.put(j, oldLength);
        }
    }

    private static void setColumnsWidth(Sheet sheet, Map<Integer, Integer> columnWidths) {
        for (Map.Entry<Integer, Integer> entry : columnWidths.entrySet()) {
            sheet.setColumnWidth(entry.getKey().intValue(), entry.getValue() * 256);
        }
    }

    private static <T> void setExcelCellData(Row row, List<T> list, Map<String, String> map, List<String> headerNames, CellStyle evenStyle, CellStyle oddStyle, int rowNumber, Map<Integer, Integer> columnWidths, int i, int j) {
        Cell cell = row.createCell(j);
        if (i % 2 == 0) {
            cell.setCellStyle(oddStyle);
        } else {
            cell.setCellStyle(evenStyle);
        }
        String headerName = headerNames.get(j);
        if (headerName.equals(DEFAULT_SERIAL_NUM)) {
            ExcelUtils.setCellValueByType(cell, rowNumber % 5000);
        } else {
            Object value;
            T obj = list.get(i);
            try {
                value = PropertyUtils.getSimpleProperty(obj, (String)map.get(headerName));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            ExcelUtils.gatherColumnsWidth(columnWidths, headerName, String.valueOf(value), j);
            ExcelUtils.setCellValueByType(cell, value);
        }
    }

    private static <T> void setExcelCellData2(Sheet sheet, Row row, List<T> list, Map<String, String> map, List<String> headerNames, CellStyle evenStyle, CellStyle oddStyle, int rowNumber, Map<Integer, Integer> columnWidths, int i, int j) throws Exception {
        Cell cell = row.createCell(j);
        if (i % 2 == 0) {
            cell.setCellStyle(oddStyle);
        } else {
            cell.setCellStyle(evenStyle);
        }
        String headerName = headerNames.get(j);
        if (headerName.equals(DEFAULT_SERIAL_NUM)) {
            ExcelUtils.setCellValueByType(cell, rowNumber % 5000);
        } else {
            T obj = list.get(i);
            Object value = PropertyUtils.getSimpleProperty(obj, (String)map.get(headerName));
            ExcelUtils.gatherColumnsWidth(columnWidths, headerName, String.valueOf(value), j);
            Integer width = columnWidths.get(j);
            sheet.setColumnWidth(j, width * 256);
            ExcelUtils.setCellValueByType(cell, value);
        }
    }

    private static void setExcelTitleDatas(Sheet sheet, List<String> headerNames, CellStyle headerStyle, Short rowHeight, Map<Integer, Integer> columnWidths, int rowNumber) {
        Row row = sheet.createRow(rowNumber % 5000);
        row.setHeight(rowHeight.shortValue());
        for (int j = 0; j < headerNames.size(); ++j) {
            Cell headCell = row.createCell(j);
            headCell.setCellStyle(headerStyle);
            String headerName = headerNames.get(j);
            ExcelUtils.gatherColumnsWidth(columnWidths, headerName, headerName, j);
            ExcelUtils.setCellValueByType(headCell, headerNames.get(j));
        }
    }

    private static void setExcelSpecialTitleDatas(Sheet sheet, String specialTitleContent, List<String> headerNames, CellStyle headerStyle, Short rowHeight, Map<Integer, Integer> columnWidths, int rowNumber) {
        if (StringUtils.isBlank((CharSequence)specialTitleContent)) {
            return;
        }
        Row row = sheet.createRow(rowNumber % 5000);
        Cell headCell = row.createCell(0);
        headCell.setCellStyle(headerStyle);
        ExcelUtils.setCellValueByType(headCell, specialTitleContent);
        ArrayList<String> colgroups = new ArrayList<String>();
        ExcelUtils.gatherCharactorCount(specialTitleContent, colgroups);
        row.setHeight((short)(rowHeight * colgroups.size()));
        Integer length = headerNames.size();
        CellRangeAddress cra = new CellRangeAddress(rowNumber, rowNumber, 0, length - 1);
        sheet.addMergedRegion(cra);
        RegionUtil.setBorderBottom((BorderStyle)BorderStyle.THIN, (CellRangeAddress)cra, (Sheet)sheet);
        RegionUtil.setBorderLeft((BorderStyle)BorderStyle.THIN, (CellRangeAddress)cra, (Sheet)sheet);
        RegionUtil.setBorderRight((BorderStyle)BorderStyle.THIN, (CellRangeAddress)cra, (Sheet)sheet);
        RegionUtil.setBorderTop((BorderStyle)BorderStyle.THIN, (CellRangeAddress)cra, (Sheet)sheet);
    }

    private static void gatherCharactorCount(String specialTitleContent, List<String> colgroups) {
        Pattern p1 = Pattern.compile(ENTER_SIGN);
        Matcher m1 = p1.matcher(specialTitleContent);
        while (m1.find()) {
            for (int i = 0; i < m1.groupCount(); ++i) {
                String test1 = m1.group(i);
                colgroups.add(test1);
            }
        }
    }

    @Documented
    @Target(value={ElementType.TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface Version {
        public String number() default "2007";

        public String suffix() default "xlsx";
    }

    @Documented
    @Target(value={ElementType.FIELD})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface Header {
        public String name() default "";
    }
}

