/*
 * Decompiled with CFR 0.152.
 */
package com.talkilla.constant;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.annotation.PostConstruct;
import org.nestframework.utils.NestUtil;
import org.springframework.stereotype.Component;

@Component(value="constantBean")
public class ConstantBean {
    private String propertiesFile;
    private String propertiesFileDB;
    private static Map<String, String> propertiesMap = new HashMap<String, String>();
    private static Map<String, String> propertiesMapDB = new HashMap<String, String>();

    public String getPropertiesFile() {
        return this.propertiesFile;
    }

    public void setPropertiesFile(String propertiesFile) {
        this.propertiesFile = propertiesFile;
    }

    public String getPropertiesFileDB() {
        return this.propertiesFileDB;
    }

    public void setPropertiesFileDB(String propertiesFileDB) {
        this.propertiesFileDB = propertiesFileDB;
    }

    public static String get(String propertyName) {
        return propertiesMap.get(propertyName);
    }

    @PostConstruct
    public void init() {
        Properties prop = new Properties();
        Properties propDB = new Properties();
        try {
            this.propertiesFile = "sys-conf.properties";
            InputStream in = this.getClass().getResourceAsStream("/" + this.propertiesFile);
            NestUtil.load((Properties)prop, (Reader)new InputStreamReader(in, "utf8"));
            for (String string : prop.keySet()) {
                String pValue = prop.getProperty(string);
                propertiesMap.put(string, pValue);
            }
            in.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

