/*
 * Decompiled with CFR 0.152.
 */
package com.talkilla.utils;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Random;
import javax.imageio.ImageIO;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;

public class RandImgCreater {
    private static final String CODE_LIST = "abcdefghijklmnopqrstuvwxy1234567890";
    private HttpServletResponse response = null;
    private static final int HEIGHT = 25;
    private static final int FONT_NUM = 4;
    private int width = 0;
    private int iNum = 0;
    private String codeList = "";
    private boolean drawBgFlag = false;
    private int rBg = 0;
    private int gBg = 0;
    private int bBg = 0;

    public RandImgCreater(HttpServletResponse response) {
        this.response = response;
        this.width = 78;
        this.iNum = 4;
        this.codeList = CODE_LIST;
    }

    public RandImgCreater(HttpServletResponse response, int iNum, String codeList) {
        this.response = response;
        this.width = 13 * iNum + 12;
        this.iNum = iNum;
        this.codeList = codeList;
    }

    public String createRandImage() throws IOException {
        BufferedImage image = new BufferedImage(this.width, 25, 1);
        Graphics g = image.getGraphics();
        Random random = new Random();
        if (this.drawBgFlag) {
            g.setColor(new Color(this.rBg, this.gBg, this.bBg));
            g.fillRect(0, 0, this.width, 25);
        } else {
            g.setColor(this.getRandColor(200, 250));
            g.fillRect(0, 0, this.width, 25);
            for (int i = 0; i < 155; ++i) {
                g.setColor(this.getRandColor(140, 200));
                int x = random.nextInt(this.width);
                int y = random.nextInt(25);
                int xl = random.nextInt(12);
                int yl = random.nextInt(12);
                g.drawLine(x, y, x + xl, y + yl);
            }
        }
        g.setFont(new Font("Times New Roman", 0, 22));
        String sRand = "";
        for (int i = 0; i < this.iNum; ++i) {
            int rand = random.nextInt(this.codeList.length());
            String strRand = this.codeList.substring(rand, rand + 1);
            sRand = sRand + strRand;
            g.setColor(new Color(20 + random.nextInt(110), 20 + random.nextInt(110), 20 + random.nextInt(110)));
            g.drawString(strRand, 18 * i + 6, 20);
        }
        g.dispose();
        ServletOutputStream out = null;
        try {
            out = this.response.getOutputStream();
            ImageIO.write((RenderedImage)image, "JPEG", (OutputStream)out);
            out.flush();
            out.close();
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            if (null != out) {
                out.flush();
                out.close();
            }
        }
        return sRand;
    }

    public void setBgColor(int r, int g, int b) {
        this.drawBgFlag = true;
        this.rBg = r;
        this.gBg = g;
        this.bBg = b;
    }

    private Color getRandColor(int fc, int bc) {
        Random random = new Random();
        if (fc > 255) {
            fc = 255;
        }
        if (bc > 255) {
            bc = 255;
        }
        int r = fc + random.nextInt(bc - fc);
        int g = fc + random.nextInt(bc - fc);
        int b = fc + random.nextInt(bc - fc);
        return new Color(r, g, b);
    }
}

