/*
 * Decompiled with CFR 0.152.
 */
package com.talkilla.utils;

import java.math.BigDecimal;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.URLDecoder;
import java.net.UnknownHostException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import org.acegisecurity.providers.encoding.Md5PasswordEncoder;
import org.apache.commons.lang.StringUtils;
import org.nestframework.commons.utils.DateUtil;
import org.nestframework.commons.utils.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NoServiceUtil {
    private static final Logger logger = LoggerFactory.getLogger(NoServiceUtil.class);

    public static void main(String[] args) {
        System.out.println(NoServiceUtil.md5("123456"));
        System.out.println(new Date().getTime());
    }

    public static String md5(String primalPass) {
        String ret = primalPass;
        try {
            Md5PasswordEncoder md5 = new Md5PasswordEncoder();
            ret = md5.encodePassword(primalPass, null);
        }
        catch (Exception ex) {
            logger.error(ex.getMessage() + ";" + ex.fillInStackTrace());
        }
        return ret;
    }

    public static Date correctDate(Date date) {
        Date ret = date;
        try {
            String dateStr = DateUtil.dateToStr((Date)date, (int)4);
            ret = NoServiceUtil.stringToDateTime(dateStr + " 23:59:59");
        }
        catch (Exception ex) {
            logger.error("\u7cfb\u7edf\uff1aftdp;" + ex.getMessage() + ";" + ex.fillInStackTrace());
        }
        return ret;
    }

    public static Date stringToDateTime(String dt) {
        Date date = null;
        if (dt == null || dt.equals("") || dt.equals("null")) {
            return date;
        }
        if (dt != null && dt.length() > 0 && dt.length() < 11) {
            dt = dt.trim() + " 00:00:00";
        }
        DateFormat formatter = DateFormat.getDateTimeInstance(2, 2, new Locale("zh", "CN"));
        try {
            date = formatter.parse(dt);
        }
        catch (ParseException ex) {
            date = null;
            logger.error("\u7cfb\u7edf\uff1aftdp;" + ex.getMessage() + ";" + ex.fillInStackTrace());
        }
        return date;
    }

    public static String changeList2Str(List<String> list) {
        if (list == null || list.size() == 0) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        for (String str : list) {
            sb.append(str);
            sb.append(",");
        }
        return sb.toString().substring(0, sb.toString().length() - 1);
    }

    public static String changeList2Integer(List<Integer> list) {
        if (list == null || list.size() == 0) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        for (Integer str : list) {
            sb.append(str);
            sb.append(",");
        }
        return sb.toString().substring(0, sb.toString().length() - 1);
    }

    public static boolean strIsEnglish(String word) {
        if (StringUtil.isEmpty((String)word)) {
            return false;
        }
        for (int i = 0; i < word.length(); ++i) {
            if (word.charAt(i) >= 'A' && word.charAt(i) <= 'Z' || word.charAt(i) >= 'a' && word.charAt(i) <= 'z') continue;
            return false;
        }
        return true;
    }

    public static String changeArray2Str(String[] s) {
        if (s == null || s.length == 0) {
            return "";
        }
        return NoServiceUtil.changeList2Str(Arrays.asList(s));
    }

    public static String getMacAddress() {
        return NoServiceUtil.getMacAddress(null);
    }

    public static String getMacAddress(String host) {
        String mac = "";
        StringBuffer sb = new StringBuffer();
        try {
            InetAddress address = host == null ? InetAddress.getLocalHost() : InetAddress.getByName(host);
            NetworkInterface ni = NetworkInterface.getByInetAddress(address);
            byte[] macs = ni.getHardwareAddress();
            for (int i = 0; i < macs.length; ++i) {
                mac = Integer.toHexString(macs[i] & 0xFF);
                if (mac.length() == 1) {
                    mac = '0' + mac;
                }
                sb.append(mac + "-");
            }
        }
        catch (SocketException e) {
            e.printStackTrace();
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        mac = sb.toString();
        mac = mac.substring(0, mac.length() - 1);
        return mac.toUpperCase();
    }

    public static BigDecimal mul(String v1, String v2) {
        BigDecimal b1 = new BigDecimal(v1);
        BigDecimal b2 = new BigDecimal(v2);
        return b1.multiply(b2);
    }

    public static String createUUID() {
        return UUID.randomUUID().toString().replaceAll("-", "");
    }

    public static String html(String content) {
        if (content == null) {
            return "";
        }
        String html = content;
        html = StringUtils.replace((String)html, (String)"&apos;", (String)"'");
        html = StringUtils.replace((String)html, (String)"&quot;", (String)"\"");
        html = StringUtils.replace((String)html, (String)"&nbsp;&nbsp;", (String)"\t");
        html = StringUtils.replace((String)html, (String)"&nbsp;", (String)" ");
        html = StringUtils.replace((String)html, (String)"&lt;", (String)"<");
        html = StringUtils.replace((String)html, (String)"&gt;", (String)">");
        html = StringUtils.replace((String)html, (String)"&amp;", (String)"&");
        html = StringUtils.replace((String)html, (String)"&times;", (String)"?\u00e1");
        html = StringUtils.replace((String)html, (String)"&divide;", (String)"??");
        html = StringUtils.replace((String)html, (String)"&ensp;", (String)"         ");
        html = StringUtils.replace((String)html, (String)"&emsp;", (String)"         ");
        return html;
    }

    public static String tranFlagString(String flag, String isUsed, String isRepeat, String isStudy) {
        String ret = flag;
        if ("0".equals(flag)) {
            ret = "\u5206\u914d\u6210\u529f";
        } else if ("5".equals(flag)) {
            ret = "\u59d3\u540d\u6709\u7a7a\u683c";
        } else if ("6".equals(flag)) {
            ret = "\u59d3\u540d\u4e0d\u5408\u6cd5";
        } else if ("7".equals(flag)) {
            ret = "\u6027\u522b\u4e0d\u5408\u6cd5";
        } else if ("8".equals(flag)) {
            ret = "\u51fa\u751f\u65e5\u671f\u4e0d\u5408\u6cd5";
        } else if ("9".equals(flag)) {
            ret = "\u5165\u5b66\u65e5\u671f\u4e0d\u5408\u6cd5";
        }
        if ("0".equals(isUsed)) {
            ret = "\u5b66\u751f\u4e0d\u5728\u7528";
        }
        if ("1".equals(isRepeat)) {
            ret = "\u5b66\u751f\u4fe1\u606f\u91cd\u590d";
        }
        if ("0".equals(isStudy)) {
            ret = "\u5b66\u751f\u4e0d\u5728\u5b66";
        }
        return ret;
    }

    public static String cutSpecString(String data) {
        List<String> keys = Arrays.asList(" ", "\u3000", "\uff07", "\uff0e", "\\.", "'", "\\|", "\\\\");
        String ret = null;
        if (StringUtil.isEmpty((String)data)) {
            return data;
        }
        ret = data;
        for (String key : keys) {
            ret = ret.replaceAll(key, "");
        }
        return ret;
    }

    public static Date addDateOneDay(Date date, int n) {
        if (null == date) {
            return date;
        }
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.add(5, n);
        date = c.getTime();
        return date;
    }

    public static String getWeekNameOfDate(Date date) {
        String[] weekDaysName = new String[]{"\u661f\u671f\u65e5", "\u661f\u671f\u4e00", "\u661f\u671f\u4e8c", "\u661f\u671f\u4e09", "\u661f\u671f\u56db", "\u661f\u671f\u4e94", "\u661f\u671f\u516d"};
        if (null == date) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        int intWeek = calendar.get(7) - 1;
        return weekDaysName[intWeek];
    }

    public static Date getMonday(Date date) {
        if (null == date) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(7, 2);
        return calendar.getTime();
    }

    public static Date getWednesday(Date date) {
        if (null == date) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(7, 4);
        return calendar.getTime();
    }

    public static Date getFriday(Date date) {
        if (null == date) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(7, 6);
        return calendar.getTime();
    }

    public static Date afterNDay(int n) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        calendar.add(5, n);
        return calendar.getTime();
    }

    public static boolean isSameWeekDates(Date date1, Date date2) {
        if (null == date1 || null == date2) {
            return false;
        }
        Calendar cal1 = Calendar.getInstance();
        Calendar cal2 = Calendar.getInstance();
        cal1.setTime(date1);
        cal2.setTime(date2);
        int subYear = cal1.get(1) - cal2.get(1);
        return 0 == subYear ? cal1.get(3) == cal2.get(3) : (1 == subYear && 11 == cal2.get(2) ? cal1.get(3) == cal2.get(3) : -1 == subYear && 11 == cal1.get(2) && cal1.get(3) == cal2.get(3));
    }

    public static String fileExt(String fileName) {
        String ret = "";
        if (StringUtil.isEmpty((String)fileName)) {
            return ret;
        }
        int i = fileName.lastIndexOf(".");
        if (i < 0 || i == fileName.length()) {
            return ret;
        }
        ret = fileName.substring(i);
        return ret;
    }

    public static Date stringToDate(String dateString) {
        Date parseDate = null;
        if (StringUtil.isEmpty((String)dateString)) {
            return parseDate;
        }
        String[] formatstring = new String[]{"yyyy-MM-dd HH:mm:ss", "yyyy/MM/dd HH:mm:ss", "yyyy.MM.dd HH:mm:ss", "yyyy-MM-dd", "yyyy/MM/dd", "yyyy.MM.dd"};
        SimpleDateFormat sdf = new SimpleDateFormat();
        int index = 0;
        while (formatstring != null && index < formatstring.length) {
            try {
                sdf.applyPattern(formatstring[index++]);
                parseDate = sdf.parse(dateString);
                break;
            }
            catch (ParseException gete) {
            }
        }
        return parseDate;
    }

    public static String formatBigDecimal(BigDecimal b) {
        String ret = null;
        try {
            if (null == b) {
                return ret;
            }
            ret = b.setScale(1).toPlainString();
            if (ret.lastIndexOf(".0") > 0) {
                ret = ret.substring(0, ret.lastIndexOf("."));
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage() + e.fillInStackTrace());
        }
        return ret;
    }

    public static String decodeURL(String urlParam) {
        if (StringUtil.isEmpty((String)urlParam)) {
            return null;
        }
        String ret = urlParam = urlParam.trim();
        String encodeCharSet = "utf-8";
        try {
            ret = URLDecoder.decode(urlParam, encodeCharSet);
        }
        catch (Exception e) {
            logger.error(e.getMessage() + e.fillInStackTrace());
        }
        return ret;
    }
}

