/*
 * Decompiled with CFR 0.152.
 */
package com.talkilla.constant;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.PropertySource;
import org.springframework.core.env.Environment;
import org.springframework.util.StringUtils;

@Configuration
@PropertySource(value={"classpath:conf.properties"})
public class SystemConfig {
    private static final Logger logger = LoggerFactory.getLogger(SystemConfig.class);
    public static String CATEGORY;
    public static String PICTURE_PATH;
    public static String TALKILLACOMMUNITY_URL;
    @Autowired
    private Environment env;

    @Bean(name={"config"})
    public SystemConfig config() throws IllegalAccessException, InstantiationException {
        Class<?>[] clazzs;
        logger.info("\u5f00\u59cb\u52a0\u8f7d\u8d44\u6e90\u6587\u4ef6...");
        this.setStaticPropertiesValue(SystemConfig.class);
        for (Class<?> clazz : clazzs = SystemConfig.class.getClasses()) {
            this.setStaticPropertiesValue(clazz);
        }
        return null;
    }

    private void setStaticPropertiesValue(Class<?> clazz) throws IllegalAccessException {
        Field[] fields;
        for (Field field : fields = clazz.getDeclaredFields()) {
            ArrayList<String> vlist;
            String[] values;
            String key = field.getName().toLowerCase().replace("_", ".");
            String confKey = SystemConfig.getPropertyName(key);
            String value = this.env.getProperty(confKey);
            if (StringUtils.isEmpty((Object)value)) continue;
            if (field.getType() == List.class) {
                values = value.split(",");
                vlist = new ArrayList<String>();
                for (String tvalue : values) {
                    if (StringUtils.isEmpty((Object)tvalue)) continue;
                    vlist.add(tvalue);
                }
                field.set(null, vlist);
            }
            if (field.getType() == String[].class) {
                values = value.split(",");
                vlist = new ArrayList();
                for (String tvalue : values) {
                    if (StringUtils.isEmpty((Object)tvalue)) continue;
                    vlist.add(tvalue);
                }
                field.set(null, vlist.toArray(new String[0]));
            }
            if (field.getType() == String.class) {
                field.set(null, value);
            }
            if (field.getType() == Integer.class) {
                field.set(null, Integer.valueOf(value));
            }
            if (field.getType() == Float.class) {
                field.set(null, Float.valueOf(value));
            }
            if (field.getType() == Double.class) {
                field.set(null, Double.valueOf(value));
            }
            logger.info("{},{},{}", new Object[]{field.getType().getName(), confKey, field.get(null)});
        }
    }

    private static String getPropertyName(String key) {
        if (null == CATEGORY) {
            return key;
        }
        return CATEGORY + "." + key;
    }

    public static class Sms {
        public static String SMS_KEY;
        public static String SMS_SECRET;
        public static String SMS_PRODUCTNAME;
        public static String SMS_URL;
        public static String SMS_TEMPLATECODE_SEND;
    }

    public static class Wechat {
        public static String WECHAT_APP_ID;
        public static String WECHAT_APP_SECRET;
        public static String WECHAT_URL;
        public static String WECHAT_URL_TIME_AWARD;
        public static String WECHAT_MESSAGE_TEMPLATE_ID;
        public static String WECHAT_MESSAGE_TEMPLATE_ID2;
        public static String WECHAT_MESSAGE_TEMPLATE_ID3;
        public static String WECHAT_MESSAGE_TEMPLATE_ID4;
        public static String WECHAT_MESSAGE_TEMPLATE_ID5;
        public static String WECHAT_MESSAGE_TEMPLATE_ID6;
        public static String WECHAT_MESSAGE_TEMPLATE_ID7;
        public static String WECHAT_RECOMMENDREGIST;
    }

    public static class Admin {
        public static String ADMIN_EMAIL;
    }
}

