/*
 * Decompiled with CFR 0.152.
 */
package com.talkilla.config;

import com.google.common.cache.Cache;
import com.talkilla.exception.BusinessException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

public class PreventRepeatSubmitInterceptor
extends HandlerInterceptorAdapter {
    private static final Logger log = LoggerFactory.getLogger(PreventRepeatSubmitInterceptor.class);
    @Autowired
    private Cache urlCache;

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        String method = request.getMethod();
        if (method.equalsIgnoreCase("GET")) {
            return true;
        }
        String sessionId = request.getRequestedSessionId();
        String key = sessionId + "-" + request.getRequestURI();
        if (this.urlCache.getIfPresent((Object)key) == null) {
            this.urlCache.put((Object)key, (Object)0);
            return true;
        }
        log.error("\u91cd\u590d\u63d0\u4ea4");
        throw new BusinessException((Object)"REPEATE_SUBMIT_999", "\u8bf7\u4e0d\u8981\u91cd\u590d\u63d0\u4ea4");
    }
}

