/*
 * Decompiled with CFR 0.152.
 */
package com.talkilla.utils;

import com.talkilla.utils.XMLDesc;
import com.talkilla.utils.XMLNamespace;
import java.io.File;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XMLUtil {
    private static Logger logger = LoggerFactory.getLogger(XMLUtil.class);

    public static String formatXML(Object obj) {
        return XMLUtil.formatXML(obj, false, null);
    }

    public static String formatXML(Object obj, String encoding) {
        return XMLUtil.formatXML(obj, false, encoding);
    }

    public static String formatXML(Object obj, boolean writeNull, String encoding) {
        Document dom = DocumentHelper.createDocument();
        String elmName = null;
        XMLNamespace annotation = obj.getClass().getAnnotation(XMLNamespace.class);
        if (annotation != null && StringUtils.isNotBlank((String)annotation.name())) {
            elmName = annotation.name();
        } else {
            StringBuffer elm = new StringBuffer(obj.getClass().getName());
            String string = elmName = elm.toString().contains(".") ? elm.substring(elm.lastIndexOf(".") + 1) : elm.toString();
        }
        if (elmName != null) {
            Element elm1 = dom.addElement(elmName);
            try {
                XMLUtil.createElement(elm1, obj, writeNull);
            }
            catch (Exception var8) {
                var8.printStackTrace();
                return null;
            }
        }
        if (StringUtils.isNotBlank((String)encoding)) {
            dom.setXMLEncoding(encoding);
        }
        return dom.asXML();
    }

    private static void createElement(Element elm, Object obj, boolean writeNull) throws Exception {
        List<Field> fields = XMLUtil.getField(obj);
        Iterator<Field> var5 = fields.iterator();
        block2: while (var5.hasNext()) {
            Element list;
            String fieldName;
            Field field = var5.next();
            if (Modifier.isStatic(field.getModifiers())) continue;
            String celmName = fieldName = field.getName();
            String getMethodName = "get" + XMLUtil.initialUpper(fieldName);
            Method getMethod = null;
            try {
                getMethod = obj.getClass().getMethod(getMethodName, new Class[0]);
            }
            catch (Exception var16) {
                logger.warn(getMethodName + "\u83b7\u53d6\u5931\u8d25\uff01");
                continue;
            }
            Object fieldValue = getMethod.invoke(obj, new Object[0]);
            XMLDesc annotation = field.getAnnotation(XMLDesc.class);
            if (annotation != null && "upper".equals(annotation.initial())) {
                celmName = XMLUtil.initialUpper(fieldName);
            }
            if (annotation != null && StringUtils.isNotBlank((String)annotation.head())) {
                celmName = annotation.head() + ":" + celmName;
            }
            if (fieldValue == null) {
                if (!writeNull) continue;
                list = elm.addElement(celmName);
                list.setText("");
                continue;
            }
            if (!(fieldValue instanceof String) && !XMLUtil.isPrimitive(field.getType())) {
                if (fieldValue instanceof List) {
                    List list1 = (List)fieldValue;
                    if (annotation != null && "child".equals(annotation.node())) {
                        Iterator cobj1 = list1.iterator();
                        while (true) {
                            if (!cobj1.hasNext()) continue block2;
                            Object celm1 = cobj1.next();
                            XMLUtil.formatObj(elm, celm1, celmName, writeNull);
                        }
                    }
                    Element celm = elm.addElement(celmName);
                    Iterator var15 = list1.iterator();
                    while (true) {
                        if (!var15.hasNext()) continue block2;
                        Object cobj = var15.next();
                        XMLUtil.formatObj(celm, cobj, null, writeNull);
                    }
                }
                XMLUtil.formatObj(elm, fieldValue, celmName, writeNull);
                continue;
            }
            if (StringUtils.isBlank((String)fieldValue.toString()) && !writeNull) continue;
            if (annotation != null) {
                if ("attribute".equals(annotation.type())) {
                    elm.addAttribute(celmName, fieldValue.toString());
                    continue;
                }
                list = elm.addElement(celmName);
                list.setText(fieldValue.toString());
                continue;
            }
            list = elm.addElement(celmName);
            list.setText(fieldValue.toString());
        }
        return;
    }

    private static void formatObj(Element elm, Object obj, String celmName, boolean writeNull) throws Exception {
        Class<?> objClass = obj.getClass();
        XMLNamespace annotation = objClass.getAnnotation(XMLNamespace.class);
        if (StringUtils.isBlank((String)celmName) || "Obj".equals(celmName) || "obj".equals(celmName)) {
            if (annotation != null && StringUtils.isNotBlank((String)annotation.name())) {
                celmName = annotation.name();
            } else {
                StringBuffer celm = new StringBuffer(objClass.getName());
                String string = celmName = celm.toString().contains(".") ? celm.substring(celm.lastIndexOf(".") + 1) : celm.toString();
            }
            if (annotation != null && StringUtils.isNotBlank((String)annotation.head())) {
                celmName = annotation.head() + ":" + celmName;
            }
        }
        Element var13 = elm.addElement(celmName);
        if (annotation != null) {
            String[] namespaces;
            String[] var11 = namespaces = annotation.namespace();
            int var10 = namespaces.length;
            for (int var9 = 0; var9 < var10; ++var9) {
                String namespace = var11[var9];
                String[] values = namespace.split("=");
                var13.addNamespace(values[0], values[1]);
            }
        }
        XMLUtil.createElement(var13, obj, writeNull);
    }

    public static <T> T parseXML(String xmlText, Class<T> rootClass) {
        return XMLUtil.parseXML(xmlText, rootClass, true);
    }

    public static <T> T parseXML(InputStream xmlInputStream, Class<T> nodeClass) {
        try {
            Document e = new SAXReader().read(xmlInputStream);
            return XMLUtil.parseXML(e, nodeClass, true);
        }
        catch (DocumentException var3) {
            logger.error("\u89e3\u6790xml\u5931\u8d25\uff01", (Throwable)var3);
            return null;
        }
    }

    public static <T> T parseXML(File xmlFile, Class<T> nodeClass) {
        try {
            Document e = new SAXReader().read(xmlFile);
            return XMLUtil.parseXML(e, nodeClass, true);
        }
        catch (DocumentException var3) {
            logger.error("\u89e3\u6790xml\u5931\u8d25\uff01", (Throwable)var3);
            return null;
        }
    }

    public static <T> T parseXML(String xmlText, Class<T> nodeClass, boolean isRoot) {
        try {
            Document e = DocumentHelper.parseText((String)xmlText);
            return XMLUtil.parseXML(e, nodeClass, isRoot);
        }
        catch (Exception var4) {
            var4.printStackTrace();
            return null;
        }
    }

    private static <T> T parseXML(Document dom, Class<T> nodeClass, boolean isRoot) {
        logger.debug(dom.asXML());
        T e = null;
        try {
            e = nodeClass.newInstance();
            if (isRoot) {
                Element elmName = dom.getRootElement();
                XMLUtil.packingBean(elmName, e, nodeClass.getPackage().getName());
            } else {
                String elmName1;
                Object elmName = null;
                XMLNamespace annotation = nodeClass.getAnnotation(XMLNamespace.class);
                if (annotation != null && StringUtils.isNotBlank((String)annotation.name())) {
                    elmName1 = annotation.name();
                } else {
                    StringBuffer root = new StringBuffer(nodeClass.getName());
                    String string = elmName1 = root.toString().contains(".") ? root.substring(root.lastIndexOf(".") + 1) : root.toString();
                }
                if (elmName1 != null) {
                    Element root1 = (Element)dom.selectSingleNode("descendant::" + elmName1);
                    XMLUtil.packingBean(root1, e, nodeClass.getPackage().getName());
                }
            }
            return e;
        }
        catch (Exception var7) {
            var7.printStackTrace();
            return null;
        }
    }

    private static void packingBean(Element root, Object parent, String packagePath) throws Exception {
        List<Field> fields = XMLUtil.getField(parent);
        Iterator<Field> var5 = fields.iterator();
        while (var5.hasNext()) {
            Element elm;
            Attribute obj;
            String fieldName;
            Field field = var5.next();
            if (Modifier.isStatic(field.getModifiers())) continue;
            String celmName = fieldName = field.getName();
            String setMethodName = "set" + XMLUtil.initialUpper(fieldName);
            Class<?> fieldClass = field.getType();
            Method setMethod = null;
            try {
                setMethod = parent.getClass().getMethod(setMethodName, fieldClass);
            }
            catch (Exception var22) {
                logger.warn(setMethodName + "\u83b7\u53d6\u5931\u8d25\uff01");
                continue;
            }
            if ("_context".equals(fieldName) && fieldClass.equals(String.class) && root.elements().isEmpty()) {
                setMethod.invoke(parent, root.getTextTrim());
                continue;
            }
            XMLDesc annotation = field.getAnnotation(XMLDesc.class);
            if (annotation != null && "upper".equals(annotation.initial())) {
                celmName = XMLUtil.initialUpper(fieldName);
            }
            if (!fieldClass.equals(String.class) && !XMLUtil.isPrimitive(fieldClass)) {
                XMLNamespace lelm;
                Object obj4;
                if (fieldClass.equals(Object.class)) {
                    List elm3 = root.elements();
                    if (elm3.size() <= 0) continue;
                    obj = null;
                    if (elm3.size() == 1) {
                        Element elmClass2 = (Element)elm3.get(0);
                        obj4 = Class.forName(packagePath + "." + elmClass2.getName()).newInstance();
                        XMLUtil.packingBean(elmClass2, obj4, packagePath);
                        setMethod.invoke(parent, obj4);
                        continue;
                    }
                    if (elm3.size() <= 1) continue;
                    ArrayList elmClass3 = new ArrayList();
                    for (Element type1 : elm3) {
                        obj4 = Class.forName(packagePath + "." + type1.getName()).newInstance();
                        XMLUtil.packingBean(type1, obj4, packagePath);
                        elmClass3.add(obj4);
                    }
                    setMethod.invoke(parent, elmClass3);
                    continue;
                }
                if (!List.class.isAssignableFrom(fieldClass)) {
                    elm = root.element(celmName);
                    if (elm == null) continue;
                    obj4 = fieldClass.newInstance();
                    XMLUtil.packingBean(elm, obj4, packagePath);
                    setMethod.invoke(parent, obj4);
                    continue;
                }
                ArrayList elm2 = new ArrayList();
                String obj3 = null;
                Class elmClass1 = null;
                Type type = field.getGenericType();
                if (type instanceof ParameterizedType) {
                    elmClass1 = (Class)((ParameterizedType)type).getActualTypeArguments()[0];
                }
                if (elmClass1 != null && (lelm = elmClass1.getAnnotation(XMLNamespace.class)) != null && StringUtils.isNotBlank((String)lelm.name())) {
                    obj3 = lelm.name();
                }
                if (annotation != null && "child".equals(annotation.node()) && elmClass1 != null) {
                    List lelm1 = root.elements(celmName);
                    for (Element elms1 : lelm1) {
                        Object obj5 = elmClass1.newInstance();
                        XMLUtil.packingBean(elms1, obj5, packagePath);
                        elm2.add(obj5);
                    }
                } else {
                    Element lelm2 = root.element(celmName);
                    if (lelm2 != null) {
                        List elms = obj3 != null ? lelm2.elements(obj3) : lelm2.elements();
                        for (Element elm1 : elms) {
                            Object obj2 = elmClass1 != null ? elmClass1.newInstance() : Class.forName(packagePath + "." + elm1.getName()).newInstance();
                            XMLUtil.packingBean(elm1, obj2, packagePath);
                            elm2.add(obj2);
                        }
                    }
                }
                if (elm2.size() <= 0) continue;
                setMethod.invoke(parent, elm2);
                continue;
            }
            elm = root.element(celmName);
            obj = root.attribute(celmName);
            String elmClass = null;
            if (elm != null) {
                elmClass = elm.getTextTrim();
            } else if (obj != null) {
                elmClass = obj.getValue();
            }
            if (elmClass == null) continue;
            if (fieldClass.isPrimitive()) {
                BeanUtils.setProperty((Object)parent, (String)fieldName, (Object)elmClass);
                continue;
            }
            if (String.class.equals(fieldClass)) {
                setMethod.invoke(parent, elmClass);
                continue;
            }
            try {
                setMethod.invoke(parent, fieldClass.getMethod("valueOf", String.class).invoke(fieldClass, elmClass));
            }
            catch (Exception var21) {
                throw new Exception(fieldName + "\u8d4b\u503c\u51fa\u9519\uff01" + var21.getMessage());
            }
        }
        return;
    }

    private static List<Field> getField(Object obj) {
        Class<?> claz = obj.getClass();
        ArrayList<Field> fieldList = new ArrayList<Field>(Arrays.asList(claz.getDeclaredFields()));
        while ((claz = claz.getSuperclass()) != null) {
            fieldList.addAll(Arrays.asList(claz.getDeclaredFields()));
        }
        return fieldList;
    }

    public static String initialUpper(String str) {
        StringBuffer sb = new StringBuffer(str);
        return sb.substring(0, 1).toUpperCase() + sb.substring(1);
    }

    public static boolean isPrimitive(Class claz) {
        try {
            return claz.isPrimitive() ? true : ((Class)claz.getField("TYPE").get(null)).isPrimitive();
        }
        catch (Exception var2) {
            return false;
        }
    }
}

